/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.Node;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.XPathTreeConstants;
import com.ibm.xltxe.rnm1.xtq.common.utils.Util;
import com.ibm.xltxe.rnm1.xtq.utils.XPathError;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Stack;

public class XQueryToXQueryX
implements XPathTreeConstants {
    Stack _openElemStack = new Stack();
    Stack _outputStack = new Stack();
    Stack _stackChecks = new Stack();
    PrintWriter _xqout1;
    PrintWriter _xqout2;
    static final int BSP_STRIP = 0;
    static final int BSP_PRESERVE = 1;
    int _boundarySpacePolicy = 0;
    private static int MAXCHAR = 65535;

    public XQueryToXQueryX() throws UnsupportedEncodingException {
        try {
            this._xqout1 = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, "utf-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                this._xqout1 = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, "UTF8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                this._xqout1 = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, System.getProperty("file.encoding")));
            }
        }
    }

    public XQueryToXQueryX(PrintWriter printWriter) throws UnsupportedEncodingException {
        this._xqout1 = printWriter;
    }

    public XQueryToXQueryX(PrintStream printStream) throws UnsupportedEncodingException {
        this._xqout1 = printStream != null ? new PrintWriter(new OutputStreamWriter((OutputStream)printStream, "utf-8")) : null;
    }

    public XQueryToXQueryX(PrintStream printStream, PrintStream printStream2) throws UnsupportedEncodingException {
        this._xqout1 = printStream != null ? new PrintWriter(new OutputStreamWriter((OutputStream)printStream, "utf-8")) : null;
        this._xqout2 = printStream2 != null ? new PrintWriter(new OutputStreamWriter((OutputStream)printStream2, "utf-8")) : null;
    }

    private void xqprintln() {
        if (null != this._xqout1) {
            this._xqout1.println();
        }
        if (null != this._xqout2) {
            this._xqout2.println();
        }
    }

    private void xqprintln(String string2) {
        if (null != this._xqout1) {
            this._xqout1.println(string2);
        }
        if (null != this._xqout2) {
            this._xqout2.println(string2);
        }
    }

    private void xqprint(String string2) {
        if (null != this._xqout1) {
            this._xqout1.print(string2);
        }
        if (null != this._xqout2) {
            this._xqout2.print(string2);
        }
    }

    private static void writeUTF16Surrogate(PrintWriter printWriter, char c, char[] cArray, int n2, int n3) {
        int n4 = XQueryToXQueryX.getURF16SurrogateValue(c, cArray, n2, n3);
        printWriter.print('&');
        printWriter.print('#');
        printWriter.print(Integer.toString(n4));
        printWriter.print(';');
    }

    private static int getURF16SurrogateValue(char c, char[] cArray, int n2, int n3) {
        int n4;
        if (n2 + 1 >= n3) {
            throw new XPathError("ERR_SYSTEM", "Invalid UTF-16 surrogate detected: " + Integer.toHexString(c));
        }
        if (56320 > (n4 = cArray[++n2]) || n4 >= 57344) {
            throw new XPathError("ERR_SYSTEM", "Invalid UTF-16 surrogate detected: " + Integer.toHexString(c));
        }
        n4 = (c - 55296 << 10) + n4 - 56320 + 65536;
        return n4;
    }

    private static final boolean isUTF16Surrogate(char c) {
        return (c & 0xFC00) == 55296;
    }

    private static boolean canConvert(char c) {
        boolean bl;
        boolean bl2 = bl = c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff';
        if (!bl) {
            throw new XPathError("ERR_INVALID_CHAR", null);
        }
        return c <= MAXCHAR;
    }

    private void xqprintEscaped(String string2) {
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (c == '<') {
                this.xqprint("&lt;");
                continue;
            }
            if (c == '>') {
                this.xqprint("&gt;");
                continue;
            }
            if (c == '&') {
                this.xqprint("&amp;");
                continue;
            }
            if (XQueryToXQueryX.isUTF16Surrogate(c)) {
                char[] cArray = string2.toCharArray();
                int n2 = string2.length();
                if (null != this._xqout1) {
                    XQueryToXQueryX.writeUTF16Surrogate(this._xqout1, c, cArray, i, n2 - 1);
                }
                if (null == this._xqout2) continue;
                XQueryToXQueryX.writeUTF16Surrogate(this._xqout2, c, cArray, i, n2 - 1);
                continue;
            }
            if (!XQueryToXQueryX.canConvert(c)) {
                this.xqprint("&#");
                this.xqprint(Integer.toString(c));
                this.xqprint(";");
                continue;
            }
            if (null != this._xqout1) {
                this._xqout1.print(c);
            }
            if (null == this._xqout2) continue;
            this._xqout2.print(c);
        }
    }

    private void indent() {
        int n2 = this._openElemStack.size();
        for (int i = 0; i < n2; ++i) {
            this.xqprint(" ");
        }
    }

    private void pd(String string2, int n2) {
        this.indent();
        for (int i = 0; i < n2; ++i) {
            this.xqprint(" ");
        }
        this.xqprint("<!-- ");
        this.xqprint(string2);
        this.xqprintln(" -->");
    }

    private void pd(String string2) {
        this.pd(string2, 0);
    }

    private void pd(int n2) {
        this.pd(jjtNodeName[n2], 0);
    }

    private void pushElem(int n2, SimpleNode simpleNode) {
        this.indent();
        this._outputStack.push("<");
        String string2 = jjtNodeName[n2];
        String string3 = "xqx:" + string2.substring(0, 1).toLowerCase() + string2.substring(1);
        this._outputStack.push(string3);
        this._openElemStack.push(string3);
        this._openElemStack.push(simpleNode);
    }

    private void pushElem(String string2, SimpleNode simpleNode) {
        this.indent();
        this._outputStack.push("<");
        this._outputStack.push(string2);
        this._openElemStack.push(string2);
        this._openElemStack.push(simpleNode);
    }

    private void pushAttr(String string2, String string3) {
        this._outputStack.push(" ");
        this._outputStack.push(string2);
        this._outputStack.push("=\"");
        this._outputStack.push(string3);
        this._outputStack.push("\"");
    }

    private void flushOpen(SimpleNode simpleNode, boolean bl) {
        if (this._outputStack.size() > 0) {
            if (simpleNode != this._openElemStack.peek()) {
                return;
            }
            for (int i = 0; i < this._outputStack.size(); ++i) {
                String string2 = (String)this._outputStack.elementAt(i);
                this.xqprint(string2);
            }
            this.xqprint(">");
            if (bl) {
                this.xqprintln();
            }
            this._outputStack.removeAllElements();
        }
    }

    private void flushOpen(SimpleNode simpleNode) {
        this.flushOpen(simpleNode, true);
    }

    private void flushEmpty(SimpleNode simpleNode) {
        if (this._outputStack.size() > 0) {
            if (simpleNode != this._openElemStack.peek()) {
                return;
            }
            this._openElemStack.pop();
            this._openElemStack.pop();
            for (int i = 0; i < this._outputStack.size(); ++i) {
                String string2 = (String)this._outputStack.elementAt(i);
                this.xqprint(string2);
            }
            this.xqprintln("/>");
            this._outputStack.removeAllElements();
        }
    }

    private void flushClose(SimpleNode simpleNode, boolean bl) {
        if (this._openElemStack.size() == 0) {
            return;
        }
        if (simpleNode != this._openElemStack.peek()) {
            return;
        }
        this._openElemStack.pop();
        String string2 = (String)this._openElemStack.pop();
        if (bl) {
            this.indent();
        }
        this.xqprint("</");
        this.xqprint(string2);
        this.xqprintln(">");
    }

    private void flushClose(SimpleNode simpleNode) {
        this.flushClose(simpleNode, true);
    }

    private boolean isJustWhitespace(SimpleNode simpleNode) {
        if (simpleNode.getId() == 127 || simpleNode.getId() == 116) {
            for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(i);
                if (this.isJustWhitespace(simpleNode2)) continue;
                return false;
            }
            return true;
        }
        if (simpleNode.getId() == 128 || simpleNode.getId() == 124 || simpleNode.getId() == 126) {
            return Util.trimWhitespace(simpleNode.getValue()).length() == 0;
        }
        return false;
    }

    private boolean isPreviousSiblingBoundaryWhitespaceChar(SimpleNode simpleNode) {
        if ((simpleNode = this.getPreviousSibling(this.sn(simpleNode.jjtGetParent()))) == null) {
            return true;
        }
        if (simpleNode.jjtGetNumChildren() > 0) {
            simpleNode = this.sn(simpleNode.jjtGetChild(0));
        }
        if (simpleNode.getId() == 128 || simpleNode.getId() == 124 || simpleNode.getId() == 126) {
            if (Util.trimWhitespace(simpleNode.getValue()).length() == 0) {
                return this.isPreviousSiblingBoundaryWhitespaceChar(simpleNode);
            }
        } else {
            return simpleNode.getId() != 129 || (simpleNode = this.sn(simpleNode.jjtGetChild(0))).getId() != 132 && simpleNode.getId() != 131 && simpleNode.getId() != 130;
        }
        return false;
    }

    private boolean isNextSiblingBoundaryWhitespaceChar(SimpleNode simpleNode) {
        if ((simpleNode = this.getNextSibling(this.sn(simpleNode.jjtGetParent()))) == null) {
            return true;
        }
        if (simpleNode.jjtGetNumChildren() > 0) {
            simpleNode = this.sn(simpleNode.jjtGetChild(0));
        }
        if (simpleNode.getId() == 128 || simpleNode.getId() == 124 || simpleNode.getId() == 126) {
            if (Util.trimWhitespace(simpleNode.getValue()).length() == 0) {
                return this.isNextSiblingBoundaryWhitespaceChar(simpleNode);
            }
        } else {
            return simpleNode.getId() != 129 || (simpleNode = this.sn(simpleNode.jjtGetChild(0))).getId() != 132 && simpleNode.getId() != 131 && simpleNode.getId() != 130;
        }
        return false;
    }

    private boolean isBoundaryWhitespaceChar(SimpleNode simpleNode) {
        return (simpleNode.getId() == 128 || simpleNode.getId() == 124 || simpleNode.getId() == 126) && Util.trimWhitespace(simpleNode.getValue()).length() == 0 && this.isPreviousSiblingBoundaryWhitespaceChar(simpleNode) && this.isNextSiblingBoundaryWhitespaceChar(simpleNode);
    }

    private boolean shouldStripChar(SimpleNode simpleNode) {
        return this._boundarySpacePolicy == 0 && this.isBoundaryWhitespaceChar(simpleNode);
    }

    private boolean shouldVoidPathExpr(SimpleNode simpleNode) {
        if (this.getNumExprChildren(simpleNode) > 1) {
            return false;
        }
        for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
            SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(i);
            if (simpleNode2.getId() != 85) continue;
            return false;
        }
        return true;
    }

    private void markCheck() {
        this._stackChecks.push(new Integer(this._openElemStack.size()));
    }

    private boolean check(SimpleNode simpleNode) {
        int n2;
        int n3 = (Integer)this._stackChecks.pop();
        if (n3 != (n2 = this._openElemStack.size())) {
            System.err.println("Stack not flushed properly!!! " + jjtNodeName[simpleNode.getId()]);
        }
        return n3 == n2;
    }

    private void xqflush() {
        if (null != this._xqout1) {
            this._xqout1.flush();
        }
        if (null != this._xqout2) {
            this._xqout2.flush();
        }
    }

    public boolean transform(SimpleNode simpleNode, PrintStream printStream) throws UnsupportedEncodingException {
        this._xqout1 = printStream != null ? new PrintWriter(new OutputStreamWriter((OutputStream)printStream, "utf-8")) : null;
        boolean bl = this.transform(simpleNode);
        this.xqflush();
        return bl;
    }

    public boolean transform(SimpleNode simpleNode, PrintStream printStream, PrintStream printStream2) throws UnsupportedEncodingException {
        this._xqout1 = printStream != null ? new PrintWriter(new OutputStreamWriter((OutputStream)printStream, "utf-8")) : null;
        this._xqout2 = printStream2 != null ? new PrintWriter(new OutputStreamWriter((OutputStream)printStream2, "utf-8")) : null;
        boolean bl = this.transform(simpleNode);
        this.xqflush();
        return bl;
    }

    public boolean transformNoEncodingException(SimpleNode simpleNode, PrintStream printStream, PrintStream printStream2) {
        try {
            this._xqout1 = printStream != null ? new PrintWriter(new OutputStreamWriter((OutputStream)printStream, "utf-8")) : null;
            this._xqout2 = printStream2 != null ? new PrintWriter(new OutputStreamWriter((OutputStream)printStream2, "utf-8")) : null;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this._xqout1 = printStream != null ? new PrintWriter(printStream) : null;
            this._xqout2 = printStream2 != null ? new PrintWriter(printStream2) : null;
        }
        boolean bl = this.transform(simpleNode);
        this.xqflush();
        return bl;
    }

    public boolean transform(SimpleNode simpleNode) {
        this.markCheck();
        int n2 = simpleNode.getId();
        switch (n2) {
            case 0: {
                this.xqprintln("<?xml version=\"1.0\"?>");
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.pushElem("xqx:module", simpleNode);
                this.pushAttr("xmlns:xqx", "http://www.w3.org/2005/XQueryX");
                this._outputStack.push("\n           ");
                this.pushAttr("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                this._outputStack.push("\n           ");
                this.pushAttr("xsi:schemaLocation", "http://www.w3.org/2005/XQueryX\n                                http://www.w3.org/2005/XQueryX/xqueryx.xsd");
                break;
            }
            case 4: {
                this.pushElem(n2, simpleNode);
                this.flushOpen(simpleNode);
                for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                    SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(i);
                    if (i == 0) {
                        this.pushElem("xqx:version", simpleNode2);
                        this.flushOpen(simpleNode2, false);
                        this.xqprint(simpleNode2.getValue().substring(1, simpleNode2.getValue().length() - 1));
                        this.flushClose(simpleNode2, false);
                        continue;
                    }
                    if (i != 1) continue;
                    this.pd("encoding: " + simpleNode2.getValue());
                }
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 5: 
            case 97: 
            case 98: 
            case 99: {
                String string2;
                boolean bl = true;
                switch (n2) {
                    case 97: {
                        string2 = "xqx:integerConstantExpr";
                        break;
                    }
                    case 98: {
                        string2 = "xqx:decimalConstantExpr";
                        break;
                    }
                    case 99: {
                        string2 = "xqx:doubleConstantExpr";
                        break;
                    }
                    case 5: {
                        if (this.getParentID(simpleNode) == 16) {
                            string2 = "xqx:optionContents";
                            bl = false;
                            break;
                        }
                        string2 = "xqx:stringConstantExpr";
                        break;
                    }
                    default: {
                        string2 = "UNKNOWN!";
                    }
                }
                this.pushElem(string2, simpleNode);
                this.flushOpen(simpleNode, bl);
                if (bl) {
                    this.pushElem("xqx:value", simpleNode);
                    this.flushOpen(simpleNode, false);
                }
                String string3 = simpleNode.getValue();
                if (n2 == 5) {
                    string3 = string3.substring(1, string3.length() - 1);
                }
                this.xqprintEscaped(string3);
                if (bl) {
                    this.flushClose(simpleNode, false);
                }
                this.flushClose(simpleNode, bl);
                return this.check(simpleNode);
            }
            case 25: {
                break;
            }
            case 185: {
                if (this.getParentID(simpleNode) == 25) {
                    this.pushElem("xqx:baseUriDecl", simpleNode);
                } else if (this.getParentID(simpleNode) == 50) {
                    this.pushElem("xqx:collation", simpleNode);
                } else if (this.getParentID(simpleNode) == 24) {
                    this.pushElem("xqx:defaultCollationDecl", simpleNode);
                } else {
                    this.pushElem("xqx:uri", simpleNode);
                }
                this.flushOpen(simpleNode, false);
                SimpleNode simpleNode3 = this.sn(simpleNode.jjtGetChild(0));
                String string4 = simpleNode3.getValue();
                string4 = string4.substring(1, string4.length() - 1);
                this.xqprint(string4);
                this.flushClose(simpleNode, false);
                return this.check(simpleNode);
            }
            case 9: {
                if (simpleNode.jjtGetNumChildren() <= 0) break;
                this.pushElem("xqx:prolog", simpleNode);
                break;
            }
            case 93: 
            case 94: {
                String string5 = simpleNode.getValue();
                int n3 = string5.indexOf(58);
                if (n3 > 0) {
                    String string6 = string5.substring(0, n3);
                    string5 = string5.substring(n3 + 1);
                    if (string6.equals("*")) {
                        this.pushElem("xqx:star", simpleNode);
                        this.flushEmpty(simpleNode);
                    } else {
                        this.pushElem("xqx:NCName", simpleNode);
                        this.flushOpen(simpleNode, false);
                        this.xqprint(string6);
                        this.flushClose(simpleNode, false);
                    }
                }
                if (string5.equals("*")) {
                    this.pushElem("xqx:star", simpleNode);
                    this.flushEmpty(simpleNode);
                } else {
                    this.pushElem("xqx:NCName", simpleNode);
                    this.flushOpen(simpleNode, false);
                    this.xqprint(string5);
                    this.flushClose(simpleNode, false);
                }
                return this.check(simpleNode);
            }
            case 163: {
                this.pushElem(n2, simpleNode);
                this.flushOpen(simpleNode);
                this.transformChildren(simpleNode);
                if (this.sn(simpleNode.jjtGetChild(0)).getValue() != null) {
                    this.pushElem("xqx:optional", simpleNode);
                    this.flushEmpty(simpleNode);
                }
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 168: {
                break;
            }
            case 175: 
            case 179: {
                if (simpleNode.getValue() == null || !simpleNode.getValue().equals("*")) break;
                this.pushElem(n2 == 175 ? 182 : 183, simpleNode);
                this.flushOpen(simpleNode);
                this.pushElem("xqx:star", simpleNode);
                this.flushEmpty(simpleNode);
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 182: 
            case 183: {
                this.pushElem(n2, simpleNode);
                break;
            }
            case 78: 
            case 190: 
            case 191: {
                int n4 = this.getParentID(simpleNode);
                if (n4 == 157 || n4 == 159) {
                    this.pushElem("xqx:tagName", simpleNode);
                } else if (n4 == 184) {
                    this.pushElem("xqx:typeName", simpleNode);
                } else if (n4 == 162) {
                    this.pushElem("xqx:piTarget", simpleNode);
                } else if (n4 == 168) {
                    this.pushElem(168, simpleNode);
                } else if (n4 == 13) {
                    this.pushElem("xqx:prefix", simpleNode);
                } else if (n4 == 29 || n4 == 34) {
                    this.pushElem("xqx:varName", simpleNode);
                } else if (n4 == 32) {
                    this.pushElem("xqx:functionName", simpleNode);
                } else if (n4 == 16) {
                    this.pushElem("xqx:optionName", simpleNode);
                } else {
                    this.pushElem("xqx:QName", simpleNode);
                }
                String string7 = this.processPrefix(simpleNode.getValue());
                this.flushOpen(simpleNode, false);
                this.xqprint(string7);
                this.flushClose(simpleNode, false);
                return this.check(simpleNode);
            }
            case 111: {
                if (this.getParentID(simpleNode) == 114 && simpleNode.getValue().startsWith("xmlns:")) {
                    this.pushElem("xqx:prefix", simpleNode);
                    this.flushOpen(simpleNode, false);
                    int n5 = simpleNode.getValue().indexOf(58);
                    String string8 = simpleNode.getValue().substring(n5 + 1);
                    this.xqprint(string8);
                    this.flushClose(simpleNode, false);
                    return this.check(simpleNode);
                }
                if (this.getParentID(simpleNode) == 114) {
                    this.pushElem("xqx:attributeName", simpleNode);
                } else {
                    this.pushElem("xqx:tagName", simpleNode);
                }
                String string9 = this.processPrefix(simpleNode.getValue());
                this.flushOpen(simpleNode, false);
                this.xqprint(string9);
                this.flushClose(simpleNode, false);
                return this.check(simpleNode);
            }
            case 192: {
                this.pushElem("xqx:functionName", simpleNode);
                String string10 = this.processPrefix(simpleNode.getValue());
                this.flushOpen(simpleNode, false);
                this.xqprint(string10);
                this.flushClose(simpleNode, false);
                return this.check(simpleNode);
            }
            case 92: {
                this.pushElem("xqx:Wildcard", simpleNode);
                break;
            }
            case 91: {
                if (this.getChildID(simpleNode, 0) == 92) break;
            }
            case 100: {
                int n6 = this.getParentID(simpleNode);
                if (n6 == 43 || n6 == 45 || n6 == 53) {
                    this.pushElem("xqx:typedVariableBinding", simpleNode);
                    this.flushOpen(simpleNode, true);
                    this.pushElem(n2, simpleNode);
                } else if (n6 == 55 || n6 == 54) {
                    this.pushElem("xqx:variableBinding", simpleNode);
                } else if (n2 == 100) {
                    this.pushElem("xqx:varRef", simpleNode);
                    this.flushOpen(simpleNode, true);
                    this.pushElem("xqx:name", simpleNode);
                } else {
                    this.pushElem(n2, simpleNode);
                }
                String string11 = ((SimpleNode)simpleNode.jjtGetChild(0)).getValue();
                if (null != string11) {
                    string11 = this.processPrefix(string11);
                }
                this.flushOpen(simpleNode, false);
                this.xqprint(string11);
                this.flushClose(simpleNode, false);
                SimpleNode simpleNode4 = this.getNextSibling(simpleNode);
                if (null != simpleNode4 && simpleNode4.getId() == 164) {
                    this.transform(simpleNode4);
                }
                if (n6 == 43 || n6 == 45 || n6 == 53) {
                    this.flushClose(simpleNode, true);
                } else if (n2 == 100) {
                    this.flushClose(simpleNode, true);
                }
                return this.check(simpleNode);
            }
            case 44: {
                this.pushElem("xqx:positionalVariableBinding", simpleNode);
                String string12 = this.sn(this.sn(simpleNode.jjtGetChild(0)).jjtGetChild(0)).getValue();
                String string13 = this.processPrefix(string12);
                this.flushOpen(simpleNode, false);
                this.xqprint(string13);
                this.flushClose(simpleNode, false);
                return this.check(simpleNode);
            }
            case 167: {
                if (simpleNode.getValue() == null || !simpleNode.getValue().equals("item")) break;
                this.pushElem("xqx:anyItemType", simpleNode);
                this.flushEmpty(simpleNode);
                return this.check(simpleNode);
            }
            case 165: {
                int n7 = this.getParentID(simpleNode);
                if (n7 == 55 || n7 == 32) {
                    this.pushElem("xqx:typeDeclaration", simpleNode);
                    this.flushOpen(simpleNode);
                }
                if (simpleNode.getValue() != null && simpleNode.getValue().equals("empty-sequence")) {
                    this.pushElem("xqx:voidSequenceType", simpleNode);
                    this.flushEmpty(simpleNode);
                } else {
                    this.transformChildren(simpleNode);
                }
                if (n7 == 55 || n7 == 32) {
                    this.flushClose(simpleNode);
                }
                return this.check(simpleNode);
            }
            case 40: {
                if (this.getNumExprChildren(simpleNode) <= 1) break;
                this.pushElem("xqx:sequenceExpr", simpleNode);
                this.flushOpen(simpleNode);
                this.transformChildren(simpleNode);
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 82: {
                int n8;
                if (this.shouldVoidPathExpr(simpleNode)) break;
                this.pushElem(n2, simpleNode);
                this.flushOpen(simpleNode, true);
                int n9 = 0;
                SimpleNode simpleNode5 = this.sn(simpleNode.jjtGetChild(0));
                if (simpleNode5.getId() != 85) {
                    this.pushElem("xqx:argExpr", simpleNode);
                    this.flushOpen(simpleNode, true);
                    this.transform(simpleNode5);
                    this.flushClose(simpleNode);
                    ++n9;
                } else {
                    n8 = this.getChildID(simpleNode5, 0);
                    if (n8 != 86 && n8 != 88 && n8 != 87 && n8 != 87 && n8 != 89) {
                        ++n9;
                        this.pushElem("xqx:argExpr", simpleNode);
                        this.flushOpen(simpleNode, true);
                        int n10 = simpleNode5.jjtGetNumChildren();
                        SimpleNode simpleNode6 = null;
                        for (int i = 0; i < n10; ++i) {
                            SimpleNode simpleNode7 = (SimpleNode)simpleNode5.jjtGetChild(i);
                            if (simpleNode7.getId() == 95) {
                                simpleNode6 = simpleNode7;
                                continue;
                            }
                            this.transform(simpleNode7);
                        }
                        this.flushClose(simpleNode);
                        if (null != simpleNode6) {
                            this.transform(simpleNode6);
                        }
                    }
                }
                for (n8 = n9; n8 < simpleNode.jjtGetNumChildren(); ++n8) {
                    SimpleNode simpleNode8 = this.sn(simpleNode.jjtGetChild(n8));
                    if (simpleNode8.getId() == 85 || simpleNode8.getId() == 84 || simpleNode8.getId() == 83) {
                        this.transform(simpleNode8);
                        continue;
                    }
                    this.pushElem("xqx:stepExpr", simpleNode);
                    this.flushOpen(simpleNode, true);
                    this.pushElem("xqx:filterExpr", simpleNode);
                    this.flushOpen(simpleNode, true);
                    if (simpleNode8.getId() == 101) {
                        this.pushElem("xqx:parenthesizedExpr", simpleNode);
                        this.flushOpen(simpleNode, true);
                    }
                    this.transform(simpleNode8);
                    if (simpleNode8.getId() == 101) {
                        this.flushClose(simpleNode);
                    }
                    this.flushClose(simpleNode);
                    this.flushClose(simpleNode);
                }
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 95: {
                this.pushElem("xqx:predicates", simpleNode);
                break;
            }
            case 105: {
                this.pushElem("xqx:functionCallExpr", simpleNode);
                this.flushOpen(simpleNode, true);
                SimpleNode simpleNode9 = (SimpleNode)simpleNode.jjtGetChild(0);
                this.transform(simpleNode9);
                this.pushElem("xqx:arguments", simpleNode);
                this.flushOpen(simpleNode, true);
                int n11 = 1;
                this.transformChildren(simpleNode, n11);
                this.flushClose(simpleNode);
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 85: {
                this.pushElem(n2, simpleNode);
                this.flushOpen(simpleNode, true);
                int n12 = 0;
                int n13 = this.getChildID(simpleNode, n12);
                if (n13 == 102 || n13 == 101) {
                    if (n13 == 101) {
                        this.pushElem("xqx:filterExpr", simpleNode);
                        this.flushOpen(simpleNode, true);
                        this.pushElem("xqx:parenthesizedExpr", simpleNode);
                        this.flushOpen(simpleNode, true);
                    } else if (n13 == 102) {
                        this.pushElem("xqx:filterExpr", simpleNode);
                        this.flushOpen(simpleNode, true);
                    }
                    SimpleNode simpleNode10 = null;
                    for (int i = n12; i < simpleNode.jjtGetNumChildren(); ++i) {
                        SimpleNode simpleNode11 = (SimpleNode)simpleNode.jjtGetChild(i);
                        if (simpleNode11.getId() == 95) {
                            simpleNode10 = simpleNode11;
                            continue;
                        }
                        this.transform(simpleNode11);
                    }
                    this.flushClose(simpleNode, true);
                    if (n13 == 101) {
                        this.flushClose(simpleNode, true);
                    }
                    if (null != simpleNode10) {
                        this.transform(simpleNode10);
                    }
                    this.flushClose(simpleNode);
                    return this.check(simpleNode);
                }
                if (n13 == 86 || n13 == 88) {
                    this.pushElem("xqx:xpathAxis", simpleNode);
                    this.flushOpen(simpleNode, false);
                    String string14 = this.sn(simpleNode.jjtGetChild(0)).getValue();
                    this.xqprint(string14);
                    ++n12;
                    this.flushClose(simpleNode, false);
                } else if (n13 == 89) {
                    this.pushElem("xqx:xpathAxis", simpleNode);
                    this.flushOpen(simpleNode, false);
                    this.xqprint("parent");
                    this.flushClose(simpleNode, false);
                    this.pushElem("xqx:anyKindTest", simpleNode);
                    this.flushEmpty(simpleNode);
                    ++n12;
                } else if (n13 == 87) {
                    String string15 = this.sn(simpleNode.jjtGetChild(0)).getValue();
                    if (string15 != null && string15.equals("@")) {
                        this.pushElem("xqx:xpathAxis", simpleNode);
                        this.flushOpen(simpleNode, false);
                        this.xqprint("attribute");
                        this.flushClose(simpleNode, false);
                    } else {
                        SimpleNode simpleNode12 = this.getPreviousSibling(simpleNode);
                        if (simpleNode12 != null) {
                            if (simpleNode12.getId() != 84) {
                                // empty if block
                            }
                            this.pushElem("xqx:xpathAxis", simpleNode);
                            this.flushOpen(simpleNode, false);
                            this.xqprint("child");
                            this.flushClose(simpleNode, false);
                        }
                    }
                    this.transformChildren(this.sn(simpleNode.jjtGetChild(0)), n12);
                    ++n12;
                } else {
                    SimpleNode simpleNode13 = this.getPreviousSibling(simpleNode);
                    if (simpleNode13 != null) {
                        if (simpleNode13.getId() != 84) {
                            // empty if block
                        }
                        this.pushElem("xqx:xpathAxis", simpleNode);
                        this.flushOpen(simpleNode, false);
                        this.xqprint("child");
                        this.flushClose(simpleNode, false);
                    }
                }
                this.transformChildren(simpleNode, n12);
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 53: {
                this.pushElem(n2, simpleNode);
                this.flushOpen(simpleNode);
                this.pushElem("xqx:quantifier", simpleNode);
                this.flushOpen(simpleNode, false);
                this.xqprint(simpleNode.getValue());
                this.flushClose(simpleNode, false);
                int n14 = simpleNode.jjtGetNumChildren();
                for (int i = 0; i < n14 - 1; i += 2) {
                    SimpleNode simpleNode14 = this.sn(simpleNode.jjtGetChild(i));
                    this.pushElem("xqx:quantifiedExprInClause", simpleNode);
                    this.flushOpen(simpleNode);
                    this.transform(simpleNode14);
                    this.pushElem("xqx:sourceExpr", simpleNode);
                    this.flushOpen(simpleNode);
                    SimpleNode simpleNode15 = this.sn(simpleNode.jjtGetChild(i + 1));
                    this.transform(simpleNode15);
                    this.flushClose(simpleNode);
                    this.flushClose(simpleNode);
                }
                this.pushElem("xqx:predicateExpr", simpleNode);
                this.flushOpen(simpleNode);
                this.transformChildren(simpleNode, n14 - 1, n14 - 1);
                this.flushClose(simpleNode);
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 56: {
                this.pushElem("xqx:ifThenElseExpr", simpleNode);
                this.flushOpen(simpleNode);
                this.pushElem("xqx:ifClause", simpleNode);
                this.flushOpen(simpleNode);
                this.transformChildren(simpleNode, 0, 0);
                this.flushClose(simpleNode);
                this.pushElem("xqx:thenClause", simpleNode);
                this.flushOpen(simpleNode);
                this.transformChildren(simpleNode, 1, 1);
                this.flushClose(simpleNode);
                this.pushElem("xqx:elseClause", simpleNode);
                this.flushOpen(simpleNode);
                this.transformChildren(simpleNode, 2, 2);
                this.flushClose(simpleNode);
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 42: {
                this.pushElem("xqx:flworExpr", simpleNode);
                this.flushOpen(simpleNode);
                int n15 = simpleNode.jjtGetNumChildren();
                this.transformChildren(simpleNode, 0, n15 - 2);
                this.pushElem("xqx:returnClause", simpleNode);
                this.flushOpen(simpleNode);
                this.transformChildren(simpleNode, n15 - 1, n15 - 1);
                this.flushClose(simpleNode);
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 60: {
                this.pushElem("xqx:rangeSequenceExpr", simpleNode);
                this.flushOpen(simpleNode);
                this.pushElem("xqx:startExpr", simpleNode);
                this.flushOpen(simpleNode);
                this.transform(this.sn(simpleNode.jjtGetChild(0)));
                this.flushClose(simpleNode);
                this.pushElem("xqx:endExpr", simpleNode);
                this.flushOpen(simpleNode);
                this.transform(this.sn(simpleNode.jjtGetChild(1)));
                this.flushClose(simpleNode);
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 69: {
                int n16 = 0;
                for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                    SimpleNode simpleNode16 = this.sn(simpleNode.jjtGetChild(i));
                    if (simpleNode16.getId() == 71) {
                        this.pushElem("xqx:unaryPlusOp", simpleNode);
                        this.flushOpen(simpleNode);
                        this.pushElem("xqx:operand", simpleNode);
                        this.flushOpen(simpleNode);
                        ++n16;
                        continue;
                    }
                    if (simpleNode16.getId() == 70) {
                        this.pushElem("xqx:unaryMinusOp", simpleNode);
                        this.flushOpen(simpleNode);
                        this.pushElem("xqx:operand", simpleNode);
                        this.flushOpen(simpleNode);
                        ++n16;
                        continue;
                    }
                    this.transform(simpleNode16);
                    for (int j = 0; j < n16; ++j) {
                        this.flushClose(simpleNode);
                        this.flushClose(simpleNode);
                    }
                    break;
                }
                return this.check(simpleNode);
            }
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                switch (n2) {
                    case 61: {
                        String string16 = simpleNode.getValue();
                        String string17 = string16.equals("+") ? "xqx:addOp" : (string16.equals("-") ? "xqx:subtractOp" : "JJTADDITIVEEXPR UNKNOWN EXPR!");
                        this.pushElem(string17, simpleNode);
                        break;
                    }
                    case 62: {
                        String string18 = simpleNode.getValue();
                        String string19 = string18.equals("*") ? "xqx:multiplyOp" : (string18.equals("div") ? "xqx:divOp" : (string18.equals("idiv") ? "xqx:idivOp" : (string18.equals("mod") ? "xqx:modOp" : "JJTMULTIPLICATIVEEXPR UNKNOWN EXPR: " + string18)));
                        this.pushElem(string19, simpleNode);
                        break;
                    }
                    case 63: {
                        this.pushElem("xqx:unionOp", simpleNode);
                        break;
                    }
                    case 64: {
                        String string20 = simpleNode.getValue();
                        String string21 = string20.equals("intersect") ? "xqx:intersectOp" : (string20.equals("except") ? "xqx:exceptOp" : "JJTINTERSECTEXCEPTEXPR UNKNOWN EXPR: " + string20);
                        this.pushElem(string21, simpleNode);
                        break;
                    }
                    case 58: {
                        this.pushElem("xqx:andOp", simpleNode);
                        break;
                    }
                    case 57: {
                        this.pushElem("xqx:orOp", simpleNode);
                        break;
                    }
                    case 59: {
                        String string22 = simpleNode.getValue();
                        String string23 = string22.equals("eq") ? "xqx:eqOp" : (string22.equals("ne") ? "xqx:neOp" : (string22.equals("lt") ? "xqx:ltOp" : (string22.equals("le") ? "xqx:leOp" : (string22.equals("gt") ? "xqx:gtOp" : (string22.equals("ge") ? "xqx:geOp" : (string22.equals("=") ? "xqx:equalOp" : (string22.equals("!=") ? "xqx:notEqualOp" : (string22.equals("<") ? "xqx:lessThanOp" : (string22.equals("<=") ? "xqx:lessThanOrEqualOp" : (string22.equals(">") ? "xqx:greaterThanOp" : (string22.equals(">=") ? "xqx:greaterThanOrEqualOp" : (string22.equals("is") ? "xqx:isOp" : (string22.equals("<<") ? "xqx:nodeBeforeOp" : (string22.equals(">>") ? "xqx:nodeAfterOp" : "JJTCOMPARISONEXPR UNKNOWN: " + string22))))))))))))));
                        this.pushElem(string23, simpleNode);
                        break;
                    }
                    default: {
                        this.pushElem("???", simpleNode);
                    }
                }
                this.flushOpen(simpleNode);
                this.pushElem("xqx:firstOperand", simpleNode);
                this.flushOpen(simpleNode);
                this.transform(this.sn(simpleNode.jjtGetChild(0)));
                this.flushClose(simpleNode);
                this.pushElem("xqx:secondOperand", simpleNode);
                this.flushOpen(simpleNode);
                this.transform(this.sn(simpleNode.jjtGetChild(1)));
                this.flushClose(simpleNode);
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 83: {
                this.pushElem("xqx:rootExpr", simpleNode);
                break;
            }
            case 84: {
                if (this.sn(simpleNode.jjtGetParent()).jjtGetChild(0) == simpleNode) {
                    this.pushElem("xqx:pathExpr", simpleNode);
                    this.flushOpen(simpleNode);
                    this.pushElem("xqx:argExpr", simpleNode);
                    this.flushOpen(simpleNode);
                    this.pushElem("xqx:rootExpr", simpleNode);
                    this.flushEmpty(simpleNode);
                    this.flushClose(simpleNode);
                    this.pushElem("xqx:stepExpr", simpleNode);
                    this.flushOpen(simpleNode);
                    this.pushElem("xqx:xpathAxis", simpleNode);
                    this.flushOpen(simpleNode, false);
                    this.xqprint("descendant-or-self");
                    this.flushClose(simpleNode, false);
                    this.pushElem("xqx:anyKindTest", simpleNode);
                    this.flushEmpty(simpleNode);
                    this.flushClose(simpleNode);
                    this.flushClose(simpleNode);
                } else {
                    this.pushElem("xqx:stepExpr", simpleNode);
                    this.flushOpen(simpleNode);
                    this.pushElem("xqx:xpathAxis", simpleNode);
                    this.flushOpen(simpleNode, false);
                    this.xqprint("descendant-or-self");
                    this.flushClose(simpleNode, false);
                    this.pushElem("xqx:anyKindTest", simpleNode);
                    this.flushEmpty(simpleNode);
                    this.flushClose(simpleNode);
                }
                return this.check(simpleNode);
            }
            case 43: 
            case 45: {
                this.pushElem(n2, simpleNode);
                this.flushOpen(simpleNode);
                int n17 = simpleNode.jjtGetNumChildren();
                for (int i = 0; i <= n17; ++i) {
                    SimpleNode simpleNode17 = (SimpleNode)simpleNode.jjtGetChild(i);
                    if (simpleNode17.getId() != 100) continue;
                    this.pushElem(n2 == 43 ? "xqx:forClauseItem" : "xqx:letClauseItem", simpleNode);
                    this.flushOpen(simpleNode, true);
                    this.transform(simpleNode17);
                    SimpleNode simpleNode18 = (SimpleNode)simpleNode.jjtGetChild(i + 1);
                    if (simpleNode18.getId() == 164) {
                        simpleNode18 = (SimpleNode)simpleNode.jjtGetChild(++i + 1);
                    }
                    if (simpleNode18.getId() == 44) {
                        this.transformChildren(simpleNode, ++i, i);
                    }
                    this.pushElem(n2 == 43 ? "xqx:forExpr" : "xqx:letExpr", simpleNode);
                    this.flushOpen(simpleNode, true);
                    ++i;
                    while (i < n17) {
                        simpleNode17 = (SimpleNode)simpleNode.jjtGetChild(i);
                        if (simpleNode17.getId() == 100) {
                            --i;
                            break;
                        }
                        this.transform(simpleNode17);
                        ++i;
                    }
                    this.flushClose(simpleNode);
                    this.flushClose(simpleNode);
                }
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 48: {
                int n18 = simpleNode.jjtGetNumChildren();
                for (int i = 0; i < n18; ++i) {
                    SimpleNode simpleNode19 = this.sn(simpleNode.jjtGetChild(i));
                    this.pushElem("xqx:orderBySpec", simpleNode);
                    this.flushOpen(simpleNode);
                    this.transform(simpleNode19);
                    if (simpleNode19.getId() == 49) {
                        int n19 = simpleNode19.jjtGetNumChildren();
                        for (int j = 0; j < n19; ++j) {
                            SimpleNode simpleNode20 = this.sn(simpleNode19.jjtGetChild(j));
                            if (simpleNode20.getId() != 50 || simpleNode20.jjtGetNumChildren() <= 0) continue;
                            this.transform(simpleNode20);
                        }
                    }
                    this.flushClose(simpleNode);
                }
                return this.check(simpleNode);
            }
            case 49: {
                this.pushElem("xqx:orderByExpr", simpleNode);
                this.flushOpen(simpleNode);
                int n20 = simpleNode.jjtGetNumChildren();
                for (int i = 0; i < n20; ++i) {
                    SimpleNode simpleNode21 = this.sn(simpleNode.jjtGetChild(i));
                    if (simpleNode21.getId() == 50) continue;
                    this.transform(simpleNode21);
                }
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 50: {
                if (simpleNode.jjtGetNumChildren() == 0) {
                    return this.check(simpleNode);
                }
                this.pushElem(n2, simpleNode);
                break;
            }
            case 173: {
                this.pushElem("xqx:piTest", simpleNode);
                if (simpleNode.jjtGetNumChildren() > 0) {
                    this.flushOpen(simpleNode);
                    SimpleNode simpleNode22 = this.sn(simpleNode.jjtGetChild(0));
                    this.markCheck();
                    this.pushElem("xqx:piTarget", simpleNode22);
                    this.flushOpen(simpleNode22, false);
                    String string24 = simpleNode22.getValue();
                    if (simpleNode22.getId() == 5) {
                        string24 = string24.substring(1, string24.length() - 1);
                    }
                    this.xqprint(string24);
                    this.flushClose(simpleNode22, false);
                    this.check(simpleNode22);
                    this.flushClose(simpleNode);
                } else {
                    this.flushEmpty(simpleNode);
                }
                return this.check(simpleNode);
            }
            case 26: {
                SimpleNode simpleNode23;
                this.pushElem("xqx:schemaImport", simpleNode);
                this.flushOpen(simpleNode);
                SimpleNode simpleNode24 = this.sn(simpleNode.jjtGetChild(0));
                int n21 = 0;
                if (simpleNode24.getId() == 27 && simpleNode24.jjtGetNumChildren() > 0) {
                    this.pushElem("xqx:namespacePrefix", simpleNode);
                    this.flushOpen(simpleNode, false);
                    this.xqprint(this.sn(simpleNode24.jjtGetChild(0)).getValue());
                    ++n21;
                    this.flushClose(simpleNode, false);
                    simpleNode23 = this.sn(simpleNode.jjtGetChild(1));
                    ++n21;
                } else if (simpleNode24.getId() == 27) {
                    this.pushElem("xqx:defaultElementNamespace", simpleNode);
                    this.flushEmpty(simpleNode);
                    ++n21;
                    simpleNode23 = this.sn(simpleNode.jjtGetChild(1));
                    ++n21;
                } else {
                    simpleNode23 = simpleNode24;
                    ++n21;
                }
                this.pushElem("xqx:targetNamespace", simpleNode23);
                this.flushOpen(simpleNode23, false);
                String string25 = this.sn(simpleNode23.jjtGetChild(0)).getValue();
                string25 = string25.substring(1, string25.length() - 1);
                this.xqprint(string25);
                this.flushClose(simpleNode23, false);
                for (int i = n21; i < simpleNode.jjtGetNumChildren(); ++i) {
                    SimpleNode simpleNode25 = this.sn(simpleNode.jjtGetChild(i));
                    this.pushElem("xqx:targetLocation", simpleNode25);
                    this.flushOpen(simpleNode25, false);
                    string25 = this.sn(simpleNode23.jjtGetChild(0)).getValue();
                    string25 = string25.substring(1, string25.length() - 1);
                    this.xqprint(string25);
                    this.flushClose(simpleNode25, false);
                }
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 51: 
            case 52: {
                this.pushElem("xqx:orderingKind", simpleNode);
                this.flushOpen(simpleNode, false);
                if (n2 == 51) {
                    this.xqprint("ascending");
                } else {
                    this.xqprint("descending");
                }
                this.flushClose(simpleNode, false);
                return this.check(simpleNode);
            }
            case 19: 
            case 20: {
                if (this.getParentID(simpleNode) == 18) {
                    this.pushElem("xqx:emptyOrderingDecl", simpleNode);
                } else {
                    this.pushElem("xqx:emptyOrderingMode", simpleNode);
                }
                this.flushOpen(simpleNode, false);
                if (n2 == 51) {
                    this.xqprint("empty greatest");
                } else {
                    this.xqprint("empty least");
                }
                this.flushClose(simpleNode, false);
                return this.check(simpleNode);
            }
            case 101: {
                if (simpleNode.jjtGetNumChildren() != 0) break;
                this.pushElem("xqx:sequenceExpr", simpleNode);
                break;
            }
            case 15: {
                this.pushElem(n2, simpleNode);
                this.flushOpen(simpleNode);
                this.pushElem("xqx:defaultNamespaceCategory", simpleNode);
                this.flushOpen(simpleNode, false);
                this.xqprint(simpleNode.getValue());
                this.flushClose(simpleNode, false);
                this.transformChildren(simpleNode);
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 14: {
                this._boundarySpacePolicy = simpleNode.getValue().equals("preserve") ? 1 : 0;
                return this.check(simpleNode);
            }
            case 17: 
            case 22: 
            case 23: 
            case 31: 
            case 166: {
                this.pushElem(n2, simpleNode);
                this.flushOpen(simpleNode, false);
                this.xqprint(simpleNode.getValue());
                this.flushClose(simpleNode, false);
                return this.check(simpleNode);
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                if (n2 == 65) {
                    this.pushElem("xqx:instanceOfExpr", simpleNode);
                } else {
                    this.pushElem(n2, simpleNode);
                }
                this.flushOpen(simpleNode);
                this.pushElem("xqx:argExpr", simpleNode);
                this.flushOpen(simpleNode);
                this.transformChildren(simpleNode, 0, 0);
                this.flushClose(simpleNode);
                if (n2 != 68 && n2 != 67) {
                    this.pushElem("xqx:sequenceType", simpleNode);
                    this.flushOpen(simpleNode);
                    this.transformChildren(simpleNode, 1, 1);
                    this.flushClose(simpleNode);
                } else {
                    this.transformChildren(simpleNode, 1, 1);
                }
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 103: 
            case 104: {
                this.pushElem(n2, simpleNode);
                this.flushOpen(simpleNode);
                this.pushElem("xqx:argExpr", simpleNode);
                this.flushOpen(simpleNode);
                this.transformChildren(simpleNode);
                this.flushClose(simpleNode);
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 54: {
                this.pushElem(n2, simpleNode);
                this.flushOpen(simpleNode);
                this.pushElem("xqx:argExpr", simpleNode);
                this.flushOpen(simpleNode);
                this.transformChildren(simpleNode, 0, 0);
                this.flushClose(simpleNode);
                int n22 = simpleNode.jjtGetNumChildren();
                int n23 = n22 - 2;
                this.transformChildren(simpleNode, 1, n23 - 1);
                if (this.getChildID(simpleNode, n23) != 100) {
                    this.transformChildren(simpleNode, n23, n23);
                    ++n23;
                }
                this.pushElem("xqx:typeswitchExprDefaultClause", simpleNode);
                this.flushOpen(simpleNode);
                if (n23 == n22 - 2) {
                    this.transformChildren(simpleNode, n23, n23);
                    ++n23;
                }
                this.pushElem("xqx:resultExpr", simpleNode);
                this.flushOpen(simpleNode);
                this.transformChildren(simpleNode, n23, n23);
                this.flushClose(simpleNode);
                this.flushClose(simpleNode);
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 55: {
                this.pushElem("xqx:typeswitchExprCaseClause", simpleNode);
                this.flushOpen(simpleNode);
                this.transformChildren(simpleNode, 0, 1);
                this.pushElem("xqx:resultExpr", simpleNode);
                this.flushOpen(simpleNode);
                this.transformChildren(simpleNode, 2);
                this.flushClose(simpleNode);
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 32: {
                this.pushElem(n2, simpleNode);
                this.flushOpen(simpleNode);
                int n24 = 0;
                this.transformChildren(simpleNode, n24, n24);
                if (this.getChildID(simpleNode, ++n24) == 33) {
                    this.transformChildren(simpleNode, n24, n24);
                    ++n24;
                } else {
                    this.pushElem("xqx:paramList", simpleNode);
                    this.flushEmpty(simpleNode);
                }
                int n25 = simpleNode.jjtGetNumChildren() - 1;
                this.transformChildren(simpleNode, n24, n25 - 1);
                n24 = n25;
                if (this.getChildID(simpleNode, n25) == 30) {
                    this.transformChildren(simpleNode, n24, n25);
                } else {
                    this.pushElem("xqx:functionBody", simpleNode);
                    this.flushOpen(simpleNode);
                    this.transformChildren(simpleNode, n24, n25);
                    this.flushClose(simpleNode);
                }
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 29: {
                this.pushElem(n2, simpleNode);
                this.flushOpen(simpleNode);
                int n26 = 0;
                int n27 = simpleNode.jjtGetNumChildren() - 1;
                this.transformChildren(simpleNode, n26, n27 - 1);
                n26 = n27;
                if (this.getChildID(simpleNode, n27) == 30) {
                    this.transformChildren(simpleNode, n26, n27);
                } else {
                    this.pushElem("xqx:varValue", simpleNode);
                    this.flushOpen(simpleNode);
                    this.transformChildren(simpleNode, n26, n27);
                    this.flushClose(simpleNode);
                }
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 16: 
            case 21: 
            case 27: 
            case 28: 
            case 30: 
            case 33: 
            case 34: 
            case 39: 
            case 41: 
            case 46: 
            case 47: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 102: 
            case 164: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 174: 
            case 176: 
            case 178: 
            case 180: {
                this.pushElem(n2, simpleNode);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 24: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 70: 
            case 71: 
            case 77: 
            case 90: 
            case 96: 
            case 106: 
            case 107: 
            case 109: 
            case 110: 
            case 112: 
            case 113: 
            case 115: 
            case 117: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 125: 
            case 129: 
            case 145: 
            case 184: {
                break;
            }
            case 130: {
                this.xqprint(simpleNode.getValue());
                break;
            }
            case 131: {
                String string26 = simpleNode.getValue();
                this.xqprint(string26);
                break;
            }
            case 132: {
                this.xqprint("{{");
                break;
            }
            case 133: {
                this.xqprint("}}");
                break;
            }
            case 134: {
                this.pushElem("xqx:computedCommentConstructor", simpleNode);
                break;
            }
            case 138: {
                this.pushElem("xqx:argExpr", simpleNode);
                this.flushOpen(simpleNode);
                this.pushElem("xqx:stringConstantExpr", simpleNode);
                this.flushOpen(simpleNode);
                this.pushElem("xqx:value", simpleNode);
                this.flushOpen(simpleNode, false);
                this.transformChildren(simpleNode);
                this.flushClose(simpleNode, false);
                this.flushClose(simpleNode);
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 139: 
            case 140: 
            case 148: 
            case 154: {
                this.xqprintEscaped(simpleNode.getValue());
                break;
            }
            case 135: 
            case 136: 
            case 137: 
            case 142: 
            case 143: 
            case 146: 
            case 150: 
            case 151: 
            case 152: 
            case 153: {
                break;
            }
            case 149: {
                this.pushElem("xqx:computedTextConstructor", simpleNode);
                this.flushOpen(simpleNode);
                this.pushElem("xqx:argExpr", simpleNode);
                this.flushOpen(simpleNode);
                this.pushElem("xqx:stringConstantExpr", simpleNode);
                this.flushOpen(simpleNode);
                this.pushElem("xqx:value", simpleNode);
                this.flushOpen(simpleNode, false);
                this.xqprint("<![CDATA[");
                this.transformChildren(simpleNode);
                this.xqprint("]]>");
                this.flushClose(simpleNode, false);
                this.flushClose(simpleNode);
                this.flushClose(simpleNode);
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 147: {
                break;
            }
            case 141: {
                this.pushElem("xqx:computedPIConstructor", simpleNode);
                this.flushOpen(simpleNode);
                this.pushElem("xqx:piTarget", simpleNode);
                this.flushOpen(simpleNode, false);
                this.xqprint(this.sn(simpleNode.jjtGetChild(1)).getValue());
                this.flushClose(simpleNode, false);
                if (this.hasChildID(simpleNode, 147)) {
                    this.pushElem("xqx:piValueExpr", simpleNode);
                    this.flushOpen(simpleNode);
                    this.pushElem("xqx:stringConstantExpr", simpleNode);
                    this.flushOpen(simpleNode);
                    this.pushElem("xqx:value", simpleNode);
                    this.flushOpen(simpleNode, false);
                    this.transformChildren(simpleNode, 2);
                    this.flushClose(simpleNode, false);
                    this.flushClose(simpleNode);
                    this.flushClose(simpleNode);
                }
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 156: 
            case 160: 
            case 161: {
                switch (n2) {
                    case 156: {
                        String string27 = "xqx:computedDocumentConstructor";
                        break;
                    }
                    case 160: {
                        String string28 = "xqx:computedTextConstructor";
                        break;
                    }
                    case 161: {
                        String string29 = "xqx:computedCommentConstructor";
                        break;
                    }
                    default: {
                        String string30 = "UNKNOWN-" + jjtNodeName[n2];
                    }
                }
                this.pushElem("xqx:computedTextConstructor", simpleNode);
                this.flushOpen(simpleNode);
                this.pushElem("xqx:argExpr", simpleNode);
                this.flushOpen(simpleNode);
                this.transformChildren(simpleNode);
                this.flushClose(simpleNode);
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 155: {
                break;
            }
            case 157: 
            case 159: 
            case 162: {
                this.pushElem(n2 == 159 ? "xqx:computedAttributeConstructor" : (n2 == 162 ? "xqx:computedPIConstructor" : "xqx:computedElementConstructor"), simpleNode);
                this.flushOpen(simpleNode);
                int n28 = 0;
                if (this.getChildID(simpleNode, 0) == 37) {
                    if (n2 == 162) {
                        this.pushElem("xqx:piTargetExpr", simpleNode);
                    } else {
                        this.pushElem("xqx:tagNameExpr", simpleNode);
                    }
                    this.flushOpen(simpleNode);
                    this.transformChildren(simpleNode, 1, 1);
                    this.flushClose(simpleNode);
                    n28 += 3;
                } else {
                    this.transformChildren(simpleNode, 0, 0);
                    ++n28;
                }
                if (n2 == 159 || n2 == 162) {
                    this.pushElem(n2 == 159 ? "xqx:valueExpr" : "xqx:piValueExpr", simpleNode);
                    this.flushOpen(simpleNode);
                    if (this.getNumExprChildren(simpleNode, n28) == 0) {
                        this.pushElem("xqx:sequenceExpr", simpleNode);
                        this.flushEmpty(simpleNode);
                    } else {
                        this.transformChildren(simpleNode, n28);
                    }
                    this.flushClose(simpleNode);
                } else {
                    this.transformChildren(simpleNode, n28);
                }
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 158: {
                this.pushElem(n2, simpleNode);
                break;
            }
            case 114: {
                if (this.getNumRealChildren(simpleNode) > 0) {
                    this.pushElem("xqx:attributeList", simpleNode);
                    this.flushOpen(simpleNode);
                    int n29 = simpleNode.jjtGetNumChildren();
                    for (int i = 0; i < n29; ++i) {
                        SimpleNode simpleNode26 = this.sn(simpleNode.jjtGetChild(i));
                        if (simpleNode26.getId() == 111) {
                            if (simpleNode26.getValue().startsWith("xmlns:")) {
                                this.pushElem("xqx:namespaceDeclaration", simpleNode);
                            } else {
                                this.pushElem("xqx:attributeConstructor", simpleNode);
                            }
                            this.flushOpen(simpleNode);
                        }
                        this.transform(simpleNode26);
                        if (simpleNode26.getId() != 116) continue;
                        this.flushClose(simpleNode);
                    }
                    this.flushClose(simpleNode);
                }
                return this.check(simpleNode);
            }
            case 127: {
                if (this.getChildID(simpleNode, 0) != 128) break;
                String string31 = this.sn(simpleNode.jjtGetChild(0)).getValue();
                this.xqprintEscaped(string31);
                return this.check(simpleNode);
            }
            case 108: {
                this.pushElem("xqx:elementConstructor", simpleNode);
                this.flushOpen(simpleNode);
                int n30 = simpleNode.jjtGetNumChildren();
                boolean bl = false;
                SimpleNode simpleNode27 = null;
                int n31 = 0;
                for (int i = 0; i < n30; ++i) {
                    SimpleNode simpleNode28 = this.sn(simpleNode.jjtGetChild(i));
                    if (simpleNode28.getId() == 127) {
                        if (!bl) {
                            this.pushElem("xqx:elementContent", simpleNode);
                            this.flushOpen(simpleNode);
                            bl = true;
                        }
                        if (this.isEncloseExpr(simpleNode28)) {
                            if (n31 == 2) {
                                this.flushClose(simpleNode, !this.isElemContentChar(simpleNode27));
                                this.flushClose(simpleNode);
                            }
                            simpleNode27 = this.sn(this.sn(simpleNode28.jjtGetChild(0)).jjtGetChild(0));
                            simpleNode28 = this.sn(this.sn(simpleNode28.jjtGetChild(0)).jjtGetChild(0));
                            n31 = 0;
                        } else if (this.isElemContentChar(simpleNode28)) {
                            if (simpleNode28.getId() == 127 && this.shouldStripChar(this.sn(simpleNode28.jjtGetChild(0)))) continue;
                            if (!this.isElemContentChar(simpleNode27)) {
                                this.pushElem("xqx:stringConstantExpr", simpleNode);
                                this.flushOpen(simpleNode);
                                this.pushElem("xqx:value", simpleNode);
                                this.flushOpen(simpleNode, false);
                                n31 = 2;
                            }
                            simpleNode27 = simpleNode28;
                        } else {
                            if (n31 == 2) {
                                this.flushClose(simpleNode, !this.isElemContentChar(simpleNode27));
                                this.flushClose(simpleNode);
                            }
                            simpleNode27 = simpleNode28;
                            n31 = 0;
                        }
                    }
                    this.transform(simpleNode28);
                }
                if (n31 == 2) {
                    this.flushClose(simpleNode, false);
                    this.flushClose(simpleNode);
                }
                if (bl) {
                    this.flushClose(simpleNode);
                }
                this.flushClose(simpleNode);
                return this.check(simpleNode);
            }
            case 116: {
                SimpleNode simpleNode29;
                int n32;
                if (this.isJustWhitespace(simpleNode)) {
                    return this.check(simpleNode);
                }
                int n33 = simpleNode.jjtGetNumChildren();
                int n34 = -1;
                boolean bl = false;
                for (n32 = 0; n32 < n33; ++n32) {
                    simpleNode29 = this.sn(simpleNode.jjtGetChild(n32));
                    if (!this.isEncloseExpr(simpleNode29)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    this.pushElem("xqx:attributeValueExpr", simpleNode);
                    this.flushOpen(simpleNode);
                    n32 = 0;
                    for (int i = 0; i < n33; ++i) {
                        SimpleNode simpleNode30 = this.sn(simpleNode.jjtGetChild(i));
                        if (this.isEncloseExpr(simpleNode30)) {
                            if (n32 == 2) {
                                this.flushClose(simpleNode, !this.isAttrContentChar(n34));
                                this.flushClose(simpleNode);
                            }
                            n34 = this.sn(this.sn(simpleNode30.jjtGetChild(0)).jjtGetChild(0)).getId();
                            simpleNode30 = this.sn(this.sn(simpleNode30.jjtGetChild(0)).jjtGetChild(0));
                            n32 = 0;
                        } else if (this.isAttrContentChar(simpleNode30.getId())) {
                            if (!this.isAttrContentChar(n34)) {
                                this.pushElem("xqx:stringConstantExpr", simpleNode);
                                this.flushOpen(simpleNode);
                                this.pushElem("xqx:value", simpleNode);
                                this.flushOpen(simpleNode, false);
                                n32 = 2;
                            }
                            n34 = simpleNode30.getId();
                        } else {
                            if (simpleNode30.getId() == 117 || simpleNode30.getId() == 119 || simpleNode30.getId() == 120 || simpleNode30.getId() == 122) continue;
                            if (n32 == 2) {
                                this.flushClose(simpleNode, !this.isAttrContentChar(n34));
                                this.flushClose(simpleNode);
                            }
                            n34 = simpleNode30.getId();
                            n32 = 0;
                        }
                        this.transform(simpleNode30);
                    }
                    if (n32 == 2) {
                        this.flushClose(simpleNode, false);
                        this.flushClose(simpleNode);
                    }
                    this.flushClose(simpleNode);
                } else {
                    if (this.getPreviousSibling(this.getPreviousSibling(simpleNode)).getValue().startsWith("xmlns:")) {
                        this.pushElem("xqx:uri", simpleNode);
                    } else {
                        this.pushElem("xqx:attributeValue", simpleNode);
                    }
                    this.flushOpen(simpleNode, false);
                    for (n32 = 0; n32 < n33; ++n32) {
                        simpleNode29 = this.sn(simpleNode.jjtGetChild(n32));
                        if (simpleNode29.getId() == 117 || simpleNode29.getId() == 119 || simpleNode29.getId() == 120 || simpleNode29.getId() == 122) continue;
                        this.transform(simpleNode29);
                    }
                    this.flushClose(simpleNode, false);
                }
                return this.check(simpleNode);
            }
            case 118: {
                this.xqprint("\"\"");
                return this.check(simpleNode);
            }
            case 121: {
                this.xqprint("''");
                return this.check(simpleNode);
            }
            case 124: 
            case 126: 
            case 128: {
                if (simpleNode.getValue() != null) {
                    this.xqprintEscaped(simpleNode.getValue());
                }
                return this.check(simpleNode);
            }
            default: {
                System.err.println("Unknown ID: " + XPathTreeConstants.jjtNodeName[n2]);
            }
        }
        int n35 = simpleNode.jjtGetNumChildren();
        if (n35 == 0) {
            this.flushEmpty(simpleNode);
        } else {
            this.flushOpen(simpleNode);
            this.transformChildren(simpleNode);
            this.flushClose(simpleNode);
        }
        return this.check(simpleNode);
    }

    private SimpleNode getNextSibling(SimpleNode simpleNode) {
        int n2 = simpleNode.jjtGetParent().jjtGetNumChildren();
        for (int i = 0; i < n2; ++i) {
            SimpleNode simpleNode2 = this.sn(simpleNode.jjtGetParent().jjtGetChild(i));
            if (simpleNode2 != simpleNode) continue;
            if (i + 1 >= n2) break;
            return this.sn(simpleNode.jjtGetParent().jjtGetChild(i + 1));
        }
        return null;
    }

    private SimpleNode getPreviousSibling(SimpleNode simpleNode) {
        int n2 = simpleNode.jjtGetParent().jjtGetNumChildren();
        for (int i = 0; i < n2; ++i) {
            SimpleNode simpleNode2 = this.sn(simpleNode.jjtGetParent().jjtGetChild(i));
            if (simpleNode2 != simpleNode) continue;
            if (i <= 0) break;
            return this.sn(simpleNode.jjtGetParent().jjtGetChild(i - 1));
        }
        return null;
    }

    private boolean hasChildID(SimpleNode simpleNode, int n2) {
        int n3 = simpleNode.jjtGetNumChildren();
        for (int i = 0; i < n3; ++i) {
            SimpleNode simpleNode2 = this.sn(simpleNode.jjtGetChild(i));
            if (simpleNode2.getId() != n2) continue;
            return true;
        }
        return false;
    }

    private int getNumExprChildren(SimpleNode simpleNode) {
        return this.getNumExprChildren(simpleNode, 0);
    }

    private int getNumExprChildren(SimpleNode simpleNode, int n2) {
        int n3 = 0;
        int n4 = simpleNode.jjtGetNumChildren();
        for (int i = n2; i < n4; ++i) {
            SimpleNode simpleNode2 = this.sn(simpleNode.jjtGetChild(i));
            if (simpleNode2.getId() == 77 || simpleNode2.getId() == 37 || simpleNode2.getId() == 38) continue;
            ++n3;
        }
        return n3;
    }

    private int getNumRealChildren(SimpleNode simpleNode) {
        int n2 = 0;
        int n3 = simpleNode.jjtGetNumChildren();
        for (int i = 0; i < n3; ++i) {
            SimpleNode simpleNode2 = this.sn(simpleNode.jjtGetChild(i));
            if (simpleNode2.getId() == 77) continue;
            ++n2;
        }
        return n2;
    }

    private boolean isEncloseExpr(SimpleNode simpleNode) {
        return (simpleNode.getId() == 123 || simpleNode.getId() == 125 || simpleNode.getId() == 127) && this.sn(simpleNode.jjtGetChild(0)).getId() == 129 && this.sn(this.sn(simpleNode.jjtGetChild(0)).jjtGetChild(0)).getId() == 35;
    }

    private boolean isAttrContentChar(int n2) {
        switch (n2) {
            case 118: 
            case 121: 
            case 123: 
            case 125: {
                return true;
            }
            case 129: {
                return true;
            }
        }
        return false;
    }

    private boolean isElemContentChar(SimpleNode simpleNode) {
        if (simpleNode == null) {
            return false;
        }
        if (simpleNode.getId() == 127) {
            switch (this.getChildID(simpleNode, 0)) {
                case 128: {
                    return true;
                }
                case 129: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private String processPrefix(String string2) {
        if (string2 == null) {
            return string2;
        }
        int n2 = string2.indexOf(58);
        if (n2 > 0) {
            String string3 = string2.substring(0, n2);
            string2 = string2.substring(n2 + 1);
            this.pushAttr("xqx:prefix", string3);
        }
        return string2;
    }

    private SimpleNode sn(Node node2) {
        return (SimpleNode)node2;
    }

    private void transformChildren(SimpleNode simpleNode, int n2, int n3) {
        for (int i = n2; i <= n3; ++i) {
            SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(i);
            this.transform(simpleNode2);
        }
    }

    private void transformChildren(SimpleNode simpleNode, int n2) {
        this.transformChildren(simpleNode, n2, simpleNode.jjtGetNumChildren() - 1);
    }

    private void transformChildren(SimpleNode simpleNode) {
        this.transformChildren(simpleNode, 0, simpleNode.jjtGetNumChildren() - 1);
    }

    private int getParentID(SimpleNode simpleNode) {
        return ((SimpleNode)simpleNode.jjtGetParent()).getId();
    }

    private int getChildID(SimpleNode simpleNode, int n2) {
        return ((SimpleNode)simpleNode.jjtGetChild(n2)).getId();
    }

    private SimpleNode getFirstChildIgnoreS(SimpleNode simpleNode) {
        for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
            SimpleNode simpleNode2 = this.sn(simpleNode.jjtGetChild(i));
            if (simpleNode2.getId() == 77) continue;
            return this.sn(simpleNode2);
        }
        return null;
    }
}

