/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.Node;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.ASTBuildingContext;
import java.util.Stack;

class JJTXPathState {
    private Stack nodes = new Stack();
    private Stack marks = new Stack();
    private int sp = 0;
    private int mk = 0;
    private boolean node_created;

    JJTXPathState() {
    }

    boolean nodeCreated() {
        return this.node_created;
    }

    void reset() {
        this.nodes.removeAllElements();
        this.marks.removeAllElements();
        this.sp = 0;
        this.mk = 0;
    }

    Node rootNode() {
        return (Node)this.nodes.elementAt(0);
    }

    void pushNode(Node node2) {
        this.nodes.push(node2);
        ++this.sp;
    }

    Node popNode() {
        if (--this.sp < this.mk) {
            this.mk = (Integer)this.marks.pop();
        }
        return (Node)this.nodes.pop();
    }

    Node peekNode() {
        return (Node)this.nodes.peek();
    }

    int nodeArity() {
        return this.sp - this.mk;
    }

    void clearNodeScope(Node node2) {
        while (this.sp > this.mk) {
            this.popNode();
        }
        this.mk = (Integer)this.marks.pop();
    }

    void openNodeScope(ASTBuildingContext aSTBuildingContext, Node node2) {
        this.marks.push(new Integer(this.mk));
        this.mk = this.sp;
        node2.jjtOpen(aSTBuildingContext);
    }

    void closeNodeScope(ASTBuildingContext aSTBuildingContext, Node node2, int n2) {
        this.mk = (Integer)this.marks.pop();
        while (n2-- > 0) {
            Node node3 = this.popNode();
            node3.jjtSetParent(node2);
            node2.jjtAddChild(aSTBuildingContext, node3, n2);
        }
        node2.jjtClose(aSTBuildingContext);
        this.pushNode(node2);
        this.node_created = true;
    }

    void closeNodeScope(ASTBuildingContext aSTBuildingContext, Node node2, boolean bl) {
        if (bl) {
            int n2 = this.nodeArity();
            this.mk = (Integer)this.marks.pop();
            while (n2-- > 0) {
                Node node3 = this.popNode();
                node3.jjtSetParent(node2);
                node2.jjtAddChild(aSTBuildingContext, node3, n2);
            }
            node2.jjtClose(aSTBuildingContext);
            this.pushNode(node2);
            this.node_created = true;
        } else {
            this.mk = (Integer)this.marks.pop();
            this.node_created = false;
        }
    }
}

