/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast.nodes;

import com.ibm.xltxe.rnm1.xtq.ast.XPath20Exception;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.ContextItemExprImpl;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.FunctionCall;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.IdOrKeyFunctionCallPattern;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.KindTest;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Literal;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Node;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.OperatorExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.StepExpr;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.Token;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.ASTBuildingContext;
import com.ibm.xltxe.rnm1.xtq.ast.res.ASTMsg;
import com.ibm.xltxe.rnm1.xtq.common.utils.Assert;
import com.ibm.xltxe.rnm1.xtq.common.utils.Util;
import com.ibm.xltxe.rnm1.xtq.utils.XPathError;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;

public class PathExpr
extends OperatorExpr {
    private boolean m_absolute;

    protected PathExpr() {
        this(82);
    }

    public PathExpr(int n2) {
        super(n2);
        this.setOpType((short)27);
    }

    public void setAbsolute(ASTBuildingContext aSTBuildingContext, boolean bl) {
        if (this.id != 187) {
            if (bl) {
                this.expandAbsolute(aSTBuildingContext);
            } else if (this.getOperandCount() != 0 && this.getOperand(0).isRootOnSelfNode()) {
                try {
                    this.removeOperand(this.getOperand(0));
                }
                catch (XPath20Exception xPath20Exception) {
                    throw new RuntimeException(xPath20Exception.getMessage());
                }
            }
        }
        this.m_absolute = bl;
    }

    @Override
    public boolean isRootOnSelfNode() {
        return this.getOperandCount() == 1 && this.getOperand(0).isRootOnSelfNode();
    }

    protected void expandAbsolute(ASTBuildingContext aSTBuildingContext) {
        if (this.getOperandCount() == 0 || !this.getOperand(0).isRootOnSelfNode()) {
            super.insertOperand(0, aSTBuildingContext.getExpressionFactory().createRootOnSelfNode(aSTBuildingContext, this.id == 187));
        }
    }

    protected boolean isPattern() {
        return this.id == 187;
    }

    protected void recomputeAbsolute() {
        this.m_absolute = this.getOperandCount() > 0 && this.getOperand(0).isRootOnSelfNode();
    }

    public boolean isAbsolute() {
        return this.m_absolute;
    }

    @Override
    public Expr addOperand(ASTBuildingContext aSTBuildingContext, Expr expr) throws XPath20Exception {
        Expr expr2 = super.addOperand(aSTBuildingContext, expr);
        this.recomputeAbsolute();
        return expr2;
    }

    @Override
    public void append(ASTBuildingContext aSTBuildingContext, OperatorExpr operatorExpr) throws XPath20Exception {
        super.append(aSTBuildingContext, operatorExpr);
        this.recomputeAbsolute();
    }

    @Override
    public Expr insertOperand(int n2, Expr expr) {
        Expr expr2 = super.insertOperand(n2, expr);
        this.recomputeAbsolute();
        return expr2;
    }

    @Override
    public void removeOperand(Expr expr) throws XPath20Exception {
        super.removeOperand(expr);
        this.recomputeAbsolute();
    }

    @Override
    public Expr replaceOperand(ASTBuildingContext aSTBuildingContext, int n2, Expr expr) throws XPath20Exception {
        Expr expr2 = super.replaceOperand(aSTBuildingContext, n2, expr);
        this.recomputeAbsolute();
        return expr2;
    }

    @Override
    public void getXQueryString(StringBuffer stringBuffer, boolean bl) {
        if (this.isAbsolute()) {
            int n2;
            stringBuffer.append('/');
            int n3 = this.getOperandCount();
            int n4 = n2 = this.isPattern() ? 0 : 1;
            while (n2 < n3) {
                Expr expr = this.getOperand(n2);
                expr.getXQueryString(stringBuffer, bl);
                if (n2 < n3 - 1) {
                    stringBuffer.append('/');
                }
                ++n2;
            }
        } else {
            if (this.isAbsolute() && bl) {
                stringBuffer.append('/');
            }
            super.getXQueryString(stringBuffer, bl);
        }
    }

    @Override
    public void jjtAddChild(ASTBuildingContext aSTBuildingContext, Node node2, int n2) {
        switch (node2.getId()) {
            case 106: 
            case 107: 
            case 157: {
                this.addChildrenOfUselessNode(aSTBuildingContext, node2, n2);
                break;
            }
            case 83: {
                this.addRoot(aSTBuildingContext);
                break;
            }
            case 84: {
                if (n2 == 0) {
                    this.addRootDescendendants(aSTBuildingContext);
                    break;
                }
                if (!this.isPattern()) {
                    node2 = aSTBuildingContext.getExpressionFactory().createSlashSlashStep(aSTBuildingContext, false);
                }
            }
            default: {
                if (this.isPattern()) {
                    this.addPatternStep(aSTBuildingContext, node2);
                    break;
                }
                int n3 = 0;
                if (((SimpleNode)node2).canBeReduced()) {
                    if (this.getId() == 82 && node2.jjtGetNumChildren() > 0 && node2.jjtGetChild(0).getId() == 82) {
                        super.jjtInsertNodeChildren(aSTBuildingContext, node2.jjtGetChild(0), n3);
                        break;
                    }
                    super.jjtInsertChild(node2.jjtGetChild(0), n3);
                    break;
                }
                super.jjtInsertChild(node2, n3);
            }
        }
    }

    private void addPatternStep(ASTBuildingContext aSTBuildingContext, Node node2) {
        if (((SimpleNode)node2).canBeReduced()) {
            node2 = this.reducedNode(aSTBuildingContext, (SimpleNode)node2);
        }
        if (node2 instanceof StepExpr) {
            StepExpr stepExpr = (StepExpr)node2;
            if (this.jjtGetNumChildren() == 0) {
                this.jjtInsertChild(stepExpr, 0);
            } else if (this.jjtGetChild(0).getId() == 84) {
                try {
                    stepExpr.setAxisType((short)7);
                }
                catch (XPath20Exception xPath20Exception) {
                    // empty catch block
                }
                this.jjtRemoveChild(this.jjtGetChild(0));
                stepExpr.id = 85;
                stepExpr.setPatternStepRewrittenToPredicate(true);
                this.prependPredicateAtTail(stepExpr, this.getStepExprRoot());
            } else if (node2.getId() == 84) {
                try {
                    stepExpr.setAxisType((short)13);
                }
                catch (XPath20Exception xPath20Exception) {
                    // empty catch block
                }
                stepExpr.id = 85;
                stepExpr.setPatternStepRewrittenToPredicate(true);
                this.prependPredicateAtTail(stepExpr, this.getStepExprRoot());
            } else {
                try {
                    stepExpr.setAxisType((short)3);
                }
                catch (XPath20Exception xPath20Exception) {
                    // empty catch block
                }
                stepExpr.id = 85;
                stepExpr.setPatternStepRewrittenToPredicate(true);
                this.prependPredicateAtTail(stepExpr, this.getStepExprRoot());
            }
        } else if (node2 instanceof FunctionCall) {
            FunctionCall functionCall = (FunctionCall)node2;
            if (this.jjtGetNumChildren() == 0) {
                if (!functionCall.isIdOrKeyFunc()) {
                    throw new XPathError("ERR_TOP_PATTERN", functionCall.getQName());
                }
                IdOrKeyFunctionCallPattern idOrKeyFunctionCallPattern = new IdOrKeyFunctionCallPattern(105, functionCall);
                node2.jjtSetParent(null);
                functionCall = idOrKeyFunctionCallPattern;
                node2 = functionCall;
                this.jjtInsertChild(functionCall, 0);
            } else {
                try {
                    StepExpr stepExpr = new StepExpr(85);
                    if (this.jjtGetChild(0).getId() == 84) {
                        stepExpr.setAxisType((short)7);
                        this.jjtRemoveChild(this.jjtGetChild(0));
                    } else {
                        stepExpr.setAxisType((short)3);
                    }
                    KindTest kindTest = new KindTest(169);
                    stepExpr.setNodeTest(aSTBuildingContext, kindTest);
                    FunctionCall functionCall2 = (FunctionCall)node2;
                    if (!functionCall.isIdOrKeyFunc()) {
                        throw new XPathError("ERR_TOP_PATTERN", functionCall2.getQName());
                    }
                    QName qName = functionCall2.getQName();
                    QName qName2 = new QName(aSTBuildingContext.getExpressionFactory().getStaticContext().getBuiltInNamespaceForFunction(), qName.getLocalPart());
                    functionCall2.setQName(qName2);
                    functionCall2.id = 105;
                    Expr expr = this.createEqualityCompareForIDOrKey(aSTBuildingContext, functionCall2);
                    stepExpr.appendPredicate(aSTBuildingContext, expr);
                    this.prependPredicateAtTail(stepExpr, this.getStepExprRoot());
                }
                catch (XPath20Exception xPath20Exception) {}
            }
        } else {
            this.jjtInsertChild(node2, 0);
        }
    }

    private Expr createEqualityCompareForIDOrKey(ASTBuildingContext aSTBuildingContext, FunctionCall functionCall) throws XPath20Exception {
        String string2;
        StringTokenizer stringTokenizer;
        int n2;
        Expr expr = functionCall.getOperand(0);
        if (!expr.isSimpleStringValue()) {
            aSTBuildingContext.reportError(3, new ASTMsg("ERR_PATTERN_ID_KEY_ARG", expr));
        }
        Assert._assert((n2 = (stringTokenizer = Util.whitespaceTokenize(string2 = expr.getSimpleStringValue())).countTokens()) != 0, Util.getStringRep(functionCall.getQName()) + " must have one or more IDs as arguments!");
        String string3 = stringTokenizer.nextToken();
        if (n2 > 1) {
            functionCall = this.createOneArgFunction(aSTBuildingContext, functionCall, string3);
        }
        OperatorExpr operatorExpr = functionCall.getQName().getLocalPart().equals("id") ? this.createNodeEqualityCompare(aSTBuildingContext, functionCall) : this.createNodeIsInSequence(aSTBuildingContext, functionCall);
        while (stringTokenizer.hasMoreTokens()) {
            OperatorExpr operatorExpr2 = new OperatorExpr(57);
            operatorExpr2.setOpType((short)24);
            string3 = stringTokenizer.nextToken();
            functionCall = this.createOneArgFunction(aSTBuildingContext, functionCall, string3);
            OperatorExpr operatorExpr3 = this.createNodeEqualityCompare(aSTBuildingContext, functionCall);
            operatorExpr2.jjtAppendChild(aSTBuildingContext, operatorExpr);
            operatorExpr2.jjtAppendChild(aSTBuildingContext, operatorExpr3);
            operatorExpr = operatorExpr2;
        }
        return operatorExpr;
    }

    private FunctionCall createOneArgFunction(ASTBuildingContext aSTBuildingContext, FunctionCall functionCall, String string2) {
        QName qName = functionCall.getQName();
        FunctionCall functionCall2 = new FunctionCall(new QName(qName.getNamespaceURI(), qName.getLocalPart(), qName.getPrefix()));
        functionCall2.setBuiltInNamespaceFunc(aSTBuildingContext.getStaticContext().getBuiltInNamespaceForFunction());
        Literal literal = new Literal(5);
        literal.setStringValue(string2);
        functionCall2.jjtAppendChild(aSTBuildingContext, literal);
        return functionCall2;
    }

    private OperatorExpr createNodeEqualityCompare(ASTBuildingContext aSTBuildingContext, Expr expr) throws XPath20Exception {
        String string2 = aSTBuildingContext.getExpressionFactory().getStaticContext().getBuiltInNamespaceForFunction();
        OperatorExpr operatorExpr = new OperatorExpr(59);
        operatorExpr.setOpType((short)13);
        FunctionCall functionCall = new FunctionCall(new QName(string2, "generate-id"));
        functionCall.setBuiltInNamespaceFunc(string2);
        functionCall.jjtAppendChild(aSTBuildingContext, expr);
        operatorExpr.jjtAppendChild(aSTBuildingContext, functionCall);
        FunctionCall functionCall2 = new FunctionCall(new QName(string2, "generate-id"));
        functionCall2.setBuiltInNamespaceFunc(string2);
        StepExpr stepExpr = new StepExpr(85);
        stepExpr.setAxisType((short)5);
        KindTest kindTest = new KindTest(169);
        stepExpr.setNodeTest(aSTBuildingContext, kindTest);
        functionCall2.jjtAppendChild(aSTBuildingContext, stepExpr);
        operatorExpr.jjtAppendChild(aSTBuildingContext, functionCall2);
        return operatorExpr;
    }

    private OperatorExpr createNodeIsInSequence(ASTBuildingContext aSTBuildingContext, Expr expr) throws XPath20Exception {
        FunctionCall functionCall = new FunctionCall(new QName("http://xtqhp", "nodeIsInSequence"));
        functionCall.setBuiltInNamespaceFunc(aSTBuildingContext.getStaticContext().getBuiltInNamespaceForFunction());
        ContextItemExprImpl contextItemExprImpl = new ContextItemExprImpl(102);
        functionCall.jjtAppendChild(aSTBuildingContext, expr);
        functionCall.jjtAppendChild(aSTBuildingContext, contextItemExprImpl);
        return functionCall;
    }

    public Expr getStepExprRoot() {
        return this.jjtGetNumChildren() > 0 ? (Expr)this.jjtGetChild(0) : null;
    }

    private void addRoot(ASTBuildingContext aSTBuildingContext) {
        if (this.isPattern()) {
            if (this.jjtGetNumChildren() == 0) {
                this.setAbsolute(aSTBuildingContext, true);
            } else {
                StepExpr stepExpr = this.createRootStep(aSTBuildingContext, (short)3);
                this.prependPredicateAtTail(stepExpr, (StepExpr)this.getStepExprRoot());
            }
        } else {
            this.setAbsolute(aSTBuildingContext, true);
        }
    }

    private void addRootDescendendants(ASTBuildingContext aSTBuildingContext) {
        if (this.isPattern()) {
            StepExpr stepExpr = this.createRootStep(aSTBuildingContext, (short)7);
            if (this.jjtGetNumChildren() == 0) {
                this.jjtInsertChild(stepExpr, 0);
            } else {
                this.prependPredicateAtTail(stepExpr, (StepExpr)this.getStepExprRoot());
            }
        } else {
            this.setAbsolute(aSTBuildingContext, true);
            if (this.id == 82) {
                Node node2 = this.jjtGetChild(0);
                int n2 = node2 instanceof FunctionCall && ((FunctionCall)node2).getQName().getLocalPart().equals("root") && ((FunctionCall)node2).getQName().getNamespaceURI().equals(aSTBuildingContext.getExpressionFactory().getStaticContext().getBuiltInNamespaceForFunction()) ? 1 : 0;
                super.insertOperand(n2, aSTBuildingContext.getExpressionFactory().createSlashSlashStep(aSTBuildingContext, false));
            } else if (this.id == 187) {
                super.insertOperand(0, aSTBuildingContext.getExpressionFactory().createSlashSlashStep(aSTBuildingContext, true));
            } else {
                throw new XPathError("ERR_SYSTEM", "Wrong id on PathExpr: " + this.id);
            }
        }
    }

    Expr getStepExprOfMostDepth(Expr expr) {
        if (expr.jjtGetNumChildren() > 1) {
            Node node2 = expr.jjtGetChild(1);
            if (node2 instanceof StepExpr && ((StepExpr)node2).isPatternStepRewrittenToPredicate()) {
                return this.getStepExprOfMostDepth((StepExpr)expr.jjtGetChild(1));
            }
            return expr;
        }
        return expr;
    }

    void prependPredicateAtTail(Expr expr, Expr expr2) {
        Expr expr3 = this.getStepExprOfMostDepth(expr2);
        if (expr3 instanceof StepExpr) {
            ((StepExpr)expr3).prependPredicate(expr);
        } else {
            Assert.assertNotImplemented();
        }
    }

    private StepExpr createRootStep(ASTBuildingContext aSTBuildingContext, short s) {
        StepExpr stepExpr = null;
        try {
            stepExpr = new StepExpr(85);
            stepExpr.setAxisType(s);
            KindTest kindTest = new KindTest(169);
            stepExpr.setNodeTest(aSTBuildingContext, kindTest);
            FunctionCall functionCall = aSTBuildingContext.getExpressionFactory().createNotElementNode(aSTBuildingContext, false);
            stepExpr.appendPredicate(aSTBuildingContext, functionCall);
        }
        catch (XPath20Exception xPath20Exception) {
            aSTBuildingContext.getReporter().report(3, xPath20Exception.getErrorMsg());
        }
        return stepExpr;
    }

    @Override
    public boolean canBeReduced() {
        return (this.id == 82 || !this.isAbsolute()) && this.getOperandCount() == 1;
    }

    @Override
    public void jjtClose(ASTBuildingContext aSTBuildingContext) {
        if (this.id == 187 && this.jjtGetNumChildren() > 0) {
            SimpleNode simpleNode = this.flatToDeep(this.getChildren(), 0);
            super.initChildren();
            super.jjtAddChild(aSTBuildingContext, simpleNode, 0);
        }
    }

    @Override
    public int initialChildNumber() {
        return 1;
    }

    @Override
    public void processToken(ASTBuildingContext aSTBuildingContext, Token token) {
        switch (token.kind) {
            case 187: 
            case 188: {
                break;
            }
            default: {
                super.processToken(aSTBuildingContext, token);
            }
        }
    }

    @Override
    public void getXQueryString(StringBuffer stringBuffer, boolean bl, String string2) {
        if (this.isAbsolute()) {
            int n2;
            stringBuffer.append('/');
            int n3 = this.getOperandCount();
            int n4 = n2 = this.isPattern() ? 0 : 1;
            while (n2 < n3) {
                Expr expr = this.getOperand(n2);
                expr.getXQueryString(stringBuffer, bl, string2 + " ");
                if (n2 < n3 - 1) {
                    stringBuffer.append('/');
                }
                ++n2;
            }
        } else {
            if (this.isAbsolute() && bl) {
                stringBuffer.append('/');
            }
            super.getXQueryString(stringBuffer, bl, string2);
        }
    }
}

