/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast.nodes;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Literal;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Node;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.OrderSpec;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.QuantifiedExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.TypeExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.VarDecl;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.VariableRef;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.WhereClause;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.tempconstructors.ILetClause;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.tempconstructors.IPositionalVar;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.tempconstructors.ISequenceType;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.ASTBuildingContext;
import com.ibm.xltxe.rnm1.xtq.utils.XPathError;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;

public class FLWORExpr
extends QuantifiedExpr {
    protected Expr _where = null;
    public static final int NO_MODIFIERS = 0;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = 2;
    public static final int EMPTY_GREATEST = 4;
    public static final int EMPTY_LEAST = 8;
    public static final int ASCENDING_EMPTY_GREATEST = 5;
    public static final int ASCENDING_EMPTY_LEAST = 9;
    public static final int DESCENDING_EMPTY_GREATEST = 6;
    public static final int DESCENDING_EMPTY_LEAST = 10;
    private static final Integer[] MODIFIERS = new Integer[]{new Integer(0), new Integer(1), new Integer(2), null, new Integer(4), new Integer(5), new Integer(6), null, new Integer(8), new Integer(9), new Integer(10)};
    private static final String[] STRING_MODIFIERS = new String[]{null, "ascending", "descending", null, "empty greatest", "ascending empty greatest", "descending empty greatest", null, "empty least", "ascending empty least", "descending empty least"};
    protected List m_osList;
    protected boolean m_orderByStable;
    protected List m_osExprList;
    protected List m_osModifiersList;
    protected List m_osCollationList;
    private TypeExpr lastSeqType = null;

    public FLWORExpr(int n2) {
        super(n2);
    }

    public Expr getWhere() {
        return this._where;
    }

    @Override
    public String toString(String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        this.getXQueryString(stringBuffer, false, "  ");
        return stringBuffer.toString();
    }

    public static String getModifierAsString(int n2) {
        return STRING_MODIFIERS[n2];
    }

    @Override
    public void getXQueryString(StringBuffer stringBuffer, boolean bl, String string2) {
        int n2;
        int n3 = -1;
        for (n2 = 0; n2 < this._vardecls.size(); ++n2) {
            VariableRef variableRef;
            VarDecl varDecl = this.getVardecl(n2);
            int n4 = varDecl.getId();
            if (n4 != n3) {
                n3 = n4;
                if (n2 > 0) {
                    stringBuffer.append("\n");
                }
                if (n4 == 45) {
                    stringBuffer.append(string2).append("let").append(' ');
                } else {
                    stringBuffer.append(string2).append("for").append(' ');
                }
            } else {
                stringBuffer.append(", ");
            }
            QName qName = varDecl.getQName();
            stringBuffer.append("$").append(qName).append(" ");
            TypeExpr typeExpr = varDecl.getType();
            if (typeExpr != null) {
                stringBuffer.append(" as ");
                typeExpr.getXQueryString(stringBuffer, bl, string2 + " ");
            }
            if ((variableRef = varDecl.getPositionalVar()) != null) {
                stringBuffer.append(" at ");
                variableRef.getXQueryString(stringBuffer, bl, string2 + " ");
                stringBuffer.append(" ");
            }
            if (n4 == 45) {
                stringBuffer.append(":=").append(' ');
            } else {
                stringBuffer.append("in").append(' ');
            }
            Expr expr = varDecl.getExpression();
            expr.getXQueryString(stringBuffer, bl, string2);
        }
        if (this._where != null) {
            stringBuffer.append("\n" + string2 + "where ");
            this._where.getXQueryString(stringBuffer, bl, string2 + " ");
        }
        if (this.getOrderSpecCount() > 0) {
            if (this.isOrderByStable()) {
                stringBuffer.append(" stable");
            }
            stringBuffer.append("\n" + string2 + " order by");
            for (n2 = 0; n2 < this.getOrderSpecCount(); ++n2) {
                String string3;
                if (n2 > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(" ");
                ((SimpleNode)this.getOrderSpecExpr(n2)).getXQueryString(stringBuffer, bl, string2);
                int n5 = this.getOrderSpecModifiers(n2);
                if (n5 != 0) {
                    stringBuffer.append(" ").append(STRING_MODIFIERS[n5]);
                }
                if ((string3 = this.getOrderSpecCollation(n2)) == null) continue;
                stringBuffer.append(" collation \"").append(string3).append("\"");
            }
        }
        stringBuffer.append('\n').append(string2).append("return").append(' ');
        this._resExpr.getXQueryString(stringBuffer, bl, string2 + " ");
    }

    public String getOrderSpecCollation(int n2) {
        if (this.getOrderSpecCount() > n2) {
            return (String)this.m_osCollationList.get(n2);
        }
        throw new IndexOutOfBoundsException();
    }

    public int getOrderSpecCount() {
        return this.m_osExprList == null ? 0 : this.m_osExprList.size();
    }

    public Expr getOrderSpecExpr(int n2) {
        if (this.getOrderSpecCount() > n2) {
            return (Expr)this.m_osExprList.get(n2);
        }
        throw new IndexOutOfBoundsException();
    }

    public int getOrderSpecModifiers(int n2) {
        if (this.getOrderSpecCount() > n2) {
            return (Integer)this.m_osModifiersList.get(n2);
        }
        throw new IndexOutOfBoundsException();
    }

    public Expr insertOrderSpec(int n2, Expr expr, int n3, String string2) {
        if (this.getOrderSpecCount() < n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 < 0 || n3 == 3 || n3 == 7 || n3 >= MODIFIERS.length) {
            throw new XPathError("ERR_INVALID_MODIFIER", new Integer(n3));
        }
        if (this.m_osExprList == null) {
            this.m_osExprList = new ArrayList(1);
            this.m_osCollationList = new ArrayList(1);
            this.m_osModifiersList = new ArrayList(1);
        }
        this.m_osCollationList.add(n2, string2);
        this.m_osExprList.add(n2, expr);
        this.m_osModifiersList.add(n2, MODIFIERS[n3]);
        return expr;
    }

    public boolean isOrderByStable() {
        if (this.getOrderSpecCount() == 0) {
            throw new XPathError("ERR_SYSTEM", "It is an invalid method call when there is no order by clause.");
        }
        return this.m_orderByStable;
    }

    public void setStableOrderBy(boolean bl) {
        if (this.getOrderSpecCount() == 0) {
            throw new XPathError("ERR_SYSTEM", "It is an invalid method call when there is no order by clause.");
        }
        this.m_orderByStable = bl;
    }

    public void removeOrderSpec(int n2) {
        if (this.getOrderSpecCount() <= n2) {
            throw new IndexOutOfBoundsException();
        }
        this.m_osCollationList.remove(n2);
        Expr expr = (Expr)this.m_osExprList.remove(n2);
        expr.jjtSetParent(null);
        this.m_osModifiersList.remove(n2);
    }

    public Expr replaceOrderSpec(int n2, Expr expr, int n3, String string2) {
        this.removeOrderSpec(n2);
        return this.insertOrderSpec(n2, expr, n3, string2);
    }

    public Expr getOrderSpec(int n2) {
        return (Expr)this.m_osList.get(n2);
    }

    public void addOrderSpec(Expr expr) {
        if (this.m_osList == null) {
            this.m_osList = new ArrayList(1);
        }
        expr = FLWORExpr.parentless(expr);
        this.m_osList.add(0, expr);
        expr.jjtSetParent(this);
    }

    public int orderSpecCount() {
        if (this.m_osList != null) {
            return this.m_osList.size();
        }
        return 0;
    }

    @Override
    public void jjtAddChild(ASTBuildingContext aSTBuildingContext, Node node2, int n2) {
        switch (node2.getId()) {
            case 43: 
            case 47: 
            case 48: {
                this.addChildrenOfUselessNode(aSTBuildingContext, node2, n2);
                break;
            }
            case 46: {
                SimpleNode simpleNode = (SimpleNode)((WhereClause)node2).jjtGetChild(0);
                this._where = (Expr)this.reducedNode(aSTBuildingContext, simpleNode);
                break;
            }
            case 45: {
                ILetClause iLetClause = (ILetClause)node2;
                Vector vector = iLetClause.getVardecls();
                int n3 = 0;
                for (VarDecl varDecl : vector) {
                    varDecl.jjtSetParent(this);
                    this._vardecls.add(n3, varDecl);
                    if (null != this.lastSeqType) {
                        varDecl.setType(this.lastSeqType);
                    }
                    ++n3;
                }
                break;
            }
            case 49: {
                OrderSpec orderSpec = (OrderSpec)node2;
                String string2 = orderSpec.getCollation() == null ? null : ((Literal)orderSpec.getCollation()).toString();
                this.insertOrderSpec(0, orderSpec.getSelect(), orderSpec.getOrderModifier(), string2);
                this.addOrderSpec(orderSpec);
                break;
            }
            case 44: {
                IPositionalVar iPositionalVar = (IPositionalVar)node2;
                VariableRef variableRef = (VariableRef)iPositionalVar.jjtGetChild(0);
                VarDecl varDecl = this.getVardecl(0);
                varDecl.setPositionalVar(variableRef);
                break;
            }
            case 100: {
                super.jjtAddChild(aSTBuildingContext, node2, n2);
                VarDecl varDecl = this.getVardecl(0);
                if (varDecl == null) break;
                varDecl.setType(this.lastSeqType);
                break;
            }
            default: {
                if (!(node2 instanceof Expr)) {
                    node2 = this.reducedNode(aSTBuildingContext, (SimpleNode)node2);
                }
                if (node2 instanceof ISequenceType) {
                    this.lastSeqType = ((ISequenceType)node2).getRealSeqType();
                    break;
                }
                super.jjtAddChild(aSTBuildingContext, node2, n2);
            }
        }
    }
}

