/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.FunctionDecl;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Param;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.TypeExpr;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.Test;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.XPath;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.ASTBuildingContext;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xltxe.rnm1.xtq.scontext.XStaticContext;
import com.ibm.xltxe.rnm1.xtq.utils.XPathError;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.namespace.QName;
import org.xml.sax.InputSource;

public class Parser {
    Object _parser;
    InputSource _input;
    public static final String XPATH1_STRING = "XPath1";
    public static final String XPATH2_STRING = "XPath2";
    public static final String XQUERY1_STRING = "XQuery1";
    public static final String XSLT1_STRING = "XSLT1";
    public static final String XSLT2_STRING = "XSLT2";
    public static final String XQUERY_MAIN_METHOD = "__xquery_result_fun__";
    public static final short XPATH1 = 1;
    public static final short XPATH2 = 2;
    public static final short XQUERY1 = 3;
    public static final short XSLT1 = 4;
    public static final short XSLT2 = 5;
    private int _lang;

    public Parser(ASTBuildingContext aSTBuildingContext, String string2, InputStream inputStream, String string3) {
        this._lang = Parser.langStringToEnum(string2);
        switch (this._lang) {
            case 1: 
            case 2: 
            case 3: {
                XPath xPath = new XPath(aSTBuildingContext, inputStream);
                this._parser = xPath;
                SimpleNode.setLanguage(xPath.getExpressionFactory(), string2);
                break;
            }
            case 4: 
            case 5: {
                this._lang = 5;
                this._input = new InputSource(inputStream);
                this._input.setSystemId(string3);
                XSLTParser xSLTParser = this.makeXSLTParser();
                this._parser = xSLTParser;
                xSLTParser.getExpressionFactory().setLanguage(string2);
            }
        }
    }

    public Parser(ASTBuildingContext aSTBuildingContext, String string2, Reader reader, String string3) {
        this._lang = Parser.langStringToEnum(string2);
        switch (this._lang) {
            case 1: 
            case 2: 
            case 3: {
                XPath xPath = new XPath(aSTBuildingContext, reader);
                this._parser = xPath;
                SimpleNode.setLanguage(xPath.getExpressionFactory(), string2);
                break;
            }
            case 4: 
            case 5: {
                this._lang = 5;
                this._input = new InputSource(reader);
                this._input.setSystemId(string3);
                XSLTParser xSLTParser = this.makeXSLTParser();
                this._parser = xSLTParser;
                xSLTParser.getExpressionFactory().setLanguage(string2);
            }
            default: {
                throw new RuntimeException("Parser doesn't understand language " + string2 + "!");
            }
        }
    }

    public Parser(ASTBuildingContext aSTBuildingContext, String string2, String string3) throws FileNotFoundException {
        this._lang = Parser.langStringToEnum(string2);
        File file = new File(string3);
        FileInputStream fileInputStream = new FileInputStream(file);
        switch (this._lang) {
            case 1: 
            case 2: 
            case 3: {
                XPath xPath = new XPath(aSTBuildingContext, fileInputStream);
                this._parser = xPath;
                SimpleNode.setLanguage(xPath.getExpressionFactory(), string2);
                break;
            }
            case 4: 
            case 5: {
                this._lang = 5;
                this._input = new InputSource(fileInputStream);
                this._input.setSystemId(string3);
                XSLTParser xSLTParser = this.makeXSLTParser();
                this._parser = xSLTParser;
                xSLTParser.getExpressionFactory().setLanguage(string2);
            }
        }
    }

    private XSLTParser makeXSLTParser() {
        XSLTParser xSLTParser = new XSLTParser(this._lang == 5, new XStaticContext());
        xSLTParser.init();
        return xSLTParser;
    }

    public static int langStringToEnum(String string2) {
        if (string2.equals(XPATH1_STRING)) {
            return 1;
        }
        if (string2.equals(XPATH2_STRING)) {
            return 2;
        }
        if (string2.equals(XQUERY1_STRING)) {
            return 3;
        }
        if (string2.equals(XSLT1_STRING)) {
            return 4;
        }
        if (string2.equals(XSLT2_STRING)) {
            return 5;
        }
        throw new XPathError("ERR_LANGUAGE", string2);
    }

    public static void main(String[] stringArray) throws Exception {
        String string2 = XPATH2_STRING;
        int n2 = 0;
        String string3 = null;
        boolean bl = false;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equals("-lang")) {
                string2 = stringArray[++n2];
                ++n2;
                continue;
            }
            if (stringArray[n2].equals("-file")) {
                string3 = stringArray[++n2];
                ++n2;
                continue;
            }
            if (stringArray[n2].equals("-dumptree")) {
                bl = true;
                ++n2;
                continue;
            }
            if (stringArray[n2].equals("-match")) {
                ++n2;
                continue;
            }
            if (stringArray[n2].equals("-expr")) {
                ++n2;
                ++n2;
                continue;
            }
            if (stringArray[n2].equals("-deepdir")) {
                ++n2;
                ++n2;
                continue;
            }
            if (n2 == stringArray.length - 1) {
                string3 = stringArray[n2];
                ++n2;
                continue;
            }
            ++n2;
        }
        int n3 = Parser.langStringToEnum(string2);
        switch (n3) {
            case 1: 
            case 2: 
            case 3: {
                Test.main(stringArray);
                break;
            }
            case 4: 
            case 5: {
                Parser parser = new Parser(null, string2, string3);
                Expr expr = parser.parse();
                if (!bl) break;
                expr.dump("", System.out);
                break;
            }
        }
    }

    public Expr parse() throws Exception {
        switch (this._lang) {
            case 1: 
            case 2: {
                XPath xPath = (XPath)this._parser;
                SimpleNode simpleNode = xPath.XPath2();
                return (Expr)simpleNode.jjtGetChild(0);
            }
            case 3: {
                XPath xPath = (XPath)this._parser;
                xPath.getExpressionFactory().setLanguage(XQUERY1_STRING);
                SimpleNode simpleNode = xPath.XPath2();
                Expr expr = (Expr)simpleNode.jjtGetChild(0);
                int n2 = expr.jjtGetNumChildren();
                if (n2 > 0) {
                    Expr expr2 = (Expr)expr.jjtGetChild(n2 - 1);
                    FunctionDecl functionDecl = new FunctionDecl();
                    functionDecl.setQName(new QName(XQUERY_MAIN_METHOD));
                    expr2.replaceWith(functionDecl);
                    functionDecl.jjtAddChild(xPath, expr2, 0);
                    functionDecl.jjtGetLastChild().jjtSetParent(functionDecl);
                    this.addParam(functionDecl, "xqstart__context__", 169, null);
                    this.addParam(functionDecl, "xqstart__contextposition__", 184, TypeExpr.TYPENAME_INTEGER);
                    this.addParam(functionDecl, "xqstart__contextlast__", 184, TypeExpr.TYPENAME_INTEGER);
                    XStaticContext xStaticContext = xPath.getStaticContext();
                    xStaticContext.addStylesheetFunction(functionDecl);
                }
                return expr;
            }
            case 4: 
            case 5: {
                XSLTParser xSLTParser = (XSLTParser)this._parser;
                return xSLTParser.makeAST(this._input);
            }
        }
        return null;
    }

    private void addParam(FunctionDecl functionDecl, String string2, int n2, QName qName) {
        Param param = new Param();
        param.setName("", "", string2);
        functionDecl.addParameter(param);
        TypeExpr typeExpr = qName == null ? new TypeExpr(n2) : new TypeExpr(n2, qName);
        typeExpr.setOccurrenceIndicator((short)0);
        param.setType(typeExpr);
    }

    public SimpleNode parseRaw() throws Exception {
        switch (this._lang) {
            case 1: 
            case 2: 
            case 3: {
                XPath xPath = (XPath)this._parser;
                return xPath.XPath2();
            }
            case 4: 
            case 5: {
                XSLTParser xSLTParser = (XSLTParser)this._parser;
                return xSLTParser.makeAST(this._input);
            }
        }
        return null;
    }

    public void ReInit(ASTBuildingContext aSTBuildingContext, InputStream inputStream, String string2) {
        switch (this._lang) {
            case 1: 
            case 2: 
            case 3: {
                XPath xPath = (XPath)this._parser;
                xPath.ReInit(aSTBuildingContext, inputStream);
                break;
            }
            case 4: 
            case 5: {
                this._input.setSystemId(string2);
                break;
            }
        }
    }

    public void ReInit(ASTBuildingContext aSTBuildingContext, Reader reader, String string2) {
        switch (this._lang) {
            case 1: 
            case 2: 
            case 3: {
                XPath xPath = (XPath)this._parser;
                xPath.ReInit(aSTBuildingContext, reader);
                break;
            }
            case 4: 
            case 5: {
                this._input.setSystemId(string2);
                break;
            }
        }
    }

    public Object getRealParser() {
        return this._parser;
    }
}

