/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.fcg.javasrc;

import com.ibm.xltxe.rnm1.fcg.impl.HiddenOptions;
import com.ibm.xltxe.rnm1.fcg.javasrc.FcgClassGenJavaSrc;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class FcgTraceBack {
    protected String m_comment = null;
    public static final String TRACECOMMENTSENABLED_OPTION = "fcgtrace";
    public static final boolean TRACECOMMENTSENABLED = HiddenOptions.optionValueIs("fcgtrace", "on");
    public static final String PRINTFORKREPORT_OPTION = "fcgforkreport";
    public static final boolean printFCGForkReport = HiddenOptions.optionValueIs("fcgforkreport", "on");
    public static final String MAX_TRACEBACK_DEPTH_OPTION = "fcgtracedepth";
    public static final int MAX_TRACEBACK_DEPTH = HiddenOptions.getIntegerValue("fcgtracedepth", 4);
    private static HashMap<String, Integer> forkCalls;

    public FcgTraceBack() {
        assert (TRACECOMMENTSENABLED);
    }

    protected void recordTrace() {
        this.recordTrace(null);
    }

    protected void recordTrace(StringBuffer stringBuffer) {
        if (forkCalls == null) {
            forkCalls = new HashMap();
        }
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl3 = false;
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            String string2 = stackTraceElement.getMethodName();
            if (string2.equals("fork")) {
                bl = true;
            } else if (string2.equals("evaluateInstanceFork")) {
                bl2 = true;
            }
            String string3 = stackTraceElement.getClassName();
            if (string3.contains("com.ibm.xltxe.rnm1.fcg.") || string3.equals("java.lang.Throwable") || string3.equals("java.lang.Thread")) continue;
            String string4 = this.getShortPos(stackTraceElement);
            if (n2 < MAX_TRACEBACK_DEPTH) {
                if (n2 != 0) {
                    stringBuffer2.append(", ");
                }
                stringBuffer2.append(string4);
            }
            ++n2;
            if (!bl && !bl2 || bl3 || !string3.equals("com.ibm.xltxe.rnm1.xylem.Instruction")) continue;
            bl3 = true;
            String string5 = string4 + (bl ? " generated fork" : " generated evaluateInstanceFork");
            Integer n3 = forkCalls.get(string5);
            if (n3 == null) {
                forkCalls.put(string5, 1);
                continue;
            }
            forkCalls.put(string5, n3 + 1);
        }
        this.m_comment = stringBuffer2.toString();
    }

    protected void blockCommentFromCurrentPos(StringBuffer stringBuffer) {
        this.recordTrace(stringBuffer);
        if (this.m_comment != null) {
            stringBuffer.append(" /* ");
            stringBuffer.append(this.m_comment);
            stringBuffer.append(" */");
        }
    }

    private String getShortPos(String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "()", false);
        stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        return string3;
    }

    private String getShortPos(StackTraceElement stackTraceElement) {
        String string2 = "";
        String string3 = stackTraceElement.getClassName();
        String[] stringArray = string3.split("\\.");
        if (stringArray.length > 0) {
            return stringArray[stringArray.length - 1] + ":" + stackTraceElement.getLineNumber();
        }
        return string2;
    }

    protected void blockComment(StringBuffer stringBuffer) {
        if (this.m_comment != null) {
            stringBuffer.append(" /* ");
            stringBuffer.append(this.m_comment);
            stringBuffer.append(" */");
        }
    }

    protected void blockComment(Writer writer) throws IOException {
        if (this.m_comment != null) {
            writer.write(" /* ");
            writer.write(this.m_comment);
            writer.write(" */");
        }
    }

    protected void comment(Writer writer, boolean bl) throws IOException {
        if (this.m_comment != null) {
            writer.write("  // ");
            writer.write(this.m_comment);
            if (!bl) {
                writer.write(FcgClassGenJavaSrc.m_eol);
            }
        }
    }

    public static void printForkReport() {
        HashMap<String, Integer> hashMap = forkCalls;
        if (hashMap != null) {
            TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
            treeMap.putAll(hashMap);
            Set set2 = treeMap.keySet();
            for (String string2 : set2) {
                int n2 = hashMap.get(string2);
                String string3 = string2;
                System.out.print(string3);
                for (int i = 60 - string3.length(); i >= 0; --i) {
                    System.out.print(".");
                }
                String string4 = Integer.toString(n2);
                System.out.print(string4);
                for (int i = 5 - string4.length(); i >= 0; --i) {
                    System.out.print(" ");
                }
                System.out.println("times");
            }
        }
    }
}

