/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.fcg.impl;

import com.ibm.xltxe.rnm1.fcg.FcgArrayType;
import com.ibm.xltxe.rnm1.fcg.FcgAttrs;
import com.ibm.xltxe.rnm1.fcg.FcgBinOp;
import com.ibm.xltxe.rnm1.fcg.FcgClassGen;
import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgField;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgInterfaceType;
import com.ibm.xltxe.rnm1.fcg.FcgMethodGen;
import com.ibm.xltxe.rnm1.fcg.FcgReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgUnaryOp;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.fcg.ifacecore.FcgBasicType;
import com.ibm.xltxe.rnm1.fcg.ifacecore.FcgOperation;
import com.ibm.xltxe.rnm1.fcg.ifacecore.FcgReferenceTypeImpl;
import com.ibm.xltxe.rnm1.fcg.ifacecore.FcgVarMutableInternal;
import com.ibm.xltxe.rnm1.fcg.impl.FcgClassGenImpl;
import com.ibm.xltxe.rnm1.fcg.impl.FcgFieldGenImpl;
import com.ibm.xltxe.rnm1.fcg.impl.FcgRuntimeException;
import com.ibm.xltxe.rnm1.fcg.impl.HiddenOptions;
import com.ibm.xltxe.rnm1.fcg.javasrc.FcgClassGenJavaSrc;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class FinalCodeGenerator
implements FcgInstructionList {
    private static final String FCG_COMPILE_TIME_CHECKING = "fcg.compile.check";
    public static final boolean DO_COMPILE_CHECKING = !HiddenOptions.optionValueIs("fcg.compile.check", "off");
    final FcgClassGen m_classGen;
    final FcgMethodGen m_method;
    protected final CodeGenStack m_codeGenerationStack = new CodeGenStack();
    private int m_nonValueConstructsOnStack = 0;
    private final LocalVarStack m_varStack = new LocalVarStack();
    private static final boolean debug_reset = System.getProperty("com.ibm.xltxe.rnm1.fcg.options.stackreset", "false").compareToIgnoreCase("true") == 0;
    private static final Construct UNDEFINED = new Construct("UNDEFINED");
    private static final Construct CLASS = new Construct("CLASS");
    private static final Construct METHOD = new Construct("METHOD");
    private static final Construct IF = new Construct("IF");
    private static final Construct ELSE = new Construct("ELSE");
    private static final Construct TRYBLOCK = new Construct("TRY");
    private static final Construct CATCHBLOCK = new Construct("CATCH");
    private static final Construct SCOPEBLOCK = new Construct("SCOPE");
    private static final Construct CHOOSE = new Construct("CHOOSE");
    private static final Construct CHOOSEBLOCK = new Construct("CHOOSEBLOCK");
    protected static final Construct LOOP = new Construct("LOOP");
    private static final Construct VALUE = new Construct("VALUE");
    private static final Construct VAR_SCOPE = new Construct("LOC_VAR_SCOPE");
    private ArrayList m_comments = new ArrayList();
    private boolean m_endMethodWasCalled = false;
    private FcgMethodGen m_beginMethod2;
    protected int m_loopCount = 0;
    public static final FcgBasicType INT_LITERAL = new FcgBasicType("int literal");

    protected FinalCodeGenerator(FcgClassGen fcgClassGen) {
        this.m_classGen = fcgClassGen;
        this.m_method = null;
    }

    protected FinalCodeGenerator(FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen) {
        this.m_classGen = fcgClassGen;
        this.m_method = fcgMethodGen;
    }

    private void push(Construct construct2) {
        this.m_codeGenerationStack.push(construct2, null, null, this.m_varStack.numLocalVars());
        this.increaseConstructCount(construct2);
    }

    private void push(Construct construct2, FcgType fcgType, Object object2) {
        if (DO_COMPILE_CHECKING && this.m_endMethodWasCalled) {
            FinalCodeGenerator.error("FCG: trying to add code after endMethod() was already called on an FcgInstructionList");
        }
        this.m_codeGenerationStack.push(construct2, fcgType, object2, this.m_varStack.numLocalVars());
        this.increaseConstructCount(construct2);
    }

    private StackValue peek() {
        return this.m_codeGenerationStack.peek();
    }

    private StackValue peek(int n2) {
        return this.m_codeGenerationStack.peek(n2);
    }

    private StackValue pop(Construct construct2) {
        if (construct2 == null) {
            construct2 = this.peek().m_constructKind;
        }
        this.decreaseConstructCount(construct2);
        return this.m_codeGenerationStack.pop(construct2);
    }

    private void increaseConstructCount(Construct construct2) {
        if (construct2 != VALUE) {
            ++this.m_nonValueConstructsOnStack;
        }
    }

    private void decreaseConstructCount(Construct construct2) {
        if (construct2 != VALUE) {
            --this.m_nonValueConstructsOnStack;
        }
    }

    protected final int getActiveNonValueConstructsCount() {
        return this.m_nonValueConstructsOnStack;
    }

    @Override
    public final void comment(String string2) {
        if (((FcgClassGenImpl)this.m_classGen).getFcgCodeGen().getSupressComments()) {
            return;
        }
        StackValue stackValue = this.peek();
        if (stackValue != null && stackValue.getConstructKind() == VALUE) {
            this.cacheComment(string2);
            return;
        }
        this.clearCachedComments();
        this.genCode_comment(string2);
    }

    private void cacheComment(String string2) {
        this.m_comments.add(string2);
    }

    private void clearCachedComments() {
        int n2 = this.m_comments.size();
        while (n2-- > 0) {
            String string2 = (String)this.m_comments.get(0);
            this.genCode_comment(string2);
            this.m_comments.remove(0);
        }
    }

    protected abstract void genCode_comment(String var1);

    @Override
    public final FcgVariable defineVar(FcgType fcgType, String string2, boolean bl) {
        StackValue stackValue = this.peek();
        if (fcgType == null) {
            fcgType = stackValue.getType();
        }
        FcgAttrs fcgAttrs = FcgAttrs.NONE;
        FcgVariable fcgVariable = this.m_varStack.push(string2, fcgType, fcgAttrs);
        if (!bl || stackValue == null || stackValue.getType() == FcgBasicType.VOID) {
            StackValue stackValue2 = stackValue;
            this.genCode_defineLocalVariable(stackValue2, fcgVariable, null);
        } else {
            FcgType fcgType2 = stackValue.getType();
            if (fcgType != null && fcgType2 != fcgType) {
                this.convertExpr(fcgType2, fcgType);
            }
            StackValue stackValue3 = this.pop(VALUE);
            StackValue stackValue4 = null;
            this.genCode_defineLocalVariable(stackValue4, fcgVariable, stackValue3);
            stackValue3.reset();
        }
        this.clearCachedComments();
        return fcgVariable;
    }

    public final FcgVariable defineMethodParam(FcgAttrs fcgAttrs, FcgType fcgType, String string2) {
        FcgVariable fcgVariable = this.m_varStack.push(string2, fcgType, fcgAttrs);
        return fcgVariable;
    }

    private final FcgVariable defineCatchClauseParam(String string2, FcgType fcgType, FcgAttrs fcgAttrs) {
        FcgVariable fcgVariable = this.defineVar(fcgType, string2, false);
        return fcgVariable;
    }

    protected abstract void genCode_defineLocalVariable(StackValue var1, FcgVariable var2, StackValue var3);

    private void undefinelVar() {
        StackValue stackValue = this.peek();
        FcgVariable fcgVariable = this.m_varStack.peek();
        this.genCode_undefineLocalVariable(stackValue, fcgVariable);
        this.m_varStack.pop(fcgVariable.getName());
    }

    protected abstract void genCode_undefineLocalVariable(StackValue var1, FcgVariable var2);

    @Override
    public final FcgVariable defineConstVar(FcgType fcgType, String string2) {
        StackValue stackValue = this.peek();
        if (fcgType == null) {
            fcgType = stackValue.getType();
        }
        FcgAttrs fcgAttrs = FcgAttrs.FINAL;
        FcgVariable fcgVariable = this.m_varStack.push(string2, fcgType, fcgAttrs);
        if (stackValue == null || stackValue.getType() == FcgBasicType.VOID) {
            StackValue stackValue2 = stackValue;
            this.genCode_defineLocalVariable(stackValue2, fcgVariable, null);
        } else {
            StackValue stackValue3 = this.pop(VALUE);
            FcgType fcgType2 = stackValue3.getType();
            if (DO_COMPILE_CHECKING && !FinalCodeGenerator.canConvert(fcgType2, fcgType)) {
                FinalCodeGenerator.error("FCG: defineConstVar() can't convert the type of the value: " + fcgType2 + ", to the type of the variable: " + fcgType);
            }
            StackValue stackValue4 = null;
            this.genCode_defineLocalVariable(stackValue4, fcgVariable, stackValue3);
            stackValue3.reset();
        }
        this.clearCachedComments();
        return fcgVariable;
    }

    @Override
    public final void endMethod() {
        StackValue stackValue = this.pop(METHOD);
        this.undeclareLocals(stackValue);
        StackValue stackValue2 = this.peek();
        this.genCode_endMethod(stackValue2, stackValue);
        stackValue.reset();
        this.m_varStack.m_freeIndex = 0;
        FcgMethodGen fcgMethodGen = this.getMethod();
        FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
        FcgClassGen fcgClassGen = fcgInstructionList.getFcgClassGen();
        ((FcgClassGenImpl)fcgClassGen).addMethod(fcgMethodGen);
        this.clearCachedComments();
        this.setMethod(null);
        this.m_endMethodWasCalled = true;
    }

    protected abstract void genCode_endMethod(StackValue var1, StackValue var2);

    protected abstract void genCode_endClass(StackValue var1);

    @Override
    public final FcgType loadInstanceField(FcgClassReferenceType fcgClassReferenceType, String string2, FcgType fcgType) {
        Object object2;
        if (DO_COMPILE_CHECKING && ((FcgReferenceTypeImpl)((Object)fcgClassReferenceType)).isNotRegistered()) {
            object2 = "FCG: The reference type '" + fcgClassReferenceType.getTypeName() + "' is not registered.";
            FinalCodeGenerator.error((String)object2);
        }
        try {
            object2 = this.pop(VALUE);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("FCG: loadInstanceField() failed, perhaps no object, whose instance field is being loaded, was pushed on the FCG stack.");
            System.err.flush();
            throw runtimeException;
        }
        Object object3 = this.genCode_loadInstanceField((StackValue)object2, fcgClassReferenceType, string2, fcgType);
        ((StackValue)object2).reset();
        this.push(VALUE, fcgType, object3);
        return fcgType;
    }

    protected abstract Object genCode_loadInstanceField(StackValue var1, FcgClassReferenceType var2, String var3, FcgType var4);

    @Override
    public final void storeInstanceFieldStmt(FcgClassReferenceType fcgClassReferenceType, String string2, FcgType fcgType) {
        Object object2;
        if (DO_COMPILE_CHECKING && ((FcgReferenceTypeImpl)((Object)fcgClassReferenceType)).isNotRegistered()) {
            object2 = "FCG: The reference type '" + fcgClassReferenceType.getTypeName() + "' is not registered.";
            FinalCodeGenerator.error((String)object2);
        }
        object2 = this.peek().getType();
        if (fcgType != null && object2 != fcgType) {
            this.convertExpr((FcgType)object2, fcgType);
        }
        StackValue stackValue = this.pop(VALUE);
        StackValue stackValue2 = this.pop(VALUE);
        String string3 = fcgClassReferenceType != null ? fcgClassReferenceType.getTypeName() : this.m_classGen.getClassType().getTypeName();
        this.genCode_storeInstanceVariableStmt(stackValue2, string3, string2, fcgType, stackValue);
        stackValue.reset();
        stackValue2.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_storeInstanceVariableStmt(StackValue var1, String var2, String var3, FcgType var4, StackValue var5);

    @Override
    public final FcgVariable findVar(String string2) {
        return this.findFcgVariable2(string2);
    }

    @Override
    public FcgType loadVar(FcgVariable fcgVariable) {
        FcgType fcgType = fcgVariable.getType();
        if (fcgType != FcgType.VOID) {
            this.push(VALUE, fcgType, this.genCode_loadLocalVariable(fcgVariable));
        }
        return fcgType;
    }

    @Override
    public final FcgClassReferenceType loadThis() {
        if (DO_COMPILE_CHECKING && this.isClassContext()) {
            FinalCodeGenerator.error("FCG: Can't generate a load of 'this' in a class (static) method.");
        }
        Object object2 = this.genCode_loadThis();
        String string2 = this.m_classGen.getClassType().getTypeName();
        FcgClassReferenceType fcgClassReferenceType = ((FcgClassGenImpl)this.m_classGen).getFcgCodeGen().getClassReferenceType(string2);
        this.push(VALUE, fcgClassReferenceType, object2);
        return fcgClassReferenceType;
    }

    protected abstract Object genCode_loadThis();

    @Override
    public final FcgType loadNull() {
        Object object2 = this.genCode_loadNull();
        this.push(VALUE, FcgType.OBJECT, object2);
        return FcgType.OBJECT;
    }

    protected abstract Object genCode_loadNull();

    protected abstract Object genCode_loadClassRef(String var1);

    protected abstract Object genCode_loadLocalVariable(FcgVariable var1);

    @Override
    public final FcgType loadArrayElement(FcgType fcgType) {
        StackValue stackValue = this.pop(VALUE);
        StackValue stackValue2 = this.pop(VALUE);
        Object object2 = this.genCode_loadFromArrayElement(stackValue2, stackValue, fcgType);
        stackValue.reset();
        stackValue2.reset();
        this.push(VALUE, fcgType, object2);
        return fcgType;
    }

    protected abstract Object genCode_loadFromArrayElement(StackValue var1, StackValue var2, FcgType var3);

    @Override
    public final FcgType loadLiteral(boolean bl) {
        this.push(VALUE, FcgBasicType.BOOLEAN, this.genCode_loadLiteralValue(bl));
        return FcgBasicType.BOOLEAN;
    }

    protected abstract Object genCode_loadLiteralValue(boolean var1);

    @Override
    public final FcgType loadLiteral(long l) {
        this.push(VALUE, FcgBasicType.LONG, this.genCode_loadLiteralValue(l));
        return FcgBasicType.LONG;
    }

    protected abstract Object genCode_loadLiteralValue(long var1);

    @Override
    public final FcgType loadLiteral(int n2) {
        this.push(VALUE, INT_LITERAL, this.genCode_loadLiteralValue(n2));
        StackValue stackValue = this.peek();
        stackValue.setLiteralValue(n2);
        return FcgType.INT;
    }

    protected abstract Object genCode_loadLiteralValue(int var1);

    @Override
    public final FcgType loadLiteral(short s) {
        this.push(VALUE, FcgBasicType.SHORT, this.genCode_loadLiteralValue(s));
        return FcgBasicType.SHORT;
    }

    protected abstract Object genCode_loadLiteralValue(short var1);

    @Override
    public final FcgType loadLiteral(byte by2) {
        this.push(VALUE, FcgBasicType.BYTE, this.genCode_loadLiteralValue(by2));
        return FcgBasicType.BYTE;
    }

    protected abstract Object genCode_loadLiteralValue(byte var1);

    @Override
    public final FcgType loadLiteral(char c) {
        this.push(VALUE, FcgBasicType.CHAR, this.genCode_loadLiteralValue(c));
        return FcgBasicType.CHAR;
    }

    protected abstract Object genCode_loadLiteralValue(char var1);

    @Override
    public final FcgType loadLiteral(String string2) {
        this.push(VALUE, FcgBasicType.STRING, this.genCode_loadLiteralValue(string2));
        return FcgBasicType.STRING;
    }

    protected abstract Object genCode_loadLiteralValue(String var1);

    @Override
    public final FcgType loadLiteral(float f2) {
        this.push(VALUE, FcgBasicType.FLOAT, this.genCode_loadLiteralValue(f2));
        return FcgBasicType.FLOAT;
    }

    protected abstract Object genCode_loadLiteralValue(float var1);

    @Override
    public final FcgType loadLiteral(double d) {
        this.push(VALUE, FcgBasicType.DOUBLE, this.genCode_loadLiteralValue(d));
        return FcgBasicType.DOUBLE;
    }

    protected abstract Object genCode_loadLiteralValue(double var1);

    @Override
    public final FcgType invokeInstanceMethod(FcgClassReferenceType fcgClassReferenceType, String string2, FcgType fcgType, int n2) {
        boolean bl = fcgType != FcgType.VOID;
        this.invokeMethod(true, bl, fcgClassReferenceType, string2, fcgType, n2, null);
        return fcgType;
    }

    @Override
    public final FcgType invokeInstanceMethod(FcgClassReferenceType fcgClassReferenceType, String string2, FcgType fcgType, FcgType[] fcgTypeArray) {
        boolean bl = fcgType != FcgType.VOID;
        this.invokeMethod(true, bl, fcgClassReferenceType, string2, fcgType, fcgTypeArray.length, fcgTypeArray);
        return fcgType;
    }

    @Override
    public final FcgType invokeInstanceMethodStmt(FcgClassReferenceType fcgClassReferenceType, String string2, FcgType fcgType, int n2) {
        boolean bl = false;
        this.invokeMethod(true, bl, fcgClassReferenceType, string2, fcgType, n2, null);
        return FcgType.VOID;
    }

    @Override
    public final FcgType invokeInstanceMethodStmt(FcgClassReferenceType fcgClassReferenceType, String string2, FcgType fcgType, FcgType[] fcgTypeArray) {
        boolean bl = false;
        this.invokeMethod(true, bl, fcgClassReferenceType, string2, fcgType, fcgTypeArray.length, fcgTypeArray);
        return FcgType.VOID;
    }

    @Override
    public final FcgType invokeInterfaceMethod(FcgInterfaceType fcgInterfaceType, String string2, FcgType fcgType, int n2) {
        boolean bl = fcgType != FcgType.VOID;
        this.invokeMethod(true, bl, fcgInterfaceType, string2, fcgType, n2, null);
        return fcgType;
    }

    @Override
    public final FcgType invokeInterfaceMethod(FcgInterfaceType fcgInterfaceType, String string2, FcgType fcgType, FcgType[] fcgTypeArray) {
        boolean bl = fcgType != FcgType.VOID;
        this.invokeMethod(true, bl, fcgInterfaceType, string2, fcgType, fcgTypeArray.length, fcgTypeArray);
        return fcgType;
    }

    @Override
    public final FcgType invokeInterfaceMethodStmt(FcgInterfaceType fcgInterfaceType, String string2, FcgType fcgType, int n2) {
        boolean bl = false;
        this.invokeMethod(true, bl, fcgInterfaceType, string2, fcgType, n2, null);
        return FcgType.VOID;
    }

    @Override
    public final FcgType invokeInterfaceMethodStmt(FcgInterfaceType fcgInterfaceType, String string2, FcgType fcgType, FcgType[] fcgTypeArray) {
        boolean bl = false;
        this.invokeMethod(true, bl, fcgInterfaceType, string2, fcgType, fcgTypeArray.length, fcgTypeArray);
        return FcgType.VOID;
    }

    @Override
    public final FcgType invokeClassMethod(FcgClassReferenceType fcgClassReferenceType, String string2, FcgType fcgType, int n2) {
        boolean bl = fcgType != FcgType.VOID;
        this.invokeMethod(false, bl, fcgClassReferenceType, string2, fcgType, n2, null);
        return fcgType;
    }

    @Override
    public final FcgType invokeClassMethod(FcgClassReferenceType fcgClassReferenceType, String string2, FcgType fcgType, FcgType[] fcgTypeArray) {
        boolean bl = fcgType != FcgType.VOID;
        this.invokeMethod(false, bl, fcgClassReferenceType, string2, fcgType, fcgTypeArray.length, fcgTypeArray);
        return fcgType;
    }

    @Override
    public final FcgType invokeClassMethodStmt(FcgClassReferenceType fcgClassReferenceType, String string2, FcgType fcgType, int n2) {
        boolean bl = false;
        boolean bl2 = false;
        this.invokeMethod(bl2, bl, fcgClassReferenceType, string2, fcgType, n2, null);
        return FcgType.VOID;
    }

    @Override
    public final FcgType invokeClassMethodStmt(FcgClassReferenceType fcgClassReferenceType, String string2, FcgType fcgType, FcgType[] fcgTypeArray) {
        boolean bl = false;
        boolean bl2 = false;
        this.invokeMethod(bl2, bl, fcgClassReferenceType, string2, fcgType, fcgTypeArray.length, fcgTypeArray);
        return FcgType.VOID;
    }

    @Override
    public final void printOut() {
        StackValue stackValue = this.pop(VALUE);
        StackValue stackValue2 = this.peek();
        this.genCode_printOut(stackValue2, stackValue);
        stackValue.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_printOut(StackValue var1, StackValue var2);

    @Override
    public final void throwObject() {
        StackValue stackValue = this.pop(VALUE);
        StackValue stackValue2 = this.peek();
        this.genCode_throwObject(stackValue2, stackValue);
        stackValue.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_throwObject(StackValue var1, StackValue var2);

    @Override
    public final void printErr() {
        StackValue stackValue = this.pop(VALUE);
        StackValue stackValue2 = this.peek();
        this.genCode_printErr(stackValue2, stackValue);
        stackValue.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_printErr(StackValue var1, StackValue var2);

    @Override
    public void storeVar(FcgVariable fcgVariable) {
        StackValue stackValue = this.pop(VALUE);
        StackValue stackValue2 = this.peek();
        FcgType fcgType = fcgVariable.getType();
        FcgType fcgType2 = stackValue.getType();
        this.genCode_storeLocalVariableStmt(stackValue2, fcgVariable, stackValue);
        stackValue.reset();
        this.clearCachedComments();
    }

    @Override
    public void endExpressionStmt() {
        StackValue stackValue = this.pop(VALUE);
        StackValue stackValue2 = this.peek();
        this.genCode_endExpressionStmt(stackValue2, stackValue);
        stackValue.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_endExpressionStmt(StackValue var1, StackValue var2);

    protected abstract void genCode_storeLocalVariableStmt(StackValue var1, FcgVariable var2, StackValue var3);

    @Override
    public final FcgType storeAndReloadVarExpr(FcgVariable fcgVariable) {
        StackValue stackValue = this.pop(VALUE);
        FcgType fcgType = stackValue.getType();
        StackValue stackValue2 = this.peek();
        Object object2 = this.genCode_storeLocalVariableExpr(stackValue2, fcgVariable, stackValue);
        stackValue.reset();
        this.push(VALUE, fcgType, object2);
        return fcgType;
    }

    protected abstract Object genCode_storeLocalVariableExpr(StackValue var1, FcgVariable var2, StackValue var3);

    @Override
    public FcgType preIncrementAndLoadLocalVariable(FcgVariable fcgVariable) {
        StackValue stackValue = this.peek();
        Object object2 = this.genCode_preIncrementAndLoadLocalVariable(stackValue, fcgVariable);
        FcgType fcgType = fcgVariable.getType();
        this.push(VALUE, fcgType, object2);
        return fcgType;
    }

    protected abstract Object genCode_preIncrementAndLoadLocalVariable(StackValue var1, FcgVariable var2);

    @Override
    public void incrementVarStmt(FcgVariable fcgVariable) {
        StackValue stackValue = this.peek();
        this.genCode_incrementLocalVarStmt(stackValue, fcgVariable);
    }

    protected abstract void genCode_incrementLocalVarStmt(StackValue var1, FcgVariable var2);

    @Override
    public final void storeAtStmt() {
        StackValue stackValue = this.pop(VALUE);
        StackValue stackValue2 = this.pop(VALUE);
        StackValue stackValue3 = this.peek();
        this.genCode_storeAt(stackValue3, stackValue2, stackValue);
        stackValue2.reset();
        stackValue.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_storeAt(StackValue var1, StackValue var2, StackValue var3);

    @Override
    public final void beginConditionalLoop(String string2, int n2) {
        this.beginConditionalLoop(string2, n2, false);
    }

    @Override
    public final void beginConditionalDoWhileLoop(String string2) {
        this.beginConditionalLoop(string2, 1, true);
    }

    private final void beginConditionalLoop(String string2, int n2, boolean bl) {
        StackValue stackValue = 2 == n2 ? this.pop(VALUE) : null;
        StackValue stackValue2 = 1 <= n2 ? this.pop(VALUE) : null;
        FcgType fcgType = stackValue == null ? FcgBasicType.VOID : stackValue.getType();
        Object object2 = this.genCode_startConditionalLoop(string2, stackValue2, stackValue, bl);
        if (stackValue2 != null) {
            stackValue2.reset();
        }
        if (stackValue != null) {
            stackValue.reset();
        }
        this.push(LOOP, fcgType, object2);
        this.clearCachedComments();
    }

    protected abstract Object genCode_startConditionalLoop(String var1, StackValue var2, StackValue var3, boolean var4);

    @Override
    public final void endConditionalLoop() {
        StackValue stackValue = this.pop(LOOP);
        StackValue stackValue2 = this.peek();
        this.undeclareLocals(stackValue);
        this.genCode_endLoop(stackValue2, stackValue);
        stackValue.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_endLoop(StackValue var1, StackValue var2);

    @Override
    public final void breakFromLoop() {
        this.breakFromLoop(1);
        this.clearCachedComments();
    }

    @Override
    public final void breakFromLoop(int n2) {
        StackValue stackValue = this.getNthEnclosingLoop(n2);
        StackValue stackValue2 = this.peek();
        this.undeclareLocals(stackValue);
        this.genCode_breakFromLoop(stackValue2, stackValue);
        this.clearCachedComments();
    }

    protected abstract void genCode_breakFromLoop(StackValue var1, StackValue var2);

    @Override
    public final void nextIterationOfLoop() {
        this.nextIterationOfLoop(1);
    }

    @Override
    public final void nextIterationOfLoop(int n2) {
        StackValue stackValue = this.getNthEnclosingLoop(n2);
        StackValue stackValue2 = this.peek();
        this.genCode_nextIterationOfLoop(stackValue2, stackValue);
    }

    protected abstract void genCode_nextIterationOfLoop(StackValue var1, StackValue var2);

    private StackValue getNthEnclosingLoop(int n2) {
        int n3 = this.m_codeGenerationStack.size();
        StackValue stackValue = null;
        for (int i = 0; i < n3 && n2 != 0; ++i) {
            stackValue = this.peek(i);
            if (stackValue.getConstructKind() != LOOP) continue;
            --n2;
        }
        if (DO_COMPILE_CHECKING && n2 != 0) {
            FinalCodeGenerator.error("FCG: Requested break or continue from non-existent loop depth " + n2);
        }
        return stackValue;
    }

    @Override
    public final void beginSwitch() {
        StackValue stackValue = this.pop(VALUE);
        Object object2 = this.genCode_beginChoice(stackValue);
        stackValue.reset();
        this.push(CHOOSE, FcgBasicType.VOID, object2);
        this.clearCachedComments();
    }

    protected abstract Object genCode_beginChoice(StackValue var1);

    @Override
    public final void beginSwitchCaseBlock(int n2) {
        StackValue stackValue = this.peek();
        Object object2 = this.genCode_beginChoiceBlock(n2, stackValue);
        this.push(CHOOSEBLOCK, FcgBasicType.VOID, object2);
        this.clearCachedComments();
    }

    protected abstract Object genCode_beginChoiceBlock(int var1, StackValue var2);

    @Override
    public final void beginSwitchCaseBlock(char c) {
        StackValue stackValue = this.peek();
        Object object2 = this.genCode_beginChoiceBlock(c, stackValue);
        this.push(CHOOSEBLOCK, FcgBasicType.VOID, object2);
        this.clearCachedComments();
    }

    protected abstract Object genCode_beginChoiceBlock(char var1, StackValue var2);

    @Override
    public final void beginSwitchDefaultBlock() {
        StackValue stackValue = this.peek();
        Object object2 = this.genCode_beginChoiceBlockDefault(stackValue);
        this.push(CHOOSEBLOCK, FcgBasicType.VOID, object2);
        this.clearCachedComments();
    }

    protected abstract Object genCode_beginChoiceBlockDefault(StackValue var1);

    @Override
    public final void endSwitchCaseBlock() {
        this.endSwitchCaseBlock(true);
    }

    @Override
    public final void endSwitchCaseBlockFallThru() {
        this.endSwitchCaseBlock(false);
    }

    private final void endSwitchCaseBlock(boolean bl) {
        StackValue stackValue = this.pop(CHOOSEBLOCK);
        StackValue stackValue2 = this.peek();
        this.undeclareLocals(stackValue);
        this.genCode_endChoiceBlock(stackValue2, stackValue, bl);
        stackValue.reset();
        this.clearCachedComments();
    }

    @Override
    public final void endSwitchDefaultBlock() {
        this.endSwitchDefaultBlock(true);
    }

    @Override
    public final void endSwitchDefaultBlockFallThru() {
        this.endSwitchDefaultBlock(false);
    }

    private final void endSwitchDefaultBlock(boolean bl) {
        this.endSwitchCaseBlock(bl);
    }

    protected abstract Object genCode_endChoiceBlock(StackValue var1, StackValue var2, boolean var3);

    @Override
    public final void endSwitch() {
        StackValue stackValue = this.pop(CHOOSE);
        StackValue stackValue2 = this.peek();
        this.undeclareLocals(stackValue);
        this.genCode_endChoice(stackValue2, stackValue);
        stackValue.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_endChoice(StackValue var1, StackValue var2);

    @Override
    public final FcgType unaryOperationExpr(FcgUnaryOp fcgUnaryOp) {
        StackValue stackValue = this.pop(VALUE);
        FcgType fcgType = this.getUnaryExprType(fcgUnaryOp, stackValue.getType());
        Object object2 = this.genCode_unaryOperation(fcgUnaryOp, stackValue, fcgType);
        stackValue.reset();
        this.push(VALUE, fcgType, object2);
        return fcgType;
    }

    private FcgType getUnaryExprType(FcgUnaryOp fcgUnaryOp, FcgType fcgType) {
        FcgType fcgType2;
        if (fcgType == INT_LITERAL) {
            fcgType = FcgType.INT;
        }
        int n2 = ((Operation)((Object)fcgUnaryOp)).getFcgOpCode();
        switch (n2) {
            case 106: {
                if (fcgType == FcgType.BYTE) {
                    fcgType2 = FcgType.INT;
                    break;
                }
                fcgType2 = fcgType;
                break;
            }
            case 1130: {
                if (fcgType == FcgType.BYTE) {
                    fcgType2 = FcgType.INT;
                    break;
                }
                fcgType2 = fcgType;
                break;
            }
            case 201: {
                fcgType2 = FcgType.BOOLEAN;
                break;
            }
            case 300: {
                if (fcgType == FcgType.BYTE || fcgType == INT_LITERAL) {
                    fcgType2 = FcgType.INT;
                    break;
                }
                fcgType2 = fcgType;
                break;
            }
            case 301: {
                if (fcgType == FcgType.FLOAT) {
                    fcgType2 = FcgType.INT;
                    break;
                }
                if (fcgType == FcgType.DOUBLE) {
                    fcgType2 = FcgType.LONG;
                    break;
                }
                if (fcgType == FcgType.INT || fcgType == INT_LITERAL) {
                    fcgType2 = FcgType.INT;
                    break;
                }
                if (fcgType == FcgType.BYTE) {
                    fcgType2 = FcgType.INT;
                    break;
                }
                if (fcgType == FcgType.LONG) {
                    fcgType2 = FcgType.LONG;
                    break;
                }
                if (fcgType == FcgType.BIG_INTEGER) {
                    fcgType2 = FcgType.BIG_INTEGER;
                    break;
                }
                if (fcgType == FcgType.BIG_DECIMAL) {
                    fcgType2 = FcgType.BIG_DECIMAL;
                    break;
                }
                throw new UnsupportedOperationException("FinalCodeGenerator:  round has an unsupported arg type: " + fcgType);
            }
            case 302: 
            case 303: {
                if (fcgType == FcgType.DOUBLE || fcgType == FcgType.FLOAT || fcgType == FcgType.BYTE || fcgType == FcgType.LONG || fcgType == FcgType.INT || fcgType == FcgType.BIG_DECIMAL || fcgType == FcgType.BIG_INTEGER) {
                    fcgType2 = fcgType;
                    break;
                }
                throw new UnsupportedOperationException("FinalCodeGenerator, ceiling or floor has an unsupported arg type: " + fcgType);
            }
            case 305: {
                fcgType2 = FcgType.BOOLEAN;
                break;
            }
            case 306: {
                fcgType2 = FcgType.INT;
                break;
            }
            case 307: {
                fcgType2 = FcgType.CHAR_ARRAY;
                break;
            }
            case 308: {
                fcgType2 = FcgType.CHAR_ARRAY;
                break;
            }
            default: {
                Object var4_5 = null;
                throw new UnsupportedOperationException("FinalCodeGenerator, UNARY_HEX_ESCAPE, has an unsupported op: " + n2);
            }
        }
        return fcgType2;
    }

    @Override
    public final FcgType binaryOperationExpr(FcgBinOp fcgBinOp) {
        StackValue stackValue = this.pop(VALUE);
        StackValue stackValue2 = this.pop(VALUE);
        FcgType fcgType = this.getBinaryExprType(fcgBinOp, stackValue2.getType(), stackValue.getType());
        Object object2 = this.genCode_binaryOperation(fcgBinOp, stackValue2, stackValue, fcgType);
        stackValue.reset();
        stackValue2.reset();
        this.push(VALUE, fcgType, object2);
        return fcgType;
    }

    private FcgType getBinaryExprType(FcgBinOp fcgBinOp, FcgType fcgType, FcgType fcgType2) {
        FcgType fcgType3;
        int n2 = ((Operation)((Object)fcgBinOp)).getFcgOpCode();
        switch (n2) {
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                if (fcgType == FcgType.BIG_DECIMAL && n2 != 104) {
                    fcgType3 = FcgType.BIG_DECIMAL;
                    break;
                }
                if (fcgType == FcgType.BIG_INTEGER) {
                    fcgType3 = FcgType.BIG_INTEGER;
                    break;
                }
                if (fcgType == FcgType.DOUBLE || fcgType2 == FcgType.DOUBLE) {
                    fcgType3 = FcgType.DOUBLE;
                    break;
                }
                if (fcgType == FcgType.FLOAT || fcgType2 == FcgType.FLOAT) {
                    fcgType3 = FcgType.FLOAT;
                    break;
                }
                if (fcgType == FcgType.LONG || fcgType2 == FcgType.LONG) {
                    fcgType3 = FcgType.LONG;
                    break;
                }
                fcgType3 = FcgType.INT;
                break;
            }
            case 110: 
            case 111: 
            case 112: {
                if (fcgType == FcgType.LONG) {
                    fcgType3 = FcgType.LONG;
                    break;
                }
                fcgType3 = FcgType.INT;
                break;
            }
            case 114: 
            case 115: 
            case 116: {
                if (fcgType == FcgType.LONG || fcgType2 == FcgType.LONG) {
                    fcgType3 = FcgType.LONG;
                    break;
                }
                fcgType3 = FcgType.INT;
                break;
            }
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: {
                fcgType3 = FcgType.BOOLEAN;
                break;
            }
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: {
                fcgType3 = FcgType.BOOLEAN;
                break;
            }
            default: {
                Object var5_6 = null;
                throw new UnsupportedOperationException("FinalCodeGenerator bad opcode: " + n2);
            }
        }
        return fcgType3;
    }

    private final FcgType createObjectExpr(FcgType fcgType, int n2, FcgType[] fcgTypeArray) {
        int n3;
        int n4 = n2;
        StackValue[] stackValueArray = new StackValue[n4];
        for (n3 = n4 - 1; n3 >= 0; --n3) {
            stackValueArray[n3] = this.pop(VALUE);
        }
        Object object2 = this.genCode_createObject(fcgType, stackValueArray, fcgTypeArray);
        for (n3 = 0; n3 < n4; ++n3) {
            stackValueArray[n3].reset();
        }
        this.push(VALUE, fcgType, object2);
        return fcgType;
    }

    @Override
    public final FcgType createObjectExpr(FcgType fcgType, int n2) {
        return this.createObjectExpr(fcgType, n2, null);
    }

    @Override
    public final FcgType createObjectExpr(FcgType fcgType, FcgType[] fcgTypeArray) {
        return this.createObjectExpr(fcgType, fcgTypeArray.length, fcgTypeArray);
    }

    @Override
    public final FcgType createInnerClassExpr(FcgType fcgType, int n2, FcgClassGen fcgClassGen) {
        int n3 = n2;
        if (DO_COMPILE_CHECKING && !(fcgClassGen instanceof FcgClassGenJavaSrc)) {
            FinalCodeGenerator.error("FCG: Can only create inner classes with Java source");
        } else {
            int n4;
            StackValue[] stackValueArray = new StackValue[n3];
            for (n4 = n3 - 1; n4 >= 0; --n4) {
                stackValueArray[n4] = this.pop(VALUE);
            }
            Object object2 = this.genCode_createInnerClass(fcgType, stackValueArray, fcgClassGen);
            for (n4 = 0; n4 < n3; ++n4) {
                stackValueArray[n4].reset();
            }
            this.push(VALUE, fcgType, object2);
        }
        return fcgType;
    }

    protected abstract Object genCode_createObject(FcgType var1, StackValue[] var2, FcgType[] var3);

    protected abstract Object genCode_createInnerClass(FcgType var1, StackValue[] var2, FcgClassGen var3);

    @Override
    public final FcgType createArrayExpr(FcgType fcgType, boolean bl) {
        Object object2;
        StackValue stackValue = this.pop(VALUE);
        if (stackValue.m_valueType == INT_LITERAL && bl) {
            int n2;
            int n3 = stackValue.getIntLiteralValue();
            StackValue[] stackValueArray = new StackValue[n3];
            for (n2 = n3 - 1; n2 >= 0; --n2) {
                stackValueArray[n2] = this.pop(VALUE);
            }
            object2 = this.genCode_createArray(fcgType, stackValueArray);
            for (n2 = 0; n2 < n3; ++n2) {
                stackValueArray[n2].reset();
            }
            stackValue.reset();
        } else {
            if (DO_COMPILE_CHECKING && bl) {
                String string2 = "FCG: Can't initialize created array, size is not a literal integer.";
                FinalCodeGenerator.error(string2);
            }
            object2 = this.genCode_createArray(fcgType, stackValue);
            stackValue.reset();
        }
        FcgType fcgType2 = ((FcgClassGenImpl)this.m_classGen).getFcgCodeGen().getArrayType(fcgType);
        this.push(VALUE, fcgType2, object2);
        return fcgType2;
    }

    protected abstract Object genCode_createArray(FcgType var1, StackValue[] var2);

    protected abstract Object genCode_createArray(FcgType var1, StackValue var2);

    @Override
    public final void beginIf() {
        StackValue stackValue = this.pop(VALUE);
        Object object2 = this.genCode_beginIf(stackValue);
        stackValue.reset();
        this.push(IF, FcgBasicType.VOID, object2);
        this.clearCachedComments();
    }

    protected abstract Object genCode_beginIf(StackValue var1);

    @Override
    public final void beginElse() {
        this.clearCachedComments();
        StackValue stackValue = this.peek();
        this.undeclareLocals(stackValue);
        stackValue = this.pop(IF);
        Object object2 = this.genCode_beginElse(stackValue);
        stackValue.reset();
        this.push(ELSE, FcgBasicType.VOID, object2);
    }

    protected abstract Object genCode_beginElse(StackValue var1);

    @Override
    public final void beginElseIf() {
        StackValue stackValue = this.pop(VALUE);
        StackValue stackValue2 = this.pop(IF);
        this.undeclareLocals(stackValue2);
        Object object2 = this.genCode_elseIf(stackValue2, stackValue);
        stackValue.reset();
        stackValue2.reset();
        this.push(IF, FcgBasicType.VOID, object2);
        this.clearCachedComments();
    }

    protected abstract Object genCode_elseIf(StackValue var1, StackValue var2);

    @Override
    public final void endIf() {
        Object object2;
        StackValue stackValue = this.peek();
        this.undeclareLocals(stackValue);
        stackValue = this.pop(null);
        Construct construct2 = stackValue.getConstructKind();
        if (DO_COMPILE_CHECKING && construct2 != IF && construct2 != ELSE) {
            object2 = "FCG: endIf() was expecting to pop previously pushed IF or ELSE contruct on the FCG stack but got: " + construct2 + " construct";
            Object object3 = stackValue.getCodeData();
            if (object3 instanceof String) {
                object2 = (String)object2 + ", with value: " + object3;
            }
            FinalCodeGenerator.error((String)object2);
        }
        object2 = this.peek();
        this.genCode_endIf((StackValue)object2, stackValue);
        stackValue.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_endIf(StackValue var1, StackValue var2);

    @Override
    public final void endTryBlock() {
        StackValue stackValue = this.pop(CATCHBLOCK);
        StackValue stackValue2 = this.peek();
        this.undeclareLocals(stackValue);
        this.genCode_endTry(stackValue2, stackValue);
        stackValue.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_endTry(StackValue var1, StackValue var2);

    @Override
    public final FcgType convertExpr(FcgType fcgType, FcgType fcgType2) {
        if (fcgType != fcgType2) {
            StackValue stackValue = this.pop(VALUE);
            Object object2 = this.genCode_coerce(fcgType, fcgType2, stackValue);
            stackValue.reset();
            this.push(VALUE, fcgType2, object2);
        }
        return fcgType2;
    }

    @Override
    public final void returnInstruction() {
        FcgType fcgType;
        FcgMethodGen fcgMethodGen = this.getMethod();
        if (DO_COMPILE_CHECKING && fcgMethodGen != null && (fcgType = fcgMethodGen.getReturnType()) != FcgBasicType.VOID && fcgType != null) {
            FinalCodeGenerator.error("FCG: internal error generating a return; when a value must be returned");
        }
        this.returnInstruction(FcgType.VOID);
        this.clearCachedComments();
    }

    @Override
    public final void returnInstruction(FcgType fcgType) {
        StackValue stackValue = this.peek();
        if (stackValue == null) {
            this.genCode_returnInstruction(null);
        } else {
            Object object2;
            StackValue stackValue2;
            FcgType fcgType2 = stackValue.getType();
            if (fcgType2 != fcgType) {
                stackValue2 = this.pop(VALUE);
                object2 = this.genCode_coerce(fcgType2, fcgType, stackValue2);
                stackValue2.reset();
                this.push(VALUE, fcgType, object2);
            }
            if (fcgType == FcgType.VOID) {
                stackValue2 = stackValue;
                this.genCode_returnInstruction(stackValue2);
            } else {
                object2 = this.pop(VALUE);
                stackValue2 = this.peek();
                this.genCode_returnInstruction(stackValue2, (StackValue)object2);
                ((StackValue)object2).reset();
            }
        }
    }

    protected abstract void genCode_returnInstruction(StackValue var1);

    protected abstract void genCode_returnInstruction(StackValue var1, StackValue var2);

    @Override
    public void streamElemCopyStmt() {
        StackValue stackValue = this.pop(VALUE);
        StackValue stackValue2 = this.pop(VALUE);
        StackValue stackValue3 = this.pop(VALUE);
        StackValue stackValue4 = this.pop(VALUE);
        StackValue stackValue5 = this.pop(VALUE);
        this.genCode_streamElemCopyStmt(stackValue5, stackValue4, stackValue3, stackValue2, stackValue);
        stackValue.reset();
        stackValue2.reset();
        stackValue3.reset();
        stackValue4.reset();
        stackValue5.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_streamElemCopyStmt(StackValue var1, StackValue var2, StackValue var3, StackValue var4, StackValue var5);

    public static void error(String string2) {
        System.err.println(string2);
        throw new RuntimeException(string2);
    }

    public static void notImplemented() {
        String string2 = "FCG: not implemented";
        FinalCodeGenerator.error(string2);
    }

    private void invokeMethod(boolean bl, boolean bl2, FcgReferenceType fcgReferenceType, String string2, FcgType fcgType, int n2, FcgType[] fcgTypeArray) {
        String string3;
        Object object2;
        StackValue[] stackValueArray;
        if (0 < n2) {
            stackValueArray = new StackValue[n2];
            for (int i = n2 - 1; i >= 0; --i) {
                stackValueArray[i] = this.pop(VALUE);
            }
        } else {
            stackValueArray = null;
        }
        StackValue stackValue = null;
        if (bl) {
            stackValue = this.pop(null);
            if (DO_COMPILE_CHECKING && stackValue.getConstructKind() != VALUE) {
                object2 = "FCG: Expected 'this' reference, but got " + stackValue;
                FinalCodeGenerator.error((String)object2);
            }
        }
        if (DO_COMPILE_CHECKING && ((FcgReferenceTypeImpl)fcgReferenceType).isNotRegistered()) {
            object2 = "FCG: The reference type '" + fcgReferenceType.getTypeName() + "' is not registered.";
            FinalCodeGenerator.error((String)object2);
        }
        boolean bl3 = false;
        if (fcgReferenceType == null) {
            string3 = this.m_classGen.getClassType().getTypeName();
        } else {
            string3 = fcgReferenceType.getTypeName();
            if (fcgReferenceType instanceof FcgInterfaceType) {
                bl3 = true;
            }
        }
        object2 = this.genCode_invokeMethod(bl, bl3, bl2, stackValue, string3, string2, stackValueArray, fcgType, fcgTypeArray);
        if (stackValue != null) {
            stackValue.reset();
        }
        if (stackValueArray != null) {
            for (int i = 0; i < n2; ++i) {
                stackValueArray[i].reset();
            }
        }
        if (fcgType != FcgBasicType.VOID && bl2) {
            this.push(VALUE, fcgType, object2);
        }
        if (!bl2) {
            this.clearCachedComments();
        }
    }

    protected abstract Object genCode_invokeMethod(boolean var1, boolean var2, boolean var3, StackValue var4, String var5, String var6, StackValue[] var7, FcgType var8, FcgType[] var9);

    private void undeclareLocals(StackValue stackValue) {
        int n2 = stackValue.getNumLocalVars();
        int n3 = this.m_varStack.numLocalVars();
        for (int i = n2; i < n3; ++i) {
            this.undefinelVar();
        }
    }

    @Override
    public final void invokeSuperConstructor(FcgClassReferenceType fcgClassReferenceType, int n2) {
        StackValue stackValue;
        int n3;
        int n4 = n2;
        StackValue[] stackValueArray = new StackValue[n4];
        try {
            for (n3 = n4 - 1; n3 >= 0; --n3) {
                stackValueArray[n3] = this.pop(VALUE);
            }
            stackValue = this.pop(VALUE);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("FCG: not enough arguments pushed on FCG stack for invokeSuperConstructor() call.");
            throw runtimeException;
        }
        if (DO_COMPILE_CHECKING && fcgClassReferenceType == null) {
            FinalCodeGenerator.error("FCG: invokeSuperConstructor() requires non-null class type for the super class");
        }
        this.genCode_invokeSuper(fcgClassReferenceType, stackValue, stackValueArray);
        for (n3 = 0; n3 < n4; ++n3) {
            stackValueArray[n3].reset();
        }
        stackValue.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_invokeSuper(FcgClassReferenceType var1, StackValue var2, StackValue[] var3);

    public final void dispose() {
    }

    @Override
    public final void beginTryBlock() {
        Object object2 = this.genCode_beginTryBlock();
        this.clearCachedComments();
        this.push(TRYBLOCK, FcgType.VOID, object2);
    }

    protected abstract Object genCode_beginTryBlock();

    @Override
    public final FcgVariable beginCatchBlock(FcgType fcgType, String string2) {
        Object object2;
        StackValue stackValue = this.pop(null);
        Construct construct2 = stackValue.getConstructKind();
        if (DO_COMPILE_CHECKING && construct2 != TRYBLOCK && construct2 != CATCHBLOCK) {
            object2 = "FCG: Expecting to pop a TRYBLOCK or CATCHBLOCK Contruct from the FCG stack but got: " + construct2;
            FinalCodeGenerator.error((String)object2);
        }
        object2 = this.peek();
        this.undeclareLocals(stackValue);
        FcgVariable fcgVariable = this.defineCatchClauseParam(string2, fcgType, null);
        Object object3 = this.genCode_beginCatchBlock((StackValue)object2, stackValue, fcgVariable);
        stackValue.reset();
        this.push(CATCHBLOCK, FcgType.VOID, object3);
        this.clearCachedComments();
        return fcgVariable;
    }

    protected abstract Object genCode_beginCatchBlock(StackValue var1, StackValue var2, FcgVariable var3);

    @Override
    public final FcgType loadClassField(FcgClassReferenceType fcgClassReferenceType, String string2, FcgType fcgType) {
        String string3;
        if (DO_COMPILE_CHECKING && ((FcgReferenceTypeImpl)((Object)fcgClassReferenceType)).isNotRegistered()) {
            string3 = "FCG: The reference type '" + fcgClassReferenceType.getTypeName() + "' is not registered.";
            FinalCodeGenerator.error(string3);
        }
        string3 = fcgClassReferenceType.getTypeName();
        Object object2 = this.genCode_loadClassVariable(string3, string2, fcgType);
        this.push(VALUE, fcgType, object2);
        return fcgType;
    }

    protected abstract Object genCode_loadClassVariable(String var1, String var2, FcgType var3);

    @Override
    public final void storeClassFieldStmt(FcgClassReferenceType fcgClassReferenceType, String string2, FcgType fcgType) {
        Object object2;
        if (DO_COMPILE_CHECKING && ((FcgReferenceTypeImpl)((Object)fcgClassReferenceType)).isNotRegistered()) {
            object2 = "FCG: The reference type '" + fcgClassReferenceType.getTypeName() + "' is not registered.";
            FinalCodeGenerator.error((String)object2);
        }
        object2 = this.peek().getType();
        if (fcgType != null && object2 != fcgType) {
            this.convertExpr((FcgType)object2, fcgType);
        }
        StackValue stackValue = this.pop(VALUE);
        String string3 = fcgClassReferenceType != null ? fcgClassReferenceType.getTypeName() : this.m_classGen.getClassType().getTypeName();
        this.genCode_storeStaticFieldStmt(string3, fcgType, string2, stackValue);
        stackValue.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_storeStaticFieldStmt(String var1, FcgType var2, String var3, StackValue var4);

    final void setMethod(FcgMethodGen fcgMethodGen) {
        this.m_beginMethod2 = fcgMethodGen;
    }

    protected final FcgMethodGen getMethod() {
        return this.m_beginMethod2;
    }

    @Override
    public final void beginMethod() {
        FcgMethodGen fcgMethodGen = this.getMethod();
        this.push(METHOD);
        this.genCode_beginMethod(fcgMethodGen);
        this.clearCachedComments();
        if (fcgMethodGen.getAttributes().isStatic()) {
            this.setStaticContext(true);
        } else {
            this.setStaticContext(false);
        }
        if (fcgMethodGen.getName().equals("<init>") && (fcgMethodGen.getArgumentTypes() == null || fcgMethodGen.getArgumentTypes().length == 0)) {
            FcgClassGen fcgClassGen = this.getFcgClassGen();
            ((FcgClassGenImpl)fcgClassGen).setDefaultCtor(fcgMethodGen);
        }
    }

    protected abstract void genCode_beginMethod(FcgMethodGen var1);

    @Override
    public FcgType loadLiteral(BigDecimal bigDecimal) {
        this.push(VALUE, FcgBasicType.BIG_DECIMAL, this.genCode_loadLiteralValue(bigDecimal));
        return FcgBasicType.BIG_DECIMAL;
    }

    @Override
    public FcgType loadLiteral(BigInteger bigInteger) {
        this.push(VALUE, FcgBasicType.BIG_INTEGER, this.genCode_loadLiteralValue(bigInteger));
        return FcgBasicType.BIG_INTEGER;
    }

    protected abstract Object genCode_loadLiteralValue(BigDecimal var1);

    protected abstract Object genCode_loadLiteralValue(BigInteger var1);

    protected abstract Object genCode_loadLiteralValue(Character var1);

    protected abstract Object genCode_loadLiteralValue(Boolean var1);

    @Override
    public final int codeGenStackDepth() {
        return this.m_codeGenerationStack.m_freeIndex;
    }

    protected abstract Object genCode_arrayLengthExpr(StackValue var1);

    @Override
    public void storeArrayElemStmt() {
        StackValue stackValue = this.pop(VALUE);
        StackValue stackValue2 = this.pop(VALUE);
        StackValue stackValue3 = this.pop(VALUE);
        this.genCode_storeArrayElemStmt(stackValue3, stackValue2, stackValue);
        stackValue.reset();
        stackValue2.reset();
        stackValue3.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_storeArrayElemStmt(StackValue var1, StackValue var2, StackValue var3);

    @Override
    public final void fillStmt() {
        StackValue stackValue = this.pop(VALUE);
        StackValue stackValue2 = this.pop(VALUE);
        StackValue stackValue3 = this.pop(VALUE);
        StackValue stackValue4 = this.pop(VALUE);
        this.clearCachedComments();
        this.genCode_fillStmt(stackValue4, stackValue3, stackValue2, stackValue);
        stackValue.reset();
        stackValue2.reset();
        stackValue3.reset();
        stackValue4.reset();
    }

    protected abstract void genCode_fillStmt(StackValue var1, StackValue var2, StackValue var3, StackValue var4);

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CODE CURRENTLY PUSHED ON FCG CODE GEN STACK:\n");
        int n2 = this.m_codeGenerationStack.m_freeIndex - 1;
        for (int i = 0; i <= n2; ++i) {
            StackValue stackValue = this.m_codeGenerationStack.peek(i);
            stringBuffer.append("at depth " + (n2 - i) + " ");
            stringBuffer.append(stackValue.toString());
        }
        return stringBuffer.toString();
    }

    public abstract FcgVarMutableInternal newFcgVariable();

    protected abstract void genCode_beginScopeBlock();

    protected abstract void genCode_endScopeBlock(StackValue var1, StackValue var2);

    @Override
    public final void beginScopeBlock() {
        this.genCode_beginScopeBlock();
        this.clearCachedComments();
        this.push(SCOPEBLOCK);
    }

    @Override
    public final void endScopeBlock() {
        StackValue stackValue = this.peek();
        this.undeclareLocals(stackValue);
        stackValue = this.pop(SCOPEBLOCK);
        StackValue stackValue2 = this.peek();
        this.genCode_endScopeBlock(stackValue2, stackValue);
        stackValue.reset();
        this.clearCachedComments();
    }

    private static boolean canConvert(FcgType fcgType, FcgType fcgType2) {
        boolean bl = false;
        if (fcgType == fcgType2) {
            return true;
        }
        if (fcgType == FcgType.STRING) {
            if (fcgType2 == FcgType.CHAR_ARRAY) {
                bl = true;
            } else if (fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_INTEGER && fcgType2 != FcgType.BOOLEAN && fcgType2 != FcgType.BYTE && fcgType2 != FcgType.CHAR && !(fcgType2 instanceof FcgClassReferenceType) && fcgType2 != FcgType.DOUBLE && fcgType2 != FcgType.FLOAT && fcgType2 != FcgType.INT && fcgType2 != FcgType.LONG && fcgType2 != FcgType.SHORT && fcgType2 != FcgType.STRING && fcgType2 == FcgType.STRINGBUFFER) {
                // empty if block
            }
        } else if (fcgType == FcgType.BIG_DECIMAL) {
            if (fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_INTEGER) {
                if (fcgType2 == FcgType.BOOLEAN) {
                    bl = true;
                } else if (fcgType2 == FcgType.BYTE) {
                    bl = true;
                } else if (fcgType2 == FcgType.CHAR) {
                    bl = true;
                } else if (fcgType2 != FcgType.CHAR_ARRAY && !(fcgType2 instanceof FcgClassReferenceType)) {
                    if (fcgType2 == FcgType.DOUBLE) {
                        bl = true;
                    } else if (fcgType2 == FcgType.FLOAT) {
                        bl = true;
                    } else if (fcgType2 == FcgType.INT) {
                        bl = true;
                    } else if (fcgType2 == FcgType.LONG) {
                        bl = true;
                    } else if (fcgType2 == FcgType.SHORT) {
                        bl = true;
                    } else if (fcgType2 != FcgType.STRING && fcgType2 == FcgType.STRINGBUFFER) {
                        // empty if block
                    }
                }
            }
        } else if (fcgType == FcgType.BIG_INTEGER) {
            if (fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_INTEGER) {
                if (fcgType2 == FcgType.BOOLEAN) {
                    bl = true;
                } else if (fcgType2 == FcgType.BYTE) {
                    bl = true;
                } else if (fcgType2 == FcgType.CHAR) {
                    bl = true;
                } else if (fcgType2 != FcgType.CHAR_ARRAY && !(fcgType2 instanceof FcgClassReferenceType)) {
                    if (fcgType2 == FcgType.DOUBLE) {
                        bl = true;
                    } else if (fcgType2 == FcgType.FLOAT) {
                        bl = true;
                    } else if (fcgType2 == FcgType.INT) {
                        bl = true;
                    } else if (fcgType2 == FcgType.LONG) {
                        bl = true;
                    } else if (fcgType2 == FcgType.SHORT) {
                        bl = true;
                    } else if (fcgType2 != FcgType.STRING && fcgType2 == FcgType.STRINGBUFFER) {
                        // empty if block
                    }
                }
            }
        } else if (fcgType == FcgType.BOOLEAN) {
            if (fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_INTEGER) {
                if (fcgType2 == FcgType.BOOLEAN) {
                    bl = true;
                } else if (fcgType2 == FcgType.BYTE) {
                    bl = true;
                } else if (fcgType2 == FcgType.CHAR) {
                    bl = true;
                } else if (fcgType2 != FcgType.CHAR_ARRAY && !(fcgType2 instanceof FcgClassReferenceType)) {
                    if (fcgType2 == FcgType.DOUBLE) {
                        bl = true;
                    } else if (fcgType2 == FcgType.FLOAT) {
                        bl = true;
                    } else if (fcgType2 == FcgType.INT) {
                        bl = true;
                    } else if (fcgType2 == FcgType.LONG) {
                        bl = true;
                    } else if (fcgType2 == FcgType.SHORT) {
                        bl = true;
                    } else if (fcgType2 != FcgType.STRING && fcgType2 == FcgType.STRINGBUFFER) {
                        // empty if block
                    }
                }
            }
        } else if (fcgType == FcgType.BYTE) {
            if (fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_INTEGER) {
                if (fcgType2 == FcgType.BOOLEAN) {
                    bl = true;
                } else if (fcgType2 == FcgType.BYTE) {
                    bl = true;
                } else if (fcgType2 == FcgType.CHAR) {
                    bl = true;
                } else if (fcgType2 != FcgType.CHAR_ARRAY && !(fcgType2 instanceof FcgClassReferenceType)) {
                    if (fcgType2 == FcgType.DOUBLE) {
                        bl = true;
                    } else if (fcgType2 == FcgType.FLOAT) {
                        bl = true;
                    } else if (fcgType2 == FcgType.INT) {
                        bl = true;
                    } else if (fcgType2 == FcgType.LONG) {
                        bl = true;
                    } else if (fcgType2 == FcgType.SHORT) {
                        bl = true;
                    } else if (fcgType2 != FcgType.STRING && fcgType2 == FcgType.STRINGBUFFER) {
                        // empty if block
                    }
                }
            }
        } else if (fcgType == FcgType.CHAR) {
            if (fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_INTEGER) {
                if (fcgType2 == FcgType.BOOLEAN) {
                    bl = true;
                } else if (fcgType2 == FcgType.BYTE) {
                    bl = true;
                } else if (fcgType2 == FcgType.CHAR) {
                    bl = true;
                } else if (fcgType2 != FcgType.CHAR_ARRAY && !(fcgType2 instanceof FcgClassReferenceType)) {
                    if (fcgType2 == FcgType.DOUBLE) {
                        bl = true;
                    } else if (fcgType2 == FcgType.FLOAT) {
                        bl = true;
                    } else if (fcgType2 == FcgType.INT) {
                        bl = true;
                    } else if (fcgType2 == FcgType.LONG) {
                        bl = true;
                    } else if (fcgType2 == FcgType.SHORT) {
                        bl = true;
                    } else if (fcgType2 != FcgType.STRING && fcgType2 == FcgType.STRINGBUFFER) {
                        // empty if block
                    }
                }
            }
        } else if (fcgType == FcgType.CHAR_ARRAY) {
            if (fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_INTEGER && fcgType2 != FcgType.BOOLEAN && fcgType2 != FcgType.BYTE && fcgType2 != FcgType.CHAR && fcgType2 != FcgType.CHAR_ARRAY) {
                if (fcgType2 instanceof FcgClassReferenceType) {
                    if ("java.lang.String".equals(fcgType2.getTypeName())) {
                        bl = true;
                    }
                } else if (fcgType2 != FcgType.DOUBLE && fcgType2 != FcgType.FLOAT && fcgType2 != FcgType.INT && fcgType2 != FcgType.LONG && fcgType2 != FcgType.LONG && fcgType2 != FcgType.SHORT) {
                    if (fcgType2 == FcgType.STRING) {
                        bl = true;
                    } else if (fcgType2 == FcgType.STRINGBUFFER) {
                        // empty if block
                    }
                }
            }
        } else if (fcgType instanceof FcgClassReferenceType) {
            if (fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_INTEGER && fcgType2 != FcgType.BOOLEAN && fcgType2 != FcgType.BYTE && fcgType2 != FcgType.CHAR && fcgType2 != FcgType.CHAR_ARRAY) {
                if (fcgType2 instanceof FcgClassReferenceType || fcgType2 instanceof FcgInterfaceType) {
                    bl = true;
                } else if (fcgType2 != FcgType.DOUBLE && fcgType2 != FcgType.FLOAT && fcgType2 != FcgType.INT && fcgType2 != FcgType.LONG && fcgType2 != FcgType.SHORT && fcgType2 != FcgType.STRING && fcgType2 == FcgType.STRINGBUFFER) {
                    // empty if block
                }
            }
        } else if (fcgType == FcgType.DOUBLE) {
            if (fcgType2 != FcgType.BIG_DECIMAL) {
                if (fcgType2 == FcgType.BIG_DECIMAL) {
                    bl = true;
                } else if (fcgType2 != FcgType.BIG_INTEGER) {
                    if (fcgType2 == FcgType.BOOLEAN) {
                        bl = true;
                    } else if (fcgType2 == FcgType.BYTE) {
                        bl = true;
                    } else if (fcgType2 == FcgType.CHAR) {
                        bl = true;
                    } else if (fcgType2 != FcgType.CHAR_ARRAY && !(fcgType2 instanceof FcgClassReferenceType)) {
                        if (fcgType2 == FcgType.DOUBLE) {
                            bl = true;
                        } else if (fcgType2 == FcgType.FLOAT) {
                            bl = true;
                        } else if (fcgType2 == FcgType.INT) {
                            bl = true;
                        } else if (fcgType2 == FcgType.LONG) {
                            bl = true;
                        } else if (fcgType2 == FcgType.SHORT) {
                            bl = true;
                        } else if (fcgType2 != FcgType.STRING && fcgType2 == FcgType.STRINGBUFFER) {
                            // empty if block
                        }
                    }
                }
            }
        } else if (fcgType == FcgType.FLOAT) {
            if (fcgType2 == FcgType.BIG_DECIMAL) {
                bl = true;
            } else if (fcgType2 != FcgType.BIG_INTEGER) {
                if (fcgType2 == FcgType.BOOLEAN) {
                    bl = true;
                } else if (fcgType2 == FcgType.BYTE) {
                    bl = true;
                } else if (fcgType2 == FcgType.CHAR) {
                    bl = true;
                } else if (fcgType2 != FcgType.CHAR_ARRAY && !(fcgType2 instanceof FcgClassReferenceType)) {
                    if (fcgType2 == FcgType.DOUBLE) {
                        bl = true;
                    } else if (fcgType2 == FcgType.FLOAT) {
                        bl = true;
                    } else if (fcgType2 == FcgType.INT) {
                        bl = true;
                    } else if (fcgType2 == FcgType.LONG) {
                        bl = true;
                    } else if (fcgType2 == FcgType.SHORT) {
                        bl = true;
                    } else if (fcgType2 != FcgType.STRING && fcgType2 == FcgType.STRINGBUFFER) {
                        // empty if block
                    }
                }
            }
        } else if (fcgType == FcgType.INT || fcgType == INT_LITERAL) {
            if (fcgType2 != FcgType.BIG_DECIMAL) {
                if (fcgType2 == FcgType.BIG_DECIMAL) {
                    bl = true;
                } else if (fcgType2 != FcgType.BIG_INTEGER) {
                    if (fcgType2 == FcgType.BOOLEAN) {
                        bl = true;
                    } else if (fcgType2 == FcgType.BYTE) {
                        bl = true;
                    } else if (fcgType2 == FcgType.CHAR) {
                        bl = true;
                    } else if (fcgType2 == FcgType.CHAR_ARRAY) {
                        bl = true;
                    } else if (fcgType2 == FcgType.STRING) {
                        bl = true;
                    } else if (!(fcgType2 instanceof FcgClassReferenceType)) {
                        if (fcgType2 == FcgType.DOUBLE) {
                            bl = true;
                        } else if (fcgType2 == FcgType.FLOAT) {
                            bl = true;
                        } else if (fcgType2 == FcgType.INT) {
                            bl = true;
                        } else if (fcgType2 == FcgType.LONG) {
                            bl = true;
                        } else if (fcgType2 == FcgType.SHORT) {
                            bl = true;
                        } else if (fcgType2 == FcgType.STRINGBUFFER) {
                            // empty if block
                        }
                    }
                }
            }
        } else if (fcgType == FcgType.LONG) {
            if (fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_INTEGER) {
                if (fcgType2 == FcgType.BOOLEAN) {
                    bl = true;
                } else if (fcgType2 == FcgType.BYTE) {
                    bl = true;
                } else if (fcgType2 == FcgType.CHAR) {
                    bl = true;
                } else if (fcgType2 != FcgType.CHAR_ARRAY && !(fcgType2 instanceof FcgClassReferenceType)) {
                    if (fcgType2 == FcgType.DOUBLE) {
                        bl = true;
                    } else if (fcgType2 == FcgType.FLOAT) {
                        bl = true;
                    } else if (fcgType2 == FcgType.INT) {
                        bl = true;
                    } else if (fcgType2 == FcgType.LONG) {
                        bl = true;
                    } else if (fcgType2 == FcgType.SHORT) {
                        bl = true;
                    } else if (fcgType2 != FcgType.STRING && fcgType2 == FcgType.STRINGBUFFER) {
                        // empty if block
                    }
                }
            }
        } else if (fcgType == FcgType.SHORT) {
            if (fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_INTEGER) {
                if (fcgType2 == FcgType.BOOLEAN) {
                    bl = true;
                } else if (fcgType2 == FcgType.BYTE) {
                    bl = true;
                } else if (fcgType2 == FcgType.CHAR) {
                    bl = true;
                } else if (fcgType2 != FcgType.CHAR_ARRAY && !(fcgType2 instanceof FcgClassReferenceType)) {
                    if (fcgType2 == FcgType.DOUBLE) {
                        bl = true;
                    } else if (fcgType2 == FcgType.FLOAT) {
                        bl = true;
                    } else if (fcgType2 == FcgType.INT) {
                        bl = true;
                    } else if (fcgType2 == FcgType.LONG) {
                        bl = true;
                    } else if (fcgType2 == FcgType.SHORT) {
                        bl = true;
                    } else if (fcgType2 != FcgType.STRING && fcgType2 == FcgType.STRINGBUFFER) {
                        // empty if block
                    }
                }
            }
        } else if (fcgType == FcgType.STRINGBUFFER && fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_INTEGER && fcgType2 != FcgType.BOOLEAN && fcgType2 != FcgType.BYTE && fcgType2 != FcgType.CHAR) {
            if (fcgType2 == FcgType.CHAR_ARRAY) {
                bl = true;
            } else if (fcgType2 instanceof FcgClassReferenceType || fcgType2 == FcgType.DOUBLE || fcgType2 == FcgType.FLOAT || fcgType2 == FcgType.INT || fcgType2 == FcgType.SHORT || fcgType2 == FcgType.STRING || fcgType2 == FcgType.STRINGBUFFER) {
                // empty if block
            }
        }
        return bl;
    }

    @Override
    public FcgType loadInstanceField(FcgField fcgField) {
        FcgAttrs fcgAttrs = fcgField.getAttrs();
        FcgClassReferenceType fcgClassReferenceType = ((FcgFieldGenImpl)fcgField).getDefiningClass();
        String string2 = fcgField.getName();
        FcgType fcgType = fcgField.getType();
        if (DO_COMPILE_CHECKING && fcgAttrs.isStatic()) {
            String string3 = fcgAttrs.toString() + fcgType.getTypeName() + ' ' + fcgClassReferenceType.getTypeName() + '.' + string2;
            FinalCodeGenerator.error("FCG: loadInstanceField(FcgField) is trying to load a class field: " + string3);
        }
        this.loadInstanceField(fcgClassReferenceType, string2, fcgType);
        return fcgType;
    }

    @Override
    public FcgType loadClassField(FcgField fcgField) {
        FcgAttrs fcgAttrs = fcgField.getAttrs();
        FcgClassReferenceType fcgClassReferenceType = ((FcgFieldGenImpl)fcgField).getDefiningClass();
        String string2 = fcgField.getName();
        FcgType fcgType = fcgField.getType();
        if (DO_COMPILE_CHECKING && !fcgAttrs.isStatic()) {
            String string3 = fcgAttrs.toString() + fcgType.getTypeName() + ' ' + fcgClassReferenceType.getTypeName() + '.' + string2;
            FinalCodeGenerator.error("FCG: loadClassField(FcgField) is trying to load an instance field: " + string3);
        }
        this.loadClassField(fcgClassReferenceType, string2, fcgType);
        return fcgType;
    }

    @Override
    public void storeInstanceFieldStmt(FcgField fcgField) {
        FcgAttrs fcgAttrs = fcgField.getAttrs();
        FcgClassReferenceType fcgClassReferenceType = ((FcgFieldGenImpl)fcgField).getDefiningClass();
        String string2 = fcgField.getName();
        FcgType fcgType = fcgField.getType();
        if (DO_COMPILE_CHECKING && fcgAttrs.isStatic()) {
            String string3 = fcgAttrs.toString() + fcgType.getTypeName() + ' ' + fcgClassReferenceType.getTypeName() + '.' + string2;
            FinalCodeGenerator.error("FCG: storeInstanceFieldStmt(FcgField) is trying to store to a class field: " + string3);
        }
        this.storeInstanceFieldStmt(fcgClassReferenceType, string2, fcgType);
    }

    @Override
    public void storeClassFieldStmt(FcgField fcgField) {
        FcgAttrs fcgAttrs = fcgField.getAttrs();
        FcgClassReferenceType fcgClassReferenceType = ((FcgFieldGenImpl)fcgField).getDefiningClass();
        String string2 = fcgField.getName();
        FcgType fcgType = fcgField.getType();
        if (DO_COMPILE_CHECKING && !fcgAttrs.isStatic()) {
            String string3 = fcgAttrs.toString() + fcgType.getTypeName() + ' ' + fcgClassReferenceType.getTypeName() + '.' + string2;
            FinalCodeGenerator.error("FCG: storeClassFieldStmt(FcgField) is trying to store to an instance field: " + string3);
        }
        this.storeClassFieldStmt(fcgClassReferenceType, string2, fcgType);
    }

    @Override
    public void runtimeTypeCheck(FcgReferenceType fcgReferenceType) {
        StackValue stackValue = this.pop(VALUE);
        Object object2 = this.genCode_runtimeTypeCheck(stackValue, fcgReferenceType);
        stackValue.reset();
        this.push(VALUE, FcgType.BOOLEAN, object2);
    }

    protected abstract Object genCode_runtimeTypeCheck(StackValue var1, FcgReferenceType var2);

    private final FcgVariable findFcgVariable2(String string2) {
        for (int i = this.m_varStack.m_freeIndex - 1; 0 <= i; --i) {
            FcgVarMutableInternal fcgVarMutableInternal = this.m_varStack.m_stackArr[i];
            if (!string2.equals(fcgVarMutableInternal.getName())) continue;
            return fcgVarMutableInternal;
        }
        return null;
    }

    public abstract void setStaticContext(boolean var1);

    protected abstract boolean isEmpty();

    protected abstract boolean isClassContext();

    public static void unimplementedException() {
        String string2 = "FCG BCEL feature is unimplemented";
        throw new RuntimeException(string2);
    }

    public static void unimplementedException(String string2) {
        throw new FcgRuntimeException("FCG INTERNAL ERROR. " + string2);
    }

    private final Object genCode_unaryOperation(FcgUnaryOp fcgUnaryOp, StackValue stackValue, FcgType fcgType) {
        FcgType fcgType2 = stackValue.getType();
        int n2 = ((Operation)((Object)fcgUnaryOp)).getFcgOpCode();
        Object object2 = null;
        switch (n2) {
            case 106: {
                if (fcgType2 == FcgType.BIG_INTEGER || fcgType2 == FcgType.BIG_DECIMAL) {
                    object2 = this.gencode_UNARY_NEGATE_BIG(stackValue);
                    break;
                }
                if (fcgType == FcgType.INT) {
                    object2 = this.genCode_UNARY_NEGATE_INT(stackValue);
                    break;
                }
                if (fcgType2 == FcgType.FLOAT) {
                    object2 = this.genCode_UNARY_NEGATE_FLOAT(stackValue);
                    break;
                }
                if (fcgType2 == FcgType.DOUBLE) {
                    object2 = this.genCode_UNARY_NEGATE_DOUBLE(stackValue);
                    break;
                }
                if (fcgType2 == FcgType.LONG) {
                    object2 = this.genCode_UNARY_NEGATE_LONG(stackValue);
                    break;
                }
                FinalCodeGenerator.unimplementedException();
                break;
            }
            case 1130: {
                if (fcgType == FcgType.INT) {
                    object2 = this.genCode_UNARY_BITWISE_NOT_INT(stackValue);
                    break;
                }
                if (fcgType == FcgType.LONG) {
                    object2 = this.genCode_UNARY_BITWISE_NOT_LONG(stackValue);
                    break;
                }
                FinalCodeGenerator.unimplementedException();
                break;
            }
            case 201: {
                object2 = this.genCode_UNARY_LOGICAL_NOT(stackValue);
                break;
            }
            case 300: {
                if (fcgType2 == FcgType.BIG_INTEGER || fcgType2 == FcgType.BIG_DECIMAL) {
                    object2 = this.genCode_UNARY_ABS_BIG(stackValue);
                    break;
                }
                if (fcgType == FcgType.INT) {
                    object2 = this.genCode_UNARY_ABS_INT(stackValue);
                    break;
                }
                if (fcgType == FcgType.LONG) {
                    object2 = this.genCode_UNARY_ABS_LONG(stackValue);
                    break;
                }
                if (fcgType == FcgType.FLOAT) {
                    object2 = this.genCode_UNARY_ABS_FLOAT(stackValue);
                    break;
                }
                if (fcgType == FcgType.DOUBLE) {
                    object2 = this.genCode_UNARY_ABS_DOUBLE(stackValue);
                    break;
                }
                FinalCodeGenerator.unimplementedException();
                break;
            }
            case 301: {
                if (fcgType2 == FcgType.BIG_INTEGER || fcgType2 == FcgType.BIG_DECIMAL) {
                    object2 = this.genCode_UNARY_ROUND_BIG(stackValue);
                    break;
                }
                if (fcgType2 == FcgType.FLOAT) {
                    object2 = this.genCode_UNARY_ROUND_FLOAT(stackValue);
                    break;
                }
                if (fcgType2 == FcgType.DOUBLE) {
                    object2 = this.genCode_UNARY_ROUND_DOUBLE(stackValue);
                    break;
                }
                if (fcgType2 == FcgType.INT || fcgType2 == FcgType.BYTE || fcgType2 == FcgType.LONG) {
                    object2 = this.genCode_UNARY_ROUND_INT(stackValue);
                    break;
                }
                FinalCodeGenerator.unimplementedException();
                break;
            }
            case 302: {
                if (fcgType2 == FcgType.BYTE || fcgType2 == FcgType.INT || fcgType2 == INT_LITERAL || fcgType2 == FcgType.LONG || fcgType2 == FcgType.BIG_INTEGER) {
                    object2 = this.genCode_UNARY_CEILING_INT(stackValue);
                    break;
                }
                if (fcgType2 == FcgType.FLOAT) {
                    object2 = this.genCode_UNARY_CEILING_FLOAT(stackValue);
                    break;
                }
                if (fcgType2 == FcgType.DOUBLE) {
                    object2 = this.genCode_UNARY_CEILING_DOUBLE(stackValue);
                    break;
                }
                if (fcgType2 == FcgType.BIG_DECIMAL) {
                    object2 = this.genCode_UNARY_CEILING_BIG_DECIMAL(stackValue);
                    break;
                }
                FinalCodeGenerator.unimplementedException();
                break;
            }
            case 303: {
                if (fcgType2 == FcgType.BYTE || fcgType2 == FcgType.INT || fcgType2 == INT_LITERAL || fcgType2 == FcgType.LONG || fcgType2 == FcgType.BIG_INTEGER) {
                    object2 = this.genCode_UNARY_FLOOR_INT(stackValue);
                    break;
                }
                if (fcgType2 == FcgType.FLOAT) {
                    object2 = this.genCode_UNARY_FLOOR_FLOAT(stackValue);
                    break;
                }
                if (fcgType2 == FcgType.DOUBLE) {
                    object2 = this.genCode_UNARY_FLOOR_DOUBLE(stackValue);
                    break;
                }
                if (fcgType2 == FcgType.BIG_DECIMAL) {
                    object2 = this.genCode_UNARY_FLOOR_BIG_DECIMAL(stackValue);
                    break;
                }
                FinalCodeGenerator.unimplementedException();
                break;
            }
            case 305: {
                if (fcgType2 == FcgType.BYTE || fcgType2 == FcgType.INT || fcgType2 == INT_LITERAL) {
                    object2 = this.genCode_UNARY_IS_NAN_INT(stackValue);
                    break;
                }
                if (fcgType2 == FcgType.LONG) {
                    object2 = this.genCode_UNARY_IS_NAN__LONG(stackValue);
                    break;
                }
                if (fcgType2 == FcgType.FLOAT) {
                    object2 = this.genCode_UNARY_IS_NAN__FLOAT(stackValue);
                    break;
                }
                if (fcgType2 == FcgType.DOUBLE) {
                    object2 = this.genCode_UNARY_IS_NAN_DOUBLE(stackValue);
                    break;
                }
                throw new UnsupportedOperationException("FcgInstructionListBCEL: bad op type for isNaN" + fcgType2);
            }
            case 306: {
                if (fcgType2 == FcgType.STRING) {
                    object2 = this.genCode_UNARY_ARRAY_LENGTH_STRING(stackValue);
                    break;
                }
                if (stackValue.getType() instanceof FcgArrayType) {
                    object2 = this.genCode_UNARY_ARRAY_LENGTH_ARRAY(stackValue);
                    break;
                }
                FinalCodeGenerator.unimplementedException();
                break;
            }
            case 307: {
                if (fcgType2 == FcgType.STRING) {
                    object2 = this.genCode_UNARY_TO_CHAR_ARRAY_STRING(stackValue, fcgType2);
                    break;
                }
                FinalCodeGenerator.unimplementedException();
                break;
            }
            default: {
                FinalCodeGenerator.unimplementedException();
            }
        }
        return object2;
    }

    protected abstract Object genCode_UNARY_ABS_BIG(StackValue var1);

    protected abstract Object genCode_UNARY_ABS_DOUBLE(StackValue var1);

    protected abstract Object genCode_UNARY_ABS_FLOAT(StackValue var1);

    protected abstract Object genCode_UNARY_ABS_INT(StackValue var1);

    protected abstract Object genCode_UNARY_ABS_LONG(StackValue var1);

    protected abstract Object genCode_UNARY_ARRAY_LENGTH_ARRAY(StackValue var1);

    protected abstract Object genCode_UNARY_ARRAY_LENGTH_STRING(StackValue var1);

    protected abstract Object genCode_UNARY_BITWISE_NOT_INT(StackValue var1);

    protected abstract Object genCode_UNARY_BITWISE_NOT_LONG(StackValue var1);

    protected abstract Object genCode_UNARY_CEILING_DOUBLE(StackValue var1);

    protected abstract Object genCode_UNARY_CEILING_BIG_DECIMAL(StackValue var1);

    protected abstract Object genCode_UNARY_CEILING_FLOAT(StackValue var1);

    protected abstract Object genCode_UNARY_CEILING_INT(StackValue var1);

    protected abstract Object genCode_UNARY_FLOOR_DOUBLE(StackValue var1);

    protected abstract Object genCode_UNARY_FLOOR_BIG_DECIMAL(StackValue var1);

    protected abstract Object genCode_UNARY_FLOOR_FLOAT(StackValue var1);

    protected abstract Object genCode_UNARY_FLOOR_INT(StackValue var1);

    protected abstract Object genCode_UNARY_IS_NAN__FLOAT(StackValue var1);

    protected abstract Object genCode_UNARY_IS_NAN__LONG(StackValue var1);

    protected abstract Object genCode_UNARY_IS_NAN_DOUBLE(StackValue var1);

    protected abstract Object genCode_UNARY_IS_NAN_INT(StackValue var1);

    protected abstract Object genCode_UNARY_LOGICAL_NOT(StackValue var1);

    protected abstract Object gencode_UNARY_NEGATE_BIG(StackValue var1);

    protected abstract Object genCode_UNARY_NEGATE_DOUBLE(StackValue var1);

    protected abstract Object genCode_UNARY_NEGATE_FLOAT(StackValue var1);

    protected abstract Object genCode_UNARY_NEGATE_INT(StackValue var1);

    protected abstract Object genCode_UNARY_NEGATE_LONG(StackValue var1);

    protected abstract Object genCode_UNARY_ROUND_BIG(StackValue var1);

    protected abstract Object genCode_UNARY_ROUND_DOUBLE(StackValue var1);

    protected abstract Object genCode_UNARY_ROUND_FLOAT(StackValue var1);

    protected abstract Object genCode_UNARY_ROUND_INT(StackValue var1);

    protected abstract Object genCode_UNARY_TO_CHAR_ARRAY_STRING(StackValue var1, FcgType var2);

    private final Object genCode_binaryOperation(FcgBinOp fcgBinOp, StackValue stackValue, StackValue stackValue2, FcgType fcgType) {
        Object object2;
        FcgType fcgType2 = stackValue.getType();
        FcgType fcgType3 = stackValue2.getType();
        int n2 = ((Operation)((Object)fcgBinOp)).getFcgOpCode();
        switch (n2) {
            case 100: {
                if ((fcgType2 == FcgType.BIG_INTEGER || fcgType2 == FcgType.BIG_DECIMAL) && fcgType2 == fcgType3) {
                    object2 = this.genCode_BINARY_ADD_BIG(stackValue, stackValue2);
                    break;
                }
                if (fcgType2 == FcgType.STRING) {
                    object2 = this.genCode_BINARY_ADD_STRING(stackValue, stackValue2);
                    break;
                }
                object2 = this.genCode_BINARY_ADD(stackValue, stackValue2, fcgType, n2);
                break;
            }
            case 101: {
                if ((fcgType2 == FcgType.BIG_INTEGER || fcgType2 == FcgType.BIG_DECIMAL) && fcgType2 == fcgType3) {
                    object2 = this.genCode_BINARY_SUBTRACT_BIG(stackValue, stackValue2);
                    break;
                }
                object2 = this.genCode_BINARY_SUBTRACT(stackValue, stackValue2, fcgType, n2);
                break;
            }
            case 102: {
                if ((fcgType2 == FcgType.BIG_INTEGER || fcgType2 == FcgType.BIG_DECIMAL) && fcgType2 == fcgType3) {
                    object2 = this.genCode_BINARY_MULTIPLY_BIG(stackValue, stackValue2, fcgType, n2);
                    break;
                }
                object2 = this.genCode_BINARY_MULTIPLY(stackValue, stackValue2, fcgType, n2);
                break;
            }
            case 103: {
                if ((fcgType2 == FcgType.BIG_INTEGER || fcgType2 == FcgType.BIG_DECIMAL) && fcgType2 == fcgType3) {
                    object2 = this.genCode_BINARY_DIVIDE_BIG(stackValue, stackValue2);
                    break;
                }
                object2 = this.genCode_BINARY_DIVIDE(stackValue, stackValue2, fcgType, n2);
                break;
            }
            case 104: {
                if (fcgType2 == FcgType.BIG_INTEGER && fcgType3 == FcgType.BIG_INTEGER) {
                    object2 = this.genCode_BINARY_MODULO_BIG(stackValue, stackValue2);
                    break;
                }
                object2 = this.genCode_BINARY_MODULO(stackValue, stackValue2, fcgType, n2);
                break;
            }
            case 110: {
                object2 = this.genCode_BINARY_SHIFT_LEFT(stackValue, stackValue2, fcgType);
                break;
            }
            case 111: {
                object2 = this.genCode_BINARY_SHIFT_RIGHT(stackValue, stackValue2, fcgType);
                break;
            }
            case 112: {
                object2 = this.genCode_BINARY_SHIFT_RIGHT_UNSIGNED(stackValue, stackValue2, fcgType);
                break;
            }
            case 114: {
                object2 = this.genCode_BINARY_BITWISE_AND(stackValue, stackValue2, fcgType);
                break;
            }
            case 115: {
                object2 = this.genCode_BINARY_BITWISE_OR(stackValue, stackValue2, fcgType);
                break;
            }
            case 116: {
                if (fcgType2 == FcgType.BIG_INTEGER) {
                    object2 = this.genCode_BINARY_BITWISE_XOR_BIG(stackValue, stackValue2, fcgType);
                    break;
                }
                object2 = this.genCode_BINARY_BITWISE_XOR(stackValue, stackValue2, fcgType);
                break;
            }
            case 150: {
                object2 = this.genCode_BINARY_COMPARE_EQ_REFERENCE(stackValue, stackValue2, fcgType2, fcgType3);
                break;
            }
            case 157: {
                object2 = this.genCode_BINARY_COMPARE_NOT_EQ_REFERENCE(stackValue, stackValue2, fcgType2, fcgType3);
                break;
            }
            case 151: {
                if (fcgType2 == FcgType.STRING || fcgType3 == FcgType.STRING) {
                    object2 = this.genCode_BINARY_COMPARE_EQ_STRING(stackValue, stackValue2, fcgType2, fcgType3);
                    break;
                }
                if (fcgType2 == FcgType.BIG_INTEGER || fcgType2 == FcgType.BIG_DECIMAL || fcgType3 == FcgType.BIG_INTEGER || fcgType3 == FcgType.BIG_DECIMAL) {
                    object2 = this.genCode_BINARY_COMPARE_EQ_BIG(stackValue, stackValue2, fcgType2, fcgType3);
                    break;
                }
                if (fcgType2 instanceof FcgReferenceType || fcgType3 instanceof FcgReferenceType) {
                    object2 = this.genCode_BINARY_COMPARE_EQ_REFERENCE(stackValue, stackValue2, fcgType2, fcgType3);
                    break;
                }
                object2 = this.genCode_BINARY_COMPARE_EQ_PRIMITIVE(stackValue, stackValue2, fcgType2, fcgType3);
                break;
            }
            case 152: {
                if (fcgType2 == FcgType.STRING || fcgType3 == FcgType.STRING) {
                    object2 = this.genCode_BINARY_COMPARE_NOT_EQ_STRING(stackValue, stackValue2, fcgType2, fcgType3);
                    break;
                }
                if (fcgType2 == FcgType.BIG_INTEGER || fcgType2 == FcgType.BIG_DECIMAL || fcgType3 == FcgType.BIG_INTEGER || fcgType3 == FcgType.BIG_DECIMAL) {
                    object2 = this.genCode_BINARY_COMPARE_NOT_EQ_BIG(stackValue, stackValue2, fcgType2, fcgType3);
                    break;
                }
                if (fcgType2 instanceof FcgReferenceType || fcgType3 instanceof FcgReferenceType) {
                    object2 = this.genCode_BINARY_COMPARE_NOT_EQ_REFERENCE(stackValue, stackValue2, fcgType2, fcgType3);
                    break;
                }
                object2 = this.genCode_BINARY_COMPARE_NOT_EQ_PRIMITIVE(stackValue, stackValue2, fcgType2, fcgType3);
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: {
                if ((fcgType2 == FcgType.BIG_INTEGER || fcgType2 == FcgType.BIG_DECIMAL) && fcgType2 == fcgType3) {
                    object2 = this.genCode_BINARY_COMPARE_ORDER_BIG(stackValue, stackValue2, fcgType2, fcgType3, n2);
                    break;
                }
                if (fcgType2 == FcgType.STRING && fcgType3 == FcgType.STRING) {
                    object2 = this.genCode_BINARY_COMPARE_ORDER_STRING(stackValue, stackValue2, n2);
                    break;
                }
                object2 = this.genCode_BINARY_COMPARE_ORDER_PRIMITIVE(stackValue, stackValue2, fcgType2, fcgType3, n2);
                break;
            }
            case 202: {
                object2 = this.genCode_BINARY_LOGICAL_AND_EVALBOTH(stackValue, stackValue2);
                break;
            }
            case 203: {
                object2 = this.genCode_BINARY_LOGICAL_OR_EVALBOTH(stackValue, stackValue2);
                break;
            }
            case 204: {
                object2 = this.genCode_BINARY_LOGICAL_XOR(stackValue, stackValue2);
                break;
            }
            case 205: {
                object2 = this.genCode_BINARY_LOGICAL_CONDITIONAL_AND(stackValue, stackValue2);
                break;
            }
            case 206: {
                object2 = this.genCode_BINARY_LOGICAL_CONDITIONAL_OR(stackValue, stackValue2);
                break;
            }
            default: {
                String string2 = "unexpected op-code for a binary operation: " + fcgBinOp + " " + fcgBinOp.toString();
                FinalCodeGenerator.unimplementedException(string2);
                object2 = null;
            }
        }
        return object2;
    }

    protected abstract Object genCode_BINARY_ADD(StackValue var1, StackValue var2, FcgType var3, int var4);

    protected abstract Object genCode_BINARY_ADD_BIG(StackValue var1, StackValue var2);

    protected abstract Object genCode_BINARY_ADD_STRING(StackValue var1, StackValue var2);

    protected abstract Object genCode_BINARY_BITWISE_AND(StackValue var1, StackValue var2, FcgType var3);

    protected abstract Object genCode_BINARY_BITWISE_OR(StackValue var1, StackValue var2, FcgType var3);

    protected abstract Object genCode_BINARY_BITWISE_XOR(StackValue var1, StackValue var2, FcgType var3);

    protected abstract Object genCode_BINARY_BITWISE_XOR_BIG(StackValue var1, StackValue var2, FcgType var3);

    protected abstract Object genCode_BINARY_COMPARE_EQ_BIG(StackValue var1, StackValue var2, FcgType var3, FcgType var4);

    protected abstract Object genCode_BINARY_COMPARE_EQ_PRIMITIVE(StackValue var1, StackValue var2, FcgType var3, FcgType var4);

    protected abstract Object genCode_BINARY_COMPARE_EQ_REFERENCE(StackValue var1, StackValue var2, FcgType var3, FcgType var4);

    protected abstract Object genCode_BINARY_COMPARE_EQ_STRING(StackValue var1, StackValue var2, FcgType var3, FcgType var4);

    protected abstract Object genCode_BINARY_COMPARE_NOT_EQ_BIG(StackValue var1, StackValue var2, FcgType var3, FcgType var4);

    protected abstract Object genCode_BINARY_COMPARE_NOT_EQ_PRIMITIVE(StackValue var1, StackValue var2, FcgType var3, FcgType var4);

    protected abstract Object genCode_BINARY_COMPARE_NOT_EQ_REFERENCE(StackValue var1, StackValue var2, FcgType var3, FcgType var4);

    protected abstract Object genCode_BINARY_COMPARE_NOT_EQ_STRING(StackValue var1, StackValue var2, FcgType var3, FcgType var4);

    protected abstract Object genCode_BINARY_COMPARE_ORDER_BIG(StackValue var1, StackValue var2, FcgType var3, FcgType var4, int var5);

    protected abstract Object genCode_BINARY_COMPARE_ORDER_PRIMITIVE(StackValue var1, StackValue var2, FcgType var3, FcgType var4, int var5);

    protected abstract Object genCode_BINARY_COMPARE_ORDER_STRING(StackValue var1, StackValue var2, int var3);

    protected abstract Object genCode_BINARY_DIVIDE(StackValue var1, StackValue var2, FcgType var3, int var4);

    protected abstract Object genCode_BINARY_DIVIDE_BIG(StackValue var1, StackValue var2);

    protected abstract Object genCode_BINARY_LOGICAL_AND_EVALBOTH(StackValue var1, StackValue var2);

    protected abstract Object genCode_BINARY_LOGICAL_CONDITIONAL_AND(StackValue var1, StackValue var2);

    protected abstract Object genCode_BINARY_LOGICAL_CONDITIONAL_OR(StackValue var1, StackValue var2);

    protected abstract Object genCode_BINARY_LOGICAL_OR_EVALBOTH(StackValue var1, StackValue var2);

    protected abstract Object genCode_BINARY_LOGICAL_XOR(StackValue var1, StackValue var2);

    protected abstract Object genCode_BINARY_MODULO(StackValue var1, StackValue var2, FcgType var3, int var4);

    protected abstract Object genCode_BINARY_MODULO_BIG(StackValue var1, StackValue var2);

    protected abstract Object genCode_BINARY_MULTIPLY(StackValue var1, StackValue var2, FcgType var3, int var4);

    protected abstract Object genCode_BINARY_MULTIPLY_BIG(StackValue var1, StackValue var2, FcgType var3, int var4);

    protected abstract Object genCode_BINARY_SHIFT_LEFT(StackValue var1, StackValue var2, FcgType var3);

    protected abstract Object genCode_BINARY_SHIFT_RIGHT(StackValue var1, StackValue var2, FcgType var3);

    protected abstract Object genCode_BINARY_SHIFT_RIGHT_UNSIGNED(StackValue var1, StackValue var2, FcgType var3);

    protected abstract Object genCode_BINARY_SUBTRACT(StackValue var1, StackValue var2, FcgType var3, int var4);

    protected abstract Object genCode_BINARY_SUBTRACT_BIG(StackValue var1, StackValue var2);

    protected final Object genCode_coerce(FcgType fcgType, FcgType fcgType2, StackValue stackValue) {
        Object object2;
        if (fcgType == fcgType2) {
            return stackValue.getCodeData();
        }
        if (fcgType == FcgType.STRING) {
            if (fcgType2 == FcgType.CHAR_ARRAY) {
                object2 = this.genCode_COERCE_STRING2CHAR_ARRAY(stackValue);
            } else if (fcgType2 == FcgType.BIG_DECIMAL) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.BIG_INTEGER) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.BOOLEAN) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.BYTE) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.CHAR) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 instanceof FcgClassReferenceType || fcgType2 instanceof FcgInterfaceType) {
                object2 = this.genCode_COERCE_2REFERENCE_TYPE(fcgType2, stackValue);
            } else if (fcgType2 == FcgType.DOUBLE) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.FLOAT) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.INT) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.LONG) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.OBJECT) {
                object2 = stackValue.getCodeData();
            } else if (fcgType2 == FcgType.SHORT) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.STRING) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.STRINGBUFFER) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            }
        } else if (fcgType == FcgType.BIG_DECIMAL) {
            if (fcgType2 == FcgType.BIG_INTEGER) {
                object2 = this.genCode_COERCE_BIG_DECIMAL2BIG_INTEGER(fcgType, stackValue);
            } else if (fcgType2 == FcgType.BOOLEAN) {
                object2 = this.genCode_COERCE_BIG_DECIMAL2BOOLEAN(fcgType, stackValue);
            } else if (fcgType2 == FcgType.BYTE) {
                object2 = this.genCode_COERCE_BIG_DECIMAL2BYTE(fcgType, stackValue);
            } else if (fcgType2 == FcgType.CHAR) {
                object2 = this.genCode_COERCE_BIG_DECIMAL2CHAR(fcgType, stackValue);
            } else if (fcgType2 == FcgType.CHAR_ARRAY) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.DOUBLE) {
                object2 = this.genCode_COERCE_BIG_DECIMAL2DOUBLE(fcgType, stackValue);
            } else if (fcgType2 == FcgType.FLOAT) {
                object2 = this.genCode_COERCE_BIG_DECIMAL2FLOAT(fcgType, stackValue);
            } else if (fcgType2 == FcgType.INT) {
                object2 = this.genCode_COERCE_BIG_DECIMAL2INT(fcgType, stackValue);
            } else if (fcgType2 == FcgType.LONG) {
                object2 = this.genCode_COERCE_BIG_DECIMAL2LONG(fcgType, stackValue);
            } else if (fcgType2 == FcgType.SHORT) {
                object2 = this.genCode_COERCE_BIG_DECIMAL2SHORT(fcgType, stackValue);
            } else if (fcgType2 == FcgType.STRING) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.STRINGBUFFER) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 instanceof FcgClassReferenceType || fcgType2 instanceof FcgInterfaceType) {
                object2 = this.genCode_COERCE_2REFERENCE_TYPE(fcgType2, stackValue);
            } else {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            }
        } else if (fcgType == FcgType.BIG_INTEGER) {
            if (fcgType2 == FcgType.BIG_DECIMAL) {
                object2 = this.genCode_COERCE_BIG_INTEGER2BIG_DECIMAL(fcgType, stackValue);
            } else if (fcgType2 == FcgType.BOOLEAN) {
                object2 = this.genCode_COERCE_BIG_INTEGER2BOOLEAN(fcgType, stackValue);
            } else if (fcgType2 == FcgType.BYTE) {
                object2 = this.genCode_COERCE_BIG_INTEGER2BYTE(fcgType, stackValue);
            } else if (fcgType2 == FcgType.CHAR) {
                object2 = this.genCode_COERCE_BIG_INTEGER2CHAR(fcgType, stackValue);
            } else if (fcgType2 == FcgType.CHAR_ARRAY) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.DOUBLE) {
                object2 = this.genCode_COERCE_BIG_INTEGER2DOUBLE(fcgType, stackValue);
            } else if (fcgType2 == FcgType.FLOAT) {
                object2 = this.genCode_COERCE_BIG_INTEGER2FLOAT(fcgType, stackValue);
            } else if (fcgType2 == FcgType.INT) {
                object2 = this.genCode_COERCE_BIG_INTEGER2INT(fcgType, stackValue);
            } else if (fcgType2 == FcgType.LONG) {
                object2 = this.genCode_COERCE_BIG_INTEGER2LONG(fcgType, stackValue);
            } else if (fcgType2 == FcgType.SHORT) {
                object2 = this.genCode_COERCE_BIG_INTEGER2SHORT(fcgType, stackValue);
            } else if (fcgType2 == FcgType.STRING) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.STRINGBUFFER) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 instanceof FcgClassReferenceType || fcgType2 instanceof FcgInterfaceType) {
                object2 = this.genCode_COERCE_2REFERENCE_TYPE(fcgType2, stackValue);
            } else {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            }
        } else if (fcgType == FcgType.BOOLEAN) {
            if (fcgType2 == FcgType.BIG_DECIMAL) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.BIG_INTEGER) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.BOOLEAN) {
                object2 = stackValue.getCodeData();
            } else if (fcgType2 == FcgType.BYTE) {
                object2 = this.genCode_COERCE_BOOLEAN2BYTE(stackValue);
            } else if (fcgType2 == FcgType.CHAR) {
                object2 = this.genCode_COERCE_BOOLEAN2CHAR(stackValue);
            } else if (fcgType2 == FcgType.CHAR_ARRAY) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.DOUBLE) {
                object2 = this.genCode_COERCE_BOOLEAN2DOUBLE(stackValue);
            } else if (fcgType2 == FcgType.FLOAT) {
                object2 = this.genCode_COERCE_BOOLEAN2FLOAT(stackValue);
            } else if (fcgType2 == FcgType.INT) {
                object2 = this.genCode_COERCE_BOOLEAN2INT(stackValue);
            } else if (fcgType2 == FcgType.LONG) {
                object2 = this.genCode_COERCE_BOOLEAN2LONG(stackValue);
            } else if (fcgType2 == FcgType.SHORT) {
                object2 = this.genCode_COERCE_BOOLEAN2SHORT(stackValue);
            } else if (fcgType2 == FcgType.STRING) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.STRINGBUFFER) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.OBJECT || fcgType2 == FcgType.BOOLEAN_OBJECT) {
                object2 = this.genCode_COERCE_BOOLEAN2OBJECT(stackValue);
            } else if (fcgType2 instanceof FcgClassReferenceType) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            }
        } else if (fcgType == FcgType.BYTE) {
            if (fcgType2 == FcgType.BIG_DECIMAL) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.BIG_DECIMAL) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.BIG_INTEGER) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.BOOLEAN) {
                object2 = this.genCode_COERCE_BYTE2BOOLEAN(stackValue);
            } else if (fcgType2 == FcgType.BYTE) {
                object2 = stackValue.getCodeData();
            } else if (fcgType2 == FcgType.CHAR) {
                object2 = this.genCode_COERCE_BYTE2CHAR(stackValue);
            } else if (fcgType2 == FcgType.CHAR_ARRAY) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.OBJECT || fcgType2 == FcgType.BYTE_OBJECT) {
                object2 = this.genCode_COERCE_BYTE2OBJECT(stackValue);
            } else if (fcgType2 instanceof FcgClassReferenceType) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.DOUBLE) {
                object2 = this.genCode_COERCE_BYTE2DOUBLE(stackValue);
            } else if (fcgType2 == FcgType.FLOAT) {
                object2 = this.genCode_COERCE_BYTE2FLOAT(stackValue);
            } else if (fcgType2 == FcgType.INT) {
                object2 = this.genCode_COERCE_BYTE2INT(stackValue);
            } else if (fcgType2 == FcgType.LONG) {
                object2 = this.genCode_COERCE_BYTE2LONG(stackValue);
            } else if (fcgType2 == FcgType.SHORT) {
                object2 = this.genCode_COERCE_BYTE2SHORT(stackValue);
            } else if (fcgType2 == FcgType.STRING) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.STRINGBUFFER) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            }
        } else if (fcgType == FcgType.CHAR) {
            if (fcgType2 == FcgType.BIG_DECIMAL) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.BIG_DECIMAL) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.BIG_INTEGER) {
                object2 = this.genCode_COERCE_CHAR2BIG_INTEGER(stackValue);
            } else if (fcgType2 == FcgType.BOOLEAN) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.BYTE) {
                object2 = this.genCode_COERCE_CHAR2BYTE(stackValue);
            } else if (fcgType2 == FcgType.CHAR) {
                object2 = this.genCode_COERCE_CHAR2INT(stackValue);
            } else if (fcgType2 == FcgType.CHAR_ARRAY) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.DOUBLE) {
                object2 = this.genCode_COERCE_CHAR2DOUBLE(stackValue);
            } else if (fcgType2 == FcgType.FLOAT) {
                object2 = this.genCode_COERCE_CHAR2FLOAT(stackValue);
            } else if (fcgType2 == FcgType.INT) {
                object2 = stackValue.getCodeData();
            } else if (fcgType2 == FcgType.LONG) {
                object2 = this.genCode_COERCE_CHAR2LONG(stackValue);
            } else if (fcgType2 == FcgType.SHORT) {
                object2 = this.genCode_COERCE_CHAR2SHORT(stackValue);
            } else if (fcgType2 == FcgType.STRING) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.STRINGBUFFER) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.OBJECT || fcgType2 == FcgType.CHAR_OBJECT) {
                object2 = this.genCode_COERCE_CHAR2OBJECT(stackValue);
            } else if (fcgType2 instanceof FcgClassReferenceType) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            }
        } else if (fcgType == FcgType.CHAR_ARRAY) {
            if (fcgType2 == FcgType.BIG_DECIMAL) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.BIG_DECIMAL) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.BIG_INTEGER) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.BOOLEAN) {
                object2 = this.genCode_COERCE_CHAR_ARRAY2BOOLEAN(stackValue);
            } else if (fcgType2 == FcgType.BYTE) {
                object2 = this.genCode_COERCE_CHAR_ARRAY2BYTE(stackValue);
            } else if (fcgType2 == FcgType.CHAR) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.CHAR_ARRAY) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.OBJECT) {
                object2 = stackValue.getCodeData();
            } else if (fcgType2 == FcgType.DOUBLE) {
                object2 = this.genCode_COERCE_CHAR_ARRAY2DOUBLE(stackValue);
            } else if (fcgType2 == FcgType.FLOAT) {
                object2 = this.genCode_COERCE_CHAR_ARRAY2FLOAT(stackValue);
            } else if (fcgType2 == FcgType.INT) {
                object2 = this.genCode_COERCE_CHAR_ARRAY2INT(stackValue);
            } else if (fcgType2 == FcgType.LONG) {
                object2 = this.genCode_COERCE_CHAR_ARRAY2LONG(stackValue);
            } else if (fcgType2 == FcgType.LONG) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.SHORT) {
                object2 = this.genCode_COERCE_CHAR_ARRAY2SHORT(stackValue);
            } else if (fcgType2 == FcgType.STRING) {
                object2 = this.genCode_COERCE_CHAR_ARRAY2STRING(stackValue);
            } else if (fcgType2 == FcgType.STRINGBUFFER) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            }
        } else if (fcgType instanceof FcgReferenceType) {
            if (fcgType2 instanceof FcgArrayType) {
                object2 = this.genCode_COERCE_2REFERENCE_TYPE(fcgType2, stackValue);
            } else if (fcgType2 instanceof FcgClassReferenceType || fcgType2 instanceof FcgInterfaceType) {
                object2 = this.genCode_COERCE_2REFERENCE_TYPE2(fcgType2, stackValue);
            } else if (fcgType == FcgType.OBJECT && !(fcgType2 instanceof FcgReferenceType)) {
                object2 = this.genCode_COERCE_2PRIMITIVE_TYPE(fcgType2, stackValue);
            } else {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            }
        } else if (fcgType == FcgType.DOUBLE) {
            if (fcgType2 == FcgType.BIG_DECIMAL) {
                object2 = this.genCode_COERCE_DOUBLE2BIG_DECIMAL(stackValue);
            } else if (fcgType2 == FcgType.BIG_INTEGER) {
                object2 = this.genCode_COERCE_DOUBLE2BIG_INTEGER(stackValue);
            } else if (fcgType2 == FcgType.BOOLEAN) {
                object2 = this.genCode_COERCE_DOUBLE2BOOLEAN(stackValue);
            } else if (fcgType2 == FcgType.BYTE) {
                object2 = this.genCode_COERCE_DOUBLE2BYTE(stackValue);
            } else if (fcgType2 == FcgType.CHAR) {
                object2 = this.genCode_COERCE_DOUBLE2CHAR(stackValue);
            } else if (fcgType2 == FcgType.CHAR_ARRAY) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.DOUBLE) {
                object2 = stackValue.getCodeData();
            } else if (fcgType2 == FcgType.FLOAT) {
                object2 = this.genCode_COERCE_DOUBLE2FLOAT(stackValue);
            } else if (fcgType2 == FcgType.INT) {
                object2 = this.genCode_COERCE_DOUBLE2INT(stackValue);
            } else if (fcgType2 == FcgType.LONG) {
                object2 = this.genCode_COERCE_DOUBLE2LONG(stackValue);
            } else if (fcgType2 == FcgType.SHORT) {
                object2 = this.genCode_COERCE_DOUBLE2SHORT(stackValue);
            } else if (fcgType2 == FcgType.STRING) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.STRINGBUFFER) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.OBJECT || fcgType2 == FcgType.DOUBLE_OBJECT) {
                object2 = this.genCode_COERCE_DOUBLE2OBJECT(stackValue);
            } else if (fcgType2 instanceof FcgClassReferenceType) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            }
        } else if (fcgType == FcgType.FLOAT) {
            if (fcgType2 == FcgType.BIG_DECIMAL) {
                object2 = this.genCode_COERCE_FLOAT2BIG_DECIMAL(stackValue);
            } else if (fcgType2 == FcgType.BIG_INTEGER) {
                object2 = this.genCode_COERCE_FLOAT2BIG_INTEGER(stackValue);
            } else if (fcgType2 == FcgType.BOOLEAN) {
                object2 = this.genCode_COERCE_FLOAT2BOOLEAN(stackValue);
            } else if (fcgType2 == FcgType.BYTE) {
                object2 = this.genCode_COERCE_FLOAT2BYTE(stackValue);
            } else if (fcgType2 == FcgType.CHAR) {
                object2 = this.genCode_COERCE_FLOAT2CHAR(stackValue);
            } else if (fcgType2 == FcgType.CHAR_ARRAY) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.DOUBLE) {
                object2 = this.genCode_COERCE_FLOAT2DOUBLE(stackValue);
            } else if (fcgType2 == FcgType.FLOAT) {
                object2 = stackValue.getCodeData();
            } else if (fcgType2 == FcgType.INT) {
                object2 = this.genCode_COERCE_FLOAT2INT(stackValue);
            } else if (fcgType2 == FcgType.LONG) {
                object2 = this.genCode_COERCE_FLOAT2LONG(stackValue);
            } else if (fcgType2 == FcgType.SHORT) {
                object2 = this.genCode_COERCE_FLOAT2SHORT(stackValue);
            } else if (fcgType2 == FcgType.STRING) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.STRINGBUFFER) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.OBJECT || fcgType2 == FcgType.FLOAT_OBJECT) {
                object2 = this.genCode_COERCE_FLOAT2OBJECT(stackValue);
            } else if (fcgType2 instanceof FcgClassReferenceType) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            }
        } else if (fcgType == FcgType.INT || fcgType == INT_LITERAL) {
            if (fcgType2 == FcgType.BIG_DECIMAL) {
                object2 = this.genCode_COERCE_INT2BIG_DECIMAL(stackValue);
            } else if (fcgType2 == FcgType.BIG_INTEGER) {
                object2 = this.genCode_COERCE_INT2BIG_INTEGER(stackValue);
            } else if (fcgType2 == FcgType.BOOLEAN) {
                object2 = this.genCode_COERCE_INT2BOOLEAN(stackValue);
            } else if (fcgType2 == FcgType.BYTE) {
                object2 = this.genCode_COERCE_INT2BYTE(stackValue);
            } else if (fcgType2 == FcgType.CHAR) {
                object2 = this.genCode_COERCE_INT2CHAR(stackValue);
            } else if (fcgType2 == FcgType.CHAR_ARRAY) {
                object2 = this.genCode_COERCE_INT2CHAR_ARRAY(stackValue);
            } else if (fcgType2 == FcgType.DOUBLE) {
                object2 = this.genCode_COERCE_INT2DOUBLE(stackValue);
            } else if (fcgType2 == FcgType.FLOAT) {
                object2 = this.genCode_COERCE_INT2FLOAT(stackValue);
            } else if (fcgType2 == FcgType.INT) {
                object2 = stackValue.getCodeData();
            } else if (fcgType2 == FcgType.LONG) {
                object2 = this.genCode_COERCE_INT2LONG(stackValue);
            } else if (fcgType2 == FcgType.SHORT) {
                object2 = this.genCode_COERCE_INT2SHORT(stackValue);
            } else if (fcgType2 == FcgType.STRING) {
                object2 = this.genCode_COERCE_INT2STRING(stackValue);
            } else if (fcgType2 == FcgType.STRINGBUFFER) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.OBJECT || fcgType2 == FcgType.INT_OBJECT) {
                object2 = this.genCode_COERCE_INT2OBJECT(stackValue);
            } else if (fcgType2 instanceof FcgClassReferenceType) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            }
        } else if (fcgType == FcgType.LONG) {
            if (fcgType2 == FcgType.BIG_DECIMAL) {
                object2 = this.genCode_COERCE_LONG2BIG_DECIMAL(stackValue);
            } else if (fcgType2 == FcgType.BIG_INTEGER) {
                object2 = this.genCode_COERCE_LONG2BIG_INTEGER(stackValue);
            } else if (fcgType2 == FcgType.BOOLEAN) {
                object2 = this.genCode_COERCE_LONG2BOOLEAN(stackValue);
            } else if (fcgType2 == FcgType.BYTE) {
                object2 = this.genCode_COERCE_LONG2BYTE(stackValue);
            } else if (fcgType2 == FcgType.CHAR) {
                object2 = this.genCode_COERCE_LONG2CHAR(stackValue);
            } else if (fcgType2 == FcgType.CHAR_ARRAY) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.STRING) {
                object2 = this.genCode_COERCE_LONG2STRING(stackValue);
            } else if (fcgType2 == FcgType.STRINGBUFFER) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.DOUBLE) {
                object2 = this.genCode_COERCE_LONG2DOUBLE(stackValue);
            } else if (fcgType2 == FcgType.FLOAT) {
                object2 = this.genCode_COERCE_LONG2FLOAT(stackValue);
            } else if (fcgType2 == FcgType.INT) {
                object2 = this.genCode_COERCE_LONG2INT(stackValue);
            } else if (fcgType2 == FcgType.LONG) {
                object2 = stackValue.getCodeData();
            } else if (fcgType2 == FcgType.SHORT) {
                object2 = this.genCode_COERCE_LONG2SHORT(stackValue);
            } else if (fcgType2 == FcgType.OBJECT || fcgType2 == FcgType.LONG_OBJECT) {
                object2 = this.genCode_COERCE_LONG2OBJECT(stackValue);
            } else if (fcgType2 instanceof FcgClassReferenceType) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            }
        } else if (fcgType == FcgType.SHORT) {
            if (fcgType2 == FcgType.BIG_DECIMAL) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.BIG_DECIMAL) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.BIG_INTEGER) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.BOOLEAN) {
                object2 = this.genCode_COERCE_SHORT2BOOLEAN(stackValue);
            } else if (fcgType2 == FcgType.BYTE) {
                object2 = this.genCode_COERCE_SHORT2BYTE(stackValue);
            } else if (fcgType2 == FcgType.CHAR) {
                object2 = this.genCode_COERCE_SHORT2CHAR(stackValue);
            } else if (fcgType2 == FcgType.CHAR_ARRAY) {
                object2 = this.genCode_COERCE_SHORT2CHAR_ARRAY(stackValue);
            } else if (fcgType2 instanceof FcgClassReferenceType) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.DOUBLE) {
                object2 = this.genCode_COERCE_SHORT2DOUBLE(stackValue);
            } else if (fcgType2 == FcgType.FLOAT) {
                object2 = this.genCode_COERCE_SHORT2FLOAT(stackValue);
            } else if (fcgType2 == FcgType.INT) {
                object2 = this.genCode_COERCE_SHORT2INT(stackValue);
            } else if (fcgType2 == FcgType.LONG) {
                object2 = this.genCode_COERCE_SHORT2LONG(stackValue);
            } else if (fcgType2 == FcgType.SHORT) {
                object2 = stackValue.getCodeData();
            } else if (fcgType2 == FcgType.STRING) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.STRINGBUFFER) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.OBJECT || fcgType2 == FcgType.SHORT_OBJECT) {
                object2 = this.genCode_COERCE_SHORT2OBJECT(stackValue);
            } else {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            }
        } else if (fcgType == FcgType.STRINGBUFFER) {
            if (fcgType2 == FcgType.BIG_DECIMAL) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.BIG_DECIMAL) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.BIG_INTEGER) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.BOOLEAN) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.BYTE) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.CHAR) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.CHAR_ARRAY) {
                object2 = this.genCode_COERCE_STRINGBUFFER2CHAR_ARRAY(stackValue);
            } else if (fcgType2 instanceof FcgClassReferenceType) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.DOUBLE) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.FLOAT) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.INT) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.SHORT) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.STRING) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else if (fcgType2 == FcgType.STRINGBUFFER) {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            } else {
                FinalCodeGenerator.unimplementedException();
                object2 = null;
            }
        } else {
            FinalCodeGenerator.unimplementedException();
            object2 = null;
        }
        return object2;
    }

    protected abstract Object genCode_COERCE_2REFERENCE_TYPE(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_2REFERENCE_TYPE2(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_2PRIMITIVE_TYPE(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_DECIMAL2BOOLEAN(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_DECIMAL2BIG_INTEGER(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_DECIMAL2BYTE(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_DECIMAL2CHAR(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_DECIMAL2DOUBLE(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_DECIMAL2FLOAT(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_DECIMAL2INT(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_DECIMAL2LONG(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_DECIMAL2SHORT(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_INTEGER2BIG_DECIMAL(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_INTEGER2BOOLEAN(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_INTEGER2BYTE(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_INTEGER2CHAR(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_INTEGER2DOUBLE(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_INTEGER2FLOAT(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_INTEGER2INT(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_INTEGER2LONG(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_INTEGER2SHORT(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BOOLEAN2BYTE(StackValue var1);

    protected abstract Object genCode_COERCE_BOOLEAN2CHAR(StackValue var1);

    protected abstract Object genCode_COERCE_BOOLEAN2DOUBLE(StackValue var1);

    protected abstract Object genCode_COERCE_BOOLEAN2FLOAT(StackValue var1);

    protected abstract Object genCode_COERCE_BOOLEAN2INT(StackValue var1);

    protected abstract Object genCode_COERCE_BOOLEAN2LONG(StackValue var1);

    protected abstract Object genCode_COERCE_BOOLEAN2SHORT(StackValue var1);

    protected abstract Object genCode_COERCE_BOOLEAN2OBJECT(StackValue var1);

    protected abstract Object genCode_COERCE_BYTE2CHAR(StackValue var1);

    protected abstract Object genCode_COERCE_BYTE2DOUBLE(StackValue var1);

    protected abstract Object genCode_COERCE_BYTE2BOOLEAN(StackValue var1);

    protected abstract Object genCode_COERCE_BYTE2FLOAT(StackValue var1);

    protected abstract Object genCode_COERCE_BYTE2INT(StackValue var1);

    protected abstract Object genCode_COERCE_BYTE2LONG(StackValue var1);

    protected abstract Object genCode_COERCE_BYTE2SHORT(StackValue var1);

    protected abstract Object genCode_COERCE_BYTE2OBJECT(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR_ARRAY2BOOLEAN(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR_ARRAY2BYTE(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR_ARRAY2DOUBLE(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR_ARRAY2FLOAT(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR_ARRAY2INT(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR_ARRAY2LONG(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR_ARRAY2SHORT(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR_ARRAY2STRING(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR2BYTE(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR2DOUBLE(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR2FLOAT(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR2INT(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR2LONG(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR2BIG_INTEGER(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR2SHORT(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR2OBJECT(StackValue var1);

    protected abstract Object genCode_COERCE_DOUBLE2BIG_DECIMAL(StackValue var1);

    protected abstract Object genCode_COERCE_DOUBLE2BIG_INTEGER(StackValue var1);

    protected abstract Object genCode_COERCE_DOUBLE2BOOLEAN(StackValue var1);

    protected abstract Object genCode_COERCE_DOUBLE2BYTE(StackValue var1);

    protected abstract Object genCode_COERCE_DOUBLE2CHAR(StackValue var1);

    protected abstract Object genCode_COERCE_DOUBLE2FLOAT(StackValue var1);

    protected abstract Object genCode_COERCE_DOUBLE2INT(StackValue var1);

    protected abstract Object genCode_COERCE_DOUBLE2LONG(StackValue var1);

    protected abstract Object genCode_COERCE_DOUBLE2SHORT(StackValue var1);

    protected abstract Object genCode_COERCE_DOUBLE2OBJECT(StackValue var1);

    protected abstract Object genCode_COERCE_FLOAT2BIG_DECIMAL(StackValue var1);

    protected abstract Object genCode_COERCE_FLOAT2BIG_INTEGER(StackValue var1);

    protected abstract Object genCode_COERCE_FLOAT2BOOLEAN(StackValue var1);

    protected abstract Object genCode_COERCE_FLOAT2BYTE(StackValue var1);

    protected abstract Object genCode_COERCE_FLOAT2CHAR(StackValue var1);

    protected abstract Object genCode_COERCE_FLOAT2DOUBLE(StackValue var1);

    protected abstract Object genCode_COERCE_FLOAT2INT(StackValue var1);

    protected abstract Object genCode_COERCE_FLOAT2LONG(StackValue var1);

    protected abstract Object genCode_COERCE_FLOAT2SHORT(StackValue var1);

    protected abstract Object genCode_COERCE_FLOAT2OBJECT(StackValue var1);

    protected abstract Object genCode_COERCE_INT2BIG_DECIMAL(StackValue var1);

    protected abstract Object genCode_COERCE_INT2BIG_INTEGER(StackValue var1);

    protected abstract Object genCode_COERCE_INT2BOOLEAN(StackValue var1);

    protected abstract Object genCode_COERCE_INT2BYTE(StackValue var1);

    protected abstract Object genCode_COERCE_INT2CHAR(StackValue var1);

    protected abstract Object genCode_COERCE_INT2CHAR_ARRAY(StackValue var1);

    protected abstract Object genCode_COERCE_INT2DOUBLE(StackValue var1);

    protected abstract Object genCode_COERCE_INT2FLOAT(StackValue var1);

    protected abstract Object genCode_COERCE_INT2LONG(StackValue var1);

    protected abstract Object genCode_COERCE_INT2SHORT(StackValue var1);

    protected abstract Object genCode_COERCE_INT2STRING(StackValue var1);

    protected abstract Object genCode_COERCE_INT2OBJECT(StackValue var1);

    protected abstract Object genCode_COERCE_LONG2BIG_DECIMAL(StackValue var1);

    protected abstract Object genCode_COERCE_LONG2BIG_INTEGER(StackValue var1);

    protected abstract Object genCode_COERCE_LONG2BOOLEAN(StackValue var1);

    protected abstract Object genCode_COERCE_LONG2BYTE(StackValue var1);

    protected abstract Object genCode_COERCE_LONG2CHAR(StackValue var1);

    protected abstract Object genCode_COERCE_LONG2DOUBLE(StackValue var1);

    protected abstract Object genCode_COERCE_LONG2FLOAT(StackValue var1);

    protected abstract Object genCode_COERCE_LONG2INT(StackValue var1);

    protected abstract Object genCode_COERCE_LONG2SHORT(StackValue var1);

    protected abstract Object genCode_COERCE_LONG2STRING(StackValue var1);

    protected abstract Object genCode_COERCE_LONG2OBJECT(StackValue var1);

    protected abstract Object genCode_COERCE_SHORT2BOOLEAN(StackValue var1);

    protected abstract Object genCode_COERCE_SHORT2BYTE(StackValue var1);

    protected abstract Object genCode_COERCE_SHORT2CHAR(StackValue var1);

    protected abstract Object genCode_COERCE_SHORT2CHAR_ARRAY(StackValue var1);

    protected abstract Object genCode_COERCE_SHORT2DOUBLE(StackValue var1);

    protected abstract Object genCode_COERCE_SHORT2FLOAT(StackValue var1);

    protected abstract Object genCode_COERCE_SHORT2INT(StackValue var1);

    protected abstract Object genCode_COERCE_SHORT2LONG(StackValue var1);

    protected abstract Object genCode_COERCE_SHORT2OBJECT(StackValue var1);

    protected abstract Object genCode_COERCE_STRING2CHAR_ARRAY(StackValue var1);

    protected abstract Object genCode_COERCE_STRINGBUFFER2CHAR_ARRAY(StackValue var1);

    public static final class UnaryOp
    extends Operation
    implements FcgUnaryOp {
        public UnaryOp(String string2, int n2) {
            super(string2, n2);
        }
    }

    public static final class BinaryOp
    extends Operation
    implements FcgBinOp {
        public BinaryOp(String string2, int n2) {
            super(string2, n2);
        }
    }

    private static class Operation
    implements FcgOperation {
        private static HashMap s_opCodes = new HashMap();
        private final String m_name;
        private final int m_opCode;

        private Operation(String string2, int n2) {
            String string3;
            this.m_name = string2;
            this.m_opCode = n2;
            String string4 = Integer.toString(n2);
            if (DO_COMPILE_CHECKING && (string3 = (String)s_opCodes.get(string4)) != null) {
                String string5 = "FinalCodeGenerator: opcode " + string4 + " already in use by '" + string3 + "', now wants to be used by '" + string2;
                throw new RuntimeException(string5);
            }
            s_opCodes.put(string4, string2);
        }

        private int getFcgOpCode() {
            return this.m_opCode;
        }

        public String toString() {
            return this.m_name;
        }
    }

    private final class LocalVarStack {
        private static final int INITIAL_STACK_SIZE = 16;
        private int m_freeIndex = 0;
        private FcgVarMutableInternal[] m_stackArr = new FcgVarMutableInternal[16];

        private int numLocalVars() {
            return this.m_freeIndex;
        }

        private LocalVarStack() {
        }

        private int size() {
            return this.m_freeIndex;
        }

        private FcgVariable push(String string2, FcgType fcgType, FcgAttrs fcgAttrs) {
            Object object2;
            int n2 = this.m_stackArr.length;
            if (this.m_freeIndex == n2) {
                object2 = new FcgVarMutableInternal[n2 * 2];
                System.arraycopy(this.m_stackArr, 0, object2, 0, n2);
                this.m_stackArr = object2;
            }
            if ((object2 = this.m_stackArr[this.m_freeIndex]) == null) {
                this.m_stackArr[this.m_freeIndex] = object2 = FinalCodeGenerator.this.newFcgVariable();
            }
            object2.setName(string2);
            object2.setType(fcgType);
            object2.setAttrs(fcgAttrs);
            ++this.m_freeIndex;
            return object2;
        }

        private void pop(String string2) {
            String string3;
            int n2 = --this.m_freeIndex;
            if (DO_COMPILE_CHECKING && !string2.equals(string3 = this.m_stackArr[n2].getName())) {
                FinalCodeGenerator.error("FCG: Popped a variable named '" + string3 + "' but expected to pop one named '" + string2 + "'.");
            }
        }

        FcgType getVarType(String string2) {
            FcgType fcgType = null;
            if (string2.equals("__should_never_be_used__")) {
                fcgType = FcgType.VOID;
                return fcgType;
            }
            for (int i = this.m_freeIndex - 1; 0 <= i; --i) {
                if (!string2.equals(this.m_stackArr[i].getName())) continue;
                fcgType = this.m_stackArr[i].getType();
                break;
            }
            if (fcgType != null) {
                return fcgType;
            }
            if (fcgType == null) {
                fcgType = FcgType.OBJECT;
            }
            if (DO_COMPILE_CHECKING && fcgType == null) {
                FinalCodeGenerator.error("FCG: failed to find variable named '" + string2 + "'");
            }
            return fcgType;
        }

        private FcgVariable peek() {
            return this.m_stackArr[this.m_freeIndex - 1];
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("LocalVarStack:\n");
            if (this.size() == 0) {
                stringBuffer.append("  *** EMPTY ***");
            } else {
                for (int i = this.size() - 1; 0 <= i; --i) {
                    stringBuffer.append("  * ");
                    stringBuffer.append(this.m_stackArr[i].toString());
                    stringBuffer.append('\n');
                }
            }
            return stringBuffer.toString();
        }
    }

    protected static final class CodeGenStack {
        private static final int INITIAL_STACK_SIZE = 16;
        private int m_freeIndex = 0;
        private StackValue[] m_stackArr = new StackValue[16];

        private CodeGenStack() {
        }

        private int size() {
            return this.m_freeIndex;
        }

        private void push(Construct construct2, FcgType fcgType, Object object2, int n2) {
            Object object3;
            int n3 = this.m_stackArr.length;
            if (this.m_freeIndex == n3) {
                object3 = new StackValue[n3 * 2];
                System.arraycopy(this.m_stackArr, 0, object3, 0, n3);
                this.m_stackArr = object3;
            }
            if ((object3 = this.m_stackArr[this.m_freeIndex]) == null) {
                this.m_stackArr[this.m_freeIndex] = object3 = new StackValue();
            } else if (DO_COMPILE_CHECKING && ((StackValue)object3).needsReset()) {
                FinalCodeGenerator.error("FCG: Recycled StackValue was not reset! " + object3);
            }
            if (debug_reset) {
                System.out.println("push: " + object3);
            }
            ((StackValue)object3).setConstructKind(construct2);
            ((StackValue)object3).setType(fcgType);
            ((StackValue)object3).setCodeData(object2);
            ((StackValue)object3).setNumLocalVars(n2);
            ++this.m_freeIndex;
            if (debug_reset) {
                for (int i = this.m_freeIndex; i < this.m_stackArr.length - 1; ++i) {
                    if (this.m_stackArr[i] == null || !this.m_stackArr[i].needsReset()) continue;
                    FinalCodeGenerator.error("FCG: Recycled StackValue was not reset! " + this.m_stackArr[i]);
                }
            }
        }

        private Construct peekAtConstructKind() {
            return this.m_stackArr[this.m_freeIndex - 1].getConstructKind();
        }

        private FcgType peekAtType() {
            return this.m_stackArr[this.m_freeIndex - 1].getType();
        }

        private StackValue peek() {
            if (this.m_freeIndex == 0) {
                return null;
            }
            return this.m_stackArr[this.m_freeIndex - 1];
        }

        private StackValue peek(Construct construct2) {
            Object object2;
            if (DO_COMPILE_CHECKING) {
                object2 = this.peekAtConstructKind();
                if (this.peekAtConstructKind() != construct2) {
                    String string2 = "FCG: Construct on top of the FCG stack is " + this.peekAtConstructKind().toString() + " but the expected construct kind is " + construct2.toString();
                    FinalCodeGenerator.error(string2);
                }
            }
            object2 = this.peek();
            return object2;
        }

        private StackValue peek(int n2) {
            return this.m_stackArr[this.m_freeIndex - 1 - n2];
        }

        private StackValue pop(Construct construct2) {
            Object object2;
            if (DO_COMPILE_CHECKING && this.peekAtConstructKind() != construct2) {
                object2 = "FCG: Popped construct from the top of FCG stack is " + this.peekAtConstructKind().toString() + " but the expected construct kind is " + construct2.toString();
                FinalCodeGenerator.error((String)object2);
            }
            --this.m_freeIndex;
            object2 = this.m_stackArr[this.m_freeIndex];
            if (debug_reset) {
                System.out.println("pop: " + object2);
            }
            return object2;
        }

        public StackValue peekAtStackValue(int n2) {
            return this.m_stackArr[n2];
        }

        private void assertStackIsEmpty() {
            if (this.m_freeIndex != 0) {
                FinalCodeGenerator.error("FCG: Code generation stack is not empty at end of code generation!");
            }
            for (int i = 0; i < this.m_stackArr.length && this.m_stackArr[i] != null; ++i) {
                if (!this.m_stackArr[i].needsReset()) continue;
                FinalCodeGenerator.error("FCG: Recycled StackValue was not reset!");
            }
        }
    }

    public static class Construct {
        final String m_name;

        private Construct(String string2) {
            this.m_name = string2;
        }

        public String toString() {
            return this.m_name;
        }
    }

    public static final class StackValue {
        private static int s_id_counter;
        private int m_id;
        private Construct m_constructKind;
        private FcgType m_valueType;
        private Object m_codeData;
        private int m_numLocalVars;
        private boolean m_needsReset = false;
        private int m_int_literal = 0;

        private StackValue() {
            if (debug_reset) {
                this.m_id = ++s_id_counter;
            }
        }

        public Object clone() {
            StackValue stackValue = new StackValue();
            stackValue.m_constructKind = this.m_constructKind;
            stackValue.m_valueType = this.m_valueType;
            stackValue.m_codeData = this.m_codeData;
            stackValue.m_numLocalVars = this.m_numLocalVars;
            stackValue.m_needsReset = this.m_needsReset;
            return stackValue;
        }

        public void reset() {
            this.m_constructKind = null;
            this.m_valueType = FcgBasicType.VOID;
            this.m_codeData = null;
            this.m_numLocalVars = 0;
            this.m_needsReset = false;
            if (debug_reset) {
                System.out.println("reset: " + this);
            }
        }

        private void setConstructKind(Construct construct2) {
            this.m_constructKind = construct2;
            this.m_needsReset = true;
        }

        public Construct getConstructKind() {
            return this.m_constructKind;
        }

        private void setType(FcgType fcgType) {
            this.m_valueType = fcgType == null ? FcgBasicType.VOID : fcgType;
            this.m_needsReset = true;
        }

        private void setLiteralValue(int n2) {
            this.m_int_literal = n2;
            this.m_needsReset = true;
        }

        public FcgType getType() {
            return this.m_valueType;
        }

        private int getIntLiteralValue() {
            return this.m_int_literal;
        }

        private void setCodeData(Object object2) {
            this.m_codeData = object2;
        }

        public Object getCodeData() {
            return this.m_codeData;
        }

        private int getNumLocalVars() {
            return this.m_numLocalVars;
        }

        private void setNumLocalVars(int n2) {
            this.m_numLocalVars = n2;
        }

        private boolean needsReset() {
            return this.m_needsReset;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("StackValue#" + this.m_id + " ");
            if (this.m_constructKind != null) {
                stringBuffer.append(this.m_constructKind.toString()).append(' ');
            }
            if (this.m_valueType != null) {
                stringBuffer.append(((Object)this.m_valueType).toString()).append(' ');
            }
            if (this.m_codeData != null) {
                stringBuffer.append(this.m_codeData.toString()).append(' ');
            }
            if (this.m_valueType == INT_LITERAL) {
                stringBuffer.append(" int literal: ").append(this.m_int_literal).append(' ');
            }
            stringBuffer.append('\n');
            return stringBuffer.toString();
        }
    }
}

