/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.fcg.bcel;

import com.ibm.xltxe.rnm1.xtq.bcel.generic.BranchInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.CompoundInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.GOTO;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Instruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionConstants;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionFactory;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionHandle;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionList;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LOOKUPSWITCH;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.POP;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.PUSH;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Select;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.TABLESWITCH;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.TargetLostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class FcgSwitchBuilderBCEL {
    private final InstructionList m_il;
    private final InstructionHandle m_switchInsertionPoint;
    private InstructionHandle m_defaultCase;
    private final ConstantPoolGen _cp;
    private final ArrayList m_breaksToEnd;
    private final ArrayList m_testsAndLabels;

    FcgSwitchBuilderBCEL(ConstantPoolGen constantPoolGen, InstructionList instructionList) {
        this._cp = constantPoolGen;
        this.m_il = instructionList;
        this.m_defaultCase = null;
        this.m_breaksToEnd = new ArrayList();
        this.m_testsAndLabels = new ArrayList();
        this.m_switchInsertionPoint = this.m_il.append(new TABLESWITCH(new int[0], new InstructionHandle[0], null));
    }

    void startCase(int n2) {
        this.m_testsAndLabels.add(new ValueLabelPair(new Integer(n2), this.m_il.append(InstructionConstants.NOP)));
    }

    void breakCase() {
        GOTO gOTO = new GOTO(null);
        this.m_breaksToEnd.add(gOTO);
        this.m_il.append(gOTO);
    }

    void startDefaultCase() {
        this.m_defaultCase = this.m_il.append(InstructionConstants.NOP);
    }

    void startSwitch() {
    }

    void endSwitch() {
        Object object2;
        int n2 = this.m_testsAndLabels.size();
        if (n2 == 0) {
            if (this.m_defaultCase == null) {
                this.removeBranchAtStartOfSwitch();
                this.m_il.append(new POP());
                return;
            }
        } else if (n2 == 1 && this.m_defaultCase == null) {
            ValueLabelPair valueLabelPair = (ValueLabelPair)this.m_testsAndLabels.get(0);
            int n3 = valueLabelPair.caseValue;
            PUSH pUSH = new PUSH(this._cp, n3);
            this.m_il.insert(this.m_switchInsertionPoint, (CompoundInstruction)pUSH);
            BranchInstruction branchInstruction = InstructionFactory.createBranchInstruction((short)160, null);
            this.m_il.insert(this.m_switchInsertionPoint, branchInstruction);
            this.removeBranchAtStartOfSwitch();
            InstructionHandle instructionHandle = this.m_il.getEnd();
            try {
                this.m_il.delete(instructionHandle);
            }
            catch (TargetLostException targetLostException) {
                targetLostException.printStackTrace();
            }
            InstructionHandle instructionHandle2 = this.m_il.append(InstructionConstants.NOP);
            branchInstruction.setTarget(instructionHandle2);
            return;
        }
        if (this.m_defaultCase == null) {
            this.startDefaultCase();
            this.breakCase();
        }
        Collections.sort(this.m_testsAndLabels, new Comparator(){

            public int compare(Object object2, Object object3) {
                ValueLabelPair valueLabelPair = (ValueLabelPair)object2;
                ValueLabelPair valueLabelPair2 = (ValueLabelPair)object3;
                return valueLabelPair.caseValue.compareTo(valueLabelPair2.caseValue);
            }
        });
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            object2 = (ValueLabelPair)this.m_testsAndLabels.get(i);
            nArray[i] = ((ValueLabelPair)object2).caseValue;
        }
        InstructionHandle[] instructionHandleArray = new InstructionHandle[n2];
        object2 = new LOOKUPSWITCH(nArray, instructionHandleArray, null);
        for (int i = 0; i < n2; ++i) {
            ValueLabelPair valueLabelPair = (ValueLabelPair)this.m_testsAndLabels.get(i);
            ((Select)object2).setTarget(i, valueLabelPair.label);
        }
        this.m_switchInsertionPoint.setInstruction((Instruction)object2);
        ((BranchInstruction)object2).setTarget(this.m_defaultCase);
        InstructionHandle instructionHandle = this.m_il.append(InstructionConstants.NOP);
        int n4 = this.m_breaksToEnd.size();
        for (int i = 0; i < n4; ++i) {
            ((BranchInstruction)this.m_breaksToEnd.get(i)).setTarget(instructionHandle);
        }
    }

    private void removeBranchAtStartOfSwitch() {
        try {
            this.m_il.delete(this.m_switchInsertionPoint);
        }
        catch (TargetLostException targetLostException) {
            targetLostException.printStackTrace();
        }
    }

    private static class ValueLabelPair {
        final Integer caseValue;
        final InstructionHandle label;

        ValueLabelPair(Integer n2, InstructionHandle instructionHandle) {
            this.caseValue = n2;
            this.label = instructionHandle;
        }
    }
}

