/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.fcg.bcel;

import com.ibm.xltxe.rnm1.fcg.FcgAttrs;
import com.ibm.xltxe.rnm1.fcg.FcgClassGen;
import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgCodeGen;
import com.ibm.xltxe.rnm1.fcg.FcgField;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgMethodGen;
import com.ibm.xltxe.rnm1.fcg.FcgReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.bcel.FcgCodeGenBCEL;
import com.ibm.xltxe.rnm1.fcg.bcel.FcgFieldGenBCEL;
import com.ibm.xltxe.rnm1.fcg.bcel.FcgInstructionListBCEL;
import com.ibm.xltxe.rnm1.fcg.bcel.FcgMethodGenBCEL;
import com.ibm.xltxe.rnm1.fcg.ifacecore.FcgAttrsImpl;
import com.ibm.xltxe.rnm1.fcg.ifacecore.FcgBasicType;
import com.ibm.xltxe.rnm1.fcg.impl.FcgClassGenImpl;
import com.ibm.xltxe.rnm1.fcg.impl.FcgCodeGenImpl;
import com.ibm.xltxe.rnm1.fcg.impl.FinalCodeGenerator;
import com.ibm.xltxe.rnm1.fcg.impl.HiddenOptions;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Code;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Method;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ClassGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionFactory;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionList;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.MethodGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Type;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class FcgClassGenBCEL
extends FcgClassGenImpl
implements FcgClassGen {
    private static final int METHOD_SIZE_LIMIT = 65535;
    public static final int CONSTANTPOOL_BEST_SIZE = 65524;
    static final boolean REPORT_SPLIT = HiddenOptions.wasSpecified("reportsplit") && HiddenOptions.getBooleanValue("reportsplit") != false;
    private final FcgClassReferenceType class_name;
    private final FcgClassReferenceType super_class_name;
    private final String file_name;
    private final FcgAttrs m_attrs;
    private int m_numberOfClassFields;
    private final ClassGen _cg;
    private final ConstantPoolGen _cp;
    private final InstructionFactory _factory;
    FcgMethodGen m_staticCode;
    private LinkedInstructionList m_free_ils;
    private FcgMethodGen m_currentMethodGen;

    public FcgClassGenBCEL(FcgCodeGen fcgCodeGen, FcgClassReferenceType fcgClassReferenceType, FcgClassReferenceType fcgClassReferenceType2, String string2, FcgAttrs fcgAttrs, String[] stringArray) {
        super(fcgCodeGen);
        this.class_name = fcgClassReferenceType;
        if (fcgClassReferenceType2 == null) {
            fcgClassReferenceType2 = FcgType.OBJECT;
        }
        this.super_class_name = fcgClassReferenceType2;
        this.file_name = string2;
        this.m_attrs = fcgAttrs;
        int n2 = 32;
        n2 = this.m_attrs != null ? (n2 |= FcgCodeGenBCEL.fcg2bcelAttrs(this.m_attrs)) : (n2 |= 1);
        this._cg = new ClassGen(this.class_name.getTypeName(), this.super_class_name.getTypeName(), this.class_name.getTypeName() + ".java", n2, stringArray);
        this._cp = this._cg.getConstantPool();
        this._factory = new InstructionFactory(this._cg, this._cp);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this._cg.addInterface(stringArray[i]);
            }
        }
    }

    @Override
    public ConstantPoolGen getbcelConstPool() {
        return this._cp;
    }

    @Override
    public int getbcelConstPoolSize() {
        return this._cp.getSize();
    }

    public ClassGen getbcelClassGen() {
        return this._cg;
    }

    @Override
    public final void dump(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.dump2(fileOutputStream);
        fileOutputStream.flush();
    }

    private void dump2(OutputStream outputStream) throws IOException {
        this.finish();
        this._cg.getJavaClass().dump(outputStream);
    }

    @Override
    public final void dump(OutputStream outputStream) throws IOException {
        this.dump2(outputStream);
        outputStream.flush();
        outputStream.close();
    }

    public final String getClassName() {
        return this.class_name.getTypeName();
    }

    @Override
    public final String getSuperClassName() {
        return this.super_class_name.getTypeName();
    }

    @Override
    public final FcgClassReferenceType getClassType() {
        return this.class_name;
    }

    @Override
    public final FcgClassReferenceType getSuperClassType() {
        return this.super_class_name;
    }

    @Override
    public final FcgInstructionList newInstructionList() {
        FcgCodeGenImpl fcgCodeGenImpl = this.m_fcgCodeGen;
        FcgMethodGenBCEL fcgMethodGenBCEL = (FcgMethodGenBCEL)this.getCurrentMethod();
        return new FcgInstructionListBCEL(this, null, fcgMethodGenBCEL);
    }

    @Override
    public final FcgInstructionList newInstructionList(FcgMethodGen fcgMethodGen) {
        return new FcgInstructionListBCEL(this, null, fcgMethodGen);
    }

    @Override
    public final FcgInstructionList getClassInstructionList() {
        if (this.m_staticCode == null) {
            this.getClassInitMethod();
        }
        return this.m_staticCode.getInstructionList();
    }

    private String toString(FcgAttrs fcgAttrs) {
        FcgAttrsImpl fcgAttrsImpl = (FcgAttrsImpl)fcgAttrs;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = fcgAttrsImpl.getAttrs();
        if ((n2 & 0x40) > 0) {
            stringBuffer.append("abstract ");
        }
        if ((n2 & 0x10) > 0) {
            stringBuffer.append("final ");
        }
        if ((n2 & 2) > 0) {
            stringBuffer.append("public ");
        }
        if ((n2 & 8) > 0) {
            stringBuffer.append("private ");
        }
        if ((n2 & 0x20) > 0) {
            stringBuffer.append("protected ");
        }
        if ((n2 & 4) > 0) {
            stringBuffer.append("static ");
        }
        String string2 = stringBuffer.toString();
        return string2;
    }

    boolean hasDefaultConstructor() {
        return this.m_defaultCtor != null;
    }

    @Override
    public final FcgMethodGen getClassInitMethod() {
        if (this.m_staticCode == null) {
            this.m_staticCode = new FcgMethodGenBCEL(this, FcgAttrs.STATIC, FcgType.VOID, this.class_name, "<clinit>", null);
        }
        return this.m_staticCode;
    }

    @Override
    public final FcgField newInstanceField(FcgAttrs fcgAttrs, FcgType fcgType, String string2) {
        if (fcgAttrs == null) {
            fcgAttrs = FcgAttrs.PUBLIC;
        }
        if (FinalCodeGenerator.DO_COMPILE_CHECKING) {
            if (fcgAttrs.isStatic()) {
                FinalCodeGenerator.error("FCG: creating an instance field named " + string2 + " in class " + this.getClassName() + " but its  attributes say it is STATIC.");
            }
            if (fcgType == FcgBasicType.VOID) {
                throw new RuntimeException("FcgClassGenBCEL, internal error, can't have an instance field of type void!");
            }
        }
        FcgFieldGenBCEL fcgFieldGenBCEL = new FcgFieldGenBCEL(this, fcgAttrs, fcgType, string2);
        super.addField(fcgFieldGenBCEL);
        return fcgFieldGenBCEL;
    }

    FcgField findInstanceField(String string2) {
        int n2 = super.getNumFcgFields();
        for (int i = 0; i < n2; ++i) {
            FcgField fcgField = this.getField(i);
            if (!string2.equals(fcgField.getName())) continue;
            return fcgField;
        }
        return null;
    }

    @Override
    public final FcgField newClassField(FcgAttrs fcgAttrs, FcgType fcgType, String string2) {
        if (fcgAttrs == null) {
            fcgAttrs = FcgAttrs.PUBLIC_STATIC;
        }
        if (FinalCodeGenerator.DO_COMPILE_CHECKING && !fcgAttrs.isStatic()) {
            FinalCodeGenerator.error("FCG: creating a class (i.e. static) field named " + string2 + " in class " + this.getClassName() + " but the creation attributes don't include STATIC");
        }
        FcgFieldGenBCEL fcgFieldGenBCEL = new FcgFieldGenBCEL(this, fcgAttrs, fcgType, string2);
        super.addField(fcgFieldGenBCEL);
        ++this.m_numberOfClassFields;
        return fcgFieldGenBCEL;
    }

    @Override
    public final int getNumberOfClassFields() {
        return this.m_numberOfClassFields;
    }

    @Override
    public final FcgMethodGen newConstructorGen(FcgAttrs fcgAttrs) {
        FcgMethodGenBCEL fcgMethodGenBCEL = new FcgMethodGenBCEL(this, fcgAttrs, FcgType.VOID, this.class_name, null, null);
        return fcgMethodGenBCEL;
    }

    private FcgMethodGen newMethodGen(FcgAttrs fcgAttrs, FcgType fcgType, FcgReferenceType fcgReferenceType, String string2, FcgType[] fcgTypeArray, FcgInstructionList fcgInstructionList) {
        FcgMethodGenBCEL fcgMethodGenBCEL = new FcgMethodGenBCEL(this, fcgAttrs, fcgType, fcgReferenceType, string2, fcgInstructionList);
        return fcgMethodGenBCEL;
    }

    @Override
    public final void addMethod(FcgMethodGen fcgMethodGen) {
        int n2;
        super.addMethod(fcgMethodGen);
        FcgMethodGenBCEL fcgMethodGenBCEL = (FcgMethodGenBCEL)fcgMethodGen;
        MethodGen methodGen = fcgMethodGenBCEL.getBCELMethodGen();
        Method method = methodGen.getMethod();
        Code code = method.getCode();
        if (code != null && (n2 = code.getLength()) > 65535) {
            if (REPORT_SPLIT) {
                System.err.println("DBG: " + fcgMethodGen.getName() + " oversize at " + n2 + " bytes");
            }
            throw new FcgMethodSizeException(n2, fcgMethodGenBCEL.getName());
        }
        n2 = this.getbcelConstPoolSize();
        if (n2 > 65524 && !fcgMethodGenBCEL.getName().equals("<init>")) {
            this._cp.rollback(65524);
            throw new FcgConstantPoolSizeException(n2, fcgMethodGenBCEL.getName());
        }
        this._cg.addMethod(method);
    }

    @Override
    public final FcgMethodGen newMethodGen(FcgAttrs fcgAttrs, FcgType fcgType, String string2, FcgInstructionList fcgInstructionList) {
        FcgClassReferenceType fcgClassReferenceType = this.getClassType();
        FcgMethodGenBCEL fcgMethodGenBCEL = new FcgMethodGenBCEL(this, fcgAttrs, fcgType, fcgClassReferenceType, string2, fcgInstructionList);
        return fcgMethodGenBCEL;
    }

    @Override
    public final void comment(String string2) {
    }

    @Override
    public final void finish() {
        if (!this.hasDefaultConstructor()) {
            this.addDefaultConstructor(this.m_fcgCodeGen);
        }
    }

    @Override
    public final FcgCodeGen getFcgCodeGen() {
        return this.m_fcgCodeGen;
    }

    private FcgMethodGen newConstructorGen(FcgAttrs fcgAttrs, String string2, FcgInstructionList fcgInstructionList) {
        FcgMethodGenBCEL fcgMethodGenBCEL = new FcgMethodGenBCEL(this, fcgInstructionList);
        return fcgMethodGenBCEL;
    }

    @Override
    public final void addDefaultConstructor(FcgCodeGen fcgCodeGen) {
        this.addDefaultConstructor(fcgCodeGen, null);
    }

    @Override
    public final void addDefaultConstructor(FcgCodeGen fcgCodeGen, FcgInstructionList fcgInstructionList) {
        FcgInstructionList fcgInstructionList2;
        if (!this.hasDefaultConstructor()) {
            String string2 = this.getClassName();
            FcgMethodGen fcgMethodGen = this.newConstructorGen(FcgAttrs.PUBLIC, string2, fcgInstructionList);
            fcgInstructionList2 = fcgMethodGen.getInstructionList();
            this.setDefaultCtor(fcgMethodGen);
            fcgInstructionList2.beginMethod();
            String string3 = this.super_class_name.getTypeName();
            FcgInstructionListBCEL fcgInstructionListBCEL = (FcgInstructionListBCEL)fcgInstructionList2;
            InstructionList instructionList = fcgInstructionListBCEL.getCode();
            instructionList.append(InstructionFactory.createLoad(Type.OBJECT, 0));
            instructionList.append(this._factory.createInvoke(string3, "<init>", Type.VOID, Type.NO_ARGS, (short)183));
        } else {
            fcgInstructionList2 = this.m_defaultCtor.getInstructionList();
        }
        fcgInstructionList2.returnInstruction();
        fcgInstructionList2.endMethod();
    }

    @Override
    public final void addInterface(String string2) {
        this._cg.addInterface(string2);
    }

    InstructionFactory getBCELInstructionFactory() {
        return this._factory;
    }

    InstructionList getInstructionList() {
        LinkedInstructionList linkedInstructionList;
        if (this.m_free_ils != null) {
            linkedInstructionList = this.m_free_ils;
            this.m_free_ils = this.m_free_ils.m_next;
        } else {
            linkedInstructionList = new LinkedInstructionList();
        }
        return linkedInstructionList;
    }

    void disposeInstructionList(InstructionList instructionList) {
        instructionList.dispose();
        LinkedInstructionList linkedInstructionList = (LinkedInstructionList)instructionList;
        linkedInstructionList.m_next = this.m_free_ils;
        this.m_free_ils = linkedInstructionList;
    }

    private FcgMethodGen getCurrentMethod() {
        FcgMethodGen fcgMethodGen = this.m_currentMethodGen;
        return fcgMethodGen;
    }

    private void setCurrentMethod(FcgMethodGen fcgMethodGen) {
        this.m_currentMethodGen = fcgMethodGen;
    }

    @Override
    public final FcgMethodGen newMethodGen(FcgAttrs fcgAttrs, FcgType fcgType, String string2) {
        return this.newMethodGen(fcgAttrs, fcgType, string2, null);
    }

    public static class FcgConstantPoolSizeException
    extends RuntimeException {
        private static final long serialVersionUID = -6283433797247228002L;
        public int size;

        FcgConstantPoolSizeException(int n2, String string2) {
            super("Constant Pool size limit of 65535 exceeded if added method: " + string2);
            this.size = n2;
        }
    }

    public static class FcgMethodSizeException
    extends RuntimeException {
        private static final long serialVersionUID = 1675941579481699540L;
        public int size;

        FcgMethodSizeException(int n2, String string2) {
            super("Method size limit of 65535 exceeded for method: " + string2);
            this.size = n2;
        }
    }

    static final class LinkedInstructionList
    extends InstructionList {
        LinkedInstructionList m_next;

        LinkedInstructionList() {
        }
    }
}

