/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.fcg;

import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgCodeGen;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;

public class FcgTypeUtils {
    private static HashMap s_predefinedMap = new HashMap();

    public static FcgType getFcgType(FcgCodeGen fcgCodeGen, Class clazz) {
        FcgType fcgType;
        if (clazz.isArray()) {
            FcgType fcgType2 = FcgTypeUtils.getFcgType(fcgCodeGen, clazz.getComponentType());
            fcgType = fcgCodeGen.getArrayType(fcgType2);
        } else {
            String string2 = clazz.getName();
            fcgType = (FcgType)s_predefinedMap.get(string2);
            if (fcgType == null) {
                string2 = FcgTypeUtils.fixupInnerClassName(fcgCodeGen, string2);
                fcgType = clazz.isInterface() ? fcgCodeGen.getInterfaceType(string2) : fcgCodeGen.getClassReferenceType(string2);
            }
        }
        return fcgType;
    }

    private static String fixupInnerClassName(FcgCodeGen fcgCodeGen, String string2) {
        int n2 = string2.indexOf(36);
        if (n2 > 0) {
            String string3 = string2.substring(0, n2);
            String string4 = FcgTypeUtils.fixupInnerClassName(fcgCodeGen, string2.substring(n2 + 1, string2.length()));
            FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getInnerClassReferenceType(string3, string4);
            string2 = fcgClassReferenceType.getTypeName();
        }
        return string2;
    }

    static {
        s_predefinedMap.put("boolean", FcgType.BOOLEAN);
        s_predefinedMap.put("byte", FcgType.BYTE);
        s_predefinedMap.put("char", FcgType.CHAR);
        s_predefinedMap.put("short", FcgType.SHORT);
        s_predefinedMap.put("int", FcgType.INT);
        s_predefinedMap.put("long", FcgType.LONG);
        s_predefinedMap.put("float", FcgType.FLOAT);
        s_predefinedMap.put("double", FcgType.DOUBLE);
        s_predefinedMap.put("[Z", FcgType.BOOLEAN_ARRAY);
        s_predefinedMap.put("[B", FcgType.BYTE_ARRAY);
        s_predefinedMap.put("[C", FcgType.CHAR_ARRAY);
        s_predefinedMap.put("[S", FcgType.SHORT_ARRAY);
        s_predefinedMap.put("[I", FcgType.INT_ARRAY);
        s_predefinedMap.put("[J", FcgType.LONG_ARRAY);
        s_predefinedMap.put("[F", FcgType.FLOAT_ARRAY);
        s_predefinedMap.put("[D", FcgType.DOUBLE_ARRAY);
        s_predefinedMap.put(Boolean.class.getName(), FcgType.BOOLEAN_OBJECT);
        s_predefinedMap.put(Byte.class.getName(), FcgType.BYTE_OBJECT);
        s_predefinedMap.put(Character.class.getName(), FcgType.CHAR_OBJECT);
        s_predefinedMap.put(Short.class.getName(), FcgType.SHORT_OBJECT);
        s_predefinedMap.put(Integer.class.getName(), FcgType.INT_OBJECT);
        s_predefinedMap.put(Long.class.getName(), FcgType.LONG_OBJECT);
        s_predefinedMap.put(Float.class.getName(), FcgType.FLOAT_OBJECT);
        s_predefinedMap.put(Double.class.getName(), FcgType.DOUBLE_OBJECT);
        s_predefinedMap.put(String.class.getName(), FcgType.STRING);
        s_predefinedMap.put(Array.newInstance(String.class, 1).getClass().getName(), FcgType.STRING_ARRAY);
        s_predefinedMap.put(StringBuffer.class.getName(), FcgType.STRINGBUFFER);
        s_predefinedMap.put(Object.class.getName(), FcgType.OBJECT);
        s_predefinedMap.put(Array.newInstance(Object.class, 1).getClass().getName(), FcgType.OBJECT_ARRAY);
        s_predefinedMap.put(BigDecimal.class.getName(), FcgType.BIG_DECIMAL);
        s_predefinedMap.put(BigInteger.class.getName(), FcgType.BIG_INTEGER);
        s_predefinedMap.put(Exception.class.getName(), FcgType.EXCEPTION);
        s_predefinedMap.put(RuntimeException.class.getName(), FcgType.RUNTIME_EXCEPTION);
        s_predefinedMap.put(ArithmeticException.class.getName(), FcgType.ARITHMETIC_EXCEPTION);
        s_predefinedMap.put("com.ibm.xltxe.rnm1.xylem.utils.OverflowException", FcgType.OVERFLOW_EXCEPTION);
    }
}

