/*
 * Decompiled with CFR 0.152.
 */
package commonj.sdo.impl;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.SDO;
import commonj.sdo.impl.ExternalizableDelegator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Resolvable
implements Externalizable,
ExternalizableDelegator.Resolvable {
    private DataObject dataObject;

    public Resolvable() {
    }

    public Resolvable(DataObject dataObject) {
        this.dataObject = dataObject;
    }

    @Override
    public Object readResolve() throws ObjectStreamException {
        return this.dataObject;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        if (objectInput.read() == 1) {
            HelperContext helperContext = SDO.getHelperContext(objectInput.readUTF());
            byte[] byArray = new byte[objectInput.readInt()];
            objectInput.readFully(byArray);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            this.dataObject = helperContext.getXMLHelper().load(gZIPInputStream).getRootObject();
        } else {
            String string = objectInput.readUTF();
            DataObject dataObject = (DataObject)objectInput.readObject();
            this.dataObject = dataObject.getDataObject(string);
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (null == this.dataObject.getContainer()) {
            HelperContext helperContext = this.dataObject.getType().getHelperContext();
            objectOutput.writeByte(1);
            String string = helperContext.getIdentifier();
            if (null == string) {
                string = "";
            }
            objectOutput.writeUTF(string);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            this.dataObject.getType().getHelperContext().getXMLHelper().save(this.dataObject, "commonj.sdo", "dataObject", gZIPOutputStream);
            gZIPOutputStream.finish();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            objectOutput.writeInt(byArray.length);
            objectOutput.write(byArray);
            gZIPOutputStream.close();
        } else {
            objectOutput.writeByte(0);
            objectOutput.writeUTF(this.getPath(this.dataObject).substring(1));
            objectOutput.writeObject(this.dataObject.getRootObject());
        }
    }

    private String getPath(DataObject dataObject) {
        if (null == dataObject.getContainer()) {
            return "";
        }
        Property property = dataObject.getContainmentProperty();
        if (property.isMany()) {
            int n = dataObject.getContainer().getList(property).indexOf(dataObject) + 1;
            return this.getPath(dataObject.getContainer()) + '/' + property.getName() + '[' + n + ']';
        }
        return this.getPath(dataObject.getContainer()) + '/' + property.getName();
    }
}

