/*
 * Decompiled with CFR 0.152.
 */
package commonj.sdo.impl;

import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.HelperContextFactory;
import commonj.sdo.impl.CreateEnvironmentException;
import commonj.sdo.impl.CreateHelperContextFactoryException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;

public abstract class Environment {
    protected static final String HELPER_CONTEXT_FACTORY = "commonj.sdo.helper.HelperContextFactory";
    protected static final String ENVIRONMENT = "commonj.sdo.impl.Environment";
    protected static final String SERVICE_RESOURCE = "META-INF/services/";
    private static Environment INSTANCE;

    public static Environment getInstance() {
        if (null == INSTANCE) {
            ClassLoader classLoader = Environment.getContextClassLoader();
            String string = Environment.getImplementationName(ENVIRONMENT);
            if (null == string) {
                try {
                    string = Environment.getImplementationName(classLoader, ENVIRONMENT);
                    if (null == string) {
                        throw new CreateEnvironmentException();
                    }
                }
                catch (IOException iOException) {
                    throw new CreateEnvironmentException(iOException);
                }
            }
            try {
                INSTANCE = (Environment)classLoader.loadClass(string).newInstance();
            }
            catch (Exception exception) {
                throw new CreateEnvironmentException(exception);
            }
        }
        return INSTANCE;
    }

    public static void setInstance(Environment environment) {
        INSTANCE = environment;
    }

    protected static HelperContextFactory createHelperContextFactory(ClassLoader classLoader) {
        String string = Environment.getImplementationName(HELPER_CONTEXT_FACTORY);
        if (null == string) {
            try {
                string = Environment.getImplementationName(classLoader, HELPER_CONTEXT_FACTORY);
                if (null == string) {
                    throw new CreateHelperContextFactoryException();
                }
            }
            catch (IOException iOException) {
                throw new CreateHelperContextFactoryException(iOException);
            }
        }
        try {
            return (HelperContextFactory)classLoader.loadClass(string).newInstance();
        }
        catch (Exception exception) {
            throw new CreateHelperContextFactoryException(exception);
        }
    }

    protected static String getImplementationName(final String string) {
        try {
            return (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(string);
                }
            });
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getImplementationName(ClassLoader classLoader, String string) throws IOException {
        InputStream inputStream = classLoader.getResourceAsStream(SERVICE_RESOURCE + string);
        if (inputStream == null) {
            return null;
        }
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader, 128);
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                int n = string2.indexOf(35);
                if (n != -1) {
                    string2 = string2.substring(0, n);
                }
                if ((string2 = string2.trim()).length() <= 0) continue;
                String string3 = string2;
                return string3;
            }
            String string4 = null;
            return string4;
        }
        finally {
            bufferedReader.close();
        }
    }

    protected static ClassLoader getContextClassLoader() {
        try {
            return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        catch (SecurityException securityException) {
            return Environment.class.getClassLoader();
        }
    }

    public abstract HelperContextFactory getHelperContextFactory();

    public abstract HelperContextFactory getHelperContextFactory(String var1);

    public abstract HelperContext getDefaultHelperContext();

    public abstract HelperContext getHelperContext(String var1);

    public abstract boolean addHelperContext(HelperContext var1);
}

