/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.soa.sca.binding.ejb;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.soa.sca.admin.runtime.SCARuntime;
import com.ibm.ws.soa.sca.admin.runtime.SCARuntimeContext;
import com.ibm.ws.soa.sca.binding.ejb.EJBServiceBindingProvider;
import com.ibm.ws.soa.sca.binding.ejb.EJBServices;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public abstract class BaseSessionBeanImpl
implements SessionBean {
    private static final TraceComponent tc = Tr.register(BaseSessionBeanImpl.class, (String)"SCARTB", null);
    protected SessionContext sessionContext;
    protected String serviceUri;
    private String appName = null;

    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public final void ejbCreate() throws CreateException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ejbCreate");
        }
        try {
            InitialContext initialContext = new InitialContext();
            String string = (String)initialContext.lookup("java:comp/env/serviceTargetURI");
            this.setServiceUri(string);
            String string2 = this.getApplicationName();
            this.setAppName(string2);
        }
        catch (NamingException namingException) {
            CreateException createException = new CreateException("Unable to acquire target URI");
            createException.initCause((Throwable)namingException);
            throw createException;
        }
        catch (Throwable throwable) {
            CreateException createException = new CreateException();
            createException.initCause(throwable);
            throw createException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ejbCreate");
        }
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    protected String getServiceUri() {
        return this.serviceUri;
    }

    private void setServiceUri(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setServiceUri", (Object)string);
        }
        this.serviceUri = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object invoke(String string, Class[] classArray, Object[] objectArray) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"invoke", (Object)new Object[]{string, Arrays.toString(classArray), Arrays.toString(objectArray)});
        }
        ClassLoader classLoader = this.getContextClassLoader();
        ClassLoader classLoader2 = this.getModuleClassLoader();
        Object object = null;
        try {
            EJBServiceBindingProvider eJBServiceBindingProvider = EJBServices.getService((String)this.serviceUri);
            this.setContextClassLoader(classLoader2);
            object = eJBServiceBindingProvider.invokeServiceOperation(string, classArray, objectArray);
        }
        finally {
            this.setContextClassLoader(classLoader);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke", (Object)object);
        }
        return object;
    }

    protected String getAppName() {
        return this.appName;
    }

    private void setAppName(String string) {
        this.appName = string;
    }

    private String getApplicationName() {
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return Thread.currentThread().getContextClassLoader().toString();
            }
        });
        int n = string.lastIndexOf(".ear");
        int n2 = string.lastIndexOf(File.separator, n);
        int n3 = n2 + 1;
        return string.substring(n3, n);
    }

    private ClassLoader getModuleClassLoader() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getModuleClassLoader");
        }
        SCARuntime sCARuntime = AccessController.doPrivileged(new PrivilegedAction<SCARuntime>(){

            @Override
            public SCARuntime run() {
                try {
                    return (SCARuntime)WsServiceRegistry.getService((Object)this, SCARuntime.class);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
        SCARuntimeContext sCARuntimeContext = sCARuntime.getContext(this.getAppName());
        ClassLoader classLoader = sCARuntimeContext.getModuleClassLoader();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getModuleClassLoader", (Object)classLoader);
        }
        return classLoader;
    }

    private ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private void setContextClassLoader(final ClassLoader classLoader) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(classLoader);
                return null;
            }
        });
    }
}

