/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.sca.context.impl;

import com.ibm.websphere.sca.context.CompositeContext;
import com.ibm.websphere.sca.context.CurrentCompositeContext;
import com.ibm.websphere.sca.context.NoSuchDomainException;
import com.ibm.websphere.sca.context.NoSuchServiceException;
import org.apache.tuscany.sca.host.embedded.SCADomain;
import org.apache.tuscany.sca.host.embedded.impl.EmbeddedSCADomain;
import org.osoa.sca.ServiceReference;

public class CurrentCompositeContextImpl
extends CurrentCompositeContext {
    private static final ThreadLocal<CompositeContext> CURRENT_COMPONENT = new InheritableThreadLocal<CompositeContext>();
    private static final String LOCAL_HOST = "http://localhost";

    public static CompositeContext getContext() {
        SCADomain sCADomain;
        CompositeContext compositeContext = CURRENT_COMPONENT.get();
        if (compositeContext == null && (sCADomain = SCADomain.connect((String)LOCAL_HOST)) != null) {
            compositeContext = new CompositeContextImpl(sCADomain);
        }
        return compositeContext;
    }

    public static CompositeContext setContext(CompositeContext compositeContext) {
        CompositeContext compositeContext2 = CURRENT_COMPONENT.get();
        CURRENT_COMPONENT.set(compositeContext);
        return compositeContext2;
    }

    private static class CompositeContextImpl
    implements CompositeContext {
        private SCADomain myDomain;

        public CompositeContextImpl(SCADomain sCADomain) {
            if (sCADomain == null) {
                throw new IllegalStateException("attempted to create a CompositeContext without a domain");
            }
            this.myDomain = sCADomain;
        }

        @Override
        public <T> T getService(Class<T> clazz, String string) {
            return this.getService(clazz, string, null);
        }

        public <T> T getService(Class<T> clazz, String string, String string2) {
            try {
                return (T)this.getServiceReference(clazz, string, string2).getService();
            }
            catch (NoSuchDomainException noSuchDomainException) {
                throw noSuchDomainException;
            }
            catch (NoSuchServiceException noSuchServiceException) {
                throw noSuchServiceException;
            }
            catch (Exception exception) {
                throw new NoSuchServiceException("getService failed for interface=" + clazz + " and service='" + string + "' and domainURI='" + string2 + "'", exception);
            }
        }

        @Override
        public <T> ServiceReference<T> getServiceReference(Class<T> clazz, String string) {
            return this.getServiceReferenceDistributed(clazz, string, null);
        }

        public <T> ServiceReference<T> getServiceReference(Class<T> clazz, String string, String string2) {
            return this.getServiceReferenceDistributed(clazz, string, string2);
        }

        protected <T> ServiceReference<T> getServiceReferenceDistributed(Class<T> clazz, String string, String string2) {
            if (this.myDomain instanceof EmbeddedSCADomain) {
                try {
                    return this.myDomain.getServiceReference(clazz, string);
                }
                catch (Exception exception) {
                    throw new NoSuchServiceException("getService failed for interface=" + clazz + " and service='" + string + "' and domainURI='" + string2 + "'", exception);
                }
            }
            throw new NoSuchServiceException("getService failed for interface=" + clazz + " and service='" + string + "' and domainURI='" + string2 + "'");
        }
    }
}

