/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.sip;

import com.ibm.ws.sip.container.osgi.ServletContextManager;
import com.ibm.ws.sip.container.osgi.ServletInstanceHolderFactory;
import java.io.IOException;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.TooManyHopsException;

public abstract class SipServlet
extends GenericServlet {
    public static final String OUTBOUND_INTERFACES = "javax.servlet.sip.outboundInterfaces";
    public static final String PRACK_SUPPORTED = "javax.servlet.sip.100rel";
    public static final String SIP_FACTORY = "javax.servlet.sip.SipFactory";
    public static final String SIP_SESSIONS_UTIL = "javax.servlet.sip.SipSessionsUtil";
    public static final String SUPPORTED = "javax.servlet.sip.supported";
    public static final String SUPPORTED_RFCs = "javax.servlet.sip.supportedRfcs";
    public static final String TIMER_SERVICE = "javax.servlet.sip.TimerService";
    public static final String APP_NAME_ATTRIBUTE = "com.ibm.ws.sip.container.app.name";
    private ServletConfig m_servletConfig;

    protected void doAck(SipServletRequest req) throws ServletException, IOException {
    }

    protected void doBranchResponse(SipServletResponse resp) throws ServletException, IOException {
    }

    protected void doBye(SipServletRequest req) throws ServletException, IOException {
        if (req.isInitial()) {
            this.notHandled(req);
        }
    }

    protected void doCancel(SipServletRequest req) throws ServletException, IOException {
    }

    protected void doErrorResponse(SipServletResponse resp) throws ServletException, IOException {
    }

    protected void doInfo(SipServletRequest req) throws ServletException, IOException {
        if (req.isInitial()) {
            this.notHandled(req);
        }
    }

    protected void doInvite(SipServletRequest req) throws ServletException, IOException {
        if (req.isInitial()) {
            this.notHandled(req);
        }
    }

    protected void doMessage(SipServletRequest req) throws ServletException, IOException {
        if (req.isInitial()) {
            this.notHandled(req);
        }
    }

    protected void doNotify(SipServletRequest req) throws ServletException, IOException {
        if (req.isInitial()) {
            this.notHandled(req);
        }
    }

    protected void doOptions(SipServletRequest req) throws ServletException, IOException {
        if (req.isInitial()) {
            this.notHandled(req);
        }
    }

    protected void doPrack(SipServletRequest req) throws ServletException, IOException {
        if (req.isInitial()) {
            this.notHandled(req);
        }
    }

    protected void doProvisionalResponse(SipServletResponse resp) throws ServletException, IOException {
    }

    protected void doPublish(SipServletRequest req) throws ServletException, IOException {
        if (req.isInitial()) {
            this.notHandled(req);
        }
    }

    protected void doRedirectResponse(SipServletResponse resp) throws ServletException, IOException {
    }

    protected void doRefer(SipServletRequest req) throws ServletException, IOException {
    }

    protected void doRegister(SipServletRequest req) throws ServletException, IOException {
        if (req.isInitial()) {
            this.notHandled(req);
        }
    }

    protected void doRequest(SipServletRequest req) throws ServletException, IOException {
        String m = req.getMethod();
        if ("INVITE".equals(m)) {
            this.doInvite(req);
        } else if ("ACK".equals(m)) {
            this.doAck(req);
        } else if ("OPTIONS".equals(m)) {
            this.doOptions(req);
        } else if ("BYE".equals(m)) {
            this.doBye(req);
        } else if ("CANCEL".equals(m)) {
            this.doCancel(req);
        } else if ("REGISTER".equals(m)) {
            this.doRegister(req);
        } else if ("SUBSCRIBE".equals(m)) {
            this.doSubscribe(req);
        } else if ("NOTIFY".equals(m)) {
            this.doNotify(req);
        } else if ("MESSAGE".equals(m)) {
            this.doMessage(req);
        } else if ("INFO".equals(m)) {
            this.doInfo(req);
        } else if ("PRACK".equals(m)) {
            this.doPrack(req);
        } else if ("PUBLISH".equals(m)) {
            this.doPublish(req);
        } else if ("REFER".equals(m)) {
            this.doRefer(req);
        } else if ("UPDATE".equals(m)) {
            this.doUpdate(req);
        } else if (req.isInitial()) {
            this.notHandled(req);
        }
    }

    private void doRequestWrapper(SipServletRequest req) throws ServletException, IOException {
        try {
            this.doRequest(req);
        }
        catch (TooManyHopsException te) {
            this.logExceptionToSessionLog(req, (Exception)((Object)te));
            req.createResponse(483).send();
        }
        catch (ServletException e) {
            this.logExceptionToSessionLog(req, (Exception)((Object)e));
            throw e;
        }
        catch (IOException e) {
            this.logExceptionToSessionLog(req, e);
            throw e;
        }
    }

    protected void doResponse(SipServletResponse resp) throws ServletException, IOException {
        int status;
        if (resp.isBranchResponse()) {
            this.doBranchResponse(resp);
        }
        if ((status = resp.getStatus()) < 200) {
            this.doProvisionalResponse(resp);
        } else if (status < 300) {
            this.doSuccessResponse(resp);
        } else if (status < 400) {
            this.doRedirectResponse(resp);
        } else {
            this.doErrorResponse(resp);
        }
    }

    private void doResponseWrapper(SipServletResponse res) throws ServletException, IOException {
        try {
            this.doResponse(res);
        }
        catch (ServletException e) {
            this.logExceptionToSessionLog(res, (Exception)((Object)e));
            throw e;
        }
        catch (IOException e) {
            this.logExceptionToSessionLog(res, e);
            throw e;
        }
    }

    protected void doSubscribe(SipServletRequest req) throws ServletException, IOException {
        if (req.isInitial()) {
            this.notHandled(req);
        }
    }

    protected void doSuccessResponse(SipServletResponse resp) throws ServletException, IOException {
    }

    protected void doUpdate(SipServletRequest req) throws ServletException, IOException {
    }

    public ServletConfig getServletConfig() {
        ServletConfig ctx;
        if (null == this.m_servletConfig && (ctx = super.getServletConfig()) != null) {
            this.m_servletConfig = ServletContextManager.getInstance().getContextFactory().wrapContext(ctx);
        }
        return this.m_servletConfig;
    }

    public ServletContext getServletContext() {
        ServletConfig cfg = this.getServletConfig();
        if (cfg != null) {
            return this.getServletConfig().getServletContext();
        }
        return null;
    }

    public void init(ServletConfig cfg) throws ServletException {
        super.init(cfg);
        ServletContext servletContext = cfg.getServletContext();
        String appName = (String)servletContext.getAttribute(APP_NAME_ATTRIBUTE);
        ServletInstanceHolderFactory.getInstanceHolder().addSipletInstance(appName, ((Object)((Object)this)).getClass().getName(), (Object)this);
        ServletInstanceHolderFactory.getInstanceHolder().saveSipletReference(appName, this, servletContext);
    }

    public void log(String message) {
        ServletContext ctx = null;
        try {
            ctx = this.getServletContext();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (null != ctx) {
            ctx.log(message);
        } else {
            System.out.println(message);
        }
    }

    public void log(String message, Throwable t) {
        ServletContext ctx = null;
        try {
            ctx = this.getServletContext();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (null != ctx) {
            ctx.log(message, t);
        } else {
            System.out.println(message + " " + t.getMessage() + "\n");
        }
    }

    private void logExceptionToSessionLog(SipServletMessage sipMsg, Exception e) {
    }

    private void notHandled(SipServletRequest req) throws IOException {
        SipServletResponse resp = req.createResponse(405, "Request not handled by application");
        resp.addHeader("Allow", "REGISTER");
        resp.addHeader("Allow", "OPTIONS");
        resp.addHeader("Allow", "INFO");
        resp.addHeader("Allow", "INVITE");
        resp.addHeader("Allow", "ACK");
        resp.addHeader("Allow", "BYE");
        resp.addHeader("Allow", "CANCEL");
        resp.addHeader("Allow", "SUBSCRIBE");
        resp.addHeader("Allow", "NOTIFY");
        resp.addHeader("Allow", "PUBLISH");
        resp.addHeader("Allow", "MESSAGE");
        resp.send();
    }

    public void service(ServletRequest req, ServletResponse resp) throws ServletException, IOException {
        if (req != null) {
            this.doRequestWrapper((SipServletRequest)req);
        } else {
            this.doResponseWrapper((SipServletResponse)resp);
        }
    }
}

