/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.namespace;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class QName
implements Serializable {
    static final long serialVersionUID;
    private static final long defaultSerialVersionUID = -9120448754896609940L;
    private static final long compatibleSerialVersionUID = 4418622981026545151L;
    private static boolean useDefaultSerialVersionUID;
    private String namespaceURI;
    private String localPart;
    private String prefix;
    private transient int hashCode;
    private transient String qNameAsString;

    public QName(String string, String string2) {
        this(string, string2, "");
    }

    public QName(String string, String string2, String string3) {
        this.namespaceURI = string == null ? "" : string;
        if (string2 == null) {
            throw new IllegalArgumentException("local part cannot be \"null\" when creating a QName");
        }
        this.localPart = string2;
        if (string3 == null) {
            throw new IllegalArgumentException("prefix cannot be \"null\" when creating a QName");
        }
        this.prefix = string3;
    }

    public QName(String string) {
        this("", string, "");
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getLocalPart() {
        return this.localPart;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof QName) {
            QName qName = (QName)object;
            return this.localPart.equals(qName.localPart) && this.namespaceURI.equals(qName.namespaceURI);
        }
        return false;
    }

    public final int hashCode() {
        int n = this.hashCode;
        if (n == 0) {
            this.hashCode = n = this.namespaceURI.hashCode() ^ this.localPart.hashCode();
        }
        return n;
    }

    public String toString() {
        String string = this.qNameAsString;
        if (string == null) {
            int n = this.namespaceURI.length();
            if (n == 0) {
                string = this.localPart;
            } else {
                StringBuffer stringBuffer = new StringBuffer(n + this.localPart.length() + 2);
                stringBuffer.append('{');
                stringBuffer.append(this.namespaceURI);
                stringBuffer.append('}');
                stringBuffer.append(this.localPart);
                string = stringBuffer.toString();
            }
            this.qNameAsString = string;
        }
        return string;
    }

    public static QName valueOf(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Cannot create QName from \"null\".");
        }
        if (string.length() == 0 || string.charAt(0) != '{') {
            return new QName("", string, "");
        }
        int n = string.indexOf(125);
        if (n == -1) {
            throw new IllegalArgumentException("Cannot create QName from \"" + string + "\", missing closing \"}\"");
        }
        if (n == 1) {
            throw new IllegalArgumentException("Cannot create QName from \"" + string + "\", missing namespace URI");
        }
        return new QName(string.substring(1, n), string.substring(n + 1), "");
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.prefix == null) {
            this.prefix = "";
        }
    }

    static {
        useDefaultSerialVersionUID = true;
        try {
            String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("com.sun.xml.namespace.QName.useCompatibleSerialVersionUID");
                }
            });
            useDefaultSerialVersionUID = string == null || !string.equals("1.0");
        }
        catch (Exception exception) {
            useDefaultSerialVersionUID = true;
        }
        serialVersionUID = useDefaultSerialVersionUID ? -9120448754896609940L : 4418622981026545151L;
    }
}

