/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.scan.util;

import com.ibm.xml.xlxp.scan.util.CharConversionError;
import com.ibm.xml.xlxp.scan.util.DataBuffer;
import com.ibm.xml.xlxp.scan.util.UTF8Support;
import com.ibm.xml.xlxp.scan.util.XMLStringBuffer;

public final class XMLString {
    public static final int FLAGS_NOTWHITESPACE = 1;
    public static final int FLAGS_ALLWHITESPACE = 2;
    public static final int FLAGS_NORMALIZE_EOL = 4;
    public static final int FLAGS_NORMALIZE_EOL11 = 8;
    public static final int FLAGS_NORMALIZE_EOL_MASK = 12;
    public byte[] bytes;
    public int startOffset;
    public int endOffset;
    public int length;
    public int flags;
    public DataBuffer firstBuffer;
    public DataBuffer lastBuffer;
    protected char[][] fConvertedChars;
    protected int[] fConvertedCharsOffset;

    public XMLString() {
    }

    public XMLString(XMLString xMLString) {
        this.bytes = xMLString.bytes;
        this.startOffset = xMLString.startOffset;
        this.endOffset = xMLString.endOffset;
        this.length = xMLString.length;
        this.flags = xMLString.flags;
        this.firstBuffer = xMLString.firstBuffer;
        this.lastBuffer = xMLString.lastBuffer;
        if (this.firstBuffer != null) {
            this.firstBuffer.addReference();
            if (this.lastBuffer != null) {
                DataBuffer dataBuffer = this.firstBuffer;
                do {
                    dataBuffer = dataBuffer.next;
                    dataBuffer.addReference();
                } while (dataBuffer != this.lastBuffer);
            }
        }
    }

    public void clear() {
        if (this.firstBuffer != null) {
            this.bytes = null;
            this.startOffset = 0;
            this.endOffset = 0;
            this.length = 0;
            this.flags = 0;
            this.dropBufferReferences();
        }
    }

    private void dropBufferReferences() {
        if (this.lastBuffer == null) {
            this.firstBuffer.removeReference();
            this.firstBuffer = null;
        } else {
            DataBuffer dataBuffer;
            do {
                dataBuffer = this.firstBuffer;
                this.firstBuffer = dataBuffer.next;
                dataBuffer.removeReference();
            } while (dataBuffer != this.lastBuffer);
            this.firstBuffer = null;
            this.lastBuffer = null;
        }
    }

    public void setValues(DataBuffer dataBuffer, int n, int n2, int n3) {
        if (this.lastBuffer == null && n < dataBuffer.endOffset) {
            if (this.firstBuffer != dataBuffer) {
                if (this.firstBuffer == null) {
                    dataBuffer.addReference();
                    this.firstBuffer = dataBuffer;
                } else {
                    this.setValuesSlowly(dataBuffer, n, n2, n3);
                    return;
                }
            }
            this.startOffset = n;
            this.endOffset = n2;
            this.length = n2 - n;
            this.bytes = dataBuffer.bytes;
            this.flags = n3;
        } else {
            this.setValuesSlowly(dataBuffer, n, n2, n3);
        }
    }

    private void setValuesSlowly(DataBuffer dataBuffer, int n, int n2, int n3) {
        this.setStartPos(dataBuffer, n);
        this.setEndPos(dataBuffer, n2, n3);
    }

    public void setStartPos(DataBuffer dataBuffer, int n) {
        if (dataBuffer == this.firstBuffer) {
            if (this.lastBuffer == null) {
                this.startOffset = n;
            } else {
                this.setStartPosClearLast(n);
            }
        } else {
            this.setStartPosNewBuffer(dataBuffer, n);
        }
    }

    private void setStartPosClearLast(int n) {
        this.lastBuffer.removeReference();
        this.lastBuffer = null;
        this.startOffset = n;
    }

    private void setStartPosNewBuffer(DataBuffer dataBuffer, int n) {
        dataBuffer.addReference();
        if (this.firstBuffer != null) {
            this.dropBufferReferences();
        }
        this.firstBuffer = dataBuffer;
        this.startOffset = n;
    }

    public void setEndPos(DataBuffer dataBuffer, int n, int n2) {
        this.flags = n2;
        if (this.startOffset < this.firstBuffer.endOffset && dataBuffer == this.firstBuffer) {
            this.endOffset = n;
            this.length = n - this.startOffset;
            this.bytes = dataBuffer.bytes;
        } else {
            this.setEndPosSpecial(dataBuffer, n);
        }
    }

    private void setEndPosSpecial(DataBuffer dataBuffer, int n) {
        if (this.startOffset < this.firstBuffer.endOffset) {
            if (n > dataBuffer.startOffset) {
                this.setEndPosAcrossBuffers(dataBuffer, n);
            } else {
                this.fixEndPos(dataBuffer);
            }
        } else {
            this.fixStartPos(dataBuffer, n);
        }
    }

    private void setEndPosAcrossBuffers(DataBuffer dataBuffer, int n) {
        DataBuffer dataBuffer2 = this.firstBuffer;
        this.endOffset = n;
        this.length = dataBuffer2.endOffset - this.startOffset;
        dataBuffer2 = dataBuffer2.next;
        while (dataBuffer2 != dataBuffer) {
            dataBuffer2.addReference();
            this.length += dataBuffer2.endOffset - dataBuffer2.startOffset;
            dataBuffer2 = dataBuffer2.next;
        }
        this.length += n - dataBuffer2.startOffset;
        dataBuffer2.addReference();
        this.lastBuffer = dataBuffer2;
        this.bytes = null;
    }

    private void fixStartPos(DataBuffer dataBuffer, int n) {
        if (dataBuffer != this.firstBuffer) {
            DataBuffer dataBuffer2 = this.firstBuffer;
            this.firstBuffer = dataBuffer2.next;
            this.firstBuffer.addReference();
            dataBuffer2.removeReference();
            this.startOffset = this.firstBuffer.startOffset;
            this.setEndPos(dataBuffer, n, this.flags);
        }
    }

    private void fixEndPos(DataBuffer dataBuffer) {
        DataBuffer dataBuffer2 = this.firstBuffer;
        while (dataBuffer2.next != dataBuffer) {
            dataBuffer2 = dataBuffer2.next;
        }
        this.setEndPos(dataBuffer2, dataBuffer2.endOffset, this.flags);
    }

    public void setValues(DataBuffer dataBuffer, DataBuffer dataBuffer2, int n, int n2, int n3) {
        if (dataBuffer2 == null) {
            dataBuffer2 = dataBuffer;
        }
        this.setStartPos(dataBuffer, n);
        this.setEndPos(dataBuffer2, n2, n3);
    }

    /*
     * Unable to fully structure code
     */
    public void setValues(XMLString var1_1) {
        block13: {
            block11: {
                block15: {
                    block14: {
                        block12: {
                            if (var1_1 == null || var1_1.firstBuffer == null) break block11;
                            this.bytes = var1_1.bytes;
                            this.startOffset = var1_1.startOffset;
                            this.endOffset = var1_1.endOffset;
                            this.length = var1_1.length;
                            this.flags = var1_1.flags;
                            if (this.firstBuffer == var1_1.firstBuffer) break block12;
                            var2_2 = var1_1.firstBuffer;
                            if (var2_2 != null) {
                                var2_2.addReference();
                                if (var1_1.lastBuffer != null) {
                                    do {
                                        var2_2 = var2_2.next;
                                        var2_2.addReference();
                                    } while (var2_2 != var1_1.lastBuffer);
                                }
                            }
                            if (this.firstBuffer != null) {
                                this.dropBufferReferences();
                            }
                            this.firstBuffer = var1_1.firstBuffer;
                            this.lastBuffer = var1_1.lastBuffer;
                            break block13;
                        }
                        if (this.lastBuffer == var1_1.lastBuffer) break block13;
                        var2_3 = this.firstBuffer;
                        if (this.lastBuffer != null) break block14;
                        do {
                            var2_3 = var2_3.next;
                            var2_3.addReference();
                        } while (var2_3 != var1_1.lastBuffer);
                        break block15;
                    }
                    if (var1_1.lastBuffer != null) ** GOTO lbl41
                    var3_4 = var2_3.next;
                    do {
                        var2_3 = var3_4;
                        var3_4 = var2_3.next;
                        var2_3.removeReference();
                    } while (var2_3 != this.lastBuffer);
                    break block15;
lbl-1000:
                    // 1 sources

                    {
                        var2_3 = var2_3.next;
lbl41:
                        // 2 sources

                        ** while (var2_3 != this.lastBuffer && var2_3 != var1_1.lastBuffer)
                    }
lbl42:
                    // 1 sources

                    if (var2_3 == this.lastBuffer) {
                        do {
                            var2_3 = var2_3.next;
                            var2_3.addReference();
                        } while (var2_3 != var1_1.lastBuffer);
                    } else {
                        var3_5 = var2_3.next;
                        do {
                            var2_3 = var3_5;
                            var3_5 = var2_3.next;
                            var2_3.removeReference();
                        } while (var2_3 != this.lastBuffer);
                    }
                }
                this.lastBuffer = var1_1.lastBuffer;
                break block13;
            }
            this.clear();
        }
    }

    public boolean isAllWhitespace() {
        if ((this.flags & 2) != 0) {
            return true;
        }
        if ((this.flags & 1) != 0) {
            return false;
        }
        return this.checkWhitespace();
    }

    private boolean checkWhitespace() {
        boolean bl;
        boolean bl2 = bl = (this.flags & 8) != 0;
        if (this.length > 0) {
            int n = this.startOffset;
            if (this.bytes != null) {
                while (n < this.endOffset) {
                    byte by = this.bytes[n];
                    if (by == 32 || by == 10 || by == 9 || by == 13) {
                        ++n;
                        continue;
                    }
                    if (bl && (by & 0xDF) == 194) {
                        if (++n == this.endOffset) {
                            this.flags |= 1;
                            return false;
                        }
                        if ((by & 0xFF) == 194 && (this.bytes[n] & 0xFF) == 133) {
                            ++n;
                            continue;
                        }
                        if ((by & 0xFF) != 226 || (this.bytes[n] & 0xFF) != 128) continue;
                        if (n + 1 < this.endOffset) {
                            if ((this.bytes[n + 1] & 0xFF) != 168) continue;
                            n += 2;
                            continue;
                        }
                        this.flags |= 1;
                        return false;
                    }
                    this.flags |= 1;
                    return false;
                }
            } else {
                DataBuffer dataBuffer = this.firstBuffer;
                byte[] byArray = dataBuffer.bytes;
                int n2 = dataBuffer.endOffset;
                while (true) {
                    if (n < n2) {
                        byte by = byArray[n];
                        if (by == 32 || by == 10 || by == 9 || by == 13) {
                            ++n;
                            continue;
                        }
                        if (bl && (by & 0xDF) == 194) {
                            if (++n == n2) {
                                if (dataBuffer == this.lastBuffer) {
                                    this.flags |= 1;
                                    return false;
                                }
                                dataBuffer = dataBuffer.next;
                                byArray = dataBuffer.bytes;
                                n = dataBuffer.startOffset;
                                int n3 = n2 = dataBuffer == this.lastBuffer ? this.endOffset : dataBuffer.endOffset;
                            }
                            if ((by & 0xFF) == 194 && (byArray[n] & 0xFF) == 133) {
                                ++n;
                                continue;
                            }
                            if ((by & 0xFF) != 226 || (byArray[n] & 0xFF) != 128) continue;
                            if (n + 1 < n2) {
                                if ((byArray[n + 1] & 0xFF) != 168) continue;
                                n += 2;
                                continue;
                            }
                            if (dataBuffer != this.lastBuffer && (dataBuffer.next.bytes[dataBuffer.next.startOffset] & 0xFF) == 168) {
                                dataBuffer = dataBuffer.next;
                                byArray = dataBuffer.bytes;
                                n = dataBuffer.startOffset + 1;
                                n2 = dataBuffer == this.lastBuffer ? this.endOffset : dataBuffer.endOffset;
                                continue;
                            }
                            this.flags |= 1;
                            return false;
                        }
                        this.flags |= 1;
                        return false;
                    }
                    if (dataBuffer == this.lastBuffer) break;
                    dataBuffer = dataBuffer.next;
                    byArray = dataBuffer.bytes;
                    n = dataBuffer.startOffset;
                    if (dataBuffer == this.lastBuffer) {
                        n2 = this.endOffset;
                        continue;
                    }
                    n2 = dataBuffer.endOffset;
                }
            }
        }
        this.flags |= 2;
        return true;
    }

    public boolean isNormalized() {
        byte by;
        if (this.length == 0) {
            return true;
        }
        if (this.bytes != null) {
            int n = this.startOffset;
            while (n < this.endOffset) {
                byte by2 = this.bytes[n];
                if (by2 < 0 || by2 > 32) {
                    while ((by2 < 0 || by2 > 32) && ++n < this.endOffset) {
                        by2 = this.bytes[n];
                    }
                    if (n >= this.endOffset || by2 >= 32 && ++n != this.endOffset) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        DataBuffer dataBuffer = this.firstBuffer;
        byte[] byArray = dataBuffer.bytes;
        int n = this.startOffset;
        int n2 = dataBuffer.endOffset;
        while ((by = byArray[n]) < 0 || by > 32) {
            while (by < 0 || by > 32) {
                if (++n < n2) {
                    by = byArray[n];
                    continue;
                }
                if (dataBuffer == this.lastBuffer) {
                    return true;
                }
                dataBuffer = dataBuffer.next;
                byArray = dataBuffer.bytes;
                n = dataBuffer.startOffset;
                n2 = dataBuffer == this.lastBuffer ? this.endOffset : dataBuffer.endOffset;
                by = byArray[n];
            }
            if (by < 32) {
                return false;
            }
            if (++n != n2) continue;
            if (dataBuffer == this.lastBuffer) {
                return false;
            }
            dataBuffer = dataBuffer.next;
            byArray = dataBuffer.bytes;
            n = dataBuffer.startOffset;
            if (dataBuffer == this.lastBuffer) {
                n2 = this.endOffset;
                continue;
            }
            n2 = dataBuffer.endOffset;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public boolean equals(XMLString var1_1) {
        block6: {
            block7: {
                if (var1_1 == this) {
                    return true;
                }
                if (this.length <= 0 || this.length != var1_1.length) break block6;
                if (this.bytes == null || var1_1.bytes == null) break block7;
                var2_2 = this.length;
                if (this.bytes[this.startOffset] == var1_1.bytes[var1_1.startOffset]) ** GOTO lbl10
                return false;
lbl-1000:
                // 1 sources

                {
                    if (this.bytes[this.startOffset + var2_2] == var1_1.bytes[var1_1.startOffset + var2_2]) continue;
                    return false;
lbl10:
                    // 2 sources

                    ** while (--var2_2 > 0)
                }
lbl11:
                // 1 sources

                return true;
            }
            var2_3 = this.firstBuffer;
            var3_4 = var1_1.firstBuffer;
            var4_5 = var2_3.bytes;
            var6_7 = this.startOffset;
            var5_6 = var3_4.bytes;
            var7_8 = var1_1.startOffset;
            if (var4_5[var6_7] != var5_6[var7_8]) {
                return false;
            }
            var8_9 = this.lastBuffer != null ? this.lastBuffer : var2_3;
            var9_10 = var1_1.lastBuffer != null ? var1_1.lastBuffer : var3_4;
            var10_11 = this.lastBuffer != null ? var2_3.endOffset : this.endOffset;
            var11_12 = var1_1.lastBuffer != null ? var3_4.endOffset : var1_1.endOffset;
            var12_13 = this.length;
            while (--var12_13 > 0) {
                if (++var6_7 == var10_11) {
                    var2_3 = var2_3.next;
                    var4_5 = var2_3.bytes;
                    var6_7 = var2_3.startOffset;
                    v0 = var10_11 = var2_3 != var8_9 ? var2_3.endOffset : this.endOffset;
                }
                if (++var7_8 == var11_12) {
                    var3_4 = var3_4.next;
                    var5_6 = var3_4.bytes;
                    var7_8 = var3_4.startOffset;
                    v1 = var11_12 = var3_4 != var9_10 ? var3_4.endOffset : var1_1.endOffset;
                }
                if (var4_5[var6_7] == var5_6[var7_8]) continue;
                return false;
            }
            return true;
        }
        return this.length == var1_1.length;
    }

    public boolean equalsString(byte[] byArray, int n) {
        if (this.length > 0 && n == this.length) {
            if (this.bytes != null) {
                if (this.bytes[this.startOffset] != byArray[0]) {
                    return false;
                }
                int n2 = n;
                while (--n2 > 0) {
                    if (this.bytes[this.startOffset + n2] == byArray[n2]) continue;
                    return false;
                }
                return true;
            }
            DataBuffer dataBuffer = this.firstBuffer;
            byte[] byArray2 = dataBuffer.bytes;
            int n3 = this.startOffset;
            if (byArray2[n3] != byArray[0]) {
                return false;
            }
            DataBuffer dataBuffer2 = this.lastBuffer != null ? this.lastBuffer : dataBuffer;
            int n4 = this.lastBuffer != null ? dataBuffer.endOffset : this.endOffset;
            int n5 = 1;
            while (n5 < n) {
                if (++n3 == n4) {
                    dataBuffer = dataBuffer.next;
                    byArray2 = dataBuffer.bytes;
                    n3 = dataBuffer.startOffset;
                    int n6 = n4 = dataBuffer != dataBuffer2 ? dataBuffer.endOffset : this.endOffset;
                }
                if (byArray2[n3] == byArray[n5++]) continue;
                return false;
            }
            return true;
        }
        return n == this.length;
    }

    public XMLString normalizeLineBreaks(XMLStringBuffer xMLStringBuffer, XMLString xMLString) {
        if (this.firstBuffer != null && (this.flags & 0xC) != 0) {
            int n = xMLStringBuffer.getOffset();
            xMLStringBuffer.appendXMLString(this);
            xMLStringBuffer.setStringValues(n, xMLStringBuffer.getOffset(), xMLString);
            return xMLString;
        }
        return this;
    }

    public CharConversionError getChars(char[][] cArray, int[] nArray) {
        if (this.firstBuffer != null) {
            if ((this.flags & 0xC) != 0) {
                return UTF8Support.normalizeBytesToChars(this.firstBuffer, this.lastBuffer, this.startOffset, this.endOffset, cArray, nArray, (this.flags & 8) != 0);
            }
            return UTF8Support.convertBytesToChars(this.firstBuffer, this.lastBuffer, this.startOffset, this.endOffset, cArray, nArray);
        }
        return null;
    }

    public int lengthAsCharacters(int[] nArray) {
        return UTF8Support.lengthAsCharacters(this.firstBuffer, this.lastBuffer, this.startOffset, this.endOffset, this.flags, nArray);
    }

    public String toString() {
        CharConversionError charConversionError = this.convertToChars();
        if (charConversionError == null) {
            return new String(this.fConvertedChars[0], 0, this.fConvertedCharsOffset[0]);
        }
        return null;
    }

    protected final CharConversionError convertToChars() {
        if (this.fConvertedChars == null) {
            int n = 16;
            while (n < this.length) {
                n <<= 1;
            }
            this.fConvertedChars = new char[1][];
            this.fConvertedChars[0] = new char[n];
            this.fConvertedCharsOffset = new int[1];
        }
        this.fConvertedCharsOffset[0] = 0;
        return this.getChars(this.fConvertedChars, this.fConvertedCharsOffset);
    }
}

