/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.util.encoding;

import com.ibm.xml.xlxp.api.util.encoding.ByteStreamDataSource;
import com.ibm.xml.xlxp.api.util.encoding.DataSourceFactory;
import com.ibm.xml.xlxp.api.util.encoding.EncodingSupport;
import com.ibm.xml.xlxp.scan.util.CharConversionError;
import com.ibm.xml.xlxp.scan.util.DataBuffer;
import com.ibm.xml.xlxp.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.scan.util.XMLString;
import java.io.IOException;
import java.io.InputStream;

public final class UTF8EncodingSupport
implements EncodingSupport {
    private static final EncodingSupport fgSingleton = new UTF8EncodingSupport();

    public static EncodingSupport getInstance() {
        return fgSingleton;
    }

    public CharConversionError loadFromByteStream(ParsedEntity parsedEntity, InputStream inputStream, XMLString xMLString, boolean bl, boolean bl2, DataSourceFactory dataSourceFactory) {
        ByteStreamDataSource byteStreamDataSource = dataSourceFactory.allocateByteStreamDataSource();
        byteStreamDataSource.checkAvailable = bl2;
        byteStreamDataSource.setByteStream(inputStream, this, bl);
        return byteStreamDataSource.load(parsedEntity);
    }

    public CharConversionError load(ByteStreamDataSource byteStreamDataSource, DataBuffer dataBuffer) {
        byte[] byArray = dataBuffer.bytes;
        int n = 0;
        try {
            if (byteStreamDataSource.checkForBOM) {
                n = this.checkUTF8BOM(byteStreamDataSource, byArray);
                byteStreamDataSource.checkForBOM = false;
            }
            int n2 = byteStreamDataSource.bufferLength - 1 - n;
            while (byteStreamDataSource.stream != null && n2 > 0) {
                int n3 = byteStreamDataSource.stream.read(byArray, n, n2);
                if (n3 == -1) {
                    byteStreamDataSource.stream.close();
                    byteStreamDataSource.stream = null;
                } else {
                    n += n3;
                    n2 -= n3;
                    if (!byteStreamDataSource.checkAvailable || byteStreamDataSource.stream.available() != 0) {
                        continue;
                    }
                }
                break;
            }
        }
        catch (IOException iOException) {
            return CharConversionError.runtimeIOError(iOException);
        }
        dataBuffer.endOffset = n;
        return null;
    }

    private UTF8EncodingSupport() {
    }

    private int checkUTF8BOM(ByteStreamDataSource byteStreamDataSource, byte[] byArray) throws IOException {
        InputStream inputStream = byteStreamDataSource.stream;
        int n = 0;
        int n2 = inputStream.read();
        if (n2 == 239) {
            n2 = inputStream.read();
            if (n2 == 187) {
                n2 = inputStream.read();
                if (n2 == 191) {
                    return 0;
                }
                byArray[n++] = -17;
                byArray[n++] = -69;
                if (n2 != -1) {
                    byArray[n++] = (byte)n2;
                    return n;
                }
            } else {
                byArray[n++] = -17;
                if (n2 != -1) {
                    byArray[n++] = (byte)n2;
                    return n;
                }
            }
        } else if (n2 != -1) {
            byArray[n++] = (byte)n2;
            return n;
        }
        byteStreamDataSource.stream.close();
        byteStreamDataSource.stream = null;
        return n;
    }
}

