/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.util;

import com.ibm.xml.xlxp.api.util.IOExceptionWrapper;
import com.ibm.xml.xlxp.api.util.encoding.CharacterStreamDataSource;
import com.ibm.xml.xlxp.api.util.encoding.DataSourceFactory;
import com.ibm.xml.xlxp.api.util.encoding.EncodingDeclReader;
import com.ibm.xml.xlxp.api.util.encoding.EncodingSupport;
import com.ibm.xml.xlxp.api.util.encoding.IANACharset;
import com.ibm.xml.xlxp.api.util.encoding.RewindableInputStream;
import com.ibm.xml.xlxp.api.util.encoding.UCSEncodingSupport;
import com.ibm.xml.xlxp.api.util.encoding.UTF8EncodingSupport;
import com.ibm.xml.xlxp.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.scan.util.ParsedEntityFactory;
import com.ibm.xml.xlxp.scan.util.UntestedCode;
import com.ibm.xml.xlxp.scan.util.XMLString;
import com.ibm.xml.xlxp.scan.util.XMLStringBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class SimpleParsedEntityFactory
implements ParsedEntityFactory {
    public static final boolean REQUIRE_IANA_ENCODING_NAMES = false;
    private static final int FREE_ENTITY_COUNT = 8;
    private static final int FREE_STREAM_COUNT = 8;
    protected XMLStringBuffer fStringBuffer;
    protected XMLString fPlaceHolderEncodingName;
    private XMLString fEncodingName;
    private int fFreeEntityCount;
    private ParsedEntity[] fFreeEntities;
    private int fFreeStreamCount;
    private RewindableInputStream[] fFreeStreams;
    private DataSourceFactory fSourceFactory;
    private int fIDCounter;
    private boolean fCheckAvailable = Boolean.getBoolean("com.ibm.xml.xlxp.api.util.SimpleParsedEntityFactory.checkAvailable");
    private final EncodingSupport fUTF8EncodingSupport;
    private EncodingDeclReader fEncodingDeclReader;

    public SimpleParsedEntityFactory(DataBufferFactory dataBufferFactory) {
        this.fSourceFactory = new DataSourceFactory(dataBufferFactory);
        this.fUTF8EncodingSupport = UTF8EncodingSupport.getInstance();
        this.fFreeEntities = new ParsedEntity[8];
        this.fFreeStreams = new RewindableInputStream[8];
        this.fStringBuffer = new XMLStringBuffer(dataBufferFactory);
        this.fEncodingName = new XMLString();
        this.fPlaceHolderEncodingName = new XMLString();
    }

    public void setBufferLength(int n) {
        this.fSourceFactory.setBufferLength(n);
    }

    private void setEncName(String string) {
        this.fStringBuffer.addString(string, this.fEncodingName);
    }

    public void reset(boolean bl) {
        this.fStringBuffer.reset(bl);
        if (!bl) {
            while (this.fFreeEntityCount > 0) {
                --this.fFreeEntityCount;
                this.fFreeEntities[this.fFreeEntityCount] = null;
            }
        }
    }

    protected final ParsedEntity getFreeEntity() {
        ParsedEntity parsedEntity = this.fFreeEntityCount > 0 ? this.fFreeEntities[--this.fFreeEntityCount] : new ParsedEntity(this);
        parsedEntity.id = this.fIDCounter++;
        return parsedEntity;
    }

    public ParsedEntity createParsedEntity(InputStream inputStream, String string) {
        ParsedEntity parsedEntity = this.getFreeEntity();
        try {
            this.setByteStreamSource(parsedEntity, inputStream, string, this.fPlaceHolderEncodingName);
        }
        catch (IOException iOException) {
            throw new IOExceptionWrapper(iOException);
        }
        return parsedEntity;
    }

    public ParsedEntity createParsedEntityFromXMLString(XMLString xMLString, XMLString xMLString2) {
        ParsedEntity parsedEntity = this.getFreeEntity();
        parsedEntity.baseURI.setValues(xMLString2);
        parsedEntity.setContent(xMLString);
        return parsedEntity;
    }

    public void releaseParsedEntity(ParsedEntity parsedEntity) {
        parsedEntity.clear();
        if (this.fFreeEntityCount < 8) {
            int n = 0;
            while (n < this.fFreeEntityCount) {
                if (this.fFreeEntities[n] == parsedEntity) {
                    UntestedCode.needTest("duplicate free entity");
                }
                ++n;
            }
            this.fFreeEntities[this.fFreeEntityCount++] = parsedEntity;
        }
    }

    protected final void setByteStreamSource(ParsedEntity parsedEntity, InputStream inputStream, String string, XMLString xMLString) throws IOException {
        if (string == null) {
            this.detectEncodingSetSource(parsedEntity, inputStream, xMLString);
        } else {
            EncodingSupport encodingSupport;
            this.fStringBuffer.addString(string, this.fEncodingName);
            if (xMLString != null) {
                xMLString.setValues(this.fEncodingName);
            }
            if ((encodingSupport = IANACharset.getEncodingSupport(this.fStringBuffer, this.fEncodingName)) != null) {
                this.loadFromByteStream(parsedEntity, inputStream, this.fEncodingName, true, encodingSupport);
            } else {
                this.convertByteStreamWithUnknownEncoding(parsedEntity, inputStream, this.fEncodingName);
            }
        }
    }

    protected final void setCharacterStreamSource(ParsedEntity parsedEntity, Reader reader) {
        this.loadFromCharacterStream(parsedEntity, reader);
    }

    private void detectEncodingSetSource(ParsedEntity parsedEntity, InputStream inputStream, XMLString xMLString) throws IOException {
        XMLString xMLString2 = null;
        boolean bl = false;
        boolean bl2 = xMLString != null;
        RewindableInputStream rewindableInputStream = this.createRewindableInputStream(inputStream);
        int n = EncodingDeclReader.detectEncoding(rewindableInputStream);
        switch (n) {
            default: {
                this.setEncName("UTF-8");
                if (bl2) {
                    xMLString.setValues(this.fEncodingName);
                }
                this.loadFromByteStream(parsedEntity, rewindableInputStream, this.fEncodingName, false, this.fUTF8EncodingSupport);
                return;
            }
            case 2: {
                this.setEncName("UTF-16BE");
                if (bl2) {
                    this.fStringBuffer.addString("UTF-16", xMLString);
                }
                this.loadFromByteStream(parsedEntity, rewindableInputStream, this.fEncodingName, false, UCSEncodingSupport.getInstance(0));
                return;
            }
            case 3: {
                this.setEncName("UTF-16LE");
                if (bl2) {
                    this.fStringBuffer.addString("UTF-16", xMLString);
                }
                this.loadFromByteStream(parsedEntity, rewindableInputStream, this.fEncodingName, false, UCSEncodingSupport.getInstance(1));
                return;
            }
            case 4: {
                this.setEncName("UTF-32BE");
                if (bl2) {
                    this.fStringBuffer.addString("UTF-32", xMLString);
                }
                this.loadFromByteStream(parsedEntity, rewindableInputStream, this.fEncodingName, false, UCSEncodingSupport.getInstance(2));
                return;
            }
            case 5: {
                this.setEncName("UTF-32LE");
                if (bl2) {
                    this.fStringBuffer.addString("UTF-32", xMLString);
                }
                this.loadFromByteStream(parsedEntity, rewindableInputStream, this.fEncodingName, false, UCSEncodingSupport.getInstance(3));
                return;
            }
            case 6: {
                if (this.fEncodingDeclReader == null) {
                    this.fEncodingDeclReader = new EncodingDeclReader(this.fStringBuffer);
                }
                if (!this.fEncodingDeclReader.getLatinEncoding(this.fEncodingName, rewindableInputStream, bl2)) break;
                xMLString2 = this.fEncodingName;
                break;
            }
            case 7: {
                if (this.fEncodingDeclReader == null) {
                    this.fEncodingDeclReader = new EncodingDeclReader(this.fStringBuffer);
                }
                if (!this.fEncodingDeclReader.getEBCDICEncoding(this.fEncodingName, rewindableInputStream, bl2)) break;
                xMLString2 = this.fEncodingName;
                break;
            }
            case 8: {
                if (this.fEncodingDeclReader == null) {
                    this.fEncodingDeclReader = new EncodingDeclReader(this.fStringBuffer);
                }
                this.fEncodingDeclReader.setState(2, true);
                if (this.fEncodingDeclReader.getUCSEncoding(this.fEncodingName, rewindableInputStream, bl2)) {
                    xMLString2 = this.fEncodingName;
                }
                bl = true;
                break;
            }
            case 9: {
                if (this.fEncodingDeclReader == null) {
                    this.fEncodingDeclReader = new EncodingDeclReader(this.fStringBuffer);
                }
                this.fEncodingDeclReader.setState(2, false);
                if (this.fEncodingDeclReader.getUCSEncoding(this.fEncodingName, rewindableInputStream, bl2)) {
                    xMLString2 = this.fEncodingName;
                }
                bl = true;
                break;
            }
            case 10: {
                if (this.fEncodingDeclReader == null) {
                    this.fEncodingDeclReader = new EncodingDeclReader(this.fStringBuffer);
                }
                this.fEncodingDeclReader.setState(4, true);
                if (this.fEncodingDeclReader.getUCSEncoding(this.fEncodingName, rewindableInputStream, bl2)) {
                    xMLString2 = this.fEncodingName;
                }
                bl = true;
                break;
            }
            case 11: {
                if (this.fEncodingDeclReader == null) {
                    this.fEncodingDeclReader = new EncodingDeclReader(this.fStringBuffer);
                }
                this.fEncodingDeclReader.setState(4, false);
                if (this.fEncodingDeclReader.getUCSEncoding(this.fEncodingName, rewindableInputStream, bl2)) {
                    xMLString2 = this.fEncodingName;
                }
                bl = true;
            }
        }
        rewindableInputStream.rewind();
        if (xMLString2 == null) {
            this.setEncName("UTF-8");
            if (bl2) {
                xMLString.setValues(this.fEncodingName);
            }
            this.loadFromByteStream(parsedEntity, rewindableInputStream, this.fEncodingName, false, this.fUTF8EncodingSupport);
        } else {
            EncodingSupport encodingSupport;
            if (bl2) {
                xMLString.setValues(xMLString2);
            }
            if ((encodingSupport = IANACharset.getEncodingSupport(this.fStringBuffer, xMLString2)) != null) {
                this.loadFromByteStream(parsedEntity, rewindableInputStream, xMLString2, bl, encodingSupport);
            } else {
                this.convertByteStreamWithUnknownEncoding(parsedEntity, rewindableInputStream, xMLString2);
            }
        }
    }

    private final void loadFromByteStream(ParsedEntity parsedEntity, InputStream inputStream, XMLString xMLString, boolean bl, EncodingSupport encodingSupport) {
        encodingSupport.loadFromByteStream(parsedEntity, inputStream, xMLString, bl, this.fCheckAvailable, this.fSourceFactory);
    }

    private final void loadFromCharacterStream(ParsedEntity parsedEntity, Reader reader) {
        CharacterStreamDataSource characterStreamDataSource = this.fSourceFactory.allocateCharacterStreamDataSource();
        characterStreamDataSource.setCharacterStream(reader);
        characterStreamDataSource.load(parsedEntity);
    }

    private final void convertByteStreamWithUnknownEncoding(ParsedEntity parsedEntity, InputStream inputStream, XMLString xMLString) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, xMLString.toString());
        this.loadFromCharacterStream(parsedEntity, inputStreamReader);
    }

    private RewindableInputStream createRewindableInputStream(InputStream inputStream) {
        RewindableInputStream rewindableInputStream;
        if (this.fFreeStreamCount > 0) {
            rewindableInputStream = this.fFreeStreams[--this.fFreeStreamCount];
            rewindableInputStream.setStream(inputStream);
        } else {
            rewindableInputStream = new RewindableInputStream(this, inputStream);
        }
        return rewindableInputStream;
    }

    public void releaseRewindableInputStream(RewindableInputStream rewindableInputStream) {
        if (this.fFreeStreamCount < 8) {
            this.fFreeStreams[this.fFreeStreamCount++] = rewindableInputStream;
        }
    }
}

