/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.stax;

import com.ibm.xml.xlxp.api.sax.impl.SAX2ParsedEntityFactory;
import com.ibm.xml.xlxp.api.stax.StAXDTDScanner;
import com.ibm.xml.xlxp.api.stax.StAXReaderToWriter;
import com.ibm.xml.xlxp.api.stax.XMLInputFactoryImpl;
import com.ibm.xml.xlxp.api.stax.XMLStreamExceptionWrapper;
import com.ibm.xml.xlxp.api.stax.msg.StAXMessageProvider;
import com.ibm.xml.xlxp.api.util.SimpleDTDScannerHelper;
import com.ibm.xml.xlxp.api.util.SymbolStringMappings;
import com.ibm.xml.xlxp.scan.DTDScannerHelper;
import com.ibm.xml.xlxp.scan.msg.MessageProvider;
import com.ibm.xml.xlxp.scan.msg.MessageProviderRegistry;
import com.ibm.xml.xlxp.scan.util.AttrList;
import com.ibm.xml.xlxp.scan.util.NSDeclList;
import com.ibm.xml.xlxp.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.scan.util.QName;
import com.ibm.xml.xlxp.scan.util.XMLString;
import com.ibm.xml.xlxp.scan.util.XMLStringBuffer;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class XMLStreamReaderImpl
extends SimpleDTDScannerHelper
implements XMLStreamReader,
EntityResolver {
    private static final int NO_EVENT = -1;
    private static final int ERROR_WARNING = -2;
    private static final int ERROR_RECOVERABLE = -3;
    private static final int ERROR_FATAL = -4;
    public boolean fInUse;
    protected StAXReaderToWriter fReaderToWriter;
    protected XMLInputFactoryImpl.Properties fProperties;
    protected SymbolStringMappings fSymbolStrings;
    protected StAXDTDScanner fDTDScanner;
    protected SAX2ParsedEntityFactory fEntityFactory;
    protected int fEventType;
    protected int fNextEventType;
    protected XMLString fActualEncoding;
    protected boolean fUserSpecifiedEncoding;
    protected char[][] fCharacters = new char[1][];
    protected int[] fCharactersOffset;
    protected int fCharactersLength;
    protected Location fLocation;
    protected StAXNamespaceContext fStAXNamespaceContext;
    protected String fPublicId;
    protected String fSystemId;
    private XMLStringBuffer fStringBuffer;
    private XMLString fBufferedContent;
    private int fBufferedContentType;
    private int fBufferedNSContext;
    private char[] fSurrogatePair;
    private boolean fHasBufferedContent;
    private boolean fHasCoalescedContent;
    private boolean fIsSingleCharacter;
    private boolean fIsEmptyElement;
    private boolean fShouldCoalesce;

    public XMLStreamReaderImpl(InputSource inputSource, XMLInputFactoryImpl.Properties properties) throws XMLStreamException {
        this.fCharacters[0] = new char[1024];
        this.fCharactersOffset = new int[1];
        this.fSurrogatePair = new char[2];
        this.fActualEncoding = new XMLString();
        this.fSymbolStrings = new SymbolStringMappings(this.fSymbolTable);
        this.fEntityFactory = new SAX2ParsedEntityFactory(this.fBufferFactory);
        this.fDTDScanner = new StAXDTDScanner((DTDScannerHelper)this, this.fDocumentEntityScanner, this.fBufferFactory, this.fSymbolTable, this.fEntityFactory);
        this.fStringBuffer = new XMLStringBuffer(this.fBufferFactory);
        this.fBufferedContent = new XMLString();
        this.setDocumentEntity(inputSource, properties);
    }

    public void reset(boolean bl) {
        super.reset(bl);
        this.fSymbolStrings.reset(true);
        this.fDTDScanner.reset(true);
        this.fEntityFactory.reset(true);
    }

    public void setDocumentEntity(InputSource inputSource, XMLInputFactoryImpl.Properties properties) throws XMLStreamException {
        this.fActualEncoding.clear();
        ParsedEntity parsedEntity = this.fEntityFactory.createParsedEntity(inputSource, this.fActualEncoding);
        if (parsedEntity.error != null) {
            StAXMessageProvider.throwXMLStreamException(parsedEntity.error.exception);
        }
        this.fUserSpecifiedEncoding = inputSource.getEncoding() != null || inputSource.getCharacterStream() != null;
        this.fPublicId = inputSource.getPublicId();
        this.fSystemId = inputSource.getSystemId();
        if (properties != this.fProperties) {
            this.fProperties = properties;
            this.setNamespaceAwareness(this.fProperties.isNamespaceAware);
            this.fDTDScanner.setScanInternalGeneralEntities(this.fProperties.isReplacingEntityReferences);
            if (this.fProperties.isReplacingEntityReferences) {
                this.fDTDScanner.setScanExternalGeneralEntities(this.fProperties.isSupportingExternalEntities);
                this.fDTDScanner.setScanExternalParameterEntities(this.fProperties.isSupportingExternalEntities);
            } else {
                this.fDTDScanner.setScanExternalGeneralEntities(false);
                this.fDTDScanner.setScanExternalParameterEntities(false);
            }
            this.fDTDScanner.setResolveDTDURIs("http://xml.org/sax/features/resolve-dtd-uris", this.fProperties.resolveDTDURIs);
            if (this.fProperties.resolver != null) {
                this.fEntityFactory.setEntityResolver(this);
            } else {
                this.fEntityFactory.setEntityResolver(null);
            }
        }
        this.fHasBufferedContent = false;
        this.fHasCoalescedContent = false;
        this.fShouldCoalesce = this.fProperties.isCoalescing;
        this.fIsSingleCharacter = false;
        this.fIsEmptyElement = false;
        this.fEventType = -1;
        this.fEncName.length = 0;
        this.fVersion.length = 0;
        super.setDocumentEntity(parsedEntity);
        this.next();
    }

    public InputSource resolveEntity(String string, String string2) {
        try {
            Object object = this.fProperties.resolver.resolveEntity(string, string2, null, null);
            if (object == null) {
                return null;
            }
            if (object instanceof InputStream) {
                return new InputSource((InputStream)object);
            }
            if (object instanceof XMLStreamReader) {
                if (this.fReaderToWriter == null) {
                    this.fReaderToWriter = new StAXReaderToWriter();
                }
                return this.fReaderToWriter.toInputSource((XMLStreamReader)object);
            }
            if (object instanceof XMLEventReader) {
                if (this.fReaderToWriter == null) {
                    this.fReaderToWriter = new StAXReaderToWriter();
                }
                return this.fReaderToWriter.toInputSource((XMLEventReader)object);
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XMLStreamExceptionWrapper(xMLStreamException);
        }
        return null;
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        if (string != null) {
            if (string.equals("javax.xml.stream.isInterning")) {
                return Boolean.TRUE;
            }
            if (this.fEventType == 11) {
                if (string.equals("javax.xml.stream.notations")) {
                    return this.fDTDScanner.getNotationDecls();
                }
                if (string.equals("javax.xml.stream.entities")) {
                    return this.fDTDScanner.getEntityDecls();
                }
                if (string.equals("javax.xml.stream.dtd.processingInstructions")) {
                    return this.fDTDScanner.getPIsInDTD();
                }
                if (string.equals("javax.xml.stream.dtd.comments")) {
                    return this.fDTDScanner.getCommentsInDTD();
                }
                if (string.equals("javax.xml.stream.dtd.declaration")) {
                    XMLString xMLString = this.doctypeText();
                    return xMLString != null ? xMLString.toString() : null;
                }
                return null;
            }
            return null;
        }
        StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 9));
        return null;
    }

    boolean isPropertySupported(String string) {
        if (string.equals("javax.xml.stream.isInterning")) {
            return true;
        }
        if (this.fEventType == 11) {
            return string.equals("javax.xml.stream.dtd.declaration") || string.equals("javax.xml.stream.notations") || string.equals("javax.xml.stream.entities") || string.equals("javax.xml.stream.dtd.processingInstructions") || string.equals("javax.xml.stream.dtd.comments");
        }
        return false;
    }

    public int next() throws XMLStreamException {
        if (!this.hasNext()) {
            StAXMessageProvider.throwNoSuchElementException(StAXMessageProvider.createMessage(null, 28));
        } else if (this.isEmptyElement()) {
            this.fIsEmptyElement = false;
            this.fEventType = 2;
            return 2;
        }
        this.getNextScannerEvent();
        while (this.fEventType < 0) {
            switch (this.fEventType) {
                case -2: {
                    if (this.fProperties.reporter != null) {
                        this.fProperties.reporter.report(this.getErrorMessage(), "WARNING", null, this.getLocation());
                    }
                    this.getNextScannerEvent();
                    break;
                }
                case -3: {
                    if (this.fProperties.reporter != null) {
                        this.fProperties.reporter.report(this.getErrorMessage(), "RECOVERABLE_ERROR", null, this.getLocation());
                    }
                    this.getNextScannerEvent();
                    break;
                }
                case -4: {
                    StAXMessageProvider.throwXMLStreamException(this.getErrorMessage(), this.getLocation());
                }
                default: {
                    StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 52, "Encountered event type: " + this.fEventType), this.getLocation());
                }
            }
        }
        this.fCharactersLength = -1;
        return this.fEventType;
    }

    public void require(int n, String string, String string2) throws XMLStreamException {
        if (this.fEventType == n) {
            if (string != null) {
                if (this.hasName()) {
                    if (string.length() == 0) {
                        if (this.getNamespaceURI() != null) {
                            StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 12, string, this.getNamespaceURI()));
                        }
                    } else if (!string.equals(this.getNamespaceURI())) {
                        StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 12, string, this.getNamespaceURI()));
                    }
                } else {
                    StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 12, string, this.getNamespaceURI()));
                }
            }
            if (string2 != null) {
                if (this.hasName() || this.fEventType == 9) {
                    if (!string2.equals(this.getLocalName())) {
                        StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 13, string2, this.getLocalName()));
                    }
                } else {
                    StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 13, string2, ""));
                }
            }
        } else {
            StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 11, new Integer(n), new Integer(this.fEventType)));
        }
    }

    public String getElementText() throws XMLStreamException {
        if (!this.isStartElement()) {
            StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 14));
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n;
            if ((n = this.next()) == 4 || n == 12 || n == 6 || n == 9) {
                stringBuffer.append(this.getText());
                continue;
            }
            if (n != 5 && n != 3) break;
        }
        if (!this.isEndElement()) {
            StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 15));
        }
        return stringBuffer.toString();
    }

    public int nextTag() throws XMLStreamException {
        int n;
        while ((n = this.next()) != 1 && n != 2) {
            if (n == 5 || n == 3 || n == 6 || n == 4 && this.isWhiteSpace()) continue;
            StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 16));
        }
        return n;
    }

    public boolean hasNext() throws XMLStreamException {
        return this.fEventType != 8;
    }

    public void close() throws XMLStreamException {
        this.reset(true);
        this.fInUse = false;
    }

    public String getNamespaceURI(String string) {
        int n;
        if (string == null) {
            StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 46));
        }
        if ((n = this.fSymbolStrings.addSymbol(string)) != 1) {
            int n2 = this.fNamespaceContext.prefixMapping(this.fNSContext, n);
            return this.fSymbolStrings.toString(n2);
        }
        return this.fSymbolStrings.toString(3);
    }

    public boolean isStartElement() {
        return this.fEventType == 1;
    }

    public boolean isEndElement() {
        return this.fEventType == 2;
    }

    public boolean isCharacters() {
        return this.fEventType == 4 || this.fEventType == 12 || this.fEventType == 6;
    }

    public boolean isWhiteSpace() {
        if (this.fEventType == 4) {
            if (this.isSingleCharacter()) {
                return this.fSingleCh == 32 || this.fSingleCh == 10 || this.fSingleCh == 9 || this.fSingleCh == 13;
            }
            return this.content().isAllWhitespace();
        }
        return this.fEventType == 6;
    }

    public String getAttributeValue(String string, String string2) {
        if (this.fEventType == 1) {
            int n = string != null ? this.fSymbolStrings.addSymbol(string) : 0;
            int n2 = this.fSymbolStrings.addSymbol(string2);
            XMLString xMLString = this.getAttributeValue(n, n2);
            return xMLString != null ? xMLString.toString() : null;
        }
        if (this.fEventType == 10) {
            return null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
        return null;
    }

    public int getAttributeCount() {
        if (this.fEventType == 1) {
            return this.fAttributeCount;
        }
        if (this.fEventType == 10) {
            return -1;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
        return -1;
    }

    public javax.xml.namespace.QName getAttributeName(int n) {
        if (this.fEventType == 1) {
            return this.createQName(this.attributeName(n));
        }
        if (this.fEventType == 10) {
            return null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
        return null;
    }

    public String getAttributeNamespace(int n) {
        if (this.fIsNamespaceAware) {
            if (this.fEventType == 1) {
                int n2 = this.attributeName((int)n).nsHandle;
                return n2 != 0 ? this.fSymbolStrings.toString(n2) : null;
            }
            if (this.fEventType == 10) {
                return null;
            }
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
            return null;
        }
        if (this.fEventType == 1) {
            return null;
        }
        if (this.fEventType == 10) {
            return null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
        return null;
    }

    public String getAttributeLocalName(int n) {
        if (this.fIsNamespaceAware) {
            if (this.fEventType == 1) {
                return this.fSymbolStrings.toString(this.attributeName((int)n).localHandle);
            }
            if (this.fEventType == 10) {
                return null;
            }
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
            return null;
        }
        if (this.fEventType == 1) {
            return this.fSymbolStrings.toString(this.attributeName((int)n).handle);
        }
        if (this.fEventType == 10) {
            return null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
        return null;
    }

    public String getAttributePrefix(int n) {
        if (this.fIsNamespaceAware) {
            if (this.fEventType == 1) {
                int n2 = this.attributeName((int)n).prefixHandle;
                return n2 != 0 ? this.fSymbolStrings.toString(n2) : null;
            }
            if (this.fEventType == 10) {
                return null;
            }
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
            return null;
        }
        if (this.fEventType == 1) {
            return null;
        }
        if (this.fEventType == 10) {
            return null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
        return null;
    }

    public String getAttributeType(int n) {
        if (this.fEventType == 1) {
            int n2 = this.attributeType(n);
            return n2 != 0 ? this.fSymbolStrings.toString(n2) : "CDATA";
        }
        if (this.fEventType == 10) {
            return null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
        return null;
    }

    public String getAttributeValue(int n) {
        if (this.fEventType == 1) {
            return this.normalizedAttributeValue(n).toString();
        }
        if (this.fEventType == 10) {
            return null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
        return null;
    }

    public boolean isAttributeSpecified(int n) {
        if (this.fEventType == 1) {
            return this.attributeSpecified(n);
        }
        if (this.fEventType == 10) {
            return false;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
        return false;
    }

    public int getNamespaceCount() {
        if (this.fEventType == 1 || this.fEventType == 2) {
            return this.fNSDecls.nsDeclCount();
        }
        if (this.fEventType == 13) {
            return -1;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 18));
        return -1;
    }

    public String getNamespacePrefix(int n) {
        if (this.fEventType == 1 || this.fEventType == 2) {
            int n2 = this.fNSDecls.nsDeclPrefix(n);
            return n2 != 0 ? this.fSymbolStrings.toString(n2) : null;
        }
        if (this.fEventType == 13) {
            return null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 18));
        return null;
    }

    public String getNamespaceURI(int n) {
        if (this.fEventType == 1 || this.fEventType == 2) {
            int n2 = this.fNSDecls.nsDeclURI(n);
            return this.fSymbolStrings.toString(n2);
        }
        if (this.fEventType == 13) {
            return null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 18));
        return null;
    }

    public NamespaceContext getNamespaceContext() {
        if (this.fStAXNamespaceContext == null) {
            this.fStAXNamespaceContext = new StAXNamespaceContext();
        }
        if (this.fEventType != 8) {
            this.fStAXNamespaceContext.setNSContext(this.fNSContext);
        }
        return this.fStAXNamespaceContext;
    }

    public int getEventType() {
        return this.fEventType;
    }

    public String getText() {
        if (this.fEventType == 4 || this.fEventType == 12 || this.fEventType == 6) {
            if (this.isSingleCharacter()) {
                if (this.fSingleCh < 65536) {
                    return String.valueOf((char)this.fSingleCh);
                }
                int n = this.fSingleCh - 65536;
                this.fSurrogatePair[0] = (char)(55296 + (n >> 10));
                this.fSurrogatePair[1] = (char)(56320 + (n & 0x3FF));
                return new String(this.fSurrogatePair);
            }
            return this.content().toString();
        }
        if (this.fEventType == 5) {
            return this.fContent.toString();
        }
        if (this.fEventType == 11) {
            XMLString xMLString = this.internalSubsetText();
            return xMLString != null ? xMLString.toString() : null;
        }
        if (this.fEventType == 9) {
            XMLString xMLString = this.entityText(this.fEntityName);
            return xMLString != null ? xMLString.toString() : null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 19));
        return null;
    }

    public char[] getTextCharacters() {
        if (this.fCharactersLength >= 0) {
            return this.fCharacters[0];
        }
        if (this.hasTextXXX()) {
            if (this.getCharacters()) {
                return this.fCharacters[0];
            }
            return null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 19));
        return null;
    }

    public int getTextCharacters(int n, char[] cArray, int n2, int n3) throws XMLStreamException {
        if (this.fCharactersLength >= 0) {
            char[] cArray2 = this.fCharacters[0];
            int n4 = this.fCharactersLength - n;
            if (n4 < n3) {
                n3 = n4;
            }
            System.arraycopy(cArray2, n, cArray, n2, n3);
            return n3;
        }
        if (this.hasTextXXX()) {
            if (this.getCharacters()) {
                char[] cArray3 = this.fCharacters[0];
                int n5 = this.fCharactersLength - n;
                if (n5 < n3) {
                    n3 = n5;
                }
                System.arraycopy(cArray3, n, cArray, n2, n3);
                return n3;
            }
            return 0;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 19));
        return -1;
    }

    public int getTextStart() {
        if (this.fCharactersLength >= 0 || this.hasTextXXX()) {
            return 0;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 19));
        return -1;
    }

    public int getTextLength() {
        if (this.fCharactersLength >= 0) {
            return this.fCharactersLength;
        }
        if (this.hasTextXXX()) {
            if (this.getCharacters()) {
                return this.fCharactersLength;
            }
            return 0;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 19));
        return -1;
    }

    public String getEncoding() {
        if (this.fEventType == 7) {
            if (this.fUserSpecifiedEncoding) {
                return this.fActualEncoding.toString();
            }
            if (this.fEncName.length != 0) {
                return this.fEncName.toString();
            }
            return this.fActualEncoding.toString();
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 20));
        return null;
    }

    public boolean hasText() {
        return this.hasTextXXX() || this.fEventType == 11 || this.fEventType == 9;
    }

    public Location getLocation() {
        if (this.fLocation != null) {
            return this.fLocation;
        }
        this.fLocation = new LocationImpl();
        return this.fLocation;
    }

    public javax.xml.namespace.QName getName() {
        if (this.fEventType == 1 || this.fEventType == 2) {
            return this.createQName(this.fElementType);
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 21));
        return null;
    }

    public String getLocalName() {
        if (this.fEventType == 1 || this.fEventType == 2) {
            return this.fSymbolStrings.toString(this.fElementType.localHandle);
        }
        if (this.fEventType == 9) {
            return this.fEntityName.toString();
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 22));
        return null;
    }

    public boolean hasName() {
        return this.fEventType == 1 || this.fEventType == 2;
    }

    public String getNamespaceURI() {
        if (this.fEventType == 1 || this.fEventType == 2) {
            int n = this.fElementType.nsHandle;
            if (this.fIsNamespaceAware) {
                return n != 0 ? this.fSymbolStrings.toString(n) : null;
            }
            return null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 21));
        return null;
    }

    public String getPrefix() {
        if (this.fEventType == 1 || this.fEventType == 2) {
            int n = this.fElementType.prefixHandle;
            if (this.fIsNamespaceAware) {
                return n != 0 ? this.fSymbolStrings.toString(n) : null;
            }
            return null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 21));
        return null;
    }

    public String getVersion() {
        if (this.fEventType == 7) {
            return this.fVersion.length == 0 ? null : this.fVersion.toString();
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 20));
        return null;
    }

    public boolean isStandalone() {
        if (this.fEventType == 7) {
            return this.fStandalone.length > 0 && "yes".equals(this.fStandalone.toString());
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 20));
        return false;
    }

    public boolean standaloneSet() {
        if (this.fEventType == 7) {
            return this.fStandalone.length > 0;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 20));
        return false;
    }

    public String getCharacterEncodingScheme() {
        if (this.fEventType == 7) {
            return this.fEncName.length == 0 ? null : this.fEncName.toString();
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 20));
        return null;
    }

    public String getPITarget() {
        if (this.fEventType == 3) {
            return this.fTarget.toString();
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 23));
        return null;
    }

    public String getPIData() {
        if (this.fEventType == 3) {
            return this.fContent.toString();
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 23));
        return null;
    }

    private void getNextScannerEvent() {
        if (this.fHasBufferedContent || this.fHasCoalescedContent) {
            this.fHasBufferedContent = false;
            this.fHasCoalescedContent = false;
            this.setCurrentEvent(this.fNextEventType);
            this.swapContents();
            return;
        }
        this.fEventType = -1;
        while (this.fEventType == -1) {
            this.fDocumentEntityScanner.produceEvent();
        }
        if (this.fHasBufferedContent || this.fHasCoalescedContent) {
            this.fHasBufferedContent = true;
            this.fNextEventType = this.fEventType;
            this.swapContents();
            this.setCurrentEvent(this.fBufferedContentType);
        }
    }

    private javax.xml.namespace.QName createQName(QName qName) {
        String string = this.fSymbolStrings.toString(qName.nsHandle);
        String string2 = this.fSymbolStrings.toString(qName.localHandle);
        String string3 = this.fSymbolStrings.toString(qName.prefixHandle);
        return new javax.xml.namespace.QName(string, string2, string3);
    }

    private String getErrorMessage() {
        StAXMessageProvider.loadMessageProvider();
        MessageProvider messageProvider = MessageProviderRegistry.getMessageProvider(this.fErrorURI);
        int n = this.fErrorParamsCount;
        Object[] objectArray = new XMLString[n];
        while (n-- > 0) {
            objectArray[n] = this.fErrorParams[n];
        }
        String string = messageProvider.createMessage(null, this.fErrorCode, objectArray);
        return string;
    }

    private boolean isEmptyElement() {
        return !this.fHasBufferedContent && this.fIsEmptyElement;
    }

    private boolean isSingleCharacter() {
        return !this.fHasBufferedContent && this.fIsSingleCharacter;
    }

    private boolean hasTextXXX() {
        return this.fEventType == 4 || this.fEventType == 12 || this.fEventType == 5 || this.fEventType == 6;
    }

    private boolean getCharacters() {
        if (this.fEventType == 4 || this.fEventType == 12 || this.fEventType == 6) {
            if (this.isSingleCharacter()) {
                if (this.fSingleCh < 65536) {
                    this.fCharacters[0][0] = (char)this.fSingleCh;
                    this.fCharactersLength = 1;
                } else {
                    int n = this.fSingleCh - 65536;
                    this.fCharacters[0][0] = (char)(55296 + (n >> 10));
                    this.fCharacters[0][1] = (char)(56320 + (n & 0x3FF));
                    this.fCharactersLength = 2;
                }
                return true;
            }
            this.fCharactersOffset[0] = 0;
            this.content().getChars(this.fCharacters, this.fCharactersOffset);
            this.fCharactersLength = this.fCharactersOffset[0];
            return true;
        }
        if (this.fEventType == 5) {
            this.fCharactersOffset[0] = 0;
            this.fContent.getChars(this.fCharacters, this.fCharactersOffset);
            this.fCharactersLength = this.fCharactersOffset[0];
            return true;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 25));
        return false;
    }

    private XMLString internalSubsetText() {
        return this.fDTDScanner.getInternalSubsetString();
    }

    private XMLString doctypeText() {
        return this.fDTDScanner.getDoctypeString();
    }

    protected XMLString entityText(XMLString xMLString) {
        int n = this.fDTDScanner.lookupEntity(xMLString);
        if (n != -1) {
            return this.fDTDScanner.getInternalEntityContent(n);
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 24));
        return null;
    }

    public XMLString getAttributeValue(int n, int n2) {
        if (this.fIsNamespaceAware) {
            int n3 = 0;
            while (n3 < this.fAttributeCount) {
                QName qName = this.attributeName(n3);
                if (n2 == qName.localHandle && n == qName.nsHandle) {
                    return this.normalizedAttributeValue(n3);
                }
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < this.fAttributeCount) {
                QName qName = this.attributeName(n4);
                if (n2 == qName.handle) {
                    return this.normalizedAttributeValue(n4);
                }
                ++n4;
            }
        }
        return null;
    }

    private XMLString content() {
        if (this.fHasCoalescedContent) {
            this.fStringBuffer.setStringValues(1, this.fStringBuffer.getOffset(), this.fContent);
            this.fHasCoalescedContent = false;
        }
        return this.fContent;
    }

    private QName attributeName(int n) {
        if (n >= 0 && n < this.fAttributeCount) {
            return this.fAttributeNames[n];
        }
        this.throwAIOOBException("attributeName");
        return null;
    }

    private int attributeType(int n) {
        if (n >= 0 && n < this.fAttributeCount) {
            return this.fAttributeTypes[n];
        }
        this.throwAIOOBException("attributeType");
        return -1;
    }

    private XMLString normalizedAttributeValue(int n) {
        if (n >= 0 && n < this.fAttributeCount) {
            if (!this.fAttributeValueNormalized[n]) {
                this.fStringBuffer.normalizeTextValue(this.fAttributeValues[n], null);
                this.fAttributeValueNormalized[n] = true;
            }
            return this.fAttributeValues[n];
        }
        this.throwAIOOBException("normalizedAttributeValue");
        return null;
    }

    private boolean attributeSpecified(int n) {
        if (n >= 0 && n < this.fAttributeCount) {
            if (!this.fHasDefaultAttributes) {
                return true;
            }
            return this.fAttributeSpecified[n];
        }
        this.throwAIOOBException("attributeSpecified");
        return false;
    }

    private void throwAIOOBException(String string) {
        throw new ArrayIndexOutOfBoundsException(string);
    }

    public NSDeclList nsDeclList() {
        return this.fNSDecls;
    }

    public AttrList attrList() {
        return this.fAttributes;
    }

    private void setCurrentEvent(int n) {
        this.fEventType = n;
    }

    private void startCoalescing(boolean bl) {
        this.fHasCoalescedContent = true;
        this.fStringBuffer.reset(true);
        if (bl) {
            this.fBufferedContentType = 4;
            if (this.fHasBufferedContent) {
                this.fHasBufferedContent = false;
                this.fStringBuffer.appendXMLString(this.fBufferedContent);
            }
        }
    }

    private void swapContents() {
        XMLString xMLString = this.fContent;
        this.fContent = this.fBufferedContent;
        this.fBufferedContent = xMLString;
        int n = this.fNSContext;
        this.fNSContext = this.fBufferedNSContext;
        this.fBufferedNSContext = n;
    }

    public boolean produceStartDocumentEvent() {
        super.produceStartDocumentEvent();
        this.setCurrentEvent(7);
        return false;
    }

    public boolean produceEndDocumentEvent() {
        super.produceEndDocumentEvent();
        this.setCurrentEvent(8);
        return false;
    }

    public boolean produceEmptyElementEvent() {
        super.produceEmptyElementEvent();
        this.fIsEmptyElement = true;
        this.setCurrentEvent(1);
        return false;
    }

    public boolean produceStartElementEvent() {
        super.produceStartElementEvent();
        this.setCurrentEvent(1);
        return false;
    }

    public boolean produceLeafElementEvent() {
        this.setCurrentEvent(-1);
        return false;
    }

    public boolean produceEndElementEvent(QName qName) {
        super.produceEndElementEvent(qName);
        this.setCurrentEvent(2);
        return false;
    }

    public boolean produceCharactersEvent() {
        super.produceCharactersEvent();
        return this.processCharactersOrWhitespaceEvent(4);
    }

    public boolean produceWhitespaceEvent() {
        super.produceWhitespaceEvent();
        return this.processCharactersOrWhitespaceEvent(6);
    }

    private boolean processCharactersOrWhitespaceEvent(int n) {
        if (this.fHasCoalescedContent) {
            this.fStringBuffer.appendXMLString(this.fContent);
            return true;
        }
        if (!this.fHasBufferedContent) {
            this.fHasBufferedContent = true;
            this.fBufferedContentType = n;
            this.swapContents();
            return true;
        }
        if (this.fShouldCoalesce) {
            this.startCoalescing(true);
            this.fStringBuffer.appendXMLString(this.fContent);
            return true;
        }
        this.fIsSingleCharacter = false;
        this.setCurrentEvent(n);
        return false;
    }

    public boolean produceStartCDATASectionEvent() {
        super.produceStartCDATASectionEvent();
        if (!this.fProperties.isCoalescing) {
            this.fShouldCoalesce = true;
            this.startCoalescing(false);
        }
        return true;
    }

    public boolean produceEndCDATASectionEvent() {
        super.produceEndCDATASectionEvent();
        if (this.fProperties.isCoalescing) {
            return true;
        }
        this.fIsSingleCharacter = false;
        this.fShouldCoalesce = false;
        this.fStringBuffer.setStringValues(1, this.fStringBuffer.getOffset(), this.fContent);
        this.fHasCoalescedContent = false;
        this.setCurrentEvent(12);
        return false;
    }

    public boolean produceCharacterEvent(int n) {
        super.produceCharacterEvent(n);
        return this.processSingleCharacterEvent();
    }

    public boolean producePredefinedEntityEvent(XMLString xMLString, int n) {
        super.producePredefinedEntityEvent(xMLString, n);
        return this.processSingleCharacterEvent();
    }

    private boolean processSingleCharacterEvent() {
        if (this.fHasCoalescedContent) {
            this.fStringBuffer.appendChar(this.fSingleCh);
            return true;
        }
        if (this.fShouldCoalesce) {
            this.startCoalescing(true);
            this.fStringBuffer.appendChar(this.fSingleCh);
            return true;
        }
        this.fIsSingleCharacter = true;
        this.setCurrentEvent(4);
        return false;
    }

    public boolean produceProcessingInstructionEvent() {
        super.produceProcessingInstructionEvent();
        this.setCurrentEvent(3);
        return false;
    }

    public boolean produceCommentEvent() {
        super.produceCommentEvent();
        this.setCurrentEvent(5);
        return false;
    }

    public boolean produceWarningEvent(String string, int n) {
        super.produceWarningEvent(string, n);
        this.setCurrentEvent(-2);
        return false;
    }

    public boolean produceRecoverableErrorEvent(String string, int n) {
        super.produceRecoverableErrorEvent(string, n);
        this.setCurrentEvent(-3);
        return false;
    }

    public boolean produceFatalErrorEvent(String string, int n) {
        super.produceFatalErrorEvent(string, n);
        this.setCurrentEvent(-4);
        return false;
    }

    public boolean reportFatalError(String string, int n) {
        this.produceFatalErrorEvent(string, n);
        return false;
    }

    public boolean produceDoctypeEvent(boolean bl) {
        super.produceDoctypeEvent(bl);
        this.setCurrentEvent(11);
        return true;
    }

    public boolean produceEntityReferenceEvent(XMLString xMLString) {
        super.produceEntityReferenceEvent(xMLString);
        this.setCurrentEvent(9);
        return false;
    }

    private final class StAXNamespaceContext
    implements NamespaceContext {
        private int fXLXPNSContext;

        public void setNSContext(int n) {
            this.fXLXPNSContext = n;
        }

        public String getNamespaceURI(String string) {
            int n;
            if (string == null) {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 46));
            }
            if ((n = XMLStreamReaderImpl.this.fSymbolStrings.addSymbol(string)) != 1) {
                int n2 = XMLStreamReaderImpl.this.fNamespaceContext.prefixMapping(this.fXLXPNSContext, n);
                return XMLStreamReaderImpl.this.fSymbolStrings.toString(n2);
            }
            return XMLStreamReaderImpl.this.fSymbolStrings.toString(3);
        }

        public String getPrefix(String string) {
            int n;
            if (string == null) {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 45));
            }
            if ((n = XMLStreamReaderImpl.this.fSymbolStrings.addSymbol(string)) != 3) {
                int n2 = XMLStreamReaderImpl.this.fNamespaceContext.totalMappingsCount(this.fXLXPNSContext);
                int[] nArray = new int[n2 << 1];
                int n3 = XMLStreamReaderImpl.this.fNamespaceContext.inScopeNamespaces(this.fXLXPNSContext, nArray) << 1;
                int n4 = 0;
                while (n4 < n3) {
                    if (nArray[n4 + 1] == n) {
                        return XMLStreamReaderImpl.this.fSymbolStrings.toString(nArray[n4]);
                    }
                    n4 += 2;
                }
                return null;
            }
            return XMLStreamReaderImpl.this.fSymbolStrings.toString(1);
        }

        public Iterator getPrefixes(String string) {
            if (string == null) {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 45));
            }
            int n = XMLStreamReaderImpl.this.fSymbolStrings.addSymbol(string);
            HashSet<String> hashSet = new HashSet<String>();
            if (n != 3) {
                int n2 = XMLStreamReaderImpl.this.fNamespaceContext.totalMappingsCount(this.fXLXPNSContext);
                int[] nArray = new int[n2 << 1];
                int n3 = XMLStreamReaderImpl.this.fNamespaceContext.inScopeNamespaces(this.fXLXPNSContext, nArray) << 1;
                int n4 = 0;
                while (n4 < n3) {
                    if (nArray[n4 + 1] == n) {
                        hashSet.add(XMLStreamReaderImpl.this.fSymbolStrings.toString(nArray[n4]));
                    }
                    n4 += 2;
                }
            } else {
                hashSet.add(XMLStreamReaderImpl.this.fSymbolStrings.toString(1));
            }
            return hashSet.iterator();
        }
    }

    private class LocationImpl
    implements Location {
        private int fLineNumber = -1;
        private int fColumnNumber = -1;
        private int fCharacterOffset = -1;

        public int getLineNumber() {
            return this.fLineNumber;
        }

        public int getColumnNumber() {
            return this.fColumnNumber;
        }

        public int getCharacterOffset() {
            return this.fCharacterOffset;
        }

        public String getPublicId() {
            return XMLStreamReaderImpl.this.fPublicId;
        }

        public String getSystemId() {
            return XMLStreamReaderImpl.this.fSystemId;
        }
    }
}

