/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.util;

import java.io.FileNotFoundException;
import java.security.ProtectionDomain;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveFileDynamicClassLoader;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;

public class WarFileDynamicClassLoader
extends ArchiveFileDynamicClassLoader {
    private boolean allowLoadingFromWAR = true;

    public WarFileDynamicClassLoader(Archive archive, ClassLoader classLoader, ClassLoader classLoader2, ProtectionDomain protectionDomain) {
        super(archive, classLoader, classLoader2, protectionDomain);
        this.allowLoadingFromWAR = archive.getOptions().getClassLoadingMode() == 0;
    }

    public WarFileDynamicClassLoader(Archive archive, ClassLoader classLoader, ClassLoader classLoader2) {
        this(archive, classLoader, classLoader2, null);
    }

    protected File getFile(String string) {
        String string2 = ArchiveUtil.concatUri("WEB-INF/classes/", string, '/');
        try {
            return this.getWarFile().getFile(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Object object;
            if (this.allowLoadingFromWAR && (object = this.getFileFromArchive(string)) != null) {
                return object;
            }
            object = this.getWarFile().getLibs();
            for (int i = 0; i < object.size(); ++i) {
                try {
                    return ((Archive)object.get(i)).getFile(string);
                }
                catch (FileNotFoundException fileNotFoundException2) {
                    continue;
                }
            }
            return this.getFileFromDependentJar(string);
        }
    }

    private WARFile getWarFile() {
        return (WARFile)this.getArchive();
    }
}

