/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.util;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.io.IOException;
import java.util.AbstractSequentialList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileDups {
    private static int sFiles = 0;
    private static int sDups = 0;
    private static int sJARs = 0;
    private static String[] excludedEntryNames = new String[]{"com/ibm/ivj/ejb/runtime/_CopyHelper_Stub.class", "org/omg/stub/javax/ejb/_HomeHandle_Stub.class", "org/omg/stub/javax/ejb/_Handle_Stub.class", "org/omg/stub/javax/ejb/_EJBObject_Stub.class", "org/omg/stub/javax/ejb/_EJBHome_Stub.class", "org/omg/stub/java/lang/_Cloneable_Stub.class", "com/ibm/websphere/csi/_TransactionalObject_Stub.class", "com/ibm/websphere/csi/_CSIServant_Stub.class", "com/ibm/ejs/container/_EJSWrapper_Tie.class", "com/ibm/ejs/container/_EJSWrapper_Stub.class"};
    private static HashSet excluded = new HashSet<String>(Arrays.asList(excludedEntryNames));

    private static void addEntry(String string, Map map, String string2) {
        ++sFiles;
        Object v = map.get(string);
        if (v == null) {
            map.put(string, string2);
        } else if (v instanceof String) {
            map.remove(string);
            String string3 = (String)v;
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.addFirst(string3);
            linkedList.addFirst(string2);
            map.put(string, linkedList);
            ++sDups;
        } else {
            LinkedList linkedList = (LinkedList)v;
            linkedList.addFirst(string2);
            ++sDups;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("FileDups utility\r\n\r\n");
            stringBuffer.append("Synopsis:\r\n");
            stringBuffer.append("Analyzes JAR and ZIP files in a directory for duplicate entries with the same name.  This excludes all entries in the \"META-INF\" directory of the archive.  This does not check timestamps or size.\r\n\r\n");
            stringBuffer.append("Usage: FileDups dirName\r\n");
            System.out.println(stringBuffer.toString());
            return;
        }
        TreeMap treeMap = new TreeMap();
        try {
            LinkedList linkedList;
            Object object;
            Object object2;
            CharSequence charSequence;
            Object object3;
            Object object4;
            Object object5;
            for (int i = 0; i < stringArray.length; ++i) {
                object5 = new File(stringArray[i]);
                FileDups.processDirectory((File)object5, treeMap);
            }
            TreeMap treeMap2 = new TreeMap();
            object5 = treeMap.entrySet();
            Iterator iterator = object5.iterator();
            while (iterator.hasNext()) {
                object4 = (Map.Entry)iterator.next();
                object3 = object4.getValue();
                if (!(object3 instanceof LinkedList)) continue;
                charSequence = new StringBuffer();
                object2 = (LinkedList)object3;
                object = ((AbstractSequentialList)object2).iterator();
                while (object.hasNext()) {
                    ((StringBuffer)charSequence).append(object.next());
                    ((StringBuffer)charSequence).append("\r\n");
                }
                linkedList = (LinkedList)treeMap2.get(((StringBuffer)charSequence).toString());
                if (linkedList == null) {
                    linkedList = new LinkedList();
                    treeMap2.put(((StringBuffer)charSequence).toString(), linkedList);
                }
                linkedList.addFirst(object4.getKey());
            }
            object4 = treeMap2.entrySet();
            iterator = object4.iterator();
            while (iterator.hasNext()) {
                object3 = (Map.Entry)iterator.next();
                charSequence = (String)object3.getKey();
                object2 = new StringTokenizer((String)charSequence, "\r\n");
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    System.out.println(((StringTokenizer)object2).nextToken());
                }
                object = (LinkedList)object3.getValue();
                linkedList = ((AbstractSequentialList)object).iterator();
                while (linkedList.hasNext()) {
                    System.out.println("    " + (String)linkedList.next());
                }
            }
            System.out.println("\r\nSearched " + sJARs + " jars, found " + sDups + " dups in " + sFiles + " files.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void processDirectory(File file, Map map) throws IOException {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                FileDups.processDirectory(file2, map);
                continue;
            }
            String string = file2.getName().toLowerCase();
            if (!string.endsWith(".zip") && !string.endsWith(".jar")) continue;
            FileDups.processFile(file2, map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void processFile(File file, Map map) throws IOException {
        String string;
        Object object;
        Object object2;
        HashSet<String> hashSet;
        block13: {
            hashSet = new HashSet<String>();
            ++sJARs;
            ZipFile zipFile = null;
            zipFile = new ZipFile(file);
            object2 = zipFile.entries();
            while (object2.hasMoreElements()) {
                object = object2.nextElement();
                string = ((ZipEntry)object).getName();
                if (string.startsWith("META-INF") || excluded.contains(string)) continue;
                hashSet.add(string);
            }
            Object var8_8 = null;
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
                break block13;
            }
            catch (IOException iOException) {}
            break block13;
            {
                catch (Exception exception) {
                    System.out.println("*Error searching in " + file.getAbsolutePath());
                    var8_8 = null;
                    try {
                        if (zipFile != null) {
                            zipFile.close();
                        }
                        break block13;
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        object2 = file.getPath();
        object = hashSet.iterator();
        while (object.hasNext()) {
            string = (String)object.next();
            FileDups.addEntry(string, map, (String)object2);
        }
    }
}

