/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.util;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.internal.common.XMLResource;

public class EARFileUtil {
    private EARFileUtil() {
    }

    public static List getIncompatible13ModuleFiles(EARFile eARFile) {
        if (EARFileUtil.isJ2EE13(eARFile)) {
            return Collections.EMPTY_LIST;
        }
        List list = eARFile.getModuleFiles();
        ArrayList<ModuleFile> arrayList = new ArrayList<ModuleFile>();
        for (int i = 0; i < list.size(); ++i) {
            ModuleFile moduleFile = (ModuleFile)list.get(i);
            if (!EARFileUtil.isJ2EE13(moduleFile)) continue;
            arrayList.add(moduleFile);
        }
        return arrayList;
    }

    public static List getIncompatible14ModuleFiles(EARFile eARFile) {
        if (EARFileUtil.isJ2EE14(eARFile)) {
            return Collections.EMPTY_LIST;
        }
        List list = eARFile.getModuleFiles();
        ArrayList<ModuleFile> arrayList = new ArrayList<ModuleFile>();
        for (int i = 0; i < list.size(); ++i) {
            ModuleFile moduleFile = (ModuleFile)list.get(i);
            if (!EARFileUtil.isJ2EE14(moduleFile)) continue;
            arrayList.add(moduleFile);
        }
        return arrayList;
    }

    public static boolean isJ2EE13(ModuleFile moduleFile) {
        try {
            XMLResource xMLResource = (XMLResource)moduleFile.getDeploymentDescriptorResource();
            return xMLResource.getJ2EEVersionID() == 13;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
    }

    public static boolean isJ2EE14(ModuleFile moduleFile) {
        try {
            XMLResource xMLResource = (XMLResource)moduleFile.getDeploymentDescriptorResource();
            return xMLResource.getJ2EEVersionID() == 14;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
    }
}

