/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.util;

import com.ibm.icu.util.StringTokenizer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIMappingRegistryImpl;
import org.eclipse.jem.java.JavaURL;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.EmptyResourceException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveURIConverterImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.DeleteOnExitUtility;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.internal.xml.XmlDocumentReader;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class ArchiveUtil {
    protected static final Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    public static final String className = (class$org$eclipse$jst$j2ee$commonarchivecore$internal$util$ArchiveUtil == null ? (class$org$eclipse$jst$j2ee$commonarchivecore$internal$util$ArchiveUtil = ArchiveUtil.class$("org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil")) : class$org$eclipse$jst$j2ee$commonarchivecore$internal$util$ArchiveUtil).getName();
    public static final String DOT_CLASS = ".class";
    public static final String DOT_JAVA = ".java";
    public static final String DOT_SQLJ = ".sqlj";
    public static final String DOT_JSP = ".jsp";
    protected static boolean isRuntime = false;
    protected static boolean shouldUseTempDirectoryForRead = true;
    protected static String tempDirectoryName;
    protected static File tempDirectory;
    protected static boolean isAIX;
    static /* synthetic */ Class class$org$eclipse$jst$j2ee$commonarchivecore$internal$util$ArchiveUtil;

    public static String classNameToJavaUri(String string) {
        return string.replace('.', '/').concat(DOT_JAVA);
    }

    public static String classNameToUri(String string) {
        return string.replace('.', '/').concat(DOT_CLASS);
    }

    public static String classUriToJavaUri(String string) {
        if (string == null || !string.endsWith(DOT_CLASS)) {
            return null;
        }
        String string2 = ArchiveUtil.truncateIgnoreCase(string, DOT_CLASS);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "$");
        return stringTokenizer.nextToken().concat(DOT_JAVA);
    }

    public static String concatUri(String string, String string2, char c) {
        String string3 = string;
        if (!string.endsWith(c + "") && !string2.startsWith(c + "")) {
            string3 = string3 + c;
        }
        return string3 + string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[1024];
        try {
            int n = inputStream.read(byArray);
            while (n > 0) {
                outputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!(inputStream instanceof ZipInputStream)) {
                inputStream.close();
            }
            if (!(outputStream instanceof ZipOutputStream)) {
                outputStream.close();
            }
            throw throwable;
        }
        if (!(inputStream instanceof ZipInputStream)) {
            inputStream.close();
        }
        if (!(outputStream instanceof ZipOutputStream)) {
            outputStream.close();
        }
    }

    public static File createTempDirectory(String string, File file) throws IOException {
        File file2;
        String string2 = "createTempDirectory";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, string2, "ENTRY [ {0} ] [ {1} ]", new Object[]{string, file});
        }
        if ((file2 = ArchiveUtil.createTempFile(string, file)).exists()) {
            if (!file2.delete()) {
                logger.logp(Level.SEVERE, className, string2, "Could not delete new temporary file [ {0} ] with basename [ {1} ] and parent directory [ {2} ]", new Object[]{file2, string, file});
            } else {
                logger.logp(Level.FINER, className, string2, "Deleted new temporary file [ {0} ] with basename [ {1} ] and parent directory [ {2} ]", new Object[]{file2, string, file});
            }
        } else {
            logger.logp(Level.SEVERE, className, string2, "New temporary file already deleted [ {0} ] with basename [ {1} ] and parent directory [ {2} ]", new Object[]{file2, string, file});
        }
        if (!file2.mkdir()) {
            logger.logp(Level.WARNING, className, string2, "Could not create temporary directory [ {0} ] with basename [ {1} ] and parent directory [ {2} ]", new Object[]{file2, string, file});
            if (!file.exists()) {
                logger.logp(Level.SEVERE, className, string2, "Parent directory does not exist [ {0} ] with basename [ {1} ] and parent directory [ {2} ]", new Object[]{file2, string, file});
            }
        }
        logger.logp(Level.FINER, className, string2, "RETURN [ {0} ]", file2);
        return file2;
    }

    public static File createTempFile(String string) throws IOException {
        return ArchiveUtil.createTempFile(string, ArchiveUtil.getTempDirectory());
    }

    public static File createTempFile(String string, File file) throws IOException {
        String string2;
        String string3 = "createTempFile";
        boolean bl = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.logp(Level.FINER, className, string3, "ENTRY [ {0} ] [ {1} ]", new Object[]{string, file});
        }
        if (file == null) {
            if (bl) {
                logger.logp(Level.FINER, className, string3, "No temporary location was specified; using the system defined location");
            }
        } else if (!file.exists()) {
            if (bl) {
                logger.logp(Level.FINER, className, string3, "Temporary location does not exist!");
            }
            logger.logp(Level.WARNING, className, string3, "Specified temporary directory [ {0} ] with basename [ {1} ] does not exist; using system temporary directory", new Object[]{file, string});
            file = null;
            string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("java.io.tmpdir");
                }
            });
            if (bl) {
                logger.logp(Level.FINER, className, string3, "system temporary directory [ {0} ]", string2);
            }
        } else if (!file.isDirectory()) {
            logger.logp(Level.SEVERE, className, string3, "Temporary location [ {0} ] with basename [ {1} ] is not a directory", new Object[]{file, string});
        }
        if ((string2 = ArchiveUtil.getFileNameTail(string)).length() < 3) {
            string2 = "WSTMP" + string2;
        }
        if (bl) {
            logger.logp(Level.FINER, className, string3, "Temp File Prefix: [ {0} ]", string2);
        }
        File file2 = File.createTempFile(string2, null, file);
        if (bl) {
            if (!file2.exists()) {
                logger.logp(Level.WARNING, className, string3, "Temp File Was Not Created: [ {0} ]", file2);
            }
            logger.logp(Level.FINER, className, string3, "RETURN Temp File: [ {0} ]", file2);
        }
        return file2;
    }

    public static boolean delete(File file) {
        File[] fileArray;
        if (file == null) {
            return true;
        }
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (ArchiveUtil.delete(fileArray[i])) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static List getWriteProtectedFiles(File file, List arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList<File>();
        }
        if (file.exists() && !file.canWrite()) {
            arrayList.add(file);
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                ArchiveUtil.getWriteProtectedFiles(fileArray[i], arrayList);
            }
        }
        return arrayList;
    }

    public static String deriveEARRelativeURI(String string, Archive archive) {
        return ArchiveUtil.deriveEARRelativeURI(string, archive.getURI());
    }

    public static String deriveEARRelativeURI(String string, String string2) {
        String string3;
        String string4;
        String string5 = "deriveEARRelativeURI";
        logger.logp(Level.FINER, className, string5, "ENTRY Archive [ {0} ] and classpath entry [ {1} ]", new Object[]{string2, string});
        try {
            string4 = new File(".").getCanonicalPath();
        }
        catch (IOException iOException) {
            logger.logp(Level.FINER, className, string5, "Unable to obtain canonical path for current directory processing archive [ {0} ] and classpath entry [ {1} ]", new Object[]{string2, string});
            logger.throwing(className, string5, iOException);
            logger.logp(Level.FINER, className, string5, "RETURN relative URI [ {0} ]", (Object)null);
            return null;
        }
        logger.logp(Level.FINEST, className, string5, "Working directory [ {0} ]", string4);
        String string6 = ArchiveUtil.getFileNameParent(string2);
        if (string6 == null || string6.equals("")) {
            string6 = ".";
        }
        logger.logp(Level.FINER, className, string5, "Selected parent [ {0} ]", string6);
        try {
            string3 = new File(string6, string).getCanonicalPath();
        }
        catch (IOException iOException) {
            logger.logp(Level.WARNING, className, string5, "Unable to obtain canonical path for resolved entry processing archive [ {0} ], classpath entry [ {1} ], and parent [ {2} ]", new Object[]{string2, string, string6});
            logger.throwing(className, string5, iOException);
            logger.logp(Level.FINER, className, string5, "RETURN relative URI [ {0} ]", (Object)null);
            return null;
        }
        logger.logp(Level.FINER, className, string5, "Resolved entry [ {0} ]", string3);
        String string7 = string3.toLowerCase();
        String string8 = string4.toLowerCase();
        if (!string7.startsWith(string8)) {
            logger.logp(Level.WARNING, className, string5, "Resolved entry reaches outside of parent application for archive [ {0} ], classpath entry [ {1} ], parent [ {2} ], and resolve entry [ {3} ]", new Object[]{string2, string, string6, string3});
            logger.logp(Level.FINER, className, string5, "RETURN relative URI [ {0} ]", (Object)null);
            return null;
        }
        if (string7.equals(string8)) {
            logger.logp(Level.WARNING, className, string5, "Resolved entry maps to parent application for archive [ {0} ], classpath entry [ {1} ], parent [ {2} ], and resolve entry [ {3} ]", new Object[]{string2, string, string6, string3});
            logger.logp(Level.FINEST, className, string5, "RETURN relative URI [ {0} ]", (Object)null);
            return null;
        }
        int n = string4.endsWith(File.separator) ? string4.length() : string4.length() + 1;
        String string9 = string3.substring(n, string3.length());
        string9 = string9.replace(File.separatorChar, '/');
        logger.logp(Level.FINER, className, string5, "RETURN relative URI [ {0} ]", string9);
        return string9;
    }

    public static String getFileNameExtension(String string) {
        int n;
        if (string != null && (n = string.lastIndexOf(".")) != -1) {
            return string.substring(n + 1);
        }
        return "";
    }

    public static String getFileNameParent(String string) {
        int n;
        String string2 = "getFileNameParent";
        if (string == null) {
            logger.logp(Level.WARNING, className, string2, "RETURN null; null module URI.");
            return "";
        }
        String string3 = string.replace('\\', '/');
        if (string3.endsWith("/")) {
            logger.logp(Level.WARNING, className, string2, "Module URI has trailing file separator characters [ {0} ]", string);
            while (string3.endsWith("/")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
        }
        if ((n = string3.lastIndexOf(47)) == -1) {
            return "";
        }
        if (n == 0) {
            logger.logp(Level.WARNING, className, string2, "RETURN '/'; module URI has a leading separator [ {0} ]", string);
            return "/";
        }
        String string4 = string.substring(0, n);
        logger.logp(Level.FINER, className, string2, "RETURN trimmed URI [ {0} ]", string4);
        return string4;
    }

    public static String getFileNameTail(String string) {
        String string2 = string.replace('\\', '/');
        while (string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        int n = string2.lastIndexOf(47);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1, string2.length());
    }

    public static ModuleFile getModuleFile(EObject eObject) {
        String string = "getModuleFile";
        logger.entering(className, string, eObject);
        Resource resource = eObject.eResource();
        if (resource == null) {
            logger.exiting(className, string, "No resource found.  Returning null.");
            return null;
        }
        Archive archive = ArchiveUtil.getArchive(resource);
        if (archive == null || !archive.isModuleFile()) {
            logger.exiting(className, string, "Archive resource is not a module.  Returning null.");
            return null;
        }
        if (!(resource instanceof XMLResource)) {
            logger.exiting(className, string, "Archive resource is not an XML Resource.  Returning null.");
            return null;
        }
        XMLResource xMLResource = (XMLResource)resource;
        if (xMLResource.isAlt()) {
            ModuleFile moduleFile = ArchiveUtil.getModuleFileUsingAltDD((EARFile)archive, resource);
            logger.logp(Level.FINER, className, string, "RETURN module file found using altDD [ {0} ]", moduleFile);
            return moduleFile;
        }
        logger.logp(Level.FINER, className, string, "RETURN module file found [{0}]", archive);
        return (ModuleFile)archive;
    }

    protected static ModuleFile getModuleFileUsingAltDD(EARFile eARFile, Resource resource) {
        if (resource == null) {
            return null;
        }
        String string = resource.getURI().toString();
        Module module = eARFile.getDeploymentDescriptor().getModuleHavingAltDD(string);
        if (module == null) {
            return null;
        }
        ModuleRef moduleRef = eARFile.getModuleRef(module);
        if (moduleRef == null) {
            return null;
        }
        return moduleRef.getModuleFile();
    }

    public static String getModuleFileTypeName(int n) {
        switch (n) {
            case 2: {
                return CommonArchiveResourceHandler.A_Application_file;
            }
            case 1: {
                return CommonArchiveResourceHandler.An_Application_Client_JAR_file;
            }
            case 3: {
                return CommonArchiveResourceHandler.An_EJB_JAR_file;
            }
            case 4: {
                return CommonArchiveResourceHandler.A_WAR_file;
            }
            case 5: {
                return CommonArchiveResourceHandler.A_RAR_file;
            }
        }
        return null;
    }

    public static Archive getArchive(Resource resource) {
        String string = "getArchive";
        logger.entering(className, string, resource);
        if (resource == null) {
            logger.exiting(className, string, "Resource is null.  Returning null.");
            return null;
        }
        ResourceSet resourceSet = resource.getResourceSet();
        if (resourceSet == null) {
            logger.exiting(className, string, "Resource Set is null.  Returning null.");
            return null;
        }
        URIConverter uRIConverter = resourceSet.getURIConverter();
        if (uRIConverter == null || !(uRIConverter instanceof ArchiveURIConverterImpl)) {
            logger.exiting(className, string, "Archive URI Converter not found.  Returning null.");
            return null;
        }
        Archive archive = ((ArchiveURIConverterImpl)uRIConverter).getArchive();
        logger.logp(Level.FINER, className, string, "RETURN archive [{0}]", archive);
        return archive;
    }

    public static String getOSUri(String string) {
        char c = File.separatorChar;
        if (c != '/') {
            return string.replace('/', c);
        }
        return string.replace('\\', c);
    }

    public static String getOSUri(String string, String string2) {
        String string3 = ArchiveUtil.getOSUri(string);
        String string4 = ArchiveUtil.getOSUri(string2);
        return ArchiveUtil.concatUri(string3, string4, File.separatorChar);
    }

    public static EObject getRoot(Resource resource) throws EmptyResourceException {
        EList eList = resource.getContents();
        if (eList.size() < 1) {
            throw new EmptyResourceException(resource.getURI().toString());
        }
        return (EObject)eList.get(0);
    }

    public static File getTempDirectory() {
        return tempDirectory;
    }

    public static String getTempDirectoryName() {
        return tempDirectoryName;
    }

    public static String[] getTokens(String string) {
        return ArchiveUtil.getTokens(string, null);
    }

    public static String[] getTokens(String string, String string2) {
        StringTokenizer stringTokenizer = string2 == null ? new StringTokenizer(string) : new StringTokenizer(string, string2);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n && stringTokenizer.hasMoreTokens(); ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static String getValueIgnoreKeyCase(String string, Attributes attributes) {
        Iterator<Map.Entry<Object, Object>> iterator = attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String string2 = entry.getKey().toString();
            if (!string2.equalsIgnoreCase(string)) continue;
            return entry.getValue() == null ? null : entry.getValue().toString();
        }
        return null;
    }

    public static void inform(String string) {
        logger.logp(Level.FINER, className, "inform", string);
    }

    public static byte[] inputStreamToBytes(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ArchiveUtil.copy(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static boolean isJavaResource(Resource resource) {
        return JavaURL.isJavaURL((String)resource.getURI().toString());
    }

    public static boolean isRegisteredURIMapping(Resource resource) {
        return URIMappingRegistryImpl.INSTANCE.getURI(resource.getURI()) != resource.getURI();
    }

    public static boolean isPlatformMetaResource(Resource resource) {
        URI uRI = resource.getURI();
        return "platform".equals(uRI.scheme()) && "meta".equals(uRI.segment(0));
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static boolean isRuntime() {
        return isRuntime;
    }

    public static boolean isValidDependency(Archive archive, Archive archive2) {
        if (archive.isWARFile()) {
            return false;
        }
        if (archive == archive2) {
            return false;
        }
        return archive2.isApplicationClientFile() || !archive.isApplicationClientFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(Archive archive, String string) throws FileNotFoundException, IOException {
        InputStream inputStream = null;
        try {
            inputStream = archive.getInputStream(string);
            Properties properties = new Properties();
            properties.load(inputStream);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public static void setIsRuntime(boolean bl) {
        isRuntime = bl;
    }

    public static void setShouldUseTempDirectoryForRead(boolean bl) {
        String string = "setShouldUseTempDirectoryForRead";
        logger.logp(Level.FINER, className, string, "Old Value [ {0} ] -- New Value [ {1} ]", new Object[]{new Boolean(shouldUseTempDirectoryForRead), new Boolean(bl)});
        shouldUseTempDirectoryForRead = bl;
    }

    public static void setTempDirectory(File file) {
        String string = "setTempDirectory";
        logger.logp(Level.FINER, className, string, "Old Value [ {0} ] -- New Value [ {1} ]", new Object[]{tempDirectory, file});
        tempDirectory = file;
        tempDirectoryName = file.getAbsolutePath();
        logger.logp(Level.FINER, className, string, "'tempDirectoryName' (absolute path) [ {0} ]", tempDirectoryName);
        if (!tempDirectory.exists()) {
            logger.logp(Level.WARNING, className, string, "Temporary directory [ {0} ] does not exist", tempDirectory);
        } else if (!tempDirectory.isDirectory()) {
            logger.logp(Level.SEVERE, className, string, "Temporary directory [ {0} ] is not a directory", tempDirectory);
        } else {
            logger.logp(Level.FINER, className, string, "Temporary directory verified to exist and is a directory.");
        }
    }

    public static void setTempDirectoryName(String string) throws ArchiveException {
        String string2 = "setTempDirectoryName";
        logger.logp(Level.FINER, className, string2, "ENTER; New name [ {0} ]", string);
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
            if (!file.exists()) {
                logger.logp(Level.WARNING, className, string2, "Failed to create temporary directory.");
                ArchiveException archiveException = new ArchiveException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.make_temp_dir_EXC_, new Object[]{string}));
                logger.throwing(className, string2, archiveException);
                throw archiveException;
            }
            logger.logp(Level.FINER, className, string2, "Verified that the temporary directory exists; marking for deletion.");
            DeleteOnExitUtility.markForDeletion(file);
        }
        ArchiveUtil.setTempDirectory(file);
        logger.logp(Level.FINER, className, string2, "RETURN");
    }

    public static boolean shouldUseTempDirectoryForRead() {
        return shouldUseTempDirectoryForRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static URL[] toLocalURLs(List var0, String var1_1) {
        var2_2 = new ArrayList<Object>();
        for (var3_3 = 0; var3_3 < var0.size(); ++var3_3) {
            block17: {
                var4_5 = (String)var0.get(var3_3);
                var5_6 = new File(var4_5);
                if (!var5_6.isAbsolute()) {
                    var4_5 = ArchiveUtil.getOSUri(var1_1, var4_5);
                    var5_6 = new File(var4_5);
                }
                if (!var5_6.exists()) continue;
                if (var5_6.isDirectory()) {
                    if (!var4_5.endsWith(File.separator)) {
                        var4_5 = var4_5 + File.separatorChar;
                    }
                } else {
                    var6_7 = null;
                    try {
                        ArchiveUtil.aixDisplay("ArchiveUtil.toLocalURLs");
                        var6_7 = new ZipFile(var5_6);
                        var9_10 = null;
                        ** if (var6_7 == null) goto lbl-1000
                    }
                    catch (Throwable var8_12) {
                        var9_10 = null;
                        if (var6_7 != null) {
                            try {
                                var6_7.close();
                            }
                            catch (IOException var10_11) {
                                // empty catch block
                            }
                        }
                        throw var8_12;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            var6_7.close();
                        }
                        catch (IOException var10_11) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block17;
                        catch (Exception var7_9) {
                            ArchiveUtil.inform(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.invalid_classpath_WARN_, new Object[]{var4_5}));
                            var9_10 = null;
                            if (var6_7 == null) continue;
                            try {
                                var6_7.close();
                            }
                            catch (IOException var10_11) {}
                            continue;
                        }
                    }
                }
            }
            try {
                var5_6 = new File(var4_5);
                var6_7 = var5_6.toURL();
                var2_2.add(var6_7);
                continue;
            }
            catch (MalformedURLException var6_8) {
                ArchiveUtil.inform(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.invalid_cp_file_WARN_, new Object[]{var4_5}));
            }
        }
        var3_4 = new URL[var2_2.size()];
        return var2_2.toArray(var3_4);
    }

    public static String truncateFromFrontIgnoreCase(String string, String string2) {
        if (!string.toLowerCase().startsWith(string2.toLowerCase())) {
            return string;
        }
        return string.substring(string2.length(), string.length());
    }

    public static String truncateIgnoreCase(String string, String string2) {
        int n = string.toLowerCase().lastIndexOf(string2.toLowerCase());
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String uriToClassName(String string) {
        return ArchiveUtil.truncateIgnoreCase(string.replace('/', '.'), DOT_CLASS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean isJ2EE13FastCheck(ModuleFile moduleFile) {
        String[] stringArray;
        DocumentType documentType;
        InputStream inputStream;
        block21: {
            block19: {
                if (moduleFile == null) {
                    return false;
                }
                if (moduleFile.isRARFile()) {
                    return true;
                }
                inputStream = null;
                String string = moduleFile.getDeploymentDescriptorUri();
                inputStream = moduleFile.getInputStream(string);
                documentType = XmlDocumentReader.readDocumentType((InputStream)inputStream, (String)string);
                if (documentType != null) break block19;
                boolean bl = false;
                Object var7_8 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return bl;
            }
            stringArray = ArchiveUtil.getJ2EE13PublicAndSystemIdFor(moduleFile);
            if (stringArray != null) break block21;
            boolean bl = false;
            Object var7_9 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return bl;
        }
        boolean bl = stringArray[0].equals(documentType.getPublicId()) && stringArray[1].equals(documentType.getSystemId());
        Object var7_10 = null;
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
        catch (IOException iOException) {
            boolean bl2;
            try {
                bl2 = false;
                Object var7_11 = null;
            }
            catch (Throwable throwable) {
                Object var7_12 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException3) {
                // empty catch block
            }
            return bl2;
        }
    }

    protected static String[] getJ2EE13PublicAndSystemIdFor(ModuleFile moduleFile) {
        if (moduleFile.isEARFile()) {
            return new String[]{"-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN", "http://java.sun.com/dtd/application_1_3.dtd"};
        }
        if (moduleFile.isEJBJarFile()) {
            return new String[]{"-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN", "http://java.sun.com/dtd/ejb-jar_2_0.dtd"};
        }
        if (moduleFile.isApplicationClientFile()) {
            return new String[]{"-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN", "http://java.sun.com/dtd/application-client_1_3.dtd"};
        }
        if (moduleFile.isWARFile()) {
            return new String[]{"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", "http://java.sun.com/dtd/web-app_2_3.dtd"};
        }
        if (moduleFile.isRARFile()) {
            return new String[]{"-//Sun Microsystems, Inc.//DTD Connector 1.0//EN", "http://java.sun.com/dtd/connector_1_0.dtd"};
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFastSpecVersion(ModuleFile moduleFile) {
        int n;
        Object object;
        Object object2;
        String string = "getFastSpecVersion";
        logger.entering(className, string, moduleFile.getURI());
        InputStream inputStream = null;
        String string2 = moduleFile.getDeploymentDescriptorUri();
        LoadStrategy loadStrategy = moduleFile.getLoadStrategy();
        if (loadStrategy instanceof LoadStrategyImpl) {
            try {
                object2 = ((LoadStrategyImpl)loadStrategy).getResourcesPath();
                logger.logp(Level.FINER, className, string, "Resource path [ {0} ]", object2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.logp(Level.FINER, className, string, "Failed to obtain resources path.");
                object2 = null;
            }
            if (object2 != null) {
                object = (String)object2 + "/" + string2;
                logger.logp(Level.FINER, className, string, "Descriptor path [ {0} ]", object);
                try {
                    inputStream = new FileInputStream((String)object);
                    logger.logp(Level.FINER, className, string, "Obtained resource based input stream");
                }
                catch (IOException iOException) {
                    logger.logp(Level.FINER, className, string, "Unable to open resource based input stream.");
                }
            }
        } else {
            logger.logp(Level.FINER, className, string, "Unknown load strategy type [ {0} ]", loadStrategy.getClass().getName());
        }
        if (inputStream == null) {
            try {
                inputStream = moduleFile.getInputStream(string2);
                logger.logp(Level.FINER, className, string, "Obtained a binaries based input stream");
            }
            catch (IOException iOException) {
                logger.logp(Level.FINER, className, string, "Failed to open binaries based input stream");
                logger.exiting(className, string, new Integer(-1));
                return -1;
            }
        }
        try {
            String string3;
            String string4;
            object2 = null;
            object = new InputSource(inputStream);
            XmlDocumentReader xmlDocumentReader = new XmlDocumentReader((InputSource)object);
            xmlDocumentReader.setValidate(false);
            Document document = xmlDocumentReader.parseDocument();
            if (document != null) {
                object2 = document.getDoctype();
            }
            int n2 = -1;
            if (null != object2) {
                string4 = object2.getPublicId();
                string3 = object2.getSystemId();
                if (string4 != null && string3 != null) {
                    n2 = ArchiveUtil.lookupVersion(moduleFile, string4, string3);
                }
            }
            if (n2 == -1) {
                NamedNodeMap namedNodeMap;
                string4 = null;
                string3 = null;
                if (document != null && null == object2 && null != (namedNodeMap = document.getDocumentElement().getAttributes())) {
                    Node node;
                    Node node2 = namedNodeMap.getNamedItem("xsi:schemaLocation");
                    if (null != node2) {
                        string4 = node2.getNodeValue();
                    }
                    if (null != (node = namedNodeMap.getNamedItem("version"))) {
                        string3 = node.getNodeValue();
                    }
                }
                if (null != string4) {
                    n2 = ArchiveUtil.lookupVersion(moduleFile, string4);
                }
                if (n2 == -1) {
                    n2 = ArchiveUtil.parseVersionString(moduleFile, string3);
                }
            }
            logger.exiting(className, string, new Integer(n2));
            n = n2;
            Object var16_19 = null;
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return n;
    }

    private static int parseVersionString(ModuleFile moduleFile, String string) {
        int n = -1;
        if (moduleFile.isEARFile()) {
            if (null == string) {
                n = 14;
            } else if (string.equals("1.2")) {
                n = 12;
            } else if (string.equals("1.3")) {
                n = 13;
            } else if (string.equals("1.4")) {
                n = 14;
            } else if (string.equals("5")) {
                n = 50;
            }
        } else if (moduleFile.isEJBJarFile()) {
            if (null == string) {
                n = 21;
            } else if (string.equals("1.1")) {
                n = 11;
            } else if (string.equals("2.0")) {
                n = 20;
            } else if (string.equals("2.1")) {
                n = 21;
            } else if (string.equals("3.0")) {
                n = 30;
            }
        } else if (moduleFile.isApplicationClientFile()) {
            if (null == string) {
                n = 14;
            } else if (string.equals("1.2")) {
                n = 12;
            } else if (string.equals("1.3")) {
                n = 13;
            } else if (string.equals("1.4")) {
                n = 14;
            } else if (string.equals("5")) {
                n = 50;
            }
        } else if (moduleFile.isWARFile()) {
            if (null == string) {
                n = 24;
            } else if (string.equals("2.2")) {
                n = 22;
            } else if (string.equals("2.3")) {
                n = 23;
            } else if (string.equals("2.4")) {
                n = 24;
            } else if (string.equals("2.5")) {
                n = 25;
            }
        } else if (moduleFile.isRARFile()) {
            n = null == string ? 15 : (string.equals("1.0") ? 10 : 15);
        }
        return n;
    }

    private static int lookupVersion(ModuleFile moduleFile, String string) {
        int n = -1;
        if (moduleFile.isEARFile()) {
            if (string.equals("http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/application_5.xsd")) {
                n = 50;
            } else if (string.equals("http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/application_1_4.xsd")) {
                n = 14;
            }
        } else if (moduleFile.isEJBJarFile()) {
            if (string.indexOf("http://java.sun.com/xml/ns/javaee/ejb-jar_3_0.xsd") != -1) {
                n = 30;
            } else if (string.indexOf("http://java.sun.com/xml/ns/j2ee/ejb-jar_2_1.xsd") != -1) {
                n = 21;
            }
        } else if (moduleFile.isApplicationClientFile()) {
            if (string.equals("http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/application-client_5.xsd")) {
                n = 50;
            } else if (string.equals("http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/application-client_1_4.xsd")) {
                n = 14;
            }
        } else if (moduleFile.isWARFile()) {
            if (string.equals("http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd")) {
                n = 25;
            } else if (string.equals("http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd")) {
                n = 24;
            }
        } else if (moduleFile.isRARFile() && string.equals("http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/connector_1_5.xsd")) {
            n = 15;
        }
        return n;
    }

    private static int lookupVersion(ModuleFile moduleFile, String string, String string2) {
        int n = -1;
        if (moduleFile.isEARFile()) {
            if (string.equals("-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN") && (string2.equals("http://java.sun.com/dtd/application_1_3.dtd") || string2.equals("http://java.sun.com/dtd/application_1.3.dtd"))) {
                n = 13;
            } else if (string.equals("-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN") && (string2.equals("http://java.sun.com/j2ee/dtds/application_1_2.dtd") || string2.equals("http://java.sun.com/j2ee/dtds/application_1.2.dtd"))) {
                n = 12;
            } else if (string.equals("-//Sun Microsystems, Inc.//DTD J2EE Application 1.4//EN") && (string2.equals("http://java.sun.com/dtd/application_1_4.dtd") || string2.equals("http://java.sun.com/dtd/application_1_4.dtd"))) {
                n = 14;
            }
        } else if (moduleFile.isEJBJarFile()) {
            n = string.equals("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN") && (string2.equals("http://java.sun.com/dtd/ejb-jar_2_0.dtd") || string2.equals("http://java.sun.com/dtd/ejb-jar_2.0.dtd")) ? 20 : (string.equals("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN") && (string2.equals("http://java.sun.com/j2ee/dtds/ejb-jar_1_1.dtd") || string2.equals("http://java.sun.com/j2ee/dtds/ejb-jar_1.1.dtd")) ? 11 : 21);
        } else if (moduleFile.isApplicationClientFile()) {
            n = string.equals("-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN") && (string2.equals("http://java.sun.com/dtd/application-client_1_3.dtd") || string2.equals("http://java.sun.com/dtd/application-client_1.3.dtd")) ? 13 : (string.equals("-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.2//EN") && (string2.equals("http://java.sun.com/j2ee/dtds/application-client_1_2.dtd") || string2.equals("http://java.sun.com/j2ee/dtds/application-client_1.2.dtd")) ? 12 : 14);
        } else if (moduleFile.isWARFile()) {
            n = string.equals("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN") && (string2.equals("http://java.sun.com/dtd/web-app_2_3.dtd") || string2.equals("http://java.sun.com/dtd/web-app_2.3.dtd")) ? 23 : (string.equals("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN") && (string2.equals("http://java.sun.com/j2ee/dtds/web-app_2_2.dtd") || string2.equals("http://java.sun.com/j2ee/dtds/web-app_2.2.dtd")) ? 22 : 24);
        } else if (moduleFile.isRARFile()) {
            n = string.equals("-//Sun Microsystems, Inc.//DTD Connector 1.0//EN") && (string2.equals("http://java.sun.com/dtd/connector_1_0.dtd") || string2.equals("http://java.sun.com/dtd/connector_1.0.dtd")) ? 10 : 15;
        }
        return n;
    }

    protected static void aixDisplay(String string) {
        if (ArchiveUtil.getIsAIX()) {
            System.out.println(string);
        }
    }

    protected static boolean getIsAIX() {
        return isAIX;
    }

    public static void dumpStackTrace(String string, String string2) {
        if (!logger.isLoggable(Level.FINER)) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("Stack trace of " + string2 + " caller:\n\n");
        Throwable throwable = new Throwable();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            stringBuffer.append("                                                              ").append(stackTraceElementArray[i] + "\n");
        }
        logger.logp(Level.FINER, string, string2, stringBuffer.toString());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string = System.getProperty("os.name");
        isAIX = string != null && string.equalsIgnoreCase("AIX");
    }
}

