/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveRuntimeException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseConfigRegister;

public class ArchiveFileDynamicClassLoader
extends ClassLoader {
    protected static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    private static String className = (class$org$eclipse$jst$j2ee$commonarchivecore$internal$util$ArchiveFileDynamicClassLoader == null ? (class$org$eclipse$jst$j2ee$commonarchivecore$internal$util$ArchiveFileDynamicClassLoader = ArchiveFileDynamicClassLoader.class$("org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveFileDynamicClassLoader")) : class$org$eclipse$jst$j2ee$commonarchivecore$internal$util$ArchiveFileDynamicClassLoader).getName();
    protected Archive archive = null;
    protected ClassLoader extraClassLoader;
    protected boolean inEARFile;
    private static final String URL_PROTOCOL = "archive";
    private ArchiveURLStreamHandler handler;
    protected ProtectionDomain protectionDomain;
    protected static final int CLASS_TYPE = 0;
    protected static final int FILE_TYPE = 1;
    static /* synthetic */ Class class$org$eclipse$jst$j2ee$commonarchivecore$internal$util$ArchiveFileDynamicClassLoader;

    public ProtectionDomain setProtectionDomain(ProtectionDomain protectionDomain) {
        ProtectionDomain protectionDomain2 = this.protectionDomain;
        this.protectionDomain = protectionDomain;
        return protectionDomain2;
    }

    public ProtectionDomain getProtectionDomain() {
        return this.protectionDomain;
    }

    public ArchiveFileDynamicClassLoader(Archive archive, ClassLoader classLoader, ClassLoader classLoader2, ProtectionDomain protectionDomain) {
        super(classLoader);
        this.setArchive(archive);
        this.setExtraClassLoader(classLoader2);
        this.inEARFile = archive.getContainer() != null && archive.getContainer().isEARFile();
        this.handler = new ArchiveURLStreamHandler();
        this.protectionDomain = protectionDomain;
    }

    public ArchiveFileDynamicClassLoader(Archive archive, ClassLoader classLoader, ClassLoader classLoader2) {
        this(archive, classLoader, classLoader2, null);
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        Class<?> clazz;
        byte[] byArray = this.getClassBytesFor(string);
        if (byArray != null) {
            clazz = this.protectionDomain == null ? this.defineClass(string, byArray, 0, byArray.length) : this.defineClass(string, byArray, 0, byArray.length, this.protectionDomain);
            if (clazz == null) {
                throw new ClassNotFoundException(string);
            }
        } else {
            throw new ClassNotFoundException(string);
        }
        return clazz;
    }

    public Archive getArchive() {
        return this.archive;
    }

    private byte[] getData(File file) {
        if (null != file) {
            try {
                return ArchiveUtil.inputStreamToBytes(file.getInputStream());
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
            catch (IOException iOException) {
                throw new ArchiveRuntimeException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.io_ex_loading_EXC_, new Object[]{file.getName()}), iOException);
            }
        }
        return null;
    }

    protected byte[] getClassBytesFor(String string) {
        if (string == null) {
            return null;
        }
        String string2 = ArchiveUtil.classNameToUri(string);
        return this.getData(this.getFile(string2));
    }

    protected EARFile getEARFile() {
        return (EARFile)this.getArchive().getContainer();
    }

    public ClassLoader getExtraClassLoader() {
        return this.extraClassLoader;
    }

    protected synchronized Class loadClass(String string, Set set) throws ClassNotFoundException {
        if (set.contains(this.getArchive())) {
            throw new ClassNotFoundException(string);
        }
        set.add(this.getArchive());
        try {
            return super.loadClass(string, false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return this.loadClassInDependentJarInEAR(string, set);
        }
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        try {
            return super.loadClass(string, bl);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class clazz = this.loadClassInDependentJar(string);
            if (clazz != null && bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
    }

    protected Class loadClassInDependentJar(String string) throws ClassNotFoundException {
        if (this.inEARFile) {
            return this.loadClassInDependentJarInEAR(string);
        }
        if (this.getExtraClassLoader() != null) {
            return this.getExtraClassLoader().loadClass(string);
        }
        throw new ClassNotFoundException(string);
    }

    protected Class loadClassInDependentJarInEAR(String string, Set set) throws ClassNotFoundException {
        Object object = this.getResourceInDependentJarInEAR(string, set, 0);
        if (object == null) {
            throw new ClassNotFoundException(string);
        }
        return (Class)object;
    }

    protected Class loadClassInDependentJarInEAR(String string) throws ClassNotFoundException {
        Object object = this.getResourceInDependentJarInEAR(string, 0);
        if (object == null) {
            throw new ClassNotFoundException(string);
        }
        return (Class)object;
    }

    protected File getFileFromDependentJar(String string) {
        Object object = this.getResourceInDependentJarInEAR(string, 1);
        if (object != null) {
            return (File)object;
        }
        return null;
    }

    protected Object getResourceInDependentJarInEAR(String string, int n) {
        String string2 = "getResourceInDependentJarInEAR";
        logger.entering(className, string2);
        HashSet<Archive> hashSet = new HashSet<Archive>(5);
        hashSet.add(this.getArchive());
        Object object = this.getResourceInDependentJarInEAR(string, hashSet, n);
        logger.exiting(className, string2, object);
        return object;
    }

    protected String getLibName(EARFile eARFile) {
        String string;
        String string2 = "getLibName";
        logger.entering(className, string2);
        Application application = eARFile.getDeploymentDescriptor();
        if (application == null) {
            string = "lib";
        } else if (application.getJ2EEVersionID() < 50) {
            string = null;
        } else if (!application.isSetLibraryDirectory()) {
            string = "lib";
        } else {
            string = application.getLibraryDirectory();
            if (string.equals("")) {
                string = null;
            }
        }
        logger.exiting(className, string2, string);
        return string;
    }

    protected Object getResourceInDependentJarInEAR(String string, Set set, int n) {
        Object object;
        String string2 = "getResourceInDependentJarInEAR";
        logger.entering(className, string2);
        EARFile eARFile = this.getEARFile();
        if (eARFile == null) {
            logger.exiting(className, string2, "EARFile not found. Returning null");
            return null;
        }
        String[] stringArray = this.archive.getManifest().getClassPathTokenized();
        Object object2 = this.getResourceInDependentJarInEAR(string, set, n, eARFile, stringArray);
        if (object2 != null || n != 0) {
            logger.logp(Level.FINER, className, string2, "RETURN Returning non-classtype target [ {0} ] ", object2);
            return object2;
        }
        String string3 = this.getLibName(eARFile);
        if (string3 == null) {
            logger.exiting(className, string2, "No libName, returning null");
            return null;
        }
        Iterator iterator = eARFile.filterFilesByPrefix(string3).iterator();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (file.isDirectoryEntry() || !((String)(object = file.getURI())).endsWith(".jar")) continue;
            arrayList.add(object);
        }
        int n2 = arrayList.size();
        if (n2 > 0) {
            object = new String[n2];
            int n3 = 0;
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                object[n3++] = (String)iterator2.next();
            }
            object2 = this.getResourceInDependentJarInEAR(string, set, n, eARFile, (String[])object);
        }
        logger.logp(Level.FINER, className, string2, "RETURN Returning target [ {0} ] ", object2);
        return object2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object getResourceInDependentJarInEAR(String var1_1, Set var2_2, int var3_3, EARFile var4_4, String[] var5_5) {
        var6_6 = "getResourceInDependentJarInEAR";
        ArchiveFileDynamicClassLoader.logger.logp(Level.FINER, ArchiveFileDynamicClassLoader.className, var6_6, "ENTRY Get resource named [ {0} ] ", var1_1);
        var7_7 = null;
        var8_8 = 0;
        while (true) {
            block16: {
                if (var8_8 >= var5_5.length) {
                    ArchiveFileDynamicClassLoader.logger.exiting(ArchiveFileDynamicClassLoader.className, var6_6, "Returning null");
                    return null;
                }
                var7_7 = var5_5[var8_8];
                ArchiveFileDynamicClassLoader.logger.logp(Level.FINER, ArchiveFileDynamicClassLoader.className, var6_6, "Classpath [ {0} ]", var7_7);
                if (ArchiveFileDynamicClassLoader.logger.isLoggable(Level.FINEST)) {
                    if (LooseConfigRegister.singleton().findLooseApplication(var4_4.getURI()) != null) {
                        var9_9 = ArchiveUtil.deriveEARRelativeURI(var7_7, var4_4);
                        ArchiveFileDynamicClassLoader.logger.logp(Level.FINER, ArchiveFileDynamicClassLoader.className, var6_6, "Derived URI Classpath [ {0} ]", var9_9);
                    } else {
                        ArchiveFileDynamicClassLoader.logger.logp(Level.FINER, ArchiveFileDynamicClassLoader.className, var6_6, "EAR is not loose");
                    }
                }
                if (var7_7 == null || !(var9_9 = var4_4.getFile(var7_7)).isArchive()) break block16;
                var10_11 = (Archive)var9_9;
                switch (var3_3) {
                    case 0: {
                        try {
                            var11_12 = ((ArchiveFileDynamicClassLoader)var10_11.getArchiveClassLoader()).loadClass(var1_1, var2_2);
                            ArchiveFileDynamicClassLoader.logger.logp(Level.FINER, ArchiveFileDynamicClassLoader.className, var6_6, "RETURN Returning class [ {0} ] ", var11_12);
                            return var11_12;
                        }
                        catch (ClassNotFoundException var11_13) {
                            ArchiveFileDynamicClassLoader.logger.logp(Level.FINER, ArchiveFileDynamicClassLoader.className, var6_6, "Class [ {0} ] not found", var1_1);
                            ** break;
                        }
                    }
                    case 1: {
                        ** GOTO lbl-1000
                    }
                    default: {
                    }
                }
                {
                    catch (FileNotFoundException var9_10) {
                        ArchiveFileDynamicClassLoader.logger.logp(Level.FINER, ArchiveFileDynamicClassLoader.className, var6_6, "[ {0} ] file not found in EAR", var7_7);
                    }
                }
                break block16;
lbl-1000:
                // 1 sources

                {
                    try {
                        var11_12 = var10_11.getFile(var1_1);
                        ArchiveFileDynamicClassLoader.logger.logp(Level.FINER, ArchiveFileDynamicClassLoader.className, var6_6, "RETURN Returning file [ {0} ] ", var11_12);
                        return var11_12;
                    }
                    catch (FileNotFoundException var11_14) {}
                    {
                        ArchiveFileDynamicClassLoader.logger.logp(Level.FINER, ArchiveFileDynamicClassLoader.className, var6_6, "[ {0} ] file not found", var1_1);
                        ** break;
                    }
                }
            }
            ++var8_8;
        }
    }

    public void setArchive(Archive archive) {
        this.archive = archive;
    }

    public void setExtraClassLoader(ClassLoader classLoader) {
        this.extraClassLoader = classLoader;
    }

    public InputStream getResourceAsStream(String string) {
        try {
            File file = this.getFile(string);
            if (null != file) {
                return file.getInputStream();
            }
        }
        catch (IOException iOException) {
            throw new ArchiveRuntimeException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.io_ex_loading_EXC_, new Object[]{string}), iOException);
        }
        return null;
    }

    protected File getFileFromArchive(String string) {
        try {
            return this.getArchive().getFile(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    protected File getFile(String string) {
        File file = this.getFileFromArchive(string);
        if (file == null) {
            file = this.getFileFromDependentJar(string);
        }
        return file;
    }

    protected URL findResource(String string) {
        if (this.getFile(string) != null) {
            try {
                return new URL(null, "archive://" + string, this.handler);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                throw new RuntimeException(malformedURLException);
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ArchiveURLConnection
    extends URLConnection {
        private String resourceName;

        protected ArchiveURLConnection(URL uRL) {
            super(uRL);
            this.resourceName = uRL.toString().substring(ArchiveFileDynamicClassLoader.URL_PROTOCOL.length() + 3);
        }

        public void connect() throws IOException {
        }

        public InputStream getInputStream() throws IOException {
            return ArchiveFileDynamicClassLoader.this.getResourceAsStream(this.resourceName);
        }
    }

    private class ArchiveURLStreamHandler
    extends URLStreamHandler {
        protected URLConnection openConnection(URL uRL) throws IOException {
            return new ArchiveURLConnection(uRL);
        }
    }
}

