/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.wst.common.internal.emf.resource.CompatibilityURIConverter;

public class ZipStreamSaveStrategyImpl
extends SaveStrategyImpl
implements SaveStrategy {
    public static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    public static final String className = (class$org$eclipse$jst$j2ee$commonarchivecore$internal$strategy$ZipStreamSaveStrategyImpl == null ? (class$org$eclipse$jst$j2ee$commonarchivecore$internal$strategy$ZipStreamSaveStrategyImpl = ZipStreamSaveStrategyImpl.class$("org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ZipStreamSaveStrategyImpl")) : class$org$eclipse$jst$j2ee$commonarchivecore$internal$strategy$ZipStreamSaveStrategyImpl).getName();
    protected OutputStream destinationStream;
    protected ZipOutputStream zipOutputStream;
    protected HashSet priorParentNames;
    static /* synthetic */ Class class$org$eclipse$jst$j2ee$commonarchivecore$internal$strategy$ZipStreamSaveStrategyImpl;

    public ZipStreamSaveStrategyImpl(OutputStream outputStream) {
        String string = "ZipStreamSaveStrategyImpl";
        this.setDestinationStream(outputStream);
        this.setZipOutputStream(new ZipOutputStream(outputStream));
        this.initPriorParentNames();
        logger.logp(Level.FINER, className, string, "ENTRY/RETURN: ZipStreamSaveStrategyImpl(OutputStream) [ {0} ]", this);
    }

    public void close() throws IOException {
        String string = "close";
        logger.logp(Level.FINER, className, string, "ENTRY [ {0} ]", this);
        this.getDestinationStream().close();
        logger.logp(Level.FINER, className, string, "RETURN");
    }

    protected SaveStrategy createNestedSaveStrategy(Archive archive) {
        return new ZipStreamSaveStrategyImpl(this.getZipOutputStream());
    }

    public void finish() throws IOException {
        String string = "finish";
        logger.logp(Level.FINER, className, string, "ENTRY [ {0} ]", this);
        this.getZipOutputStream().finish();
        if (!(this.getDestinationStream() instanceof ZipOutputStream)) {
            logger.logp(Level.FINER, className, string, "Not a zip stream; closing destination stream");
            this.getDestinationStream().close();
        } else {
            logger.logp(Level.FINER, className, string, "Zip stream; skipping close of destination stream");
        }
        logger.logp(Level.FINER, className, string, "RETURN");
    }

    public OutputStream getDestinationStream() {
        return this.destinationStream;
    }

    protected OutputStream getOutputStreamForResource(Resource resource) throws IOException {
        return this.getZipOutputStream();
    }

    public void saveMofResource(Resource resource, OutputStream outputStream) throws IOException {
        URIConverter uRIConverter;
        String string = "saveMofResource";
        URI uRI = resource.getURI();
        String string2 = uRI.toString();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, string, "ENTRY [ {0} ] Resource [ {1} ]", new Object[]{this, string2});
        }
        if ((uRIConverter = this.getArchive().getResourceSet().getURIConverter()) instanceof CompatibilityURIConverter) {
            uRI = ((CompatibilityURIConverter)uRIConverter).deNormalize(uRI);
            string2 = uRI.toString();
            logger.logp(Level.FINER, className, string, "Updated URI to [ {0} ]", string2);
        }
        this.putParentEntries(string2);
        ZipEntry zipEntry = new ZipEntry(string2);
        this.prepareEntry(zipEntry);
        super.saveMofResource(resource, outputStream);
        this.completeEntry(zipEntry);
        logger.logp(Level.FINER, className, string, "RETURN");
    }

    protected ZipOutputStream getZipOutputStream() {
        return this.zipOutputStream;
    }

    public void save(ArchiveManifest archiveManifest) throws SaveFailureException {
        String string = "save(ArchiveManifest)";
        String string2 = "META-INF/MANIFEST.MF";
        logger.logp(Level.FINER, className, string, "ENTRY Entry Name [ {0} ]", string2);
        try {
            this.putParentEntries(string2);
            ZipEntry zipEntry = new ZipEntry(string2);
            this.prepareEntry(zipEntry);
            archiveManifest.write(this.getZipOutputStream());
            this.completeEntry(zipEntry);
        }
        catch (IOException iOException) {
            logger.throwing(className, string, iOException);
            throw new SaveFailureException("META-INF/MANIFEST.MF", iOException);
        }
        logger.logp(Level.FINER, className, string, "RETURN");
    }

    public void save(Archive archive) throws SaveFailureException {
        String string = "save(Archive)";
        String string2 = archive.getURI();
        logger.logp(Level.FINER, className, string, "ENTRY Entry Name [ {0} ]", string2);
        try {
            this.putParentEntries(string2);
            ZipEntry zipEntry = new ZipEntry(string2);
            this.prepareEntry(zipEntry);
            super.save(archive);
            this.completeEntry(zipEntry);
        }
        catch (IOException iOException) {
            logger.throwing(className, string, iOException);
            throw new SaveFailureException(string2, iOException);
        }
        logger.logp(Level.FINER, className, string, "RETURN");
    }

    public void save(File file, InputStream inputStream) throws SaveFailureException {
        String string = "save(File, InputStream)";
        String string2 = file.getURI();
        if (file.isDirectoryEntry() && !string2.endsWith("/")) {
            string2 = string2 + '/';
        }
        if (file.isDirectoryEntry() && !this.testAddParentName(string2)) {
            logger.logp(Level.FINER, className, string, "ENTRY/RETURN Entry Name [ {0} ] - Already added as a directory", string2);
            return;
        }
        logger.logp(Level.FINER, className, string, "ENTRY Entry Name [ {0} ]", string2);
        long l = file.getLastModified();
        try {
            this.putParentEntries(string2);
            ZipEntry zipEntry = new ZipEntry(string2);
            if (l > 0L) {
                zipEntry.setTime(l);
            }
            this.prepareEntry(zipEntry);
            if (!file.isDirectoryEntry()) {
                ArchiveUtil.copy(inputStream, this.getZipOutputStream());
            }
            this.completeEntry(zipEntry);
        }
        catch (IOException iOException) {
            logger.throwing(className, string, iOException);
            throw new SaveFailureException(file.getURI(), iOException);
        }
        logger.logp(Level.FINER, className, string, "RETURN");
    }

    public void setDestinationStream(OutputStream outputStream) {
        this.destinationStream = outputStream;
    }

    protected void setZipOutputStream(ZipOutputStream zipOutputStream) {
        this.zipOutputStream = zipOutputStream;
    }

    protected void putParentEntries(String string) throws IOException {
        List list = this.getParentNames(string);
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!this.testAddParentName(string2)) continue;
            this.addDirectoryEntry(string2);
        }
    }

    protected List getParentNames(String string) {
        String string2 = "getParentEntries";
        ArrayList<String> arrayList = null;
        int n = string.length() - 1;
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) != '/') continue;
            String string3 = string.substring(0, i + 1);
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(string3);
        }
        logger.logp(Level.FINER, className, string2, "Entry Name [ " + string + " ] RETURN [ " + arrayList + " ]");
        return arrayList;
    }

    protected void initPriorParentNames() {
        this.priorParentNames = new HashSet();
    }

    protected boolean testAddParentName(String string) {
        return this.priorParentNames.add(string);
    }

    protected void addDirectoryEntry(String string) throws IOException {
        String string2 = "addDirectoryEntry";
        logger.logp(Level.FINER, className, string2, "Entry Name [ {0} ]", string);
        ZipEntry zipEntry = new ZipEntry(string);
        this.prepareEntry(zipEntry);
        this.completeEntry(zipEntry);
    }

    protected void prepareEntry(ZipEntry zipEntry) throws IOException {
        this.getZipOutputStream().putNextEntry(zipEntry);
    }

    protected void completeEntry(ZipEntry zipEntry) throws IOException {
        this.getZipOutputStream().closeEntry();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

