/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.LifeCycleTracker;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.LifeCycleTrackerElement;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategyImpl;

public class ZipFileLoadStrategyImpl
extends LoadStrategyImpl {
    protected static boolean TRACK_ZIPFILE_ACCESS = true;
    protected static boolean ZIPFILE_OPEN = true;
    protected static final String OPEN_STRING = "ZIPFILE OPEN ";
    protected static final String CLOSE_STRING = "ZIPFILE CLOSE";
    protected static String className = (class$org$eclipse$jst$j2ee$commonarchivecore$internal$strategy$ZipFileLoadStrategyImpl == null ? (class$org$eclipse$jst$j2ee$commonarchivecore$internal$strategy$ZipFileLoadStrategyImpl = ZipFileLoadStrategyImpl.class$("org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ZipFileLoadStrategyImpl")) : class$org$eclipse$jst$j2ee$commonarchivecore$internal$strategy$ZipFileLoadStrategyImpl).getName();
    protected static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    protected static Logger loggerLCT = Logger.getLogger("com.ibm.config.eclipse.wtp.lct");
    protected java.io.File _file = null;
    protected ZipFile _zipFile = null;
    private StackTraceElement[] _createStack = null;
    private StackTraceElement[] _openStack = null;
    private StackTraceElement[] _closeStack = null;
    private String _createTime = null;
    private String _openTime = null;
    private String _closeTime = null;
    protected String _hash;
    public static final LifeCycleTracker lct = new LifeCycleTracker(loggerLCT);
    protected static final DateFormat stampFormat = new SimpleDateFormat("M/dd/yy HH:mm:ss:SSS z");
    static /* synthetic */ Class class$org$eclipse$jst$j2ee$commonarchivecore$internal$strategy$ZipFileLoadStrategyImpl;

    protected static String getTimeStamp() {
        return stampFormat.format(Calendar.getInstance().getTime());
    }

    public ZipFileLoadStrategyImpl() {
        String string = "constructor without file";
        logger.logp(Level.FINER, className, string, "ENTRY/RETURN [ {0} ]", this);
        if (loggerLCT.isLoggable(Level.FINER)) {
            this._createTime = ZipFileLoadStrategyImpl.getTimeStamp();
            this._createStack = this.stackTrace();
        }
    }

    private StackTraceElement[] stackTrace() {
        try {
            throw new Throwable();
        }
        catch (Throwable throwable) {
            return throwable.getStackTrace();
        }
    }

    public ZipFileLoadStrategyImpl(java.io.File file) throws IOException {
        String string = "constructor with file";
        logger.logp(Level.FINER, className, string, "ENTRY [ {0} ]", this);
        if (logger.isLoggable(Level.FINER)) {
            this._createTime = ZipFileLoadStrategyImpl.getTimeStamp();
            this._createStack = this.stackTrace();
        }
        this.setFile(file);
        this.setZipFile(new ZipFile(file));
        this.closeZipFile(!TRACK_ZIPFILE_ACCESS);
        logger.logp(Level.FINER, className, string, "RETURN [ {0} ]", this);
    }

    protected void finalize() throws Throwable {
        String string = "finalize";
        logger.logp(Level.FINER, className, string, "ENTRY [ {0} ]", this);
        super.finalize();
        if (logger.isLoggable(Level.FINEST)) {
            this.describeFile(string, Level.FINEST, "", this._file);
        }
        logger.logp(Level.FINER, className, string, "RETURN [ {0} ]", this);
    }

    public void closeZipFile() throws IOException {
        this.closeZipFile(TRACK_ZIPFILE_ACCESS);
    }

    public void closeZipFile(boolean bl) throws IOException {
        String string = "closeZipFile";
        logger.logp(Level.FINER, className, string, "ENTRY [ {0} ]", this);
        ZipFile zipFile = this._zipFile;
        if (zipFile != null) {
            logger.logp(Level.FINER, className, string, "Closing zip file [ {0} ]", zipFile.getName());
            if (bl) {
                this.trackZipFileAccess(!ZIPFILE_OPEN);
            }
            this.setZipFile(null);
            zipFile.close();
        } else {
            logger.logp(Level.FINER, className, string, "The zip file was already closed.");
        }
        logger.logp(Level.FINER, className, string, "RETURN [ {0} ]", this);
    }

    public void close() {
        String string = "close";
        logger.logp(Level.FINER, className, string, "ENTRY [ {0} ]", this);
        if (logger.isLoggable(Level.FINEST)) {
            this.describeFile(string, Level.FINEST, "", this._file);
        }
        super.close();
        try {
            this.closeZipFile();
        }
        catch (IOException iOException) {
            logger.logp(Level.FINEST, className, string, "Ignoring Throwable exception from zipfile close [ {0} ]", iOException);
        }
        logger.logp(Level.FINER, className, string, "RETURN [ {0} ]", this);
    }

    protected boolean primContains(String string) {
        return this.getZipFile().getEntry(string) != null;
    }

    public String getAbsolutePath() throws FileNotFoundException {
        return this.getFile().getAbsolutePath();
    }

    public java.io.File getFile() {
        return this._file;
    }

    public List getFiles() {
        String string = "getFiles";
        logger.entering(className, string);
        ArrayList<File> arrayList = new ArrayList<File>();
        Enumeration<? extends ZipEntry> enumeration = this.getZipFile().entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || this.collectedLooseArchiveFiles.containsKey(zipEntry.getName())) continue;
            File file = this.createFile(zipEntry.getName());
            file.setSize(zipEntry.getSize());
            file.setLastModified(zipEntry.getTime());
            arrayList.add(file);
        }
        try {
            this.closeZipFile();
        }
        catch (IOException iOException) {
            logger.logp(Level.FINER, className, string, "Ignoring IOException when closing zipfile");
        }
        logger.exiting(className, string, arrayList);
        return arrayList;
    }

    public InputStream getInputStream(String string) throws IOException, FileNotFoundException {
        String string2 = "getInputStream";
        logger.logp(Level.FINER, className, string2, "ENTRY uri [ {0} ]", string);
        try {
            ZipFile zipFile = this.getZipFile();
            ZipEntry zipEntry = zipFile.getEntry(string);
            if (zipEntry == null) {
                logger.logp(Level.FINER, className, string2, "RETURN Throwing FileNotFoundException");
                throw new FileNotFoundException(string);
            }
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            logger.logp(Level.FINER, className, string2, "RETURN input stream [ {0} ]", inputStream);
            return new BufferedInputStream(inputStream);
        }
        catch (IllegalStateException illegalStateException) {
            if (loggerLCT.isLoggable(Level.FINER)) {
                loggerLCT.logp(Level.SEVERE, className, string2, this.dumpStack("Create Stack", this._createTime, this._createStack));
                loggerLCT.logp(Level.SEVERE, className, string2, this.dumpStack("Open Stack", this._openTime, this._openStack));
                loggerLCT.logp(Level.SEVERE, className, string2, this.dumpStack("Close Stack", this._closeTime, this._closeStack));
            }
            logger.logp(Level.FINER, className, string2, "RETURN Throwing IOException - zip file closed");
            throw new IOException(illegalStateException.toString());
        }
    }

    public ZipFile getZipFile() {
        java.io.File file = this.getFile();
        String string = "getZipFile";
        logger.logp(Level.FINER, className, string, "ENTRY file [ {0} ]", file);
        if (logger.isLoggable(Level.FINEST)) {
            this.describeFile(string, Level.FINEST, "", file);
        }
        if (file == null) {
            logger.logp(Level.FINER, className, string, "No file is set; null will be returned.");
        } else if (this._zipFile != null) {
            logger.logp(Level.FINER, className, string, "The zip file is already opened; will answer the existing zip file.");
        } else {
            try {
                logger.logp(Level.FINER, className, string, "Opening zip file [ {0} ]", this._file.getName());
                this._zipFile = new ZipFile(file);
                this.trackZipFileAccess(ZIPFILE_OPEN);
            }
            catch (ZipException zipException) {
                logger.logp(Level.FINER, className, string, "Ignoring ZipException [ {0} ] ", zipException);
                logger.logp(Level.FINER, className, string, "An exception occurred while attempting to open the zipfile; null will be returned.");
            }
            catch (IOException iOException) {
                logger.logp(Level.FINER, className, string, "Ignoring IOException [ {0} ] ", iOException);
                logger.logp(Level.FINER, className, string, "An exception occurred while attempting to open the zipfile; null will be returned.");
            }
        }
        logger.logp(Level.FINER, className, string, "RETURN [ {0} ]", this._zipFile);
        return this._zipFile;
    }

    public boolean isUsing(java.io.File file) {
        String string = "isUsing";
        logger.logp(Level.FINER, className, string, "ENTRY file [ {0} ]", file);
        boolean bl = false;
        java.io.File file2 = this.getFile();
        if (file2 != null && file2.equals(file)) {
            bl = true;
        }
        logger.logp(Level.FINER, className, string, "RETURN ZipFileLoadStrategy isUsing file [ {0} ]", new Boolean(bl));
        return bl;
    }

    public void setFile(java.io.File file) {
        String string = "setFile";
        logger.logp(Level.FINER, className, string, "ENTRY [ {0} ]", file);
        this.describeFile(string, Level.FINER, "Old ", this._file);
        this._file = file;
        this.describeFile(string, Level.FINER, "New ", this._file);
        logger.logp(Level.FINER, className, string, "RETURN");
    }

    public void setZipFile(ZipFile zipFile) {
        String string = "setZipFile";
        logger.logp(Level.FINEST, className, string, "ENTRY old value [ {0} ]", this._zipFile);
        this._zipFile = zipFile;
        logger.logp(Level.FINEST, className, string, "RETURN new value [ {0} ]", this._zipFile);
    }

    public void trackZipFileAccess(boolean bl) {
        Object object;
        String string;
        String string2 = "trackZipFileAccess";
        if (!loggerLCT.isLoggable(Level.FINER)) {
            return;
        }
        if (bl) {
            this._openTime = ZipFileLoadStrategyImpl.getTimeStamp();
            this._openStack = this.stackTrace();
        } else {
            this._closeTime = ZipFileLoadStrategyImpl.getTimeStamp();
            this._closeStack = this.stackTrace();
        }
        if (bl) {
            string = OPEN_STRING;
            object = new zflRepresentation(this._file, this.stackTrace());
            String string3 = object.hashCode() + this._file.getPath();
            this._hash = lct.add(string3, object);
        } else {
            string = CLOSE_STRING;
            lct.remove(this._hash);
        }
        object = new StringBuffer();
        ((StringBuffer)object).append("\n\n  Activity: ").append(string).append("     ZipFileLoadStrategy [ ").append(this).append(" ] ");
        if (this._file != null) {
            ((StringBuffer)object).append("\n  Activity: ").append(string).append("         file      [ ").append(Integer.toHexString(this._file.hashCode())).append(" ").append(this._file).append(" ] ");
        }
        ((StringBuffer)object).append("\n  Activity: ").append(string).append("         zip file  [ ").append(this._zipFile).append(" ] ");
        ((StringBuffer)object).append("\n  Activity: ").append(string).append("         container [ ").append(this.getContainer()).append(" ] ");
        logger.logp(Level.FINER, className, string2, ((StringBuffer)object).toString());
    }

    protected void describeFile(String string, Level level, String string2, java.io.File file) {
        if (file != null) {
            logger.logp(level, className, string, string2 + "file name          [ {0} ] ", file.getName());
            logger.logp(level, className, string, string2 + "file absolute path [ {0} ] ", file.getAbsolutePath());
            logger.logp(level, className, string, string2 + "file exists        [ {0} ] ", new Boolean(file.exists()));
        } else {
            logger.logp(level, className, string, string2 + "file is null");
        }
    }

    protected String dumpStack(String string, String string2, StackTraceElement[] stackTraceElementArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string2 == null || stackTraceElementArray == null) {
            stringBuffer.append("\n  ");
            stringBuffer.append("Stack trace unavailable for [ ");
            stringBuffer.append(string);
            stringBuffer.append(" ]\n");
        } else {
            stringBuffer.append("\n  ");
            stringBuffer.append("Stack trace for [ ");
            stringBuffer.append(string);
            stringBuffer.append(" ] recorded at [");
            stringBuffer.append(string2);
            stringBuffer.append(" ]:\n");
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                stringBuffer.append("      ");
                stringBuffer.append(stackTraceElementArray[i]);
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class zflRepresentation
    implements LifeCycleTrackerElement {
        private java.io.File _file;
        private StackTraceElement[] _trace;
        private String _timestamp;

        public zflRepresentation(java.io.File file, StackTraceElement[] stackTraceElementArray) {
            this._file = file;
            this._trace = stackTraceElementArray;
            this._timestamp = ZipFileLoadStrategyImpl.getTimeStamp();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("  Time Stamp: [ ");
            stringBuffer.append(this._timestamp);
            stringBuffer.append(" ]\n");
            stringBuffer.append("  File Name:  [ ");
            stringBuffer.append(this._file.getName());
            stringBuffer.append(" ]\n");
            stringBuffer.append("  File:       [ ");
            stringBuffer.append(this._file);
            stringBuffer.append(" ]\n");
            stringBuffer.append("  Stack Trace of zipfile creation: \n");
            for (int i = 0; i < this._trace.length; ++i) {
                stringBuffer.append("      ");
                stringBuffer.append(this._trace[i]);
                stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }

        public boolean matches(String string) {
            return string.equals(this._file.toString());
        }
    }
}

