/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.FileIterator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.SaveFilter;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.SaveFilterImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ArchiveStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ZipFileLoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.wst.common.internal.emf.resource.CompatibilityXMIResource;
import org.eclipse.wst.common.internal.emf.resource.TranslatorResource;
import org.eclipse.wst.common.internal.emf.utilities.Revisit;

public abstract class SaveStrategyImpl
extends ArchiveStrategyImpl
implements SaveStrategy {
    protected static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    private static String className = (class$org$eclipse$jst$j2ee$commonarchivecore$internal$strategy$SaveStrategyImpl == null ? (class$org$eclipse$jst$j2ee$commonarchivecore$internal$strategy$SaveStrategyImpl = SaveStrategyImpl.class$("org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategyImpl")) : class$org$eclipse$jst$j2ee$commonarchivecore$internal$strategy$SaveStrategyImpl).getName();
    protected SaveFilter filter;
    static /* synthetic */ Class class$org$eclipse$jst$j2ee$commonarchivecore$internal$strategy$SaveStrategyImpl;

    public void close() throws IOException {
    }

    protected abstract SaveStrategy createNestedSaveStrategy(Archive var1) throws IOException;

    public void finish() throws IOException {
    }

    public SaveFilter getFilter() {
        if (this.filter == null) {
            this.filter = new SaveFilterImpl();
        }
        return this.filter;
    }

    protected abstract OutputStream getOutputStreamForResource(Resource var1) throws IOException;

    public boolean isDirectory() {
        return false;
    }

    protected boolean isLoadedResourceOrManifest(File file) {
        return this.getArchive().isMofResourceLoaded(file.getURI()) || file.getURI().equals("META-INF/MANIFEST.MF");
    }

    public void save() throws SaveFailureException {
        String string = "save";
        this.saveManifest();
        this.saveMofResources();
        this.saveFiles();
        LoadStrategy loadStrategy = this.archive.getLoadStrategy();
        if (loadStrategy instanceof ZipFileLoadStrategyImpl) {
            ZipFileLoadStrategyImpl zipFileLoadStrategyImpl = (ZipFileLoadStrategyImpl)loadStrategy;
            try {
                zipFileLoadStrategyImpl.closeZipFile();
            }
            catch (IOException iOException) {
                logger.logp(Level.WARNING, className, string, "IOException from zipfile close [ {0} ]", iOException);
            }
        }
    }

    public void save(Archive archive) throws SaveFailureException {
        SaveStrategy saveStrategy = null;
        try {
            saveStrategy = this.createNestedSaveStrategy(archive);
        }
        catch (IOException iOException) {
            throw new SaveFailureException(archive.getURI(), iOException);
        }
        archive.save(saveStrategy);
    }

    public void save(File file, FileIterator fileIterator) throws SaveFailureException {
        if (file.isArchive() && this.shouldIterateOver((Archive)file)) {
            this.save((Archive)file);
        } else {
            InputStream inputStream = null;
            if (!file.isDirectoryEntry()) {
                try {
                    inputStream = fileIterator.getInputStream(file);
                }
                catch (IOException iOException) {
                    throw new SaveFailureException(file.getURI(), iOException);
                }
            }
            this.save(file, inputStream);
        }
    }

    public abstract void save(File var1, InputStream var2) throws SaveFailureException;

    protected void saveFiles() throws SaveFailureException {
        try {
            FileIterator fileIterator = this.getArchive().getFilesForSave();
            while (fileIterator.hasNext()) {
                File file = fileIterator.next();
                if (!this.shouldSave(file)) continue;
                this.save(file, fileIterator);
            }
        }
        catch (IOException iOException) {
            throw new SaveFailureException(CommonArchiveResourceHandler.Error_occurred_iterating_f_EXC_, iOException);
        }
    }

    protected void saveManifest() throws SaveFailureException {
        if (!this.shouldSave("META-INF/MANIFEST.MF")) {
            return;
        }
        ArchiveManifest archiveManifest = this.getArchive().getManifest();
        if (archiveManifest.getManifestVersion() == null || archiveManifest.getManifestVersion().equals("")) {
            archiveManifest.setManifestVersion("1.0");
        }
        this.save(archiveManifest);
    }

    public void saveMofResource(Resource resource) throws SaveFailureException {
        if (!this.shouldSave(resource)) {
            return;
        }
        this.setEncoding(resource);
        try {
            boolean bl = resource.isModified();
            OutputStream outputStream = this.getOutputStreamForResource(resource);
            this.saveMofResource(resource, outputStream);
            resource.setModified(bl);
        }
        catch (Exception exception) {
            throw new SaveFailureException(resource.getURI().toString(), exception);
        }
    }

    protected void saveMofResource(Resource resource, OutputStream outputStream) throws IOException {
        resource.save(outputStream, Collections.EMPTY_MAP);
    }

    protected void saveMofResources() throws SaveFailureException {
        Iterator iterator = this.getArchive().getLoadedMofResources().iterator();
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        ArrayList<Resource> arrayList2 = new ArrayList<Resource>();
        Resource resource = null;
        while (iterator.hasNext()) {
            resource = (Resource)iterator.next();
            if (ArchiveUtil.isJavaResource(resource) || ArchiveUtil.isRegisteredURIMapping(resource) || ArchiveUtil.isPlatformMetaResource(resource)) continue;
            Revisit.revisit();
            if (resource instanceof CompatibilityXMIResource) {
                ((CompatibilityXMIResource)resource).setFormat(1);
            }
            if (resource instanceof TranslatorResource) {
                arrayList2.add(resource);
                continue;
            }
            arrayList.add(resource);
        }
        this.basicSaveMofResources(arrayList);
        this.basicSaveMofResources(arrayList2);
    }

    protected void basicSaveMofResources(List list) throws SaveFailureException {
        Resource resource = null;
        for (int i = 0; i < list.size(); ++i) {
            resource = (Resource)list.get(i);
            this.saveMofResource(resource);
        }
    }

    protected void setEncoding(Resource resource) {
        if (resource instanceof XMLResource) {
            ((XMLResource)resource).setEncoding(this.archive.getXmlEncoding());
        }
    }

    public void setFilter(SaveFilter saveFilter) {
        this.filter = saveFilter;
    }

    protected boolean shouldIterateOver(Archive archive) {
        return archive.getLoadStrategy().requiresIterationOnSave();
    }

    protected boolean shouldSave(File file) {
        ModuleFile moduleFile;
        boolean bl = this.isLoadedResourceOrManifest(file);
        if (bl) {
            Resource resource = this.archive.getLoadStrategy().getExistingMofResource(file.getURI());
            if (resource == null) {
                return false;
            }
            return !this.shouldSave(resource);
        }
        if (this.getArchive().isModuleFile() && (moduleFile = (ModuleFile)this.getArchive()).getExportStrategy() != null && moduleFile.getExportStrategy().hasSaved(file.getURI())) {
            return false;
        }
        return this.shouldSave(file.getURI());
    }

    protected boolean shouldSave(Resource resource) {
        if (!resource.isModified() && this.getArchive().getOptions().saveOnlyDirtyMofResources()) {
            return false;
        }
        return this.shouldSave(resource.getURI().toString());
    }

    protected boolean shouldSave(String string) {
        return this.getFilter().shouldSave(string, this.getArchive());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

