/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.NestedJarException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.FileIterator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.NestedArchiveIterator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategyImpl;

public class NestedArchiveLoadStrategyImpl
extends LoadStrategyImpl {
    public static final String CONFIG_WTP_LOGGER = "com.ibm.config.eclipse.wtp";
    public static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    public static final String CLASS_NAME = (class$org$eclipse$jst$j2ee$commonarchivecore$internal$strategy$NestedArchiveLoadStrategyImpl == null ? (class$org$eclipse$jst$j2ee$commonarchivecore$internal$strategy$NestedArchiveLoadStrategyImpl = NestedArchiveLoadStrategyImpl.class$("org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.NestedArchiveLoadStrategyImpl")) : class$org$eclipse$jst$j2ee$commonarchivecore$internal$strategy$NestedArchiveLoadStrategyImpl).getName();
    protected LoadStrategy parent;
    protected Map urisToPositions;
    static /* synthetic */ Class class$org$eclipse$jst$j2ee$commonarchivecore$internal$strategy$NestedArchiveLoadStrategyImpl;

    public NestedArchiveLoadStrategyImpl(LoadStrategy loadStrategy) {
        this.setParent(loadStrategy);
        logger.logp(Level.FINER, CLASS_NAME, "constructor", "Initial construction");
    }

    public void setContainer(Container container) {
        super.setContainer(container);
        if (logger.isLoggable(Level.FINER)) {
            Container container2 = this.getContainer();
            Container container3 = this.getParent() == null ? null : this.getParent().getContainer();
            logger.logp(Level.FINER, CLASS_NAME, "setContainer", "Strategy for [ {0} ] within parent [ {1} ]", new String[]{container2 == null ? null : container2.getURI(), container3 == null ? null : container3.getURI()});
        }
    }

    protected boolean primContains(String string) {
        if (this.usingIndex()) {
            return this.containsUsingIndex(string);
        }
        return this.containsSequentially(string);
    }

    public FileIterator getFileIterator() throws IOException {
        if (((Archive)this.getContainer()).getOptions().isReadOnly()) {
            return new NestedArchiveIterator(this.getContainer().getFiles(), this.getZipInputStream());
        }
        return super.getFileIterator();
    }

    public InputStream getInputStream(String string) throws IOException, FileNotFoundException {
        if (this.usingIndex()) {
            return this.getInputStreamUsingIndex(string);
        }
        return this.getInputStreamSequentially(string);
    }

    public void setParent(LoadStrategy loadStrategy) {
        this.parent = loadStrategy;
    }

    public LoadStrategy getParent() {
        return this.parent;
    }

    protected ZipInputStream getZipInputStream() throws IOException, FileNotFoundException {
        String string = this.getContainer().getURI();
        InputStream inputStream = this.getParent().getInputStream(string);
        return new ZipInputStream(inputStream);
    }

    protected ZipInputStream getZipInputStreamSkippedTo(String string) throws IOException, FileNotFoundException {
        ZipInputStream zipInputStream;
        if (string == null) {
            throw new NullPointerException(CommonArchiveResourceHandler.Null_uri_EXC_);
        }
        ZipInputStream zipInputStream2 = this.getZipInputStream();
        ZipEntry zipEntry = null;
        try {
            while ((zipEntry = zipInputStream2.getNextEntry()) != null) {
                if (!string.equals(zipEntry.getName())) continue;
                zipInputStream = zipInputStream2;
                Object var6_5 = null;
                if (zipEntry != null) break block8;
            }
        }
        catch (Throwable throwable) {
            block9: {
                Object var6_6 = null;
                if (zipEntry != null) break block9;
                try {
                    zipInputStream2.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        {
            block8: {
                try {
                    zipInputStream2.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return zipInputStream;
        }
        throw new FileNotFoundException(string);
    }

    protected boolean containsSequentially(String string) {
        try {
            ZipInputStream zipInputStream = this.getZipInputStreamSkippedTo(string);
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    protected InputStream getInputStreamSequentially(String string) throws IOException, FileNotFoundException {
        return new BufferedInputStream(this.getZipInputStreamSkippedTo(string));
    }

    public List getFiles() throws NestedJarException {
        ZipInputStream zipInputStream;
        try {
            zipInputStream = this.getZipInputStream();
        }
        catch (IOException iOException) {
            throw this.newNestedJarException(iOException);
        }
        try {
            Object object;
            ZipEntry zipEntry;
            ArrayList<Object> arrayList = new ArrayList<Object>(500);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                object = this.createFile(zipEntry.getName());
                object.setSize(zipEntry.getSize());
                object.setLastModified(zipEntry.getTime());
                arrayList.add(object);
            }
            object = arrayList;
            return object;
        }
        catch (IOException iOException) {
            throw this.newNestedJarException(iOException);
        }
        finally {
            try {
                zipInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public boolean usingIndex() {
        return false;
    }

    public Map getUrisToPositions() {
        if (this.usingIndex() && this.urisToPositions == null) {
            this.buildIndex();
        }
        return this.urisToPositions;
    }

    public void setUrisToPositions(Map map) {
        this.urisToPositions = map;
    }

    protected void buildIndex() throws NestedJarException {
        this.setUrisToPositions(this.generateIndex());
    }

    protected Map generateIndex() throws NestedJarException {
        ZipInputStream zipInputStream;
        try {
            zipInputStream = this.getZipInputStream();
        }
        catch (IOException iOException) {
            throw this.newNestedJarException(iOException);
        }
        try {
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            long l = 0L;
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                hashMap.put(zipEntry.getName(), new Long(++l));
            }
            HashMap<String, Long> hashMap2 = hashMap;
            return hashMap2;
        }
        catch (IOException iOException) {
            throw this.newNestedJarException(iOException);
        }
        finally {
            try {
                zipInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected boolean containsUsingIndex(String string) {
        return this.getUrisToPositions().containsKey(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getInputStreamUsingIndex(String string) throws IOException, FileNotFoundException {
        BufferedInputStream bufferedInputStream;
        block7: {
            Long l = (Long)this.getUrisToPositions().get(string);
            if (l == null) {
                throw new FileNotFoundException();
            }
            ZipInputStream zipInputStream = this.getZipInputStream();
            try {
                for (long i = l.longValue(); i > 0L; --i) {
                    zipInputStream.getNextEntry();
                }
                ZipInputStream zipInputStream2 = zipInputStream;
                zipInputStream = null;
                bufferedInputStream = new BufferedInputStream(zipInputStream2);
                Object var7_7 = null;
                if (zipInputStream == null) break block7;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var7_8 = null;
                    if (zipInputStream == null) break block8;
                    try {
                        zipInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                zipInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bufferedInputStream;
    }

    protected void throwNestedJarException(Exception exception) throws NestedJarException {
        String string = CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.nested_jar_EXC_, new Object[]{this.getContainer().getURI(), this.getParent().getContainer().getURI()});
        throw new NestedJarException(string, exception);
    }

    protected NestedJarException newNestedJarException(Exception exception) {
        String string = CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.nested_jar_EXC_, new Object[]{this.getContainer().getURI(), this.getParent().getContainer().getURI()});
        return new NestedJarException(string, exception);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

