/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jem.internal.java.adapters.jdk.JavaJDKAdapterFactory;
import org.eclipse.jst.j2ee.common.internal.impl.J2EEResouceFactorySaxRegistry;
import org.eclipse.jst.j2ee.common.internal.impl.J2EEResourceFactoryDomRegistry;
import org.eclipse.jst.j2ee.common.internal.impl.J2EEResourceFactoryRegistry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveFactoryRegistry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveRuntimeException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ResourceLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveURIConverterImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.FileIterator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.FileIteratorImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveWrapperClassLoader;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseArchive;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseConfigRegister;
import org.eclipse.wst.common.internal.emf.utilities.ExtendedEcoreUtil;

public abstract class LoadStrategyImpl
extends AdapterImpl
implements LoadStrategy {
    protected static String className = (class$org$eclipse$jst$j2ee$commonarchivecore$internal$strategy$LoadStrategyImpl == null ? (class$org$eclipse$jst$j2ee$commonarchivecore$internal$strategy$LoadStrategyImpl = LoadStrategyImpl.class$("org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategyImpl")) : class$org$eclipse$jst$j2ee$commonarchivecore$internal$strategy$LoadStrategyImpl).getName();
    protected static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    protected boolean isOpen = true;
    protected Container container;
    protected ResourceSet resourceSet;
    protected LooseArchive looseArchive;
    protected Map collectedLooseArchiveFiles = Collections.EMPTY_MAP;
    protected boolean readOnly = false;
    private int rendererType;
    static /* synthetic */ Class class$org$eclipse$jst$j2ee$commonarchivecore$internal$strategy$LoadStrategyImpl;

    public void addOrReplaceMofResource(Resource resource) {
        Resource resource2 = this.getResourceSet().getResource(resource.getURI(), false);
        if (resource2 != null) {
            this.getResourceSet().getResources().remove(resource2);
        }
        this.getResourceSet().getResources().add(resource);
    }

    protected void updateModificationTracking(Resource resource) {
        boolean bl;
        boolean bl2 = resource.isTrackingModification();
        boolean bl3 = this.container != null ? ((Archive)this.container).getOptions().isReadOnly() : false;
        boolean bl4 = bl = !bl3 && !ArchiveUtil.isJavaResource(resource) && !ArchiveUtil.isRegisteredURIMapping(resource);
        if (bl && !bl2) {
            resource.setTrackingModification(true);
        }
    }

    public void close() {
        this.setIsOpen(false);
        if (this.resourceSet != null && this.resourceSet.eAdapters().contains(this)) {
            this.resourceSet.eAdapters().remove(this);
        }
    }

    protected abstract boolean primContains(String var1);

    public boolean contains(String string) {
        if (this.containsUsingLooseArchive(string)) {
            return true;
        }
        return this.primContains(string);
    }

    protected boolean containsUsingLooseArchive(String string) {
        if (this.getLooseArchive() == null) {
            return false;
        }
        LooseArchive looseArchive = this.getLooseArchive();
        if (looseArchive.getResourcesPath() == null) {
            return false;
        }
        java.io.File file = new java.io.File(looseArchive.getResourcesPath(), string);
        if (file.exists()) {
            return true;
        }
        return LooseConfigRegister.singleton().findFirstLooseChild(string, looseArchive) != null;
    }

    protected File createDirectory(String string) {
        File file = null;
        file = this.getArchiveFactory().createFile();
        file.setDirectoryEntry(true);
        file.setURI(string);
        file.setOriginalURI(string);
        file.setLoadingContainer(this.getContainer());
        return file;
    }

    protected File createFile(String string) {
        File file = null;
        if (this.isArchive(string)) {
            file = this.openNestedArchive(string);
        }
        if (file == null) {
            file = this.getArchiveFactory().createFile();
            file.setURI(string);
            file.setOriginalURI(string);
        }
        file.setLoadingContainer(this.getContainer());
        return file;
    }

    protected void finalize() throws Throwable {
        if (this.isOpen) {
            this.close();
        }
    }

    public String getAbsolutePath() throws FileNotFoundException {
        String string = "getAbsolutePath";
        logger.logp(Level.FINER, className, string, "ENTRY/RETURN Throwing FileNotFoundException");
        throw new FileNotFoundException(CommonArchiveResourceHandler.Absolute_path_unknown_EXC_);
    }

    public String getResourcesPath() throws FileNotFoundException {
        return this.getLooseArchive() == null ? this.getAbsolutePath() : this.getLooseArchive().getResourcesPath();
    }

    protected String primGetResourcesPath() {
        return this.getLooseArchive() == null ? null : this.getLooseArchive().getResourcesPath();
    }

    public String getBinariesPath() throws FileNotFoundException {
        String string = "getBinariesPath";
        Archive archive = (Archive)this.container;
        String string2 = archive.getURI();
        logger.logp(Level.FINER, className, string, "ENTRY for archive [ {0} ]", string2);
        String string3 = null;
        LooseArchive looseArchive = this.getLooseArchive();
        if (looseArchive == null) {
            logger.logp(Level.FINER, className, string, "No loose archive.");
            ArchiveOptions archiveOptions = archive.getOptions();
            if (!archive.isEARFile()) {
                logger.logp(Level.FINER, className, string, "Archive is not an EAR file.  Look for parentEarBinariesPath.");
                String string4 = archiveOptions.getParentEarBinariesPath();
                logger.logp(Level.FINER, className, string, "parentEarBinariesPath [ {0} ]", string4);
                if (string4 != null) {
                    logger.logp(Level.FINER, className, string, "appending archive URI to parent binaries path [ {0} ].", string4);
                    string3 = string4 + java.io.File.separatorChar + string2;
                }
            } else {
                logger.logp(Level.FINER, className, string, "Archive is an EAR file.  Look for altBinariesPath.");
                String string5 = archiveOptions.getAltBinariesPath();
                logger.logp(Level.FINER, className, string, "altBinariesPath in archiveOptions [ {0} ]", string5);
                if (string5 != null) {
                    logger.logp(Level.FINER, className, string, "Replacing binariesPath with altBinariesPath");
                    string3 = string5;
                }
            }
            if (string3 == null) {
                string3 = this.getAbsolutePath();
                logger.logp(Level.FINER, className, string, "Use absolute path.");
            }
        } else {
            string3 = looseArchive.getBinariesPath();
            logger.logp(Level.FINER, className, string, "Got loose archive binaries path [ {0} ]", string3);
        }
        logger.logp(Level.FINER, className, string, "RETURN [ {0} ] ", string3);
        return string3;
    }

    public CommonarchiveFactory getArchiveFactory() {
        return CommonArchiveFactoryRegistry.INSTANCE.getCommonArchiveFactory();
    }

    public Container getContainer() {
        return this.container;
    }

    public ResourceSet primGetResourceSet() {
        return this.resourceSet;
    }

    public boolean requiresIterationOnSave() {
        if (!this.getContainer().isArchive() || this.isDirectory()) {
            return true;
        }
        Archive archive = (Archive)this.getContainer();
        if (archive.isModuleFile()) {
            return !archive.getOptions().isReadOnly();
        }
        if (archive.getOptions().isSaveLibrariesAsFiles() && archive.getLoadingContainer() != null) {
            if (archive.isIndexed()) {
                EList eList = archive.getFiles();
                File file = null;
                Container container = null;
                Container container2 = null;
                for (int i = 0; i < eList.size(); ++i) {
                    file = (File)eList.get(i);
                    if (i == 0 && (container = file.getLoadingContainer()).getLoadStrategy().isDirectory()) {
                        return true;
                    }
                    container2 = file.getLoadingContainer();
                    if (container2 == container) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public ResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            this.initializeResourceSet();
            this.resourceSet.eAdapters().add(this);
        }
        return this.resourceSet;
    }

    public void notifyChanged(Notification notification) {
        switch (notification.getEventType()) {
            case 3: {
                this.updateModificationTracking((Resource)notification.getNewValue());
                break;
            }
            case 5: {
                List list = (List)notification.getNewValue();
                for (int i = 0; i < list.size(); ++i) {
                    this.updateModificationTracking((Resource)list.get(i));
                }
                break;
            }
        }
    }

    public FileIterator getFileIterator() throws IOException {
        return new FileIteratorImpl(this.getContainer().getFiles());
    }

    public abstract List getFiles();

    public List collectFiles() {
        String string = "collectFiles";
        String string2 = "unknown";
        if (this.container != null) {
            string2 = this.container.getURI();
        }
        logger.logp(Level.FINER, className, string, "ENTRY - URI [ {0} ]", string2);
        this.collectFilesFromLooseArchives();
        List list = this.getFiles();
        if (logger.isLoggable(Level.FINEST)) {
            String string3 = "getFiles collected files:\n";
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                string3 = string3 + iterator.next() + "\n";
            }
            logger.logp(Level.FINEST, className, string, string3);
        }
        list.addAll(this.collectedLooseArchiveFiles.values());
        this.collectedLooseArchiveFiles = Collections.EMPTY_MAP;
        logger.logp(Level.FINER, className, string, "RETURN Collected a total of [ {0} ] files", Integer.toString(list.size()));
        return list;
    }

    protected void collectFilesFromLooseArchives() {
        Object object;
        String string = "collectFilesFromLooseArchives";
        logger.logp(Level.FINER, className, string, "ENTRY");
        if (!this.canHaveLooseChildren() || this.getLooseArchive() == null) {
            this.collectedLooseArchiveFiles = Collections.EMPTY_MAP;
            logger.logp(Level.FINER, className, string, "RETURN No loose archive files to collect");
            return;
        }
        this.collectedLooseArchiveFiles = new HashMap();
        List list = LooseConfigRegister.singleton().getLooseChildren(this.getLooseArchive());
        for (int i = 0; i < list.size(); ++i) {
            Archive archive;
            object = (LooseArchive)list.get(i);
            String string2 = object.getUri();
            if (this.collectedLooseArchiveFiles.containsKey(string2) || (archive = this.openNestedArchive((LooseArchive)object)) == null) continue;
            this.collectedLooseArchiveFiles.put(string2, archive);
            archive.setLoadingContainer(this.getContainer());
        }
        if (logger.isLoggable(Level.FINEST)) {
            String string3 = "collectFilesFromLooseArchives collected files:\n";
            object = this.collectedLooseArchiveFiles.values().iterator();
            while (object.hasNext()) {
                string3 = string3 + object.next() + "\n";
            }
            logger.logp(Level.FINEST, className, string, string3);
        }
        logger.logp(Level.FINER, className, string, "RETURN Collected [ {0} ] loose archive files", Integer.toString(this.collectedLooseArchiveFiles.size()));
    }

    public abstract InputStream getInputStream(String var1) throws IOException, FileNotFoundException;

    public InputStream getResourceInputStream(String string) throws IOException {
        return this.getResourceSet().getURIConverter().createInputStream(URI.createURI(string));
    }

    public Collection getLoadedMofResources() {
        EList eList = this.getResourceSet().getResources();
        if (eList.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Resource> arrayList = new ArrayList<Resource>(eList.size());
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            if (!resource.isLoaded()) continue;
            arrayList.add(resource);
        }
        return arrayList;
    }

    public Resource getMofResource(String string) throws FileNotFoundException, ResourceLoadException {
        try {
            return this.getResourceSet().getResource(URI.createURI(string), true);
        }
        catch (WrappedException wrappedException) {
            if (ExtendedEcoreUtil.getFileNotFoundDetector().isFileNotFound(wrappedException)) {
                FileNotFoundException fileNotFoundException = ExtendedEcoreUtil.getInnerFileNotFoundException((WrappedException)wrappedException);
                throw fileNotFoundException;
            }
            this.throwResourceLoadException(string, wrappedException);
            return null;
        }
    }

    protected void initializeResourceSet() {
        String string = "initializeResourceSet";
        logger.logp(Level.FINER, className, string, "ENTRY");
        Archive archive = (Archive)this.getContainer();
        ArchiveURIConverterImpl archiveURIConverterImpl = new ArchiveURIConverterImpl(archive, this.primGetResourcesPath());
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        Resource.Factory.Registry registry = this.createResourceFactoryRegistry();
        resourceSetImpl.setResourceFactoryRegistry(registry);
        this.setResourceSet(resourceSetImpl);
        resourceSetImpl.setURIConverter(archiveURIConverterImpl);
        JavaJDKAdapterFactory javaJDKAdapterFactory = new JavaJDKAdapterFactory();
        javaJDKAdapterFactory.setContextClassLoader(this.getWrapperClassLoader(archive));
        javaJDKAdapterFactory.flushAll();
        resourceSetImpl.getAdapterFactories().add(javaJDKAdapterFactory);
        logger.logp(Level.FINER, className, string, "RETURN");
    }

    protected ClassLoader getWrapperClassLoader(Archive archive) {
        return new ArchiveWrapperClassLoader(archive);
    }

    protected Resource.Factory.Registry createResourceFactoryRegistry() {
        if (this.isReadOnly()) {
            return new J2EEResouceFactorySaxRegistry();
        }
        J2EEResourceFactoryRegistry j2EEResourceFactoryRegistry = null;
        switch (this.getRendererType()) {
            case 1: {
                j2EEResourceFactoryRegistry = new J2EEResouceFactorySaxRegistry();
                break;
            }
            case 2: {
                j2EEResourceFactoryRegistry = new J2EEResourceFactoryDomRegistry();
                break;
            }
            default: {
                j2EEResourceFactoryRegistry = new J2EEResourceFactoryRegistry();
            }
        }
        return j2EEResourceFactoryRegistry;
    }

    public int getRendererType() {
        return this.rendererType;
    }

    protected boolean isArchive(String string) {
        return ((Archive)this.getContainer()).isNestedArchive(string);
    }

    public boolean isClassLoaderNeeded() {
        return true;
    }

    public boolean isDirectory() {
        return false;
    }

    public Resource getExistingMofResource(String string) {
        return this.getResourceSet().getResource(URI.createURI(string), false);
    }

    public boolean isMofResourceLoaded(String string) {
        Resource resource = this.getExistingMofResource(string);
        return resource != null && resource.isLoaded();
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public boolean isUsing(java.io.File file) {
        return false;
    }

    public Resource makeMofResource(String string, EList eList) {
        Resource resource = this.getExistingMofResource(string);
        if (resource != null) {
            return resource;
        }
        return this.getResourceSet().createResource(URI.createURI(string));
    }

    protected Archive openNestedArchive(String string) {
        String string2 = "openNestedArchive - uri";
        logger.entering(className, string2, string);
        try {
            Archive archive = ((Archive)this.getContainer()).openNestedArchive(string);
            if (logger.isLoggable(Level.FINER)) {
                logger.exiting(className, string2, "Opened [ " + archive.getURI() + " ]");
            }
            return archive;
        }
        catch (OpenFailureException openFailureException) {
            logger.severe(openFailureException.getMessage());
            logger.exiting(className, string2, null);
            return null;
        }
    }

    protected Archive openNestedArchive(LooseArchive looseArchive) {
        String string = "openNestedArchive - loose";
        logger.entering(className, string, looseArchive.getUri());
        try {
            Archive archive = ((Archive)this.getContainer()).openNestedArchive(looseArchive);
            if (archive != null) {
                logger.logp(Level.FINER, className, string, "RETURN Opened [ {0} ] ", archive.getURI());
            } else {
                logger.logp(Level.FINER, className, string, "RETURN null");
            }
            return archive;
        }
        catch (OpenFailureException openFailureException) {
            logger.severe(openFailureException.getMessage());
            logger.exiting(className, string, null);
            return null;
        }
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public void setResourceSet(ResourceSet resourceSet) {
        if (this.resourceSet != resourceSet) {
            if (this.resourceSet != null) {
                this.resourceSet.eAdapters().remove(this);
            }
            if (resourceSet != null && !resourceSet.eAdapters().contains(this)) {
                resourceSet.eAdapters().add(this);
            }
            this.resourceSet = resourceSet;
        }
    }

    protected void setIsOpen(boolean bl) {
        this.isOpen = bl;
    }

    protected void throwResourceLoadException(String string, Exception exception) throws ResourceLoadException {
        throw new ResourceLoadException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.load_resource_EXC_, new Object[]{string, this.getContainer().getURI()}), exception);
    }

    public LooseArchive getLooseArchive() {
        String string = "getLooseArchive";
        logger.logp(Level.FINER, className, string, "ENTRY/RETURN [ {0} ] ", this.looseArchive);
        return this.looseArchive;
    }

    public void setLooseArchive(LooseArchive looseArchive) {
        String string = "setLooseArchive";
        logger.logp(Level.FINER, className, string, "ENTRY [ {0} ] ", looseArchive);
        this.looseArchive = looseArchive;
        this.checkLoosePathsValid();
        logger.logp(Level.FINER, className, string, "RETURN");
    }

    protected void checkLoosePathsValid() {
        String string = "checkLoosePathsValid";
        if (this.looseArchive == null) {
            logger.logp(Level.FINER, className, string, "ENTRY/RETURN non-applicable, as no loose archive");
            return;
        }
        logger.logp(Level.FINER, className, string, "ENTRY");
        String string2 = this.looseArchive.getBinariesPath();
        logger.logp(Level.FINER, className, string, "loose archive binaries path [ {0} ] ", string2);
        if (!this.exists(string2)) {
            logger.logp(Level.WARNING, className, string, "RETURN Throwing ArchiveRuntimeException because binaries path does not exist");
            throw new ArchiveRuntimeException("Invalid binaries path: " + string2);
        }
        string2 = this.looseArchive.getResourcesPath();
        logger.logp(Level.FINER, className, string, "loose archive resources path [ {0} ] ", string2);
        if (!this.exists(string2)) {
            logger.logp(Level.WARNING, className, string, "RETURN Throwing ArchiveRuntimeException because resources path does not exist");
            throw new ArchiveRuntimeException("Invalid resources path: " + string2);
        }
        logger.logp(Level.FINER, className, string, "RETURN loose paths valid");
    }

    private boolean exists(String string) {
        java.io.File file;
        return string != null && (file = new java.io.File(string)).exists();
    }

    protected boolean canHaveLooseChildren() {
        return this.container.isEARFile() || this.container.isWARFile();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public void setRendererType(int n) {
        this.rendererType = n;
    }

    public List getFiles(String string) {
        ArrayList<File> arrayList = new ArrayList<File>();
        List list = this.getFiles();
        for (int i = 0; i < list.size(); ++i) {
            File file = (File)list.get(i);
            if (!file.getURI().startsWith(string)) continue;
            arrayList.add(file);
        }
        return arrayList;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

