/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.io.FileNotFoundException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.ApplicationFactory;
import org.eclipse.jst.j2ee.application.EjbModule;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveTypeDiscriminator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveTypeDiscriminatorImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ModuleLocator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.DirectoryArchiveLoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.DirectoryLoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ImportStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.XmlBasedImportStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseApplication;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseArchive;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseConfigRegister;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseModule;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseconfigFactory;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseconfigPackage;

public class Ear30NoDDImportStrategyImpl
extends XmlBasedImportStrategyImpl {
    private static final String className = (class$org$eclipse$jst$j2ee$commonarchivecore$internal$strategy$Ear30NoDDImportStrategyImpl == null ? (class$org$eclipse$jst$j2ee$commonarchivecore$internal$strategy$Ear30NoDDImportStrategyImpl = Ear30NoDDImportStrategyImpl.class$("org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.Ear30NoDDImportStrategyImpl")) : class$org$eclipse$jst$j2ee$commonarchivecore$internal$strategy$Ear30NoDDImportStrategyImpl).getName();
    private static final boolean IS_EJB_MODULE = true;
    private static final String SEPARATOR = System.getProperty("file.separator");
    protected static Discriminator discriminator;
    static /* synthetic */ Class class$org$eclipse$jst$j2ee$commonarchivecore$internal$strategy$Ear30NoDDImportStrategyImpl;
    static /* synthetic */ Class class$org$eclipse$jst$j2ee$commonarchivecore$internal$strategy$Ear30NoDDImportStrategyImpl$Discriminator;

    public ImportStrategy createImportStrategy(Archive archive, Archive archive2) {
        return Ear30NoDDImportStrategyImpl.getDiscriminator().createImportStrategy(archive, archive2);
    }

    public static ArchiveTypeDiscriminator getDiscriminator() {
        if (discriminator == null) {
            discriminator = new Discriminator();
        }
        return discriminator;
    }

    public EARFile getEARFile() {
        return (EARFile)this.getArchive();
    }

    public boolean isNoDDStrategy() {
        return true;
    }

    public void importMetaData() throws Exception {
        this.loadDeploymentDescriptor();
    }

    public void loadDeploymentDescriptor() throws Exception {
        Archive archive;
        String string = "loadDeploymentDescriptor";
        String string2 = this.archive.getName();
        logger.logp(Level.FINER, className, string, "ENTRY Creating an application.xml for EAR [ {0} ]", string2);
        ApplicationFactory applicationFactory = ApplicationFactory.eINSTANCE;
        Application application = applicationFactory.createApplication();
        application.setVersion("5");
        EList eList = application.getModules();
        if (string2.endsWith(".ear")) {
            string2 = string2.substring(0, string2.length() - 4);
        }
        application.setDisplayName(string2);
        EARFile eARFile = this.getEARFile();
        eARFile.setDeploymentDescriptor_noDD(application);
        LoadStrategy loadStrategy = eARFile.getLoadStrategy();
        LooseApplication looseApplication = (LooseApplication)loadStrategy.getLooseArchive();
        boolean bl = looseApplication != null;
        String string3 = null;
        logger.logp(Level.FINER, className, string, "loose application [ {0} ] ", Boolean.toString(bl));
        try {
            string3 = this.getEARFile().getBinariesPath();
            logger.logp(Level.FINER, className, string, "EAR binaries path [ {0} ]", string3);
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.logp(Level.FINER, className, string, "Ignoring FileNotFoundException while getting EAR's binaries path");
        }
        List list = eARFile.getArchiveFiles();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EjbModule ejbModule;
            archive = (Archive)iterator.next();
            String string4 = archive.getURI();
            logger.logp(Level.FINER, className, string, "Examining archive [ {0} ]", archive);
            if (string4.startsWith("lib/")) {
                logger.logp(Level.FINER, className, string, "Skipping archive [ {0} ] as modules can't be in lib directory", archive);
                continue;
            }
            if (string4.endsWith(".jar")) {
                if (Ear30NoDDImportStrategyImpl.isEJBModule(archive)) {
                    ejbModule = applicationFactory.createEjbModule();
                    ejbModule.setUri(string4);
                    ejbModule.setApplication(application);
                    eList.add(ejbModule);
                    if (bl) {
                        this.setLooseArchive(true, string3, looseApplication, archive.getLoadStrategy(), (Module)ejbModule);
                    }
                    logger.logp(Level.FINER, className, string, "Added archive [ {0} ] to list of EJB Modules", archive);
                    logger.logp(Level.FINER, className, string, "Container for EJB Module is [ {0} ]", archive.getContainer());
                    continue;
                }
                if (!Ear30NoDDImportStrategyImpl.isAppClientModule(archive)) continue;
                ejbModule = applicationFactory.createJavaClientModule();
                ejbModule.setUri(string4);
                ejbModule.setApplication(application);
                eList.add(ejbModule);
                logger.logp(Level.FINER, className, string, "Added archive [ {0} ] to list of Application Client Modules", archive);
                continue;
            }
            if (string4.endsWith(".war")) {
                ejbModule = applicationFactory.createWebModule();
                ejbModule.setUri(string4);
                String string5 = string4.substring(0, string4.length() - 4);
                ejbModule.setContextRoot("/" + string5);
                ejbModule.setApplication(application);
                eList.add(ejbModule);
                if (bl) {
                    this.setLooseArchive(false, string3, looseApplication, archive.getLoadStrategy(), (Module)ejbModule);
                }
                logger.logp(Level.FINER, className, string, "Added archive [ {0} ] to list of Web Modules", archive);
                continue;
            }
            if (!string4.endsWith(".rar")) continue;
            ejbModule = applicationFactory.createConnectorModule();
            ejbModule.setUri(string4);
            ejbModule.setApplication(application);
            eList.add(ejbModule);
            logger.logp(Level.FINER, className, string, "Added archive [ {0} ] to list of Connector Modules", archive);
        }
        logger.logp(Level.FINER, className, string, "application.xml created for [ {0} ]", string2);
        eARFile.clearFiles();
        iterator = list.iterator();
        while (iterator.hasNext()) {
            archive = (Archive)iterator.next();
            logger.logp(Level.FINER, className, string, "Close archive file [ {0} ]", archive.getURI());
            archive.close();
        }
        eARFile.getFiles();
        logger.exiting(className, string);
    }

    private static boolean isAppClientModule(Archive archive) {
        boolean bl = false;
        if (archive.containsFile("META-INF/application-client.xml")) {
            bl = true;
        } else {
            ArchiveManifest archiveManifest = archive.getManifest();
            if (archiveManifest != null && archiveManifest.getMainClass() != null) {
                bl = true;
            }
        }
        return bl;
    }

    protected static boolean isEJBModule(Archive archive) {
        String string = "isEJBModule";
        String string2 = archive.getURI();
        logger.logp(Level.FINER, className, string, "ENTRY archive", string2);
        if (archive instanceof EJBJarFile) {
            logger.logp(Level.FINER, className, string, "RETURN true - archive [ {0} ] already determined to be an EJB Module", string2);
            return true;
        }
        if (archive.containsFile("META-INF/ejb-jar.xml")) {
            logger.logp(Level.FINER, className, string, "RETURN true - archive [ {0} ] contains an EJB Module Deployment Descriptor", string2);
            return true;
        }
        if (archive.containsFile("META-INF/application-client.xml")) {
            logger.logp(Level.FINER, className, string, "RETURN false - archive [ {0} ] contains an Application Client Deployment Descriptor", string2);
            return false;
        }
        logger.logp(Level.FINER, className, string, "Scanning archive [ {0} ] for EJB Module annotations", string2);
        ModuleLocator moduleLocator = new ModuleLocator();
        boolean bl = moduleLocator.isEJBModule(archive);
        if (bl) {
            logger.logp(Level.FINER, className, string, "RETURN true - archive [ {0} ] contains EJB Module annotations", string2);
        } else {
            logger.logp(Level.FINER, className, string, "RETURN false - archive [ {0} ] does not contain EJB Module annotations", string2);
        }
        return bl;
    }

    private void setLooseArchive(boolean bl, String string, LooseApplication looseApplication, LoadStrategy loadStrategy, Module module) {
        EList eList;
        String string2 = "setLooseArchive";
        String string3 = module.getUri();
        logger.logp(Level.FINER, className, string2, "ENTRY", string3);
        if (loadStrategy instanceof DirectoryLoadStrategyImpl && !(eList = looseApplication.getLooseArchives()).contains(module)) {
            String string4 = string + SEPARATOR + string3;
            logger.logp(Level.FINER, className, string2, "Set module directory URI to binaries path [ {0} ]", string4);
            ((DirectoryLoadStrategyImpl)loadStrategy).setDirectoryUri(string4);
            LooseconfigFactory looseconfigFactory = (LooseconfigFactory)LooseconfigPackage.eINSTANCE.getEFactoryInstance();
            LooseModule looseModule = bl ? looseconfigFactory.createLooseModule() : looseconfigFactory.createLooseWARFile();
            looseModule.setUri(module.getUri());
            looseModule.setAltDD(module.getAltDD());
            String string5 = looseApplication.getBinariesPath() + SEPARATOR + looseModule.getUri();
            looseModule.setBinariesPath(string5);
            logger.logp(Level.FINER, className, string2, "Set loose module binaries path [ {0} ]", string5);
            String string6 = looseModule.getAltDD();
            if (string6 == null || string6.length() == 0) {
                string6 = looseModule.getUri();
            }
            string5 = looseApplication.getResourcesPath() + SEPARATOR + string6;
            looseModule.setResourcesPath(string5);
            logger.logp(Level.FINER, className, string2, "Set loose module resources path [ {0} ]", string5);
            looseApplication.getLooseArchives().add(looseModule);
        }
        logger.logp(Level.FINER, className, string2, "RETURN");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Discriminator
    extends ArchiveTypeDiscriminatorImpl {
        private static final String className = (class$org$eclipse$jst$j2ee$commonarchivecore$internal$strategy$Ear30NoDDImportStrategyImpl$Discriminator == null ? (class$org$eclipse$jst$j2ee$commonarchivecore$internal$strategy$Ear30NoDDImportStrategyImpl$Discriminator = Ear30NoDDImportStrategyImpl.class$("org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.Ear30NoDDImportStrategyImpl$Discriminator")) : class$org$eclipse$jst$j2ee$commonarchivecore$internal$strategy$Ear30NoDDImportStrategyImpl$Discriminator).getName();

        public boolean canImport(Archive archive) {
            String string;
            Archive archive2;
            String string2;
            String string3 = "canImport";
            XmlBasedImportStrategyImpl.logger.entering(className, string3, archive.getURI());
            String string4 = archive.getURI();
            if (!string4.endsWith(".ear")) {
                boolean bl = archive.getLoadStrategy() instanceof DirectoryArchiveLoadStrategyImpl;
                if (!bl) {
                    archive.closeArchiveZipFile();
                    XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, string3, "RETURN false - file archive [ {0} ] does not end with the .ear file extension", string4);
                    return false;
                }
                if (string4.endsWith(".jar") || string4.endsWith(".rar") || string4.endsWith(".war") || string4.endsWith(".zip")) {
                    XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, string3, "RETURN false - directory archive [ {0} ] has a disallowed extension (jar/war/rar)", string4);
                    archive.closeArchiveZipFile();
                    return false;
                }
            }
            if ((string2 = archive.containsFile("META-INF/application-client.xml") ? "META-INF/application-client.xml" : (archive.containsFile("WEB-INF/web.xml") ? "WEB-INF/web.xml" : (archive.containsFile("META-INF/ejb-jar.xml") ? "META-INF/ejb-jar.xml" : (archive.containsFile("META-INF/ra.xml") ? "META-INF/ra.xml" : null)))) != null) {
                XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, string3, "RETURN false - Blocked by descriptor [ {0} ]", string2);
                archive.closeArchiveZipFile();
                return false;
            }
            XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, string3, "No blocking descriptors");
            LooseApplication looseApplication = LooseConfigRegister.singleton().findLooseApplication(string4);
            if (looseApplication != null) {
                archive.getLoadStrategy().setLooseArchive((LooseArchive)looseApplication);
                XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, string3, "RETURN true - Archive [ {0} ] is a loose application", string4);
                archive.closeArchiveZipFile();
                return true;
            }
            List list = archive.getArchiveFiles();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                archive2 = (Archive)iterator.next();
                string = archive2.getURI();
                if (string.startsWith("lib/")) continue;
                if (string.endsWith(".jar")) {
                    if (!Ear30NoDDImportStrategyImpl.isAppClientModule(archive2)) continue;
                    XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, string3, "RETURN true - Archive [ {0} ] contains an Application Client module (JAR)", string4);
                    archive.closeArchiveZipFile();
                    return true;
                }
                if (string.endsWith(".war")) {
                    XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, string3, "RETURN true - Archive [ {0} ] contains a Web module (WAR)", string4);
                    archive.closeArchiveZipFile();
                    return true;
                }
                if (!string.endsWith(".rar")) continue;
                XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, string3, "RETURN true - Archive [ {0} ] contains a Connector module (RAR)", string4);
                archive.closeArchiveZipFile();
                return true;
            }
            iterator = list.iterator();
            while (iterator.hasNext()) {
                archive2 = (Archive)iterator.next();
                string = archive2.getURI();
                if (string.startsWith("lib/") || !string.endsWith(".jar") || !Ear30NoDDImportStrategyImpl.isEJBModule(archive2)) continue;
                XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, string3, "RETURN true - Archive [ {0} ] contains an EJB module (JAR)", string4);
                archive.closeArchiveZipFile();
                return true;
            }
            XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, string3, "RETURN false - Could not find anything in Archive [ {0} ] to indicate that it is an EAR file", string4);
            if (XmlBasedImportStrategyImpl.logger.isLoggable(Level.FINEST)) {
                new Throwable("Debug data for archive with no EAR contents").printStackTrace(System.out);
            }
            archive.closeArchiveZipFile();
            return false;
        }

        public ImportStrategy createImportStrategy(Archive archive, Archive archive2) {
            return new Ear30NoDDImportStrategyImpl();
        }

        public String getUnableToOpenMessage() {
            return this.getXmlDDMessage(CommonArchiveResourceHandler.EAR_File, "META-INF/application.xml");
        }

        public Archive createConvertedArchive() {
            return Ear30NoDDImportStrategyImpl.getArchiveFactory().createEARFile();
        }
    }
}

