/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveURIConverterImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ZipStreamSaveStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;

public class DirectorySaveStrategyImpl
extends SaveStrategyImpl
implements SaveStrategy {
    public static final String CONFIG_WTP_LOGGER = "com.ibm.config.eclipse.wtp";
    public static final String className = (class$org$eclipse$jst$j2ee$commonarchivecore$internal$strategy$DirectorySaveStrategyImpl == null ? (class$org$eclipse$jst$j2ee$commonarchivecore$internal$strategy$DirectorySaveStrategyImpl = DirectorySaveStrategyImpl.class$("org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.DirectorySaveStrategyImpl")) : class$org$eclipse$jst$j2ee$commonarchivecore$internal$strategy$DirectorySaveStrategyImpl).getName();
    protected static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    protected String directoryName;
    protected URIConverter uriConverter;
    protected int expansionFlags;
    static /* synthetic */ Class class$org$eclipse$jst$j2ee$commonarchivecore$internal$strategy$DirectorySaveStrategyImpl;

    public DirectorySaveStrategyImpl() {
    }

    public DirectorySaveStrategyImpl(String string, int n) {
        this.setDirectoryName(string);
        this.setExpansionFlags(n);
        this.initialize();
    }

    protected SaveStrategy createNestedDirectoryStrategy(Archive archive) {
        String string = ArchiveUtil.getOSUri(this.getDirectoryName(), archive.getURI());
        return new DirectorySaveStrategyImpl(string, this.getExpansionFlags());
    }

    protected SaveStrategy createNestedSaveStrategy(Archive archive) throws IOException {
        if (this.shouldExpand(archive)) {
            return this.createNestedDirectoryStrategy(archive);
        }
        return this.createNestedZipStrategy(archive);
    }

    protected SaveStrategy createNestedZipStrategy(Archive archive) throws IOException {
        OutputStream outputStream = this.getUriConverter().createOutputStream(URI.createFileURI(archive.getURI()));
        return new ZipStreamSaveStrategyImpl(outputStream);
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public int getExpansionFlags() {
        return this.expansionFlags;
    }

    protected OutputStream getOutputStreamForResource(Resource resource) throws IOException {
        return this.getUriConverter().createOutputStream(resource.getURI());
    }

    public URIConverter getUriConverter() {
        return this.uriConverter;
    }

    public void initialize() {
        ArchiveURIConverterImpl archiveURIConverterImpl = new ArchiveURIConverterImpl(this.getArchive(), this.getDirectoryName());
        archiveURIConverterImpl.setOutputFilepath(this.getDirectoryName());
        this.setUriConverter(archiveURIConverterImpl);
    }

    public boolean isDirectory() {
        return true;
    }

    protected void mkdirs(String string) {
        java.io.File file = new java.io.File(this.getDirectoryName() + java.io.File.separatorChar + string);
        file.mkdirs();
    }

    public void save(ArchiveManifest archiveManifest) throws SaveFailureException {
        try {
            OutputStream outputStream = this.getUriConverter().createOutputStream(URI.createFileURI("META-INF/MANIFEST.MF"));
            archiveManifest.write(outputStream);
            outputStream.close();
            if (this.getArchive().getOptions().isReadOnly()) {
                this.setTimestampAfterSaving("META-INF/MANIFEST.MF");
            }
        }
        catch (IOException iOException) {
            throw new SaveFailureException("META-INF/MANIFEST.MF", iOException);
        }
    }

    public void save(File file, InputStream inputStream) throws SaveFailureException {
        String string = "save";
        String string2 = file.getURI();
        logger.logp(Level.FINER, className, string, "ENTRY [ {0} ]", string2);
        if (file.isDirectoryEntry()) {
            logger.logp(Level.FINER, className, string, "Creating directory");
            this.mkdirs(string2);
        } else {
            logger.logp(Level.FINER, className, string, "Writing file");
            try {
                Object object;
                URI uRI = URI.createFileURI(string2);
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, className, string, "URI (URI.createURI.toFileString) [ " + uRI.toFileString() + " ]");
                    object = new StringBuffer();
                    this.dumpBytes((StringBuffer)object, string2.getBytes());
                    logger.logp(Level.FINER, className, string, "Entry Name Bytes (Default) [ {0} ]", ((StringBuffer)object).toString());
                }
                object = this.getUriConverter().createOutputStream(uRI);
                ArchiveUtil.copy(inputStream, (OutputStream)object);
                this.setTimestampAfterSaving(file);
            }
            catch (IOException iOException) {
                throw new SaveFailureException(file.getURI(), iOException);
            }
        }
    }

    protected void dumpBytes(StringBuffer stringBuffer, byte[] byArray) {
        stringBuffer.append("[ ");
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            stringBuffer.append("0x");
            stringBuffer.append(Integer.toString(by, 16));
            stringBuffer.append(" ");
        }
        stringBuffer.append("]");
    }

    protected void saveMofResource(Resource resource, OutputStream outputStream) throws IOException {
        super.saveMofResource(resource, outputStream);
        outputStream.close();
    }

    public void setDirectoryName(String string) {
        this.directoryName = string;
    }

    public void setExpansionFlags(int n) {
        this.expansionFlags = n;
    }

    protected void setTimestampAfterSaving(File file) {
        long l = file.getLastModified();
        if (l == 0L) {
            return;
        }
        String string = ArchiveUtil.getOSUri(this.getDirectoryName(), file.getURI());
        java.io.File file2 = new java.io.File(string);
        file2.setLastModified(l);
    }

    protected void setTimestampAfterSaving(String string) {
        File file = null;
        try {
            file = this.getArchive().getFile(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        this.setTimestampAfterSaving(file);
    }

    public void setUriConverter(URIConverter uRIConverter) {
        this.uriConverter = uRIConverter;
    }

    protected boolean shouldExpand(Archive archive) {
        int n = 0;
        n = archive.isWARFile() ? 2 : (archive.isEARFile() ? 4 : (archive.isRARFile() ? 64 : (archive.isEJBJarFile() ? 8 : (archive.isApplicationClientFile() ? 16 : 32))));
        return (this.getExpansionFlags() & n) != 0;
    }

    protected boolean shouldIterateOver(Archive archive) {
        return super.shouldIterateOver(archive) || this.shouldExpand(archive);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

