/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.DirectoryArchiveLoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseApplication;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseArchive;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseWARFile;

public abstract class DirectoryLoadStrategyImpl
extends LoadStrategyImpl
implements DirectoryArchiveLoadStrategy {
    protected static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    private static final String className = (class$org$eclipse$jst$j2ee$commonarchivecore$internal$strategy$DirectoryLoadStrategyImpl == null ? (class$org$eclipse$jst$j2ee$commonarchivecore$internal$strategy$DirectoryLoadStrategyImpl = DirectoryLoadStrategyImpl.class$("org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.DirectoryLoadStrategyImpl")) : class$org$eclipse$jst$j2ee$commonarchivecore$internal$strategy$DirectoryLoadStrategyImpl).getName();
    static boolean IS_AIX = "AIX".equals(System.getProperty("os.name"));
    protected String directoryUri;
    protected String directoryUriAsZipString;
    protected static char SEPARATOR_CHAR = java.io.File.separatorChar;
    static /* synthetic */ Class class$org$eclipse$jst$j2ee$commonarchivecore$internal$strategy$DirectoryLoadStrategyImpl;

    public DirectoryLoadStrategyImpl(String string) {
        String string2 = "DirectoryLoadStrategyImpl";
        logger.logp(Level.FINER, className, string2, "ENTRY Directory URI [ {0} ]", string);
        this.setDirectoryUri(string);
        String string3 = null;
        try {
            string3 = new java.io.File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            string3 = string;
        }
        this.setDirectoryUriAsZipString(string3.replace(SEPARATOR_CHAR, '/'));
        logger.logp(Level.FINER, className, string2, "RETURN");
    }

    protected abstract void addDirectory(java.io.File var1, List var2);

    protected void addFile(java.io.File file, List list) {
        String string = "addFile";
        logger.logp(Level.FINER, className, string, "ENTRY [ {0} ]", file);
        String string2 = this.getURIFrom(file);
        if (this.collectedLooseArchiveFiles.containsKey(string2)) {
            return;
        }
        File file2 = this.createFile(string2);
        file2.setSize(file.length());
        file2.setLastModified(file.lastModified());
        list.add(file2);
        logger.logp(Level.FINER, className, string, "RETURN");
    }

    protected void addFiles(java.io.File file, List list) {
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            java.io.File file2;
            String string = ArchiveUtil.concatUri(file.getPath(), stringArray[i], SEPARATOR_CHAR);
            if (stringArray[i] == null || IS_AIX && ".backup".equals(stringArray[i]) || !(file2 = new java.io.File(string)).exists()) continue;
            if (file2.isDirectory() && !this.isArchive(this.getURIFrom(file2))) {
                this.addDirectory(file2, list);
                continue;
            }
            this.addFile(file2, list);
        }
    }

    protected boolean primContains(String string) {
        return new java.io.File(this.getFileNameFrom(string)).exists();
    }

    public String getAbsolutePath() throws FileNotFoundException {
        String string = "getAbsolutePath";
        logger.logp(Level.FINER, className, string, "ENTRY");
        String string2 = new java.io.File(this.getDirectoryUri()).getAbsolutePath();
        logger.logp(Level.FINER, className, string, "RETURN [ {0} ]", string2);
        return string2;
    }

    protected abstract java.io.File getDirectoryForList();

    public String getDirectoryUri() {
        String string = "getDirectoryUri";
        logger.logp(Level.FINER, className, string, "ENTRY/RETURN [ {0} ]", this.directoryUri);
        return this.directoryUri;
    }

    public String getDirectoryUriAsZipString() {
        return this.directoryUriAsZipString;
    }

    protected String getFileNameFrom(String string) {
        String string2;
        LooseArchive looseArchive = this.getLooseArchive();
        if (looseArchive != null) {
            string2 = null;
            switch (looseArchive.eClass().getClassifierID()) {
                case 0: {
                    string2 = this.getURIFromLooseArchivesIfAvailable(((LooseApplication)looseArchive).getLooseArchives(), string);
                    break;
                }
                case 5: {
                    string2 = this.getURIFromLooseArchivesIfAvailable(((LooseWARFile)looseArchive).getLooseLibs(), string);
                }
            }
            if (string2 != null) {
                return string2;
            }
        }
        string2 = string;
        if (SEPARATOR_CHAR != '/') {
            string2 = string2.replace('/', SEPARATOR_CHAR);
        }
        return this.getDirectoryUri() + SEPARATOR_CHAR + string2;
    }

    private String getURIFromLooseArchivesIfAvailable(List list, String string) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            LooseArchive looseArchive = (LooseArchive)iterator.next();
            if (!string.equals(looseArchive.getUri())) continue;
            return looseArchive.getBinariesPath();
        }
        return null;
    }

    public List getFiles() {
        String string = "getFiles";
        logger.logp(Level.FINER, className, string, "URI [ {0} ]", this.directoryUri);
        ArrayList arrayList = new ArrayList();
        java.io.File file = this.getDirectoryForList();
        logger.logp(Level.FINER, className, string, "Directory [ {0} ]", file.getAbsolutePath());
        this.addFiles(file, arrayList);
        logger.logp(Level.FINER, className, string, "RETURN list of [ {0} ] files", Integer.toString(arrayList.size()));
        if (logger.isLoggable(Level.FINEST)) {
            String string2 = "complete list of returned files:\n";
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                string2 = string2 + iterator.next() + "\n";
            }
            logger.logp(Level.FINEST, className, string, string2);
        }
        return arrayList;
    }

    public List getFiles(String string) {
        ArrayList arrayList = new ArrayList();
        java.io.File file = this.getDirectoryForList();
        java.io.File file2 = new java.io.File(file, string);
        this.addFiles(file2, arrayList);
        return arrayList;
    }

    public InputStream getInputStream(String string) throws IOException, FileNotFoundException {
        return new FileInputStream(this.getFileNameFrom(string));
    }

    protected String getURIFrom(java.io.File file) {
        String string = "getURIFrom";
        logger.logp(Level.FINER, className, string, "ENTRY - file [ {0} ]", file);
        String string2 = "";
        String string3 = null;
        String string4 = this.getDirectoryUriAsZipString();
        logger.logp(Level.FINER, className, string, "root [ {0} ]", string4);
        try {
            string2 = file.getCanonicalPath();
            logger.logp(Level.FINER, className, string, "canonical path [ {0} ]", string2);
            string3 = this.makeRelative(string2, string4);
        }
        catch (IOException iOException) {
            logger.logp(Level.FINER, className, string, "Ignoring IOException getting filename");
            string2 = null;
        }
        if (string3 == null) {
            string2 = file.getAbsolutePath();
            logger.logp(Level.FINER, className, string, "absolute path [ {0} ]", string2);
            string3 = this.makeRelative(string2, string4);
        }
        if (string3 == null) {
            string2 = file.getPath();
            logger.logp(Level.FINER, className, string, "file path [ {0} ]", string2);
            string4 = this.replaceSeparators(this.getDirectoryUri());
            logger.logp(Level.FINER, className, string, "root [ {0} ]", string4);
            string3 = this.makeRelative(string2, string4);
        }
        logger.logp(Level.FINER, className, string, "RETURN [ {0} ]", string3);
        return string3;
    }

    private String replaceSeparators(String string) {
        if (java.io.File.separatorChar != '/') {
            return string.replace(java.io.File.separatorChar, '/');
        }
        return string;
    }

    private String makeRelative(String string, String string2) {
        String string3;
        int n;
        if (string == null || string2 == null) {
            return null;
        }
        for (n = string2.length(); n > 0 && string2.charAt(n - 1) == '/'; --n) {
        }
        if (n < string2.length()) {
            if (++n < string2.length()) {
                string2 = string2.substring(0, n);
            }
        } else {
            string2 = string2 + '/';
        }
        string3 = (string3 = this.replaceSeparators(string)).startsWith(string2) ? string3.substring(string2.length()) : null;
        return string3;
    }

    public boolean isDirectory() {
        return true;
    }

    public boolean isUsing(java.io.File file) {
        java.io.File file2 = new java.io.File(this.getDirectoryUri());
        return file2.equals(file);
    }

    public void setDirectoryUri(String string) {
        String string2 = "setDirectoryUri";
        logger.logp(Level.FINER, className, string2, "ENTRY/RETURN [ {0} ]", string);
        this.directoryUri = string;
    }

    public void setDirectoryUriAsZipString(String string) {
        String string2 = "setDirectoryUriAsZipString";
        logger.logp(Level.FINER, className, string2, "ENTRY/RETURN [ {0} ]", string);
        this.directoryUriAsZipString = string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

