/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveURIConverterImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ZipStreamSaveStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;

public class ConnectorDirectorySaveStrategyImpl
extends SaveStrategyImpl
implements SaveStrategy {
    protected String directoryName;
    protected URIConverter uriConverter;
    protected int expansionFlags;

    public ConnectorDirectorySaveStrategyImpl() {
    }

    public ConnectorDirectorySaveStrategyImpl(String string, int n) {
        this.setDirectoryName(string);
        this.setExpansionFlags(n);
        this.initialize();
    }

    protected SaveStrategy createNestedDirectoryStrategy(Archive archive) {
        String string = ArchiveUtil.getOSUri(this.getDirectoryName(), "");
        return new ConnectorDirectorySaveStrategyImpl(string, this.getExpansionFlags());
    }

    protected SaveStrategy createNestedSaveStrategy(Archive archive) throws IOException {
        if (this.shouldExpand(archive)) {
            return this.createNestedDirectoryStrategy(archive);
        }
        return this.createNestedZipStrategy(archive);
    }

    protected SaveStrategy createNestedZipStrategy(Archive archive) throws IOException {
        OutputStream outputStream = this.getUriConverter().createOutputStream(URI.createURI(archive.getURI()));
        return new ZipStreamSaveStrategyImpl(outputStream);
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public int getExpansionFlags() {
        return this.expansionFlags;
    }

    protected OutputStream getOutputStreamForResource(Resource resource) throws IOException {
        return this.getUriConverter().createOutputStream(resource.getURI());
    }

    public URIConverter getUriConverter() {
        return this.uriConverter;
    }

    public void initialize() {
        ArchiveURIConverterImpl archiveURIConverterImpl = new ArchiveURIConverterImpl(this.getArchive(), this.getDirectoryName());
        archiveURIConverterImpl.setOutputFilepath(this.getDirectoryName());
        this.setUriConverter(archiveURIConverterImpl);
    }

    public boolean isDirectory() {
        return true;
    }

    protected void mkdirs(String string) {
        java.io.File file = new java.io.File(this.getDirectoryName() + java.io.File.separatorChar + string);
        file.mkdirs();
    }

    public void save(ArchiveManifest archiveManifest) throws SaveFailureException {
        try {
            OutputStream outputStream = this.getUriConverter().createOutputStream(URI.createURI("META-INF/MANIFEST.MF"));
            archiveManifest.write(outputStream);
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new SaveFailureException("META-INF/MANIFEST.MF", iOException);
        }
    }

    public void save(File file, InputStream inputStream) throws SaveFailureException {
        String string = file.getURI();
        if (file.isDirectoryEntry()) {
            this.mkdirs(string);
        } else {
            try {
                OutputStream outputStream = this.getUriConverter().createOutputStream(URI.createURI(string));
                ArchiveUtil.copy(inputStream, outputStream);
            }
            catch (IOException iOException) {
                throw new SaveFailureException(file.getURI(), iOException);
            }
        }
    }

    protected void saveMofResource(Resource resource, OutputStream outputStream) throws IOException {
        super.saveMofResource(resource, outputStream);
        outputStream.close();
    }

    public void setDirectoryName(String string) {
        this.directoryName = string;
    }

    public void setExpansionFlags(int n) {
        this.expansionFlags = n;
    }

    public void setUriConverter(URIConverter uRIConverter) {
        this.uriConverter = uRIConverter;
    }

    protected boolean shouldExpand(Archive archive) {
        int n = 0;
        n = archive.isWARFile() ? 2 : (archive.isEARFile() ? 4 : (archive.isEJBJarFile() ? 8 : (archive.isRARFile() ? 64 : (archive.isApplicationClientFile() ? 16 : 32))));
        return (this.getExpansionFlags() & n) != 0;
    }
}

