/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DeploymentDescriptorLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.RuntimeClasspathEntry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ModuleFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.WarFileDynamicClassLoader;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseLibrary;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseWARFile;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebapplicationPackage;

public class WARFileImpl
extends ModuleFileImpl
implements WARFile {
    protected WebApp deploymentDescriptor = null;
    protected List sourceFiles;
    private static final Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    private static final String className = (class$org$eclipse$jst$j2ee$commonarchivecore$internal$impl$WARFileImpl == null ? (class$org$eclipse$jst$j2ee$commonarchivecore$internal$impl$WARFileImpl = WARFileImpl.class$("org.eclipse.jst.j2ee.commonarchivecore.internal.impl.WARFileImpl")) : class$org$eclipse$jst$j2ee$commonarchivecore$internal$impl$WARFileImpl).getName();
    static /* synthetic */ Class class$org$eclipse$jst$j2ee$commonarchivecore$internal$impl$WARFileImpl;

    protected EClass eStaticClass() {
        return CommonarchivePackage.Literals.WAR_FILE;
    }

    public File addCopyClass(File file) throws DuplicateObjectException {
        if (file.isReadOnlyDirectory()) {
            throw new IllegalArgumentException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.add_copy_class_dir_EXC_, new Object[]{file.getURI()}));
        }
        return this.addCopyFileAddingPrefix(file, "WEB-INF/classes/");
    }

    protected File addCopyFileAddingPrefix(File file, String string) throws DuplicateObjectException {
        String string2 = file.getURI();
        if (!string2.startsWith(string)) {
            string2 = ArchiveUtil.concatUri(string, string2, '/');
        }
        this.checkAddValid(string2);
        File file2 = this.copy(file);
        file2.setURI(string2);
        this.getFiles().add(file2);
        return file2;
    }

    public File addCopyLib(File file) throws DuplicateObjectException {
        if (file.isReadOnlyDirectory()) {
            throw new IllegalArgumentException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.add_copy_lib_dir_EXC_, new Object[]{file.getURI()}));
        }
        return this.addCopyFileAddingPrefix(file, "WEB-INF/lib/");
    }

    protected RuntimeClasspathEntry createLibClasspathEntry(String string) {
        RuntimeClasspathEntry runtimeClasspathEntry = this.createRuntimeClasspathEntry(string);
        runtimeClasspathEntry.setWarFile(this);
        return runtimeClasspathEntry;
    }

    protected List getAllFileEntriesRecursive(java.io.File file, List list) {
        if (!file.exists()) {
            return list;
        }
        String string = file.getName();
        if (string.regionMatches(true, string.length() - 4, ".jar", 0, 4)) {
            list.add(file.getAbsolutePath());
        } else if (file.isDirectory()) {
            java.io.File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                this.getAllFileEntriesRecursive(fileArray[i], list);
            }
        }
        return list;
    }

    public List getClasses() {
        return this.filterFilesByPrefix("WEB-INF/classes/");
    }

    public WebApp getDeploymentDescriptor() throws DeploymentDescriptorLoadException {
        String string = "getDeploymentDescriptor";
        logger.entering(className, string);
        WebApp webApp = this.getDeploymentDescriptorGen();
        if (webApp == null && this.canLazyInitialize()) {
            try {
                this.getImportStrategy().importMetaData();
            }
            catch (Exception exception) {
                logger.severe(exception.getMessage());
                logger.exiting(className, string, "Throwing DeploymentDescriptorLoadException");
                throw new DeploymentDescriptorLoadException(this.getDeploymentDescriptorUri(), exception);
            }
        }
        WebApp webApp2 = this.getDeploymentDescriptorGen();
        logger.exiting(className, string, webApp2);
        return webApp2;
    }

    public String getDeploymentDescriptorUri() {
        return "WEB-INF/web.xml";
    }

    public List getLibs() {
        return this.filterFilesByPrefix("WEB-INF/lib/");
    }

    public List getLibArchives() {
        return this.filterFiles("WEB-INF/lib/", new String[]{"jar", "zip"});
    }

    public List getResources() {
        String[] stringArray = new String[]{"META-INF", "WEB-INF"};
        return this.filterFilesWithoutPrefix(stringArray);
    }

    public RuntimeClasspathEntry[] getLocalRuntimeClassPath() {
        String string;
        try {
            string = this.getLoadStrategy().getBinariesPath();
        }
        catch (IOException iOException) {
            return new RuntimeClasspathEntry[0];
        }
        ArrayList<RuntimeClasspathEntry> arrayList = new ArrayList<RuntimeClasspathEntry>();
        if (this.getLoadStrategy().isDirectory()) {
            String string2 = ArchiveUtil.getOSUri(string, "WEB-INF/classes/");
            arrayList.add(this.createRuntimeClasspathEntry(string2));
            this.addWebLibs(string, arrayList);
        }
        arrayList.add(this.createRuntimeClasspathEntry(string));
        return arrayList.toArray(new RuntimeClasspathEntry[arrayList.size()]);
    }

    protected void addWebLibs(String string, List list) {
        java.io.File file = new java.io.File(ArchiveUtil.getOSUri(string, "WEB-INF/lib/"));
        List list2 = this.getAllFileEntriesRecursive(file, new ArrayList());
        for (int i = 0; i < list2.size(); ++i) {
            String string2 = (String)list2.get(i);
            list.add(this.createLibClasspathEntry(string2));
        }
        this.addLooseLibsToRuntimeClasspath(list);
    }

    protected void addLooseLibsToRuntimeClasspath(List list) {
        LooseWARFile looseWARFile = (LooseWARFile)this.getLoadStrategy().getLooseArchive();
        if (looseWARFile == null) {
            return;
        }
        EList eList = looseWARFile.getLooseLibs();
        for (int i = 0; i < eList.size(); ++i) {
            LooseLibrary looseLibrary = (LooseLibrary)eList.get(i);
            list.add(this.createLibClasspathEntry(looseLibrary.getBinariesPath()));
        }
    }

    protected List calculateSourceCandidateFiles() {
        EList eList = this.getFiles();
        Vector<File> vector = new Vector<File>();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            String string = file.getURI();
            if (!string.startsWith("WEB-INF") || string.startsWith("WEB-INF/lib/")) continue;
            vector.add(file);
        }
        return vector;
    }

    protected List getSourceCandidateFiles() {
        if (this.sourceFiles == null) {
            this.sourceFiles = this.calculateSourceCandidateFiles();
        }
        return this.sourceFiles;
    }

    protected String makeRelative(String string, String string2) {
        if (string.startsWith(string2)) {
            return ArchiveUtil.truncateFromFrontIgnoreCase(string, string2);
        }
        return string;
    }

    public File getSourceFile(File file) {
        String string;
        List list = this.getSourceCandidateFiles();
        String string2 = string = file.getURI();
        if (!string.endsWith(".class")) {
            return null;
        }
        string2 = ArchiveUtil.classUriToJavaUri(file.getURI());
        string2 = this.makeRelative(string2, "WEB-INF/classes/");
        int n = Short.MAX_VALUE;
        File file2 = null;
        File file3 = null;
        String string3 = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int n2;
            file3 = (File)iterator.next();
            string3 = file3.getURI();
            if (!string3.endsWith(string2) || string3.equals(string) || (n2 = string3.length() - string2.length()) >= n) continue;
            file2 = file3;
            n = n2;
        }
        return file2;
    }

    public EObject getStandardDeploymentDescriptor() throws DeploymentDescriptorLoadException {
        return this.getDeploymentDescriptor();
    }

    public boolean isDeploymentDescriptorSet() {
        return this.deploymentDescriptor != null;
    }

    public boolean isWARFile() {
        return true;
    }

    public EObject makeDeploymentDescriptor(XMLResource xMLResource) {
        WebApp webApp = ((WebapplicationPackage)EPackage.Registry.INSTANCE.getEPackage("webapplication.xmi")).getWebapplicationFactory().createWebApp();
        xMLResource.setID((EObject)webApp, "WebApp_ID");
        this.setDeploymentDescriptorGen(webApp);
        xMLResource.getContents().add(webApp);
        return webApp;
    }

    public void setDeploymentDescriptor(WebApp webApp) {
        this.setDeploymentDescriptorGen(webApp);
        this.replaceRoot(this.getMofResourceMakeIfNecessary(this.getDeploymentDescriptorUri()), (EObject)webApp);
    }

    public WebApp getDeploymentDescriptorGen() {
        if (this.deploymentDescriptor != null && this.deploymentDescriptor.eIsProxy()) {
            InternalEObject internalEObject = (InternalEObject)this.deploymentDescriptor;
            this.deploymentDescriptor = (WebApp)this.eResolveProxy(internalEObject);
            if (this.deploymentDescriptor != internalEObject && this.eNotificationRequired()) {
                this.eNotify(new ENotificationImpl((InternalEObject)this, 9, 9, (Object)internalEObject, (Object)this.deploymentDescriptor));
            }
        }
        return this.deploymentDescriptor;
    }

    public WebApp basicGetDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public void setDeploymentDescriptorGen(WebApp webApp) {
        WebApp webApp2 = this.deploymentDescriptor;
        this.deploymentDescriptor = webApp;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 9, (Object)webApp2, (Object)this.deploymentDescriptor));
        }
    }

    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 9: {
                if (bl) {
                    return this.getDeploymentDescriptor();
                }
                return this.basicGetDeploymentDescriptor();
            }
        }
        return super.eGet(n, bl, bl2);
    }

    public void eSet(int n, Object object) {
        switch (n) {
            case 9: {
                this.setDeploymentDescriptor((WebApp)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    public void eUnset(int n) {
        switch (n) {
            case 9: {
                this.setDeploymentDescriptor(null);
                return;
            }
        }
        super.eUnset(n);
    }

    public boolean eIsSet(int n) {
        switch (n) {
            case 9: {
                return this.deploymentDescriptor != null;
            }
        }
        return super.eIsSet(n);
    }

    public ClassLoader createDynamicClassLoader(ClassLoader classLoader, ClassLoader classLoader2) {
        return new WarFileDynamicClassLoader(this, classLoader, classLoader2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

