/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.impl;

import java.io.IOException;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.RARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DeploymentDescriptorLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ModuleFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ConnectorDirectorySaveStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.RarFileDynamicClassLoader;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.jst.j2ee.jca.JcaFactory;
import org.eclipse.jst.j2ee.jca.JcaPackage;

public class RARFileImpl
extends ModuleFileImpl
implements RARFile {
    protected Connector deploymentDescriptor = null;

    protected EClass eStaticClass() {
        return CommonarchivePackage.Literals.RAR_FILE;
    }

    public File addCopyClass(File file) throws DuplicateObjectException {
        if (file.isReadOnlyDirectory()) {
            throw new IllegalArgumentException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.add_copy_class_dir_EXC_, new Object[]{file.getURI()}));
        }
        return this.addCopyFileAddingPrefix(file, "WEB-INF/classes/");
    }

    protected File addCopyFileAddingPrefix(File file, String string) throws DuplicateObjectException {
        String string2 = file.getURI();
        if (!string2.startsWith(string)) {
            string2 = ArchiveUtil.concatUri(string, string2, '/');
        }
        this.checkAddValid(string2);
        File file2 = this.copy(file);
        file2.setURI(string2);
        this.getFiles().add(file2);
        return file2;
    }

    protected SaveStrategy createSaveStrategyForConnectorDirectory(java.io.File file, int n) {
        return new ConnectorDirectorySaveStrategyImpl(file.getAbsolutePath(), n);
    }

    public void extractToConnectorDirectory(String string, int n) throws SaveFailureException {
        java.io.File file = new java.io.File(string);
        if (this.getLoadStrategy().isUsing(file)) {
            throw new SaveFailureException(CommonArchiveResourceHandler.Extract_destination_is_the_EXC_);
        }
        try {
            SaveStrategy saveStrategy = this.createSaveStrategyForConnectorDirectory(file, n);
            this.save(saveStrategy);
            saveStrategy.close();
        }
        catch (IOException iOException) {
            throw new SaveFailureException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.error_saving_EXC_, new Object[]{this.uri}), iOException);
        }
    }

    public List getClasses() {
        return this.filterFilesByPrefix("com");
    }

    public Connector getDeploymentDescriptor() throws DeploymentDescriptorLoadException {
        Connector connector = this.deploymentDescriptor;
        if (connector == null && this.canLazyInitialize()) {
            try {
                this.getImportStrategy().importMetaData();
            }
            catch (Exception exception) {
                throw new DeploymentDescriptorLoadException(this.getDeploymentDescriptorUri(), exception);
            }
        }
        return this.deploymentDescriptor;
    }

    public Connector basicGetDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public String getDeploymentDescriptorUri() {
        return "META-INF/ra.xml";
    }

    public List getResources() {
        String[] stringArray = new String[]{"META-INF", "WEB-INF"};
        return this.filterFilesWithoutPrefix(stringArray);
    }

    public EObject getStandardDeploymentDescriptor() throws DeploymentDescriptorLoadException {
        return this.getDeploymentDescriptor();
    }

    public boolean isDeploymentDescriptorSet() {
        return this.deploymentDescriptor != null;
    }

    public boolean isRARFile() {
        return true;
    }

    public EObject makeDeploymentDescriptor(XMLResource xMLResource) {
        JcaPackage jcaPackage = (JcaPackage)EPackage.Registry.INSTANCE.getEPackage("jca.xmi");
        JcaFactory jcaFactory = jcaPackage.getJcaFactory();
        Connector connector = jcaFactory.createConnector();
        this.setDeploymentDescriptor(connector);
        xMLResource.getContents().add(connector);
        return connector;
    }

    public void setDeploymentDescriptor(Connector connector) {
        this.deploymentDescriptor = connector;
        this.replaceRoot(this.getMofResourceMakeIfNecessary(this.getDeploymentDescriptorUri()), (EObject)connector);
    }

    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 9: {
                if (bl) {
                    return this.getDeploymentDescriptor();
                }
                return this.basicGetDeploymentDescriptor();
            }
        }
        return super.eGet(n, bl, bl2);
    }

    public void eSet(int n, Object object) {
        switch (n) {
            case 9: {
                this.setDeploymentDescriptor((Connector)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    public void eUnset(int n) {
        switch (n) {
            case 9: {
                this.setDeploymentDescriptor(null);
                return;
            }
        }
        super.eUnset(n);
    }

    public boolean eIsSet(int n) {
        switch (n) {
            case 9: {
                return this.deploymentDescriptor != null;
            }
        }
        return super.eIsSet(n);
    }

    public ClassLoader createDynamicClassLoader(ClassLoader classLoader, ClassLoader classLoader2) {
        return new RarFileDynamicClassLoader(this, classLoader, classLoader2);
    }
}

