/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.common.internal.impl.J2EEEObjectImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveFactoryRegistry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveRuntimeException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveWrappedException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.NoModuleFileException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ResourceLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;

public abstract class ModuleRefImpl
extends J2EEEObjectImpl
implements ModuleRef {
    protected static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    private static final String className = (class$org$eclipse$jst$j2ee$commonarchivecore$internal$impl$ModuleRefImpl == null ? (class$org$eclipse$jst$j2ee$commonarchivecore$internal$impl$ModuleRefImpl = ModuleRefImpl.class$("org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ModuleRefImpl")) : class$org$eclipse$jst$j2ee$commonarchivecore$internal$impl$ModuleRefImpl).getName();
    protected ModuleFile moduleFile = null;
    protected Module module = null;
    static /* synthetic */ Class class$org$eclipse$jst$j2ee$commonarchivecore$internal$impl$ModuleRefImpl;
    static /* synthetic */ Class class$org$eclipse$jst$j2ee$commonarchivecore$internal$EARFile;

    protected ModuleRefImpl() {
    }

    protected EClass eStaticClass() {
        return CommonarchivePackage.Literals.MODULE_REF;
    }

    protected CommonarchiveFactory getCommonArchiveFactory() {
        return CommonArchiveFactoryRegistry.INSTANCE.getCommonArchiveFactory();
    }

    protected void buildComponentList(EList eList) {
    }

    public ModuleFile getModuleFileGen() {
        if (this.moduleFile != null && this.moduleFile.eIsProxy()) {
            InternalEObject internalEObject = (InternalEObject)((Object)this.moduleFile);
            this.moduleFile = (ModuleFile)this.eResolveProxy(internalEObject);
            if (this.moduleFile != internalEObject && this.eNotificationRequired()) {
                this.eNotify(new ENotificationImpl((InternalEObject)this, 9, 0, (Object)internalEObject, (Object)this.moduleFile));
            }
        }
        return this.moduleFile;
    }

    public ModuleFile getModuleFile() {
        if (this.moduleFile == null) {
            this.initModuleFileFromEAR();
        }
        return this.moduleFile;
    }

    public ModuleFile basicGetModuleFile() {
        return this.moduleFile;
    }

    protected void initModuleFileFromEAR() {
        ModuleFile moduleFile;
        String string;
        block4: {
            string = "initModuleFileFromEAR";
            String string2 = this.module.getUri();
            logger.entering(className, string, string2);
            this.checkEARFile();
            logger.logp(Level.FINER, className, string, "Checked EARFile");
            moduleFile = null;
            EARFile eARFile = null;
            try {
                eARFile = this.getEarFile();
                logger.logp(Level.FINER, className, string, "EAR [ {0} ]", eARFile);
                moduleFile = (ModuleFile)eARFile.getFile(string2);
                logger.logp(Level.FINER, className, string, "Module file [ {0} ]", moduleFile);
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.logp(Level.WARNING, className, string, "Ignoring FileNotFoundException [ {0} ]", fileNotFoundException.getMessage());
                if (logger.isLoggable(Level.FINEST)) {
                    this.displayModuleRef();
                    new Throwable("Debug data for FileNotFoundException in initModuleFileFromEAR").printStackTrace(System.out);
                }
                moduleFile = (ModuleFile)eARFile.getModule(string2, this.module.getAltDD());
            }
            catch (ClassCastException classCastException) {
                logger.logp(Level.WARNING, className, string, "Ignoring ClassCastException [ {0} ]", classCastException.getMessage());
                if (!logger.isLoggable(Level.FINEST)) break block4;
                this.displayModuleRef();
                new Throwable("Debug data for ClassCastException in initModuleFileFromEAR").printStackTrace(System.out);
            }
        }
        this.checkType(this.module, moduleFile);
        this.setModuleFile(moduleFile);
        logger.exiting(className, string);
    }

    public void setModuleFile(ModuleFile moduleFile) {
        ModuleFile moduleFile2 = this.moduleFile;
        this.moduleFile = moduleFile;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 0, (Object)moduleFile2, (Object)this.moduleFile));
        }
    }

    public boolean usesAltDD() {
        if (this.module == null) {
            return false;
        }
        return !ArchiveUtil.isNullOrEmpty(this.module.getAltDD());
    }

    public EObject getAltDeploymentDescriptor() throws ArchiveWrappedException {
        if (this.getEarFile() == null) {
            return null;
        }
        try {
            return this.getEarFile().getAltDeploymentDescriptor(this.getModule());
        }
        catch (Exception exception) {
            throw new ArchiveWrappedException(exception);
        }
    }

    public EObject getDeploymentDescriptor() throws ArchiveWrappedException {
        if (this.getEarFile() == null) {
            return this.getStandardDeploymentDescriptor();
        }
        try {
            return this.getEarFile().getDeploymentDescriptor(this.getModule());
        }
        catch (Exception exception) {
            throw new ArchiveWrappedException(exception);
        }
    }

    public EObject getStandardDeploymentDescriptor() {
        if (this.getModuleFile() == null) {
            return null;
        }
        return this.getModuleFile().getStandardDeploymentDescriptor();
    }

    public void setURI(String string) {
        if (this.getModuleFile() != null) {
            this.getModuleFile().setURI(string);
        }
        if (this.getModule() != null) {
            this.getModule().setUri(string);
        }
    }

    public boolean isClient() {
        return false;
    }

    public boolean isConnector() {
        return false;
    }

    public boolean isEJB() {
        return false;
    }

    public boolean isWeb() {
        return false;
    }

    public EARFile getEarFile() {
        if (this.eContainerFeatureID != 1) {
            return null;
        }
        return (EARFile)this.eContainer();
    }

    public NotificationChain basicSetEarFile(EARFile eARFile, NotificationChain notificationChain) {
        notificationChain = this.eBasicSetContainer((InternalEObject)((Object)eARFile), 1, notificationChain);
        return notificationChain;
    }

    public void setEarFile(EARFile eARFile) {
        if (eARFile != this.eInternalContainer() || this.eContainerFeatureID != 1 && eARFile != null) {
            if (EcoreUtil.isAncestor(this, (EObject)eARFile)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain notificationChain = null;
            if (this.eInternalContainer() != null) {
                notificationChain = this.eBasicRemoveFromContainer(notificationChain);
            }
            if (eARFile != null) {
                notificationChain = ((InternalEObject)((Object)eARFile)).eInverseAdd(this, 9, class$org$eclipse$jst$j2ee$commonarchivecore$internal$EARFile == null ? (class$org$eclipse$jst$j2ee$commonarchivecore$internal$EARFile = ModuleRefImpl.class$("org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile")) : class$org$eclipse$jst$j2ee$commonarchivecore$internal$EARFile, notificationChain);
            }
            if ((notificationChain = this.basicSetEarFile(eARFile, notificationChain)) != null) {
                notificationChain.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 1, (Object)eARFile, (Object)eARFile));
        }
    }

    public Module getModule() {
        if (this.module != null && this.module.eIsProxy()) {
            Module module = this.module;
            this.module = (Module)EcoreUtil.resolve((EObject)this.module, this);
            if (this.module != module && this.eNotificationRequired()) {
                this.eNotify(new ENotificationImpl((InternalEObject)this, 9, 2, (Object)module, (Object)this.module));
            }
        }
        return this.module;
    }

    public Module basicGetModule() {
        return this.module;
    }

    public void setModule(Module module) {
        Module module2 = this.module;
        this.module = module;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 2, (Object)module2, (Object)this.module));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject internalEObject, int n, NotificationChain notificationChain) {
        switch (n) {
            case 1: {
                if (this.eInternalContainer() != null) {
                    notificationChain = this.eBasicRemoveFromContainer(notificationChain);
                }
                return this.basicSetEarFile((EARFile)((Object)internalEObject), notificationChain);
            }
        }
        return super.eInverseAdd(internalEObject, n, notificationChain);
    }

    public NotificationChain eInverseRemove(InternalEObject internalEObject, int n, NotificationChain notificationChain) {
        switch (n) {
            case 1: {
                return this.basicSetEarFile(null, notificationChain);
            }
        }
        return super.eInverseRemove(internalEObject, n, notificationChain);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain notificationChain) {
        switch (this.eContainerFeatureID) {
            case 1: {
                return this.eInternalContainer().eInverseRemove(this, 9, class$org$eclipse$jst$j2ee$commonarchivecore$internal$EARFile == null ? (class$org$eclipse$jst$j2ee$commonarchivecore$internal$EARFile = ModuleRefImpl.class$("org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile")) : class$org$eclipse$jst$j2ee$commonarchivecore$internal$EARFile, notificationChain);
            }
        }
        return super.eBasicRemoveFromContainerFeature(notificationChain);
    }

    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 0: {
                if (bl) {
                    return this.getModuleFile();
                }
                return this.basicGetModuleFile();
            }
            case 1: {
                return this.getEarFile();
            }
            case 2: {
                if (bl) {
                    return this.getModule();
                }
                return this.basicGetModule();
            }
        }
        return super.eGet(n, bl, bl2);
    }

    public void eSet(int n, Object object) {
        switch (n) {
            case 0: {
                this.setModuleFile((ModuleFile)object);
                return;
            }
            case 1: {
                this.setEarFile((EARFile)object);
                return;
            }
            case 2: {
                this.setModule((Module)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    public void eUnset(int n) {
        switch (n) {
            case 0: {
                this.setModuleFile(null);
                return;
            }
            case 1: {
                this.setEarFile(null);
                return;
            }
            case 2: {
                this.setModule(null);
                return;
            }
        }
        super.eUnset(n);
    }

    public boolean eIsSet(int n) {
        switch (n) {
            case 0: {
                return this.moduleFile != null;
            }
            case 1: {
                return this.getEarFile() != null;
            }
            case 2: {
                return this.module != null;
            }
        }
        return super.eIsSet(n);
    }

    public InputStream getResourceInputStream(String string) throws IOException {
        if (this.usesAltDD()) {
            return this.getAltResourceInputStream(string);
        }
        return this.getLocalResourceInputStream(string);
    }

    public InputStream getLocalResourceInputStream(String string) throws IOException {
        this.checkModuleFile();
        return this.moduleFile.getResourceInputStream(string);
    }

    public InputStream getAltResourceInputStream(String string) throws IOException {
        this.checkEARFile();
        return this.getEarFile().getResourceInputStream(string);
    }

    public String getUri() {
        if (this.module != null) {
            return this.module.getUri();
        }
        if (this.moduleFile != null) {
            return this.moduleFile.getURI();
        }
        return null;
    }

    public Resource getAltMofResource(String string) throws FileNotFoundException, ResourceLoadException {
        this.checkEARFile();
        return this.getEarFile().getMofResource(string);
    }

    public Resource getLocalMofResource(String string) throws FileNotFoundException, ResourceLoadException {
        this.checkModuleFile();
        return this.moduleFile.getMofResource(string);
    }

    public Resource getMofResource(String string) throws FileNotFoundException, ResourceLoadException {
        if (this.usesAltDD()) {
            return this.getAltMofResource(string);
        }
        return this.getLocalMofResource(string);
    }

    public Resource makeAltMofResource(String string) throws DuplicateObjectException {
        this.checkEARFile();
        return this.getEarFile().makeMofResource(string);
    }

    protected void checkEARFile() {
        if (this.getEarFile() == null) {
            throw new ArchiveRuntimeException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.Module_not_in_EAR, new Object[]{this.getUri()}));
        }
    }

    public Resource makeLocalMofResource(String string) throws DuplicateObjectException {
        this.checkModuleFile();
        return this.moduleFile.makeMofResource(string);
    }

    protected void checkModuleFile() {
        this.getModuleFile();
        if (this.moduleFile == null) {
            throw new NoModuleFileException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.Module_file_does_not_exist_2, new Object[]{this.getUri()}));
        }
    }

    protected void checkType(Module module, File file) {
        String string = "checkType";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, string, "ENTRY - module [ " + module + " ]\n               File [ " + file + " ]");
        }
        if (file == null) {
            String string2 = CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.A_file_does_not_exist_for_module, new Object[]{module.getUri()});
            logger.logp(Level.FINER, className, string, "RETURN No file specified.  Throwing NoModuleFileException");
            throw new NoModuleFileException(string2);
        }
        boolean bl = true;
        String string3 = CommonArchiveResourceHandler.Module_file;
        if (module.isWebModule() && !file.isWARFile()) {
            bl = false;
            string3 = CommonArchiveResourceHandler.A_WAR_file;
        } else if (module.isEjbModule() && !file.isEJBJarFile()) {
            bl = false;
            string3 = CommonArchiveResourceHandler.An_EJB_JAR_file;
        } else if (module.isJavaModule() && !file.isApplicationClientFile()) {
            bl = false;
            string3 = CommonArchiveResourceHandler.An_Application_Client_JAR_file;
        } else if (module.isConnectorModule() && !file.isRARFile()) {
            bl = false;
            string3 = CommonArchiveResourceHandler.A_RAR_file;
        } else if (!file.isModuleFile()) {
            bl = false;
        }
        if (bl) {
            logger.logp(Level.FINER, className, string, "RETURN Type is valid [ {0} ]", string3);
            return;
        }
        String string4 = "";
        if (this.getEarFile() != null) {
            string4 = this.getEarFile().getURI();
        }
        String string5 = CommonArchiveResourceHandler.getString("File_not_correct_type", new Object[]{file.getURI(), string4, string3});
        logger.exiting(className, string, "Throwing ArchiveRuntimeException");
        throw new ArchiveRuntimeException(string5);
    }

    public Resource makeMofResource(String string) throws DuplicateObjectException {
        if (this.usesAltDD()) {
            return this.makeAltMofResource(string);
        }
        return this.makeLocalMofResource(string);
    }

    void displayModuleRef() {
        String string = "\n    \nDescribing ModuleRef\n";
        string = string + "\n    Module   [ " + this.module + " ]";
        if (this.module != null) {
            string = string + "\n      Module URI [ " + this.module.getUri() + " ]";
        }
        EARFile eARFile = this.getEarFile();
        string = string + "\n    EAR File   [ " + eARFile + " ]";
        if (eARFile != null) {
            try {
                string = string + "\n      EAR AbsolutePath [ " + eARFile.getAbsolutePath() + " ]";
            }
            catch (FileNotFoundException fileNotFoundException) {
                string = string + "\n      EAR AbsolutePath [ unknown ]";
            }
            try {
                string = string + "\n      EAR BinariesPath [ " + eARFile.getBinariesPath() + " ]";
            }
            catch (FileNotFoundException fileNotFoundException) {
                string = string + "\n      EAR BinariesPath [ unknown ]";
            }
            string = string + "\n      EAR Options [ " + eARFile.getOptions() + " ]";
            ArchiveOptions archiveOptions = eARFile.getOptions();
            string = string + "\n    EAR Options   [ " + archiveOptions + " ]";
            if (archiveOptions != null) {
                string = string + "\n        EAR ParentEarBinariesPath [ " + archiveOptions.getParentEarBinariesPath() + " ]";
                string = string + "\n        EAR AltBinariesPath [ " + archiveOptions.getAltBinariesPath() + " ]";
            }
        }
        logger.finest(string + "\n");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

