/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.impl;

import java.io.FileNotFoundException;
import java.util.logging.Level;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveRuntimeException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ResourceLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ExportStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ArchiveImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ImportStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategy;
import org.eclipse.jst.j2ee.internal.common.XMLResource;

public abstract class ModuleFileImpl
extends ArchiveImpl
implements ModuleFile {
    protected ImportStrategy importStrategy;
    protected ExportStrategy exportStrategy;
    private static final String className = (class$org$eclipse$jst$j2ee$commonarchivecore$internal$impl$ModuleFileImpl == null ? (class$org$eclipse$jst$j2ee$commonarchivecore$internal$impl$ModuleFileImpl = ModuleFileImpl.class$("org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ModuleFileImpl")) : class$org$eclipse$jst$j2ee$commonarchivecore$internal$impl$ModuleFileImpl).getName();
    static /* synthetic */ Class class$org$eclipse$jst$j2ee$commonarchivecore$internal$impl$ModuleFileImpl;

    protected EClass eStaticClass() {
        return CommonarchivePackage.Literals.MODULE_FILE;
    }

    protected boolean canLazyInitialize() {
        return this.getImportStrategy() != null;
    }

    public Resource getDeploymentDescriptorResource() throws FileNotFoundException, ResourceLoadException {
        return this.getMofResource(this.getDeploymentDescriptorUri());
    }

    public abstract String getDeploymentDescriptorUri();

    public EARFile getEARFile() {
        String string = "getEARFile";
        logger.entering(className, string, this.getURI());
        Container container = this.getContainer();
        if (container == null || !container.isEARFile()) {
            logger.logp(Level.FINER, className, string, "Container is [ {0} ]", container);
            if (container != null) {
                logger.logp(Level.FINER, className, string, "Container is an instance of [ {0} ]", container.getClass());
            }
            logger.logp(Level.FINER, className, string, "Container is not an EAR file.");
            container = this.getLoadingContainer();
            if (container == null || !container.isEARFile()) {
                logger.logp(Level.FINER, className, string, "Loading Container is [ {0} ]", container);
                if (container != null) {
                    logger.logp(Level.FINER, className, string, "Loading Container is an instance of [ {0} ]", container.getClass());
                }
                logger.logp(Level.FINER, className, string, "RETURN Cannot find EAR file container.");
                return null;
            }
        }
        logger.logp(Level.FINER, className, string, "RETURN [ {0} ]", container);
        return (EARFile)container;
    }

    public ExportStrategy getExportStrategy() {
        return this.exportStrategy;
    }

    public ImportStrategy getImportStrategy() {
        return this.importStrategy;
    }

    public String getSpecVersion() {
        float f = this.getSpecVersionID();
        Float f2 = new Float(f / 10.0f);
        return f2.toString();
    }

    public int getSpecVersionID() {
        try {
            return ((XMLResource)this.getDeploymentDescriptorResource()).getModuleVersionID();
        }
        catch (Exception exception) {
            throw new ArchiveRuntimeException(exception);
        }
    }

    public abstract boolean isDeploymentDescriptorSet();

    public boolean isModuleFile() {
        return true;
    }

    public abstract EObject makeDeploymentDescriptor(XMLResource var1);

    public Resource makeDeploymentDescriptorResource() {
        XMLResource xMLResource = null;
        try {
            xMLResource = (XMLResource)this.makeMofResource(this.getDeploymentDescriptorUri());
        }
        catch (DuplicateObjectException duplicateObjectException) {
            try {
                return this.getDeploymentDescriptorResource();
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        this.makeDeploymentDescriptor(xMLResource);
        return xMLResource;
    }

    public void save(SaveStrategy saveStrategy) throws SaveFailureException {
        this.setSaveStrategy(saveStrategy);
        if (this.getExportStrategy() != null) {
            this.getExportStrategy().preSave(saveStrategy);
        }
        super.save(saveStrategy);
    }

    public void setExportStrategy(ExportStrategy exportStrategy) {
        this.exportStrategy = exportStrategy;
        if (exportStrategy != null) {
            exportStrategy.setArchive(this);
        }
    }

    public void setImportStrategy(ImportStrategy importStrategy) {
        this.importStrategy = importStrategy;
        if (importStrategy != null) {
            importStrategy.setArchive(this);
        }
    }

    public void setJ2EEVersion(int n) {
        try {
            ((XMLResource)this.getDeploymentDescriptorResource()).setVersionID(n);
        }
        catch (ResourceLoadException resourceLoadException) {
            throw resourceLoadException;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ArchiveRuntimeException(fileNotFoundException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

