/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.ApplicationFactory;
import org.eclipse.jst.j2ee.application.ApplicationPackage;
import org.eclipse.jst.j2ee.application.ConnectorModule;
import org.eclipse.jst.j2ee.application.EjbModule;
import org.eclipse.jst.j2ee.application.JavaClientModule;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.client.internal.impl.ApplicationClientResourceFactory;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveWrappedException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DeploymentDescriptorLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.EmptyResourceException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ObjectNotFoundException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ResourceLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ModuleFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseArchive;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EJBResource;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.internal.impl.EJBJarResourceFactory;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.jst.j2ee.jca.internal.impl.ConnectorResourceFactory;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.internal.impl.WebAppResourceFactory;
import org.eclipse.wst.common.internal.emf.resource.FileNameResourceFactoryRegistry;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;

public class EARFileImpl
extends ModuleFileImpl
implements EARFile {
    private static final Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    private static String className = (class$org$eclipse$jst$j2ee$commonarchivecore$internal$impl$EARFileImpl == null ? (class$org$eclipse$jst$j2ee$commonarchivecore$internal$impl$EARFileImpl = EARFileImpl.class$("org.eclipse.jst.j2ee.commonarchivecore.internal.impl.EARFileImpl")) : class$org$eclipse$jst$j2ee$commonarchivecore$internal$impl$EARFileImpl).getName();
    protected Application deploymentDescriptor = null;
    protected EList moduleRefs = null;
    static /* synthetic */ Class class$org$eclipse$jst$j2ee$commonarchivecore$internal$impl$EARFileImpl;
    static /* synthetic */ Class class$org$eclipse$jst$j2ee$commonarchivecore$internal$ModuleRef;

    public ModuleFile getModuleFile(Module module) {
        String string = "getModuleFile";
        logger.logp(Level.FINER, className, string, "ENTRY [ {0} ]", module);
        ModuleRef moduleRef = this.getModuleRef(module);
        ModuleFile moduleFile = moduleRef == null ? null : moduleRef.getModuleFile();
        logger.logp(Level.FINER, className, string, "RETURN [ {0} ]", moduleFile);
        return moduleFile;
    }

    public ModuleFile addCopy(ModuleFile moduleFile) throws DuplicateObjectException {
        Object object = this.primAddCopyRef(moduleFile);
        if (object instanceof ModuleRef) {
            return ((ModuleRef)object).getModuleFile();
        }
        return (ModuleFile)object;
    }

    protected EClass eStaticClass() {
        return CommonarchivePackage.Literals.EAR_FILE;
    }

    public Archive addCopy(Archive archive) throws DuplicateObjectException {
        if (archive.isModuleFile()) {
            return this.addCopy((ModuleFile)archive);
        }
        Archive archive2 = super.addCopy(archive);
        archive2.initializeClassLoader();
        return archive2;
    }

    protected Object primAddCopyRef(ModuleFile moduleFile) throws DuplicateObjectException {
        EList eList = this.getModuleRefs();
        if (moduleFile.isEARFile()) {
            return (ModuleFile)super.addCopy(moduleFile);
        }
        this.checkAddValid(moduleFile);
        ModuleFile moduleFile2 = this.getCommonArchiveFactory().copy(moduleFile);
        Module module = this.createModuleForCopying(moduleFile);
        this.getFiles().add(moduleFile2);
        moduleFile2.initializeClassLoader();
        if (!moduleFile2.getURI().equals(module.getUri())) {
            moduleFile2.setURI(module.getUri());
        }
        this.getDeploymentDescriptor().getModules().add(module);
        ModuleRef moduleRef = this.createModuleRef(module, moduleFile2);
        eList.add(moduleRef);
        return moduleRef;
    }

    public ModuleRef addCopyRef(ModuleFile moduleFile) throws DuplicateObjectException {
        Object object = this.primAddCopyRef(moduleFile);
        if (object instanceof ModuleRef) {
            return (ModuleRef)object;
        }
        return null;
    }

    public SecurityRole addCopy(SecurityRole securityRole, Module module) throws DuplicateObjectException {
        String string = "addCopy";
        String string2 = module.getUri();
        String string3 = securityRole.getRoleName();
        logger.entering(className, string, new Object[]{string3, string2});
        EObject eObject = null;
        try {
            eObject = this.getDeploymentDescriptor(module);
        }
        catch (Exception exception) {
            logger.severe(exception.getMessage());
            logger.exiting(className, string, "Throwing DeploymentDescriptorLoadException");
            String string4 = "";
            if (module.isWebModule()) {
                string4 = "WEB-INF/web.xml";
            } else if (module.isEjbModule()) {
                string4 = "META-INF/ejb-jar.xml";
            }
            throw new DeploymentDescriptorLoadException(CommonArchiveResourceHandler.getString("dd_in_ear_load_EXC_", new Object[]{string4, module.getUri(), this.getURI()}), exception);
        }
        SecurityRole securityRole2 = (SecurityRole)EtoolsCopyUtility.createCopy((EObject)securityRole);
        if (module.isEjbModule()) {
            logger.logp(Level.FINER, className, string, "Module found to be an EJB Module");
            EJBJar eJBJar = (EJBJar)eObject;
            if (eJBJar.containsSecurityRole(string3)) {
                logger.exiting(className, string, "Throwing DuplicateObjectException");
                throw new DuplicateObjectException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.dup_sec_role_module_EXC_, new Object[]{module.getUri(), string3}), eJBJar.getAssemblyDescriptor().getSecurityRoleNamed(string3));
            }
            this.getAssemblyDescriptorAddIfNecessary(eJBJar).getSecurityRoles().add(securityRole2);
        } else if (module.isWebModule()) {
            logger.logp(Level.FINER, className, string, "Module found to be a Web Module");
            WebApp webApp = (WebApp)eObject;
            if (webApp.containsSecurityRole(string3)) {
                logger.exiting(className, string, "Throwing DuplicateObjectException");
                throw new DuplicateObjectException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.dup_sec_role_module_EXC_, new Object[]{module.getUri(), string3}), webApp.getSecurityRoleNamed(string3));
            }
            webApp.getSecurityRoles().add(securityRole2);
        }
        this.addCopyIfNotExists(securityRole);
        logger.exiting(className, string, securityRole2);
        return securityRole2;
    }

    public SecurityRole addCopyIfNotExists(SecurityRole securityRole) {
        Application application = this.getDeploymentDescriptor();
        SecurityRole securityRole2 = null;
        if (!application.containsSecurityRole(securityRole.getRoleName())) {
            securityRole2 = (SecurityRole)EtoolsCopyUtility.createCopy((EObject)securityRole);
            application.getSecurityRoles().add(securityRole2);
        }
        return securityRole2;
    }

    protected void checkDuplicate(String string) throws DuplicateObjectException {
        if (this.isDuplicate(string)) {
            throw new DuplicateObjectException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.dup_resource_EXC_, new Object[]{string, this.getURI()}));
        }
    }

    protected Module createModuleForCopying(ModuleFile moduleFile) {
        WebModule webModule = null;
        if (moduleFile.isWARFile()) {
            webModule = this.getApplicationFactory().createWebModule();
        } else if (moduleFile.isEJBJarFile()) {
            webModule = this.getApplicationFactory().createEjbModule();
        } else if (moduleFile.isApplicationClientFile()) {
            webModule = this.getApplicationFactory().createJavaClientModule();
        } else if (moduleFile.isRARFile()) {
            webModule = this.getApplicationFactory().createConnectorModule();
        }
        webModule.setUri(moduleFile.getURI());
        return webModule;
    }

    public EObject getAltDeploymentDescriptor(Module module) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        XMLResource xMLResource;
        String string = module.getAltDD();
        if (ArchiveUtil.isNullOrEmpty(string)) {
            return null;
        }
        if (!this.isMofResourceLoaded(string.trim())) {
            this.registerResourceFactory(module, string);
        }
        if (!(xMLResource = (XMLResource)this.getMofResource(string.trim())).isAlt()) {
            xMLResource.setIsAlt(true);
            xMLResource.setApplication(this.getDeploymentDescriptor());
        }
        return ArchiveUtil.getRoot((Resource)xMLResource);
    }

    public List getApplicationClientFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        EList eList = this.getFiles();
        for (int i = 0; i < eList.size(); ++i) {
            File file = (File)eList.get(i);
            if (!file.isApplicationClientFile()) continue;
            arrayList.add(file);
        }
        return arrayList;
    }

    protected ApplicationFactory getApplicationFactory() {
        return ((ApplicationPackage)EPackage.Registry.INSTANCE.getEPackage("application.xmi")).getApplicationFactory();
    }

    protected AssemblyDescriptor getAssemblyDescriptorAddIfNecessary(EJBJar eJBJar) {
        String string = "getAssemblyDescriptorAddIfNecessary";
        logger.entering(className, string, eJBJar);
        AssemblyDescriptor assemblyDescriptor = eJBJar.getAssemblyDescriptor();
        if (assemblyDescriptor == null) {
            assemblyDescriptor = ((EjbPackage)EPackage.Registry.INSTANCE.getEPackage("ejb.xmi")).getEjbFactory().createAssemblyDescriptor();
            eJBJar.setAssemblyDescriptor(assemblyDescriptor);
            logger.logp(Level.FINER, className, string, "created Assembly Descriptor");
        } else {
            logger.logp(Level.FINER, className, string, "got existing Assembly Descriptor");
        }
        logger.exiting(className, string, assemblyDescriptor);
        return assemblyDescriptor;
    }

    public Application getDeploymentDescriptor() throws DeploymentDescriptorLoadException {
        String string = "getDeploymentDescriptor";
        logger.entering(className, string);
        Application application = this.getDeploymentDescriptorGen();
        if (application == null && this.canLazyInitialize()) {
            try {
                logger.logp(Level.FINER, className, string, "Must import metadata");
                this.getImportStrategy().importMetaData();
            }
            catch (Exception exception) {
                logger.severe(exception.getMessage());
                logger.exiting(className, string, "Throwing DeploymentDescriptorLoadException");
                throw new DeploymentDescriptorLoadException(this.getDeploymentDescriptorUri(), exception);
            }
        }
        Application application2 = this.getDeploymentDescriptorGen();
        logger.exiting(className, string, application2);
        this.displayDescriptor(application2);
        return application2;
    }

    public Connector getDeploymentDescriptor(ConnectorModule connectorModule) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        return (Connector)this.getDeploymentDescriptor((Module)connectorModule);
    }

    public EJBJar getDeploymentDescriptor(EjbModule ejbModule) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        return (EJBJar)this.getDeploymentDescriptor((Module)ejbModule);
    }

    public ApplicationClient getDeploymentDescriptor(JavaClientModule javaClientModule) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        return (ApplicationClient)this.getDeploymentDescriptor((Module)javaClientModule);
    }

    public EObject getDeploymentDescriptor(Module module) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        String string = "getDeploymentDescriptor - module";
        String string2 = module.getUri();
        logger.entering(className, string, string2);
        EObject eObject = this.getAltDeploymentDescriptor(module);
        if (eObject == null) {
            eObject = this.getModuleFile(module).getStandardDeploymentDescriptor();
            logger.logp(Level.FINER, className, string, "got standard Deployment Descriptor");
        } else {
            logger.logp(Level.FINER, className, string, "got alternate Deployment Descriptor");
        }
        logger.exiting(className, string, eObject);
        return eObject;
    }

    public WebApp getDeploymentDescriptor(WebModule webModule) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        String string = "getDeploymentDescriptor - webmodule";
        String string2 = webModule.getUri();
        logger.entering(className, string, string2);
        WebApp webApp = (WebApp)this.getDeploymentDescriptor((Module)webModule);
        logger.exiting(className, string, webApp);
        return webApp;
    }

    public String getDeploymentDescriptorUri() {
        return "META-INF/application.xml";
    }

    public List getEJBJarFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        EList eList = this.getFiles();
        for (int i = 0; i < eList.size(); ++i) {
            File file = (File)eList.get(i);
            if (!file.isEJBJarFile()) continue;
            arrayList.add(file);
        }
        return arrayList;
    }

    public EnterpriseBean getEnterpiseBeanFromRef(EjbRef ejbRef) {
        String string = ejbRef.getLink();
        if (string == null) {
            return null;
        }
        List list = this.getEJBJarFiles();
        for (int i = 0; i < list.size(); ++i) {
            EnterpriseBean enterpriseBean = ((EJBJarFile)list.get(i)).getDeploymentDescriptor().getEnterpriseBeanNamed(string);
            if (enterpriseBean == null) continue;
            return enterpriseBean;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EnterpriseBean getEnterpiseBeanFromRef(EjbRef ejbRef, String string) {
        String string2 = ejbRef.getLink();
        if (string2 == null) {
            return null;
        }
        if (string2.indexOf(35) == -1) {
            Object object;
            EnterpriseBean enterpriseBean = null;
            XMLResource xMLResource = (XMLResource)ejbRef.eResource();
            if (xMLResource instanceof EJBResource && (object = ((EJBResource)xMLResource).getEJBJar()) != null) {
                enterpriseBean = object.getEnterpiseBeanFromRef(ejbRef);
            }
            if (enterpriseBean != null) return enterpriseBean;
            object = this.getEJBJarFiles();
            for (int i = 0; i < object.size(); ++i) {
                enterpriseBean = ((EJBJarFile)object.get(i)).getDeploymentDescriptor().getEnterpriseBeanNamed(string2);
                if (enterpriseBean == null) continue;
                return enterpriseBean;
            }
            return null;
        } else {
            String string3;
            String string4 = string2.substring(string2.indexOf("#") + 1, string2.length());
            String string5 = string2.substring(0, string2.indexOf("#"));
            if (string4 == null || string5 == null || (string3 = ArchiveUtil.deriveEARRelativeURI(string5, string)) == null) return null;
            try {
                File file = this.getFile(string3);
                if (file == null || !file.isEJBJarFile()) {
                    return null;
                }
                EJBJarFile eJBJarFile = (EJBJarFile)this.getFile(string3);
                EList eList = eJBJarFile.getDeploymentDescriptor().getEnterpriseBeans();
                if (eList == null || eList.isEmpty()) return null;
                Iterator iterator = eList.iterator();
                while (iterator.hasNext()) {
                    EnterpriseBean enterpriseBean = (EnterpriseBean)iterator.next();
                    if (enterpriseBean == null || !enterpriseBean.getName().equals(string4)) continue;
                    return enterpriseBean;
                }
                return null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
    }

    public Module getModule(String string, String string2) {
        return this.getDeploymentDescriptor().getModule(string, string2);
    }

    public ModuleRef getModuleRef(Module module) {
        String string = "getModuleRef";
        logger.logp(Level.FINER, className, string, "ENTRY [ {0} ]", module);
        EList eList = this.getModuleRefs();
        for (int i = 0; i < eList.size(); ++i) {
            ModuleRef moduleRef = (ModuleRef)eList.get(i);
            if (moduleRef.getModule() != module) continue;
            logger.logp(Level.FINER, className, string, "RETURN [ {0} ]", moduleRef);
            return moduleRef;
        }
        logger.logp(Level.FINER, className, string, "RETURN null");
        return null;
    }

    public List getModuleFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        EList eList = this.getFiles();
        for (int i = 0; i < eList.size(); ++i) {
            File file = (File)eList.get(i);
            if (!file.isModuleFile()) continue;
            arrayList.add(file);
        }
        return arrayList;
    }

    protected ArchiveOptions getOptionsForOpening(String string) throws IOException {
        LoadStrategy loadStrategy = this.getCommonArchiveFactory().createChildLoadStrategy(string, this.getLoadStrategy());
        return this.getOptions().cloneWith(loadStrategy, string);
    }

    protected ArchiveOptions getOptionsForOpening(LooseArchive looseArchive) throws IOException, OpenFailureException {
        if (looseArchive.getBinariesPath() == null) {
            throw new OpenFailureException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.open_nested_EXC_, new Object[]{looseArchive.getUri(), this.getURI()}), null);
        }
        LoadStrategy loadStrategy = this.getCommonArchiveFactory().createLoadStrategy(looseArchive.getBinariesPath());
        loadStrategy.setLooseArchive(looseArchive);
        return this.getOptions().cloneWith(loadStrategy, looseArchive.getUri());
    }

    public List getRARFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        EList eList = this.getFiles();
        for (int i = 0; i < eList.size(); ++i) {
            File file = (File)eList.get(i);
            if (!file.isRARFile()) continue;
            arrayList.add(file);
        }
        return arrayList;
    }

    public EList getRolesFromAllModules() {
        BasicEList basicEList = new BasicEList();
        EList eList = this.getDeploymentDescriptor().getModules();
        int n = eList.size();
        for (int i = 0; i < n; ++i) {
            Module module = (Module)eList.get(i);
            EList eList2 = this.getRolesFromModule(module);
            int n2 = eList2.size();
            for (int j = 0; j < n2; ++j) {
                basicEList.add(eList2.get(j));
            }
        }
        return basicEList;
    }

    public EList getRolesFromModule(Module module) {
        String string = "getRolesFromModule";
        String string2 = module.getUri();
        logger.entering(className, string, string2);
        EList eList = new BasicEList();
        try {
            if (module.isWebModule()) {
                logger.logp(Level.FINER, className, string, "Module found to be a Web Module");
                eList = this.getDeploymentDescriptor((WebModule)module).getSecurityRoles();
            } else if (module.isEjbModule()) {
                logger.logp(Level.FINER, className, string, "Module found to be an EJB Module");
                eList = this.getAssemblyDescriptorAddIfNecessary(this.getDeploymentDescriptor((EjbModule)module)).getSecurityRoles();
            }
        }
        catch (Exception exception) {
            logger.severe(exception.getMessage());
            logger.exiting(className, string, "Throwing DeploymentDescriptorLoadException");
            String string3 = "";
            if (module.isWebModule()) {
                string3 = "WEB-INF/web.xml";
            } else if (module.isEjbModule()) {
                string3 = "META-INF/ejb-jar.xml";
            }
            throw new DeploymentDescriptorLoadException(CommonArchiveResourceHandler.getString("dd_in_ear_load_EXC_", new Object[]{string3, module.getUri(), this.getURI()}), exception);
        }
        logger.exiting(className, string, eList);
        return eList;
    }

    public EObject getStandardDeploymentDescriptor() throws DeploymentDescriptorLoadException {
        return this.getDeploymentDescriptor();
    }

    public List getWARFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        EList eList = this.getFiles();
        for (int i = 0; i < eList.size(); ++i) {
            File file = (File)eList.get(i);
            if (!file.isWARFile()) continue;
            arrayList.add(file);
        }
        return arrayList;
    }

    public void initializeAfterOpen() {
        super.initializeAfterOpen();
    }

    public boolean isDeploymentDescriptorSet() {
        return this.deploymentDescriptor != null;
    }

    public boolean isEARFile() {
        return true;
    }

    public boolean isNestedArchive(String string) {
        if (super.isNestedArchive(string)) {
            return true;
        }
        return this.getDeploymentDescriptor().getFirstModule(string) != null;
    }

    public EObject makeDeploymentDescriptor(XMLResource xMLResource) {
        Application application = ((ApplicationPackage)EPackage.Registry.INSTANCE.getEPackage("application.xmi")).getApplicationFactory().createApplication();
        xMLResource.setID((EObject)application, "Application_ID");
        this.setDeploymentDescriptorGen(application);
        xMLResource.getContents().add(application);
        return application;
    }

    public Archive openNestedArchive(LooseArchive looseArchive) throws OpenFailureException {
        String string = "openNestedArchive - loose";
        String string2 = looseArchive.getUri();
        logger.logp(Level.FINER, className, string, "ENTRY - loose archive URI [ {0} ]", string2);
        Module module = this.getDeploymentDescriptor().getFirstModule(string2);
        logger.logp(Level.FINER, className, string, "Got module [ {0} ]", module);
        if (module == null) {
            Archive archive = super.openNestedArchive(looseArchive);
            if (archive == null) {
                logger.logp(Level.FINER, className, string, "RETURN null");
            } else {
                logger.logp(Level.FINER, className, string, "RETURN archive [ {0} ]", archive.getURI());
            }
            return archive;
        }
        try {
            ArchiveOptions archiveOptions = this.getOptionsForOpening(looseArchive);
            Archive archive = this.openNestedArchive(module, archiveOptions);
            if (archive == null) {
                logger.logp(Level.FINER, className, string, "RETURN null");
            } else {
                logger.logp(Level.FINER, className, string, "RETURN archive [ {0} ]", archive.getURI());
            }
            return archive;
        }
        catch (IOException iOException) {
            logger.logp(Level.FINER, className, string, "java.io.IOException with module [ {0} ]", module.getUri());
            logger.logp(Level.FINER, className, string, "RETURN null");
            return null;
        }
    }

    public Archive openNestedArchive(String string) throws OpenFailureException {
        Object object;
        Object object2;
        String string2;
        String string3 = "openNestedArchive - URI";
        logger.logp(Level.FINER, className, string3, "ENTRY - URI [ {0} ]", string);
        try {
            string2 = this.getBinariesPath();
            logger.logp(Level.FINER, className, string3, "Found parentBinariesPath [ {0} ]", string2);
            object2 = this.getOptions();
            if (((ArchiveOptions)object2).isSetAltBinariesPath() && (object = ((ArchiveOptions)object2).getAltBinariesPath()) != null) {
                logger.logp(Level.FINER, className, string3, "Replacing binariesPath [ {0} ] with altBinariesPath in archiveOptions", string2);
                string2 = object;
            }
            this.options.setParentEarBinariesPath(string2);
            logger.logp(Level.FINER, className, string3, "Saved parentBinariesPath in archiveOptions [ {0} ]", string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.logp(Level.WARNING, className, string3, "Couldn't set binariesPath in archive options.  Continuing without it.");
        }
        string2 = this.getDeploymentDescriptor().getFirstModule(string);
        logger.logp(Level.FINER, className, string3, "Got module [ {0} ]", string2);
        if (string2 == null) {
            object2 = super.openNestedArchive(string);
            if (object2 == null) {
                logger.logp(Level.FINER, className, string3, "RETURN null");
            } else {
                logger.logp(Level.FINER, className, string3, "RETURN archive [ {0} ]", object2.getURI());
            }
            return object2;
        }
        try {
            object2 = this.getOptionsForOpening(string);
            object = this.openNestedArchive((Module)string2, (ArchiveOptions)object2);
            if (object == null) {
                logger.logp(Level.FINER, className, string3, "RETURN null");
            } else {
                logger.logp(Level.FINER, className, string3, "RETURN archive [ {0} ]", object.getURI());
            }
            return object;
        }
        catch (IOException iOException) {
            logger.logp(Level.FINER, className, string3, "java.io.IOException with archive [ {0} ]", string);
            logger.logp(Level.FINER, className, string3, "RETURN null");
            return null;
        }
    }

    protected Archive openNestedArchive(Module module, ArchiveOptions archiveOptions) throws OpenFailureException {
        String string = "openNestedArchive - module";
        String string2 = module.getUri();
        logger.logp(Level.FINER, className, string, "ENTRY - module URI [ {0} ]", string2);
        try {
            Object object;
            try {
                object = this.getBinariesPath();
                logger.logp(Level.FINER, className, string, "Found parentBinariesPath [ {0} ]", object);
                String string3 = this.getOptions().getAltBinariesPath();
                if (string3 != null) {
                    logger.logp(Level.FINER, className, string, "Found altBinariesPath in archiveOptions [ {0} ]", string3);
                    object = string3;
                }
                archiveOptions.setParentEarBinariesPath((String)object);
                logger.logp(Level.FINER, className, string, "Saved parentBinariesPath [ {0} ] in archiveOptions", object);
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.logp(Level.WARNING, className, string, "Couldn't set binariesPath in archive options.  Continuing without it.");
            }
            if (module.isWebModule()) {
                object = this.getCommonArchiveFactory().openWARFile(archiveOptions, string2);
                logger.logp(Level.FINER, className, string, "RETURN [ {0} ]", object);
                return object;
            }
            if (module.isEjbModule()) {
                object = this.getCommonArchiveFactory().openEJBJarFile(archiveOptions, string2);
                logger.logp(Level.FINER, className, string, "RETURN [ {0} ]", object);
                return object;
            }
            if (module.isJavaModule()) {
                object = this.getCommonArchiveFactory().openApplicationClientFile(archiveOptions, string2);
                logger.logp(Level.FINER, className, string, "RETURN [ {0} ]", object);
                return object;
            }
            if (module.isConnectorModule()) {
                object = this.getCommonArchiveFactory().openRARFile(archiveOptions, string2);
                logger.logp(Level.FINER, className, string, "RETURN [ {0} ]", object);
                return object;
            }
        }
        catch (OpenFailureException openFailureException) {
            logger.severe(openFailureException.getMessage());
            logger.logp(Level.FINER, className, string, "RETURN Throwing OpenFailureException");
            throw new OpenFailureException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.nested_open_fail_EXC_, new Object[]{string2, this.getURI()}), (Exception)((Object)openFailureException));
        }
        logger.logp(Level.FINER, className, string, "RETURN null");
        return null;
    }

    public void pushDownRole(SecurityRole securityRole) {
        if (securityRole == null) {
            throw new IllegalArgumentException(CommonArchiveResourceHandler.Parameter_should_not_be_nu_EXC_);
        }
        EList eList = this.getDeploymentDescriptor().getModules();
        for (int i = 0; i < eList.size(); ++i) {
            Module module = (Module)eList.get(i);
            this.pushDownRole(securityRole, module);
        }
    }

    public void pushDownRole(SecurityRole securityRole, Module module) {
        String string = "pushDownRole";
        String string2 = module.getUri();
        String string3 = securityRole.getRoleName();
        logger.entering(className, string, new Object[]{string3, string2});
        try {
            if (module.isWebModule()) {
                logger.logp(Level.FINER, className, string, "Module found to be a Web Module");
                WebApp webApp = this.getDeploymentDescriptor((WebModule)module);
                if (webApp.getSecurityRoleNamed(string3) == null) {
                    webApp.getSecurityRoles().add(EtoolsCopyUtility.createCopy((EObject)securityRole));
                }
            } else if (module.isEjbModule()) {
                logger.logp(Level.FINER, className, string, "Module found to be an EJB Module");
                AssemblyDescriptor assemblyDescriptor = this.getAssemblyDescriptorAddIfNecessary(this.getDeploymentDescriptor((EjbModule)module));
                if (assemblyDescriptor.getSecurityRoleNamed(string3) == null) {
                    assemblyDescriptor.getSecurityRoles().add(EtoolsCopyUtility.createCopy((EObject)securityRole));
                }
            }
        }
        catch (Exception exception) {
            logger.severe(exception.getMessage());
            logger.exiting(className, string, "Throwing DeploymentDescriptorLoadException");
            String string4 = "";
            if (module.isWebModule()) {
                string4 = "WEB-INF/web.xml";
            } else if (module.isEjbModule()) {
                string4 = "META-INF/ejb-jar.xml";
            }
            throw new DeploymentDescriptorLoadException(CommonArchiveResourceHandler.getString("dd_in_ear_load_EXC_", new Object[]{string4, module.getUri(), this.getURI()}), exception);
        }
        logger.exiting(className, string);
    }

    protected void registerResourceFactory(Module module, String string) {
        Resource.Factory factory = null;
        if (module.isEjbModule()) {
            factory = EJBJarResourceFactory.getRegisteredFactory();
        } else if (module.isWebModule()) {
            factory = WebAppResourceFactory.getRegisteredFactory();
        } else if (module.isJavaModule()) {
            factory = ApplicationClientResourceFactory.getRegisteredFactory();
        } else if (module.isConnectorModule()) {
            factory = ConnectorResourceFactory.getRegisteredFactory();
        }
        if (factory != null) {
            ResourceSet resourceSet = this.getResourceSet();
            ((FileNameResourceFactoryRegistry)resourceSet.getResourceFactoryRegistry()).registerLastFileSegment(string, factory);
        }
    }

    public void remove(ModuleRef moduleRef) {
        String string = "remove";
        logger.entering(className, string, moduleRef);
        if (moduleRef == null) {
            return;
        }
        Module module = moduleRef.getModule();
        if (module != null) {
            this.getDeploymentDescriptor().getModules().remove(module);
        }
        this.getModuleRefs().remove(moduleRef);
        ModuleFile moduleFile = moduleRef.getModuleFile();
        if (this.getModuleRefs(moduleFile).isEmpty()) {
            logger.logp(Level.FINER, className, string, "Removing EAR file list entry for module [ {0} ]", moduleFile.getURI());
            this.getFiles().remove(moduleFile);
        }
        logger.exiting(className, string);
    }

    public List getModuleRefs(ModuleFile moduleFile) {
        EList eList = this.getModuleRefs();
        ArrayList<ModuleRef> arrayList = new ArrayList<ModuleRef>(1);
        for (int i = 0; i < eList.size(); ++i) {
            ModuleRef moduleRef = (ModuleRef)eList.get(i);
            if (moduleRef.getModuleFile() != moduleFile) continue;
            arrayList.add(moduleRef);
        }
        return arrayList;
    }

    protected void renameRolesInModuleDDs(String string, String string2) {
        String string3 = "renameRolesInModuleDDs";
        logger.entering(className, string3, new Object[]{string, string2});
        EList eList = this.getDeploymentDescriptor().getModules();
        for (int i = 0; i < eList.size(); ++i) {
            Module module = (Module)eList.get(i);
            try {
                if (module.isEjbModule()) {
                    logger.logp(Level.FINER, className, string3, "Module found to be an EJB Module");
                    this.getDeploymentDescriptor((EjbModule)module).renameSecurityRole(string, string2);
                    continue;
                }
                if (!module.isWebModule()) continue;
                logger.logp(Level.FINER, className, string3, "Module found to be a Web Module");
                this.getDeploymentDescriptor((WebModule)module).renameSecurityRole(string, string2);
                continue;
            }
            catch (Exception exception) {
                logger.severe(exception.getMessage());
                logger.exiting(className, string3, "Throwing DeploymentDescriptorLoadException");
                String string4 = "";
                if (module.isWebModule()) {
                    string4 = "WEB-INF/web.xml";
                } else if (module.isEjbModule()) {
                    string4 = "META-INF/ejb-jar.xml";
                }
                throw new DeploymentDescriptorLoadException(CommonArchiveResourceHandler.getString("dd_in_ear_load_EXC_", new Object[]{string4, module.getUri(), this.getURI()}), exception);
            }
        }
        logger.exiting(className, string3);
    }

    public void renameSecurityRole(String string, String string2) throws ObjectNotFoundException, DuplicateObjectException {
        Application application = this.getDeploymentDescriptor();
        SecurityRole securityRole = application.getSecurityRoleNamed(string);
        if (securityRole == null) {
            throw new ObjectNotFoundException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.no_sec_role_EXC_, new Object[]{this.getURI(), string}));
        }
        if (application.getSecurityRoleNamed(string2) != null) {
            throw new DuplicateObjectException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.dup_sec_role_EXC_, new Object[]{this.getURI(), string2}), application.getSecurityRoleNamed(string2));
        }
        securityRole.setRoleName(string2);
        this.renameRolesInModuleDDs(string, string2);
    }

    public void rollUpRoles() {
        EList eList = this.getDeploymentDescriptor().getModules();
        for (int i = 0; i < eList.size(); ++i) {
            Module module = (Module)eList.get(i);
            this.rollUpRoles(module);
        }
    }

    public void rollUpRoles(Module module) {
        String string = "rollUpRoles";
        String string2 = module.getUri();
        logger.entering(className, string, string2);
        List list = null;
        try {
            if (module.isWebModule()) {
                logger.logp(Level.FINER, className, string, "Module found to be a Web Module");
                list = this.getDeploymentDescriptor((WebModule)module).getSecurityRoles();
            } else if (module.isEjbModule()) {
                logger.logp(Level.FINER, className, string, "Module found to be an EJB Module");
                EJBJar eJBJar = this.getDeploymentDescriptor((EjbModule)module);
                if (eJBJar != null) {
                    list = this.getAssemblyDescriptorAddIfNecessary(eJBJar).getSecurityRoles();
                }
            }
        }
        catch (Exception exception) {
            logger.severe(exception.getMessage());
            logger.exiting(className, string, "Throwing DeploymentDescriptorLoadException");
            String string3 = "";
            if (module.isWebModule()) {
                string3 = "WEB-INF/web.xml";
            } else if (module.isEjbModule()) {
                string3 = "META-INF/ejb-jar.xml";
            }
            throw new DeploymentDescriptorLoadException(CommonArchiveResourceHandler.getString("dd_in_ear_load_EXC_", new Object[]{string3, module.getUri(), this.getURI()}), exception);
        }
        if (list == null) {
            logger.exiting(className, string, "No security roles found");
            return;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            this.addCopyIfNotExists((SecurityRole)list.get(i));
        }
        logger.logp(Level.FINER, className, string, "RETURN Found {0} security roles", Integer.toString(n));
    }

    public void setDeploymentDescriptor(Application application) {
        this.setDeploymentDescriptorGen(application);
        this.replaceRoot(this.getMofResourceMakeIfNecessary(this.getDeploymentDescriptorUri()), (EObject)application);
    }

    public void setDeploymentDescriptor_noDD(Application application) {
        String string = "setDeploymentDescriptor_noDD";
        logger.logp(Level.FINER, className, string, "ENTRY");
        this.setDeploymentDescriptorGen(application);
        try {
            this.replaceRoot(this.makeMofResource(this.getDeploymentDescriptorUri()), (EObject)application);
        }
        catch (DuplicateObjectException duplicateObjectException) {
            logger.logp(Level.FINER, className, string, "Ignoring DuplicateObjectException");
        }
        logger.logp(Level.FINER, className, string, "RETURN");
    }

    public Application getDeploymentDescriptorGen() {
        if (this.deploymentDescriptor != null && this.deploymentDescriptor.eIsProxy()) {
            InternalEObject internalEObject = (InternalEObject)this.deploymentDescriptor;
            this.deploymentDescriptor = (Application)this.eResolveProxy(internalEObject);
            if (this.deploymentDescriptor != internalEObject && this.eNotificationRequired()) {
                this.eNotify(new ENotificationImpl((InternalEObject)this, 9, 10, (Object)internalEObject, (Object)this.deploymentDescriptor));
            }
        }
        return this.deploymentDescriptor;
    }

    public Application basicGetDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public void setDeploymentDescriptorGen(Application application) {
        Application application2 = this.deploymentDescriptor;
        this.deploymentDescriptor = application;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 10, (Object)application2, (Object)this.deploymentDescriptor));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject internalEObject, int n, NotificationChain notificationChain) {
        switch (n) {
            case 9: {
                return ((InternalEList)this.getModuleRefs()).basicAdd(internalEObject, notificationChain);
            }
        }
        return super.eInverseAdd(internalEObject, n, notificationChain);
    }

    public NotificationChain eInverseRemove(InternalEObject internalEObject, int n, NotificationChain notificationChain) {
        switch (n) {
            case 9: {
                return ((InternalEList)this.getModuleRefs()).basicRemove(internalEObject, notificationChain);
            }
        }
        return super.eInverseRemove(internalEObject, n, notificationChain);
    }

    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 9: {
                return this.getModuleRefs();
            }
            case 10: {
                if (bl) {
                    return this.getDeploymentDescriptor();
                }
                return this.basicGetDeploymentDescriptor();
            }
        }
        return super.eGet(n, bl, bl2);
    }

    public void eSet(int n, Object object) {
        switch (n) {
            case 9: {
                this.getModuleRefs().clear();
                this.getModuleRefs().addAll((Collection)object);
                return;
            }
            case 10: {
                this.setDeploymentDescriptor((Application)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    public void eUnset(int n) {
        switch (n) {
            case 9: {
                this.getModuleRefs().clear();
                return;
            }
            case 10: {
                this.setDeploymentDescriptor(null);
                return;
            }
        }
        super.eUnset(n);
    }

    public boolean eIsSet(int n) {
        switch (n) {
            case 9: {
                return this.moduleRefs != null && !this.moduleRefs.isEmpty();
            }
            case 10: {
                return this.deploymentDescriptor != null;
            }
        }
        return super.eIsSet(n);
    }

    public EList getModuleRefsGen() {
        if (this.moduleRefs == null) {
            this.moduleRefs = new EObjectContainmentWithInverseEList(class$org$eclipse$jst$j2ee$commonarchivecore$internal$ModuleRef == null ? (class$org$eclipse$jst$j2ee$commonarchivecore$internal$ModuleRef = EARFileImpl.class$("org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef")) : class$org$eclipse$jst$j2ee$commonarchivecore$internal$ModuleRef, this, 9, 1);
        }
        return this.moduleRefs;
    }

    public EList getModuleRefs() {
        EList eList = this.getModuleRefsGen();
        if (eList.isEmpty()) {
            this.initRefs(eList);
        }
        return eList;
    }

    public void initRefs(EList eList) {
        EList eList2 = this.getDeploymentDescriptor().getModules();
        for (int i = 0; i < eList2.size(); ++i) {
            Module module = (Module)eList2.get(i);
            eList.add(this.createModuleRef(module, null));
        }
    }

    protected ModuleRef createModuleRef(Module module, ModuleFile moduleFile) {
        ModuleRef moduleRef = null;
        if (module.isEjbModule()) {
            moduleRef = this.getCommonArchiveFactory().createEJBModuleRef();
        } else if (module.isWebModule()) {
            moduleRef = this.getCommonArchiveFactory().createWebModuleRef();
        } else if (module.isConnectorModule()) {
            moduleRef = this.getCommonArchiveFactory().createConnectorModuleRef();
        } else if (module.isJavaModule()) {
            moduleRef = this.getCommonArchiveFactory().createClientModuleRef();
        }
        moduleRef.setModule(module);
        moduleRef.setModuleFile(moduleFile);
        return moduleRef;
    }

    public List getClientModuleRefs() {
        ArrayList<ModuleRef> arrayList = new ArrayList<ModuleRef>();
        EList eList = this.getModuleRefs();
        for (int i = 0; i < eList.size(); ++i) {
            ModuleRef moduleRef = (ModuleRef)eList.get(i);
            if (!moduleRef.isClient()) continue;
            arrayList.add(moduleRef);
        }
        return arrayList;
    }

    public List getConnectorModuleRefs() {
        ArrayList<ModuleRef> arrayList = new ArrayList<ModuleRef>();
        EList eList = this.getModuleRefs();
        for (int i = 0; i < eList.size(); ++i) {
            ModuleRef moduleRef = (ModuleRef)eList.get(i);
            if (!moduleRef.isConnector()) continue;
            arrayList.add(moduleRef);
        }
        return arrayList;
    }

    public List getEJBModuleRefs() {
        ArrayList<ModuleRef> arrayList = new ArrayList<ModuleRef>();
        EList eList = this.getModuleRefs();
        for (int i = 0; i < eList.size(); ++i) {
            ModuleRef moduleRef = (ModuleRef)eList.get(i);
            if (!moduleRef.isEJB()) continue;
            arrayList.add(moduleRef);
        }
        return arrayList;
    }

    public List getWebModuleRefs() {
        ArrayList<ModuleRef> arrayList = new ArrayList<ModuleRef>();
        EList eList = this.getModuleRefs();
        for (int i = 0; i < eList.size(); ++i) {
            ModuleRef moduleRef = (ModuleRef)eList.get(i);
            if (!moduleRef.isWeb()) continue;
            arrayList.add(moduleRef);
        }
        return arrayList;
    }

    public List getFARFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        EList eList = this.getFiles();
        for (int i = 0; i < eList.size(); ++i) {
            File file = (File)eList.get(i);
            if (!file.isFARFile()) continue;
            arrayList.add(file);
        }
        return arrayList;
    }

    public List getArchivesOfType(String string) {
        return Collections.EMPTY_LIST;
    }

    public Map getEJBReferences(boolean bl, boolean bl2) throws ArchiveWrappedException {
        Application application;
        if (!(bl && bl2 || (application = this.getDeploymentDescriptor()) == null)) {
            EList eList = application.getModules();
            Map map = null;
            for (int i = 0; i < eList.size(); ++i) {
                Module module = (Module)eList.get(i);
                try {
                    map = this.collectEJBReferences(module, bl, bl2, map);
                    continue;
                }
                catch (ResourceLoadException resourceLoadException) {
                    throw new ArchiveWrappedException((Exception)((Object)resourceLoadException));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new ArchiveWrappedException(fileNotFoundException);
                }
                catch (EmptyResourceException emptyResourceException) {
                    throw new ArchiveWrappedException(emptyResourceException);
                }
            }
            return map;
        }
        return Collections.EMPTY_MAP;
    }

    private Map collectEJBReferences(Module module, boolean bl, boolean bl2, Map hashMap) throws ResourceLoadException, FileNotFoundException, EmptyResourceException {
        HashMap hashMap2 = hashMap;
        List list = this.getEJBReferences(module);
        if (list != null && !list.isEmpty()) {
            EjbRef ejbRef = null;
            ArrayList<EjbRef> arrayList = null;
            String string = null;
            for (int i = 0; i < list.size(); ++i) {
                ejbRef = (EjbRef)list.get(i);
                string = ejbRef.getLink();
                if ((string == null || string.length() <= 0 || bl) && (string != null && string.length() != 0 || bl2)) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<EjbRef>(list.size());
                }
                arrayList.add(ejbRef);
            }
            if (arrayList != null) {
                if (hashMap2 == null) {
                    hashMap2 = new HashMap();
                }
                hashMap2.put(module, arrayList);
            }
        }
        return hashMap2;
    }

    private List getEJBReferences(Module module) throws ResourceLoadException, FileNotFoundException, EmptyResourceException {
        if (module != null) {
            ApplicationClient applicationClient;
            if (module.isEjbModule()) {
                EJBJar eJBJar = this.getDeploymentDescriptor((EjbModule)module);
                return this.getEJBReferences(eJBJar);
            }
            if (module.isWebModule()) {
                WebApp webApp = this.getDeploymentDescriptor((WebModule)module);
                if (webApp != null) {
                    return webApp.getEjbRefs();
                }
            } else if (module.isJavaModule() && (applicationClient = this.getDeploymentDescriptor((JavaClientModule)module)) != null) {
                return applicationClient.getEjbReferences();
            }
        }
        return Collections.EMPTY_LIST;
    }

    private List getEJBReferences(EJBJar eJBJar) {
        if (eJBJar != null) {
            EList eList = eJBJar.getEnterpriseBeans();
            ArrayList arrayList = null;
            EnterpriseBean enterpriseBean = null;
            for (int i = 0; i < eList.size(); ++i) {
                enterpriseBean = (EnterpriseBean)eList.get(i);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.addAll(enterpriseBean.getEjbRefs());
            }
            if (arrayList != null) {
                return arrayList;
            }
        }
        return Collections.EMPTY_LIST;
    }

    protected void displayDescriptor(Application application) {
        if (!logger.isLoggable(Level.FINER)) {
            return;
        }
        String string = "\n    \nDescribing EAR File descriptor for [ " + this.getURI() + " ]\n";
        string = string + "\n    Version ID   [ " + application.getVersionID() + " ]";
        EList eList = application.getModules();
        string = string + "\n    EAR contains [ " + eList.size() + " ] modules:";
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Module module = (Module)iterator.next();
            string = string + "\n      Module URI[ " + module.getUri() + " ]";
            if (module == null) continue;
            if (module.isEjbModule()) {
                string = string + "\n        EJB Module";
            } else if (module.isWebModule()) {
                string = string + "\n        Web Module";
            } else if (module.isConnectorModule()) {
                string = string + "\n        Connector Module";
            } else if (module.isJavaModule()) {
                string = string + "\n        Java Module";
            }
            string = string + "\n        Alt DD      [ " + module.getAltDD() + " ]";
        }
        logger.finest(string + "\n");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

