/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.FileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;

public abstract class ContainerImpl
extends FileImpl
implements Container {
    protected static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    private static final String className = (class$org$eclipse$jst$j2ee$commonarchivecore$internal$impl$ContainerImpl == null ? (class$org$eclipse$jst$j2ee$commonarchivecore$internal$impl$ContainerImpl = ContainerImpl.class$("org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ContainerImpl")) : class$org$eclipse$jst$j2ee$commonarchivecore$internal$impl$ContainerImpl).getName();
    protected LoadStrategy loadStrategy;
    protected Map fileIndex;
    protected FileNotificationAdapter fileIndexAdapter;
    protected EList files = null;
    static /* synthetic */ Class class$org$eclipse$jst$j2ee$commonarchivecore$internal$impl$ContainerImpl;
    static /* synthetic */ Class class$org$eclipse$jst$j2ee$commonarchivecore$internal$File;
    static /* synthetic */ Class class$org$eclipse$emf$ecore$util$EObjectContainmentWithInverseEList;

    protected EClass eStaticClass() {
        return CommonarchivePackage.Literals.CONTAINER;
    }

    public boolean containsFile(String string) {
        String string2;
        String string3 = string2 = string.startsWith("/") ? ArchiveUtil.truncateFromFrontIgnoreCase(string, "/") : string;
        if (this.isIndexed()) {
            return this.getFileIndex().containsKey(string2);
        }
        return this.getLoadStrategy().contains(string2);
    }

    public String getAbsolutePath() throws FileNotFoundException {
        return this.getLoadStrategy().getAbsolutePath();
    }

    public File getFile(String string) throws FileNotFoundException {
        File file;
        String string2 = "getFile";
        logger.entering(className, string2, string);
        if (!this.isIndexed()) {
            logger.logp(Level.FINER, className, string2, "Container not indexed, get new list of files");
            this.getFiles();
        }
        if ((file = (File)this.getFileIndex().get(string)) == null) {
            logger.exiting(className, string2, "Throwing FileNotFoundException");
            throw new FileNotFoundException(string);
        }
        logger.exiting(className, string2, file);
        return file;
    }

    protected Map getFileIndex() {
        String string = "getFileIndex";
        logger.logp(Level.FINER, className, string, "ENTRY");
        if (this.fileIndex == null) {
            this.getFileIndexAdapter().rebuildFileIndex();
        }
        logger.logp(Level.FINER, className, string, "RETURN fileIndex {0}", this.fileIndex);
        return this.fileIndex;
    }

    protected FileNotificationAdapter getFileIndexAdapter() {
        if (this.fileIndexAdapter == null) {
            this.fileIndexAdapter = new FileNotificationAdapter();
            this.eAdapters().add(this.fileIndexAdapter);
        }
        return this.fileIndexAdapter;
    }

    public EList getFiles() {
        Object object;
        String string = "getFiles";
        String string2 = this.getURI();
        logger.entering(className, string, string2);
        EList eList = this.getFilesGen();
        logger.logp(Level.FINER, className, string, "List of {0} files", Integer.toString(eList.size()));
        if (!this.isIndexed()) {
            logger.logp(Level.FINER, className, string, "List is not indexed");
            object = this.getLoadStrategy();
            logger.logp(Level.FINER, className, string, "Load strategy [ {0} ]", object);
            if (eList.isEmpty() && object != null) {
                eList.addAll(object.collectFiles());
                logger.logp(Level.FINER, className, string, "Collected list of {0} files", Integer.toString(eList.size()));
            }
            logger.logp(Level.FINER, className, string, "Build list index");
            this.getFileIndex();
        }
        logger.logp(Level.FINER, className, string, "RETURN {0} list of {1} files", new Object[]{string2, Integer.toString(this.files.size())});
        if (logger.isLoggable(Level.FINEST)) {
            object = "complete list of returned files:\n";
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                object = (String)object + iterator.next() + "\n";
            }
            logger.logp(Level.FINEST, className, string, (String)object);
        }
        return eList;
    }

    public InputStream getInputStream(String string) throws IOException, FileNotFoundException {
        if (this.isIndexed()) {
            return this.getFile(string).getInputStream();
        }
        return this.primGetInputStream(string);
    }

    public LoadStrategy getLoadStrategy() {
        return this.loadStrategy;
    }

    public boolean isContainer() {
        return true;
    }

    public boolean isIndexed() {
        return this.fileIndex != null;
    }

    public InputStream primGetInputStream(String string) throws IOException, FileNotFoundException {
        return this.getLoadStrategy().getInputStream(string);
    }

    public void rebuildFileIndex() {
        this.getFileIndexAdapter().rebuildFileIndex();
    }

    public void setLoadStrategy(LoadStrategy loadStrategy) {
        if (loadStrategy != null) {
            loadStrategy.setContainer(this);
            if (this.loadStrategy != null) {
                loadStrategy.setRendererType(this.loadStrategy.getRendererType());
                loadStrategy.setReadOnly(this.loadStrategy.isReadOnly());
                this.loadStrategy.setContainer(null);
                this.loadStrategy.close();
            }
        }
        this.loadStrategy = loadStrategy;
    }

    public EList getFilesGen() {
        String string = "getFilesGen";
        logger.entering(className, string, this);
        if (this.files == null) {
            logger.logp(Level.FINER, className, string, "Creating new list of files");
            this.files = new EObjectContainmentWithInverseEList(class$org$eclipse$jst$j2ee$commonarchivecore$internal$File == null ? (class$org$eclipse$jst$j2ee$commonarchivecore$internal$File = ContainerImpl.class$("org.eclipse.jst.j2ee.commonarchivecore.internal.File")) : class$org$eclipse$jst$j2ee$commonarchivecore$internal$File, this, 7, 6){
                private final String innerClassName = (class$org$eclipse$emf$ecore$util$EObjectContainmentWithInverseEList == null ? (class$org$eclipse$emf$ecore$util$EObjectContainmentWithInverseEList = ContainerImpl.class$("org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList")) : class$org$eclipse$emf$ecore$util$EObjectContainmentWithInverseEList).getName();

                protected void doClear() {
                    String string = "doClear";
                    logger.entering(this.innerClassName, string, this);
                    super.doClear();
                    logger.exiting(this.innerClassName, string);
                }

                protected void didAdd(int n, Object object) {
                    String string = "didAdd";
                    logger.entering(this.innerClassName, string, this);
                    logger.logp(Level.FINER, className, string, "Object index[ {0} ]", Integer.toString(n));
                    logger.logp(Level.FINER, className, string, "Object added [ {0} ]", object);
                    super.didAdd(n, object);
                    logger.exiting(this.innerClassName, string);
                }

                protected void didRemove(int n, Object object) {
                    String string = "didRemove";
                    logger.entering(this.innerClassName, string, this);
                    logger.logp(Level.FINER, className, string, "Object index[ {0} ]", Integer.toString(n));
                    logger.logp(Level.FINER, className, string, "Object removed [ {0} ]", object);
                    super.didRemove(n, object);
                    logger.exiting(this.innerClassName, string);
                }

                protected void didSet(int n, Object object, Object object2) {
                    String string = "didSet";
                    logger.entering(this.innerClassName, string, this);
                    logger.logp(Level.FINER, className, string, "Object index[ {0} ]", Integer.toString(n));
                    logger.logp(Level.FINER, className, string, "New Object [ {0} ]", object);
                    logger.logp(Level.FINER, className, string, "Old Object [ {0} ]", object2);
                    super.didSet(n, object, object2);
                    logger.exiting(this.innerClassName, string);
                }
            };
        }
        logger.logp(Level.FINER, className, string, "RETURN list of [ {0} ] files", Integer.toString(this.files.size()));
        return this.files;
    }

    public NotificationChain eInverseAdd(InternalEObject internalEObject, int n, NotificationChain notificationChain) {
        switch (n) {
            case 7: {
                return ((InternalEList)this.getFiles()).basicAdd(internalEObject, notificationChain);
            }
        }
        return super.eInverseAdd(internalEObject, n, notificationChain);
    }

    public NotificationChain eInverseRemove(InternalEObject internalEObject, int n, NotificationChain notificationChain) {
        switch (n) {
            case 7: {
                return ((InternalEList)this.getFiles()).basicRemove(internalEObject, notificationChain);
            }
        }
        return super.eInverseRemove(internalEObject, n, notificationChain);
    }

    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 7: {
                return this.getFiles();
            }
        }
        return super.eGet(n, bl, bl2);
    }

    public void eSet(int n, Object object) {
        switch (n) {
            case 7: {
                this.getFiles().clear();
                this.getFiles().addAll((Collection)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    public void eUnset(int n) {
        switch (n) {
            case 7: {
                this.getFiles().clear();
                return;
            }
        }
        super.eUnset(n);
    }

    public boolean eIsSet(int n) {
        switch (n) {
            case 7: {
                return this.files != null && !this.files.isEmpty();
            }
        }
        return super.eIsSet(n);
    }

    public void clearFiles() {
        boolean bl = this.eDeliver();
        this.files.clear();
        this.eSetDeliver(bl);
        if (this.isIndexed()) {
            this.eAdapters().remove(this.fileIndexAdapter);
            this.fileIndexAdapter = null;
            this.fileIndex = null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class FileNotificationAdapter
    extends AdapterImpl {
        protected FileNotificationAdapter() {
        }

        public boolean isAdapterForType(Object object) {
            return object == "FileNotificationAdapter";
        }

        public void addIndexedFile(String string, Notifier notifier) {
            ContainerImpl.this.fileIndex.put(string, notifier);
            if (notifier.eAdapters() == null || !notifier.eAdapters().contains(this)) {
                notifier.eAdapters().add(this);
            }
        }

        public void removeIndexedFile(String string, Notifier notifier) {
            ContainerImpl.this.fileIndex.remove(string);
            notifier.eAdapters().remove(this);
        }

        public void notifyChanged(Notification notification) {
            if (ContainerImpl.this.fileIndex == null || notification.getFeature() == null) {
                return;
            }
            if (notification.getFeature().equals(CommonarchivePackage.eINSTANCE.getFile_URI()) && ((File)notification.getNotifier()).getContainer() == ContainerImpl.this) {
                ContainerImpl.this.fileIndex.remove(notification.getOldValue());
                ContainerImpl.this.fileIndex.put(notification.getNewValue(), notification.getNotifier());
            }
            if (notification.getFeature().equals(CommonarchivePackage.eINSTANCE.getContainer_Files()) && notification.getNotifier() == ContainerImpl.this) {
                switch (notification.getEventType()) {
                    case 3: {
                        File file = (File)notification.getNewValue();
                        this.addIndexedFile(file.getURI(), file);
                        break;
                    }
                    case 4: {
                        this.removeIndexedFile(((File)notification.getOldValue()).getURI(), (File)notification.getOldValue());
                        break;
                    }
                    case 5: {
                        this.filesAdded((List)notification.getNewValue());
                        break;
                    }
                    case 6: {
                        this.filesRemoved((List)notification.getOldValue());
                        break;
                    }
                    case 7: {
                        break;
                    }
                    case 1: {
                        if (notification.getPosition() == -1) break;
                        File file = (File)notification.getNewValue();
                        this.removeIndexedFile(((File)notification.getOldValue()).getURI(), (File)notification.getOldValue());
                        this.addIndexedFile(file.getURI(), file);
                    }
                }
            }
        }

        public void filesAdded(List list) {
            for (int i = 0; i < list.size(); ++i) {
                File file = (File)list.get(i);
                this.addIndexedFile(file.getURI(), file);
            }
        }

        public void filesRemoved(List list) {
            for (int i = 0; i < list.size(); ++i) {
                File file = (File)list.get(i);
                this.removeIndexedFile(file.getURI(), file);
            }
        }

        public void rebuildFileIndex() {
            String string = "rebuildFileIndex";
            logger.logp(Level.FINER, className, string, "ENTRY");
            this.removeAdaptersIfNecessary();
            ContainerImpl.this.fileIndex = new HashMap();
            if (ContainerImpl.this.getFiles().size() > 0) {
                Iterator iterator = ContainerImpl.this.getFiles().iterator();
                while (iterator.hasNext()) {
                    File file = (File)iterator.next();
                    this.addIndexedFile(file.getURI(), file);
                }
            }
            logger.logp(Level.FINER, className, string, "RETURN");
        }

        public void removeAdaptersIfNecessary() {
            if (ContainerImpl.this.fileIndex == null) {
                return;
            }
            Iterator iterator = ContainerImpl.this.fileIndex.values().iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                file.eAdapters().remove(this);
            }
        }
    }
}

