/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.impl;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ApplicationClientFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ArchiveTypeDiscriminatorRegistry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ClientModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveFactoryRegistry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ConnectorModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.RARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ReadOnlyDirectory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WebModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveInit;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveTypeDiscriminator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ApplicationClientFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ArchiveCopyUtility;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ArchiveImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ClientModuleRefImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ConnectorModuleRefImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.EARFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.EJBJarFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.EJBModuleRefImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.FileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.RARFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ReadOnlyDirectoryImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.RootAppClientJarDescriminatorImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.RootArchiveTypeDescriminatorImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.RootEARFileDescriminatorImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.RootEJBJarDescriminatorImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.WARFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.WebModuleRefImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.DirectoryArchiveLoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.DirectoryArchiveLoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.Ear12ImportStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.Ear30NoDDImportStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.EjbJar11ImportStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.NestedArchiveLoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.NullLoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.RarImportStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ReadOnlyDirectoryLoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.TempZipFileLoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.War22ImportStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ZipFileLoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.DeleteOnExitUtility;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseApplication;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseArchive;

public class CommonarchiveFactoryImpl
extends EFactoryImpl
implements CommonarchiveFactory {
    protected static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    protected static String className = (class$org$eclipse$jst$j2ee$commonarchivecore$internal$impl$CommonarchiveFactoryImpl == null ? (class$org$eclipse$jst$j2ee$commonarchivecore$internal$impl$CommonarchiveFactoryImpl = CommonarchiveFactoryImpl.class$("org.eclipse.jst.j2ee.commonarchivecore.internal.impl.CommonarchiveFactoryImpl")) : class$org$eclipse$jst$j2ee$commonarchivecore$internal$impl$CommonarchiveFactoryImpl).getName();
    protected Map openArchives = new WeakHashMap();
    private static boolean delegateNeedsInit = true;
    private CommonarchiveFactory delegate = null;
    static /* synthetic */ Class class$org$eclipse$jst$j2ee$commonarchivecore$internal$impl$CommonarchiveFactoryImpl;

    public static CommonarchiveFactory init() {
        try {
            CommonarchiveFactory commonarchiveFactory = (CommonarchiveFactory)EPackage.Registry.INSTANCE.getEFactory("commonarchive.xmi");
            if (commonarchiveFactory != null) {
                return commonarchiveFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log(exception);
        }
        return new CommonarchiveFactoryImpl();
    }

    public CommonarchiveFactoryImpl() {
        this.initDelegate();
    }

    private void initDelegate() {
        if (delegateNeedsInit) {
            delegateNeedsInit = false;
            this.delegate = new CommonarchiveFactoryImpl(){

                public ApplicationClientFile createApplicationClientFile() {
                    return this.createApplicationClientFileGen();
                }

                public ClientModuleRef createClientModuleRef() {
                    return this.createClientModuleRefGen();
                }

                public ConnectorModuleRef createConnectorModuleRef() {
                    return this.createConnectorModuleRefGen();
                }

                public EARFile createEARFile() {
                    return this.createEARFileGen();
                }

                public EJBJarFile createEJBJarFile() {
                    return this.createEJBJarFileGen();
                }

                public EJBModuleRef createEJBModuleRef() {
                    return this.createEJBModuleRefGen();
                }

                public RARFile createRARFile() {
                    return this.createRARFileGen();
                }

                public WARFile createWARFile() {
                    return this.createWARFileGen();
                }

                public WebModuleRef createWebModuleRef() {
                    return this.createWebModuleRefGen();
                }
            };
        }
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createFile();
            }
            case 1: {
                return this.createArchive();
            }
            case 2: {
                return this.createEJBJarFile();
            }
            case 3: {
                return this.createWARFile();
            }
            case 4: {
                return this.createEARFile();
            }
            case 5: {
                return this.createApplicationClientFile();
            }
            case 8: {
                return this.createReadOnlyDirectory();
            }
            case 9: {
                return this.createRARFile();
            }
            case 11: {
                return this.createEJBModuleRef();
            }
            case 12: {
                return this.createWebModuleRef();
            }
            case 13: {
                return this.createClientModuleRef();
            }
            case 14: {
                return this.createConnectorModuleRef();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void archiveClosed(Archive archive) {
        Map map;
        String string = "archiveClosed";
        logger.logp(Level.FINER, className, string, "Archive URI [ {0} ]", archive.getURI());
        Map map2 = map = this.getOpenArchives();
        synchronized (map2) {
            map.remove(archive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void archiveOpened(Archive archive) {
        Map map;
        String string = "archiveOpened";
        logger.logp(Level.FINER, className, string, "Archive URI [ {0} ]", archive.getURI());
        Map map2 = map = this.getOpenArchives();
        synchronized (map2) {
            map.put(archive, null);
        }
    }

    public boolean canClose(Archive archive) {
        return !this.getOpenArchivesDependingOn(archive).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeOpenArchives() {
        Map map;
        Map map2 = map = this.getOpenArchives();
        synchronized (map2) {
            ArrayList arrayList = new ArrayList(map.keySet());
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Archive archive = (Archive)iterator.next();
                archive.close();
            }
        }
    }

    public Archive copy(Archive archive) {
        return new ArchiveCopyUtility().copy(archive);
    }

    public ModuleFile copy(ModuleFile moduleFile) {
        return new ArchiveCopyUtility().copy(moduleFile);
    }

    public ApplicationClientFile createApplicationClientFileInitialized(String string) {
        ApplicationClientFile applicationClientFile = this.createApplicationClientFile();
        this.initializeNewApplicationClientFile(applicationClientFile, string);
        return applicationClientFile;
    }

    public Archive createArchiveInitialized(String string) {
        Archive archive = this.createArchive();
        this.initializeNewArchive(archive, string);
        return archive;
    }

    public Archive createArchiveInitialized(ArchiveOptions archiveOptions, String string) {
        Archive archive = this.createArchive();
        this.initializeNewArchive(archive, string, archiveOptions);
        return archive;
    }

    public LoadStrategy createChildLoadStrategy(String string, LoadStrategy loadStrategy) throws IOException, FileNotFoundException {
        String string2 = "createChildLoadStrategy";
        logger.logp(Level.FINER, className, string2, "ENTRY - URI [ {0} ]", string);
        String string3 = loadStrategy.getContainer().getURI();
        logger.logp(Level.FINER, className, string2, "Parent container URI [ {0} ]", string3);
        LoadStrategy loadStrategy2 = null;
        if (loadStrategy.isDirectory()) {
            logger.logp(Level.FINER, className, string2, "Parent is a directory [ {0} ]", string3);
            String string4 = ((DirectoryArchiveLoadStrategy)loadStrategy).getDirectoryUri();
            logger.logp(Level.FINER, className, string2, "Parent directory URI [ {0} ]", string4);
            String string5 = ArchiveUtil.getOSUri(string4, string);
            logger.logp(Level.FINER, className, string2, "Combined URI [ {0} ]", string5);
            loadStrategy2 = this.createLoadStrategy(string5);
        } else {
            logger.logp(Level.FINER, className, string2, "Parent is not a directory [ {0} ]", string3);
            loadStrategy2 = this.createNestedLoadStrategy(string, loadStrategy);
        }
        logger.logp(Level.FINER, className, string2, "RETURN [ {0} ]", loadStrategy2);
        return loadStrategy2;
    }

    public EARFile createEARFileInitialized(String string) {
        EARFile eARFile = this.createEARFile();
        this.initializeNewEARFile(eARFile, string);
        return eARFile;
    }

    public EARFile createEARFileInitialized(ArchiveOptions archiveOptions, String string) {
        EARFile eARFile = this.createEARFile();
        this.initializeNewEARFile(eARFile, string, archiveOptions);
        return eARFile;
    }

    public EJBJarFile createEJBJarFileInitialized(String string) {
        EJBJarFile eJBJarFile = this.createEJBJarFile();
        this.initializeNewEJBJarFile(eJBJarFile, string);
        return eJBJarFile;
    }

    public EJBJarFile createEJBJarFileInitialized(ArchiveOptions archiveOptions, String string) {
        EJBJarFile eJBJarFile = this.createEJBJarFile();
        this.initializeNewEJBJarFile(eJBJarFile, string, archiveOptions);
        return eJBJarFile;
    }

    public LoadStrategy createEmptyLoadStrategy() {
        return new NullLoadStrategyImpl();
    }

    public LoadStrategy createLoadStrategy(String string) throws FileNotFoundException, IOException {
        String string2 = "createLoadStrategy";
        logger.logp(Level.FINER, className, string2, "ENTRY - URI [ {0} ]", string);
        String string3 = string.replace('/', java.io.File.separatorChar);
        java.io.File file = new java.io.File(string3);
        if (!file.exists()) {
            logger.logp(Level.FINER, className, string2, "[ {0} ] could not be found", string3);
            logger.logp(Level.FINER, className, string2, "RETURN Throwing FileNotFoundException");
            throw new FileNotFoundException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.file_not_found_EXC_, new Object[]{string, file.getAbsolutePath()}));
        }
        if (file.isDirectory()) {
            DirectoryArchiveLoadStrategyImpl directoryArchiveLoadStrategyImpl = new DirectoryArchiveLoadStrategyImpl(string);
            logger.logp(Level.FINER, className, string2, "RETURN Returning DirectoryArchiveLoadStrategy [ {0} ]", directoryArchiveLoadStrategyImpl);
            return directoryArchiveLoadStrategyImpl;
        }
        ZipFileLoadStrategyImpl zipFileLoadStrategyImpl = new ZipFileLoadStrategyImpl(file);
        logger.logp(Level.FINER, className, string2, "RETURN Returning ZipFileLoadStrategy [ {0} ]", zipFileLoadStrategyImpl);
        return zipFileLoadStrategyImpl;
    }

    public LoadStrategy createNestedLoadStrategy(String string, LoadStrategy loadStrategy) {
        String string2 = "createNestedLoadStrategy";
        logger.logp(Level.FINER, className, string2, "ENTRY [ {0} ]", string);
        LoadStrategy loadStrategy2 = null;
        ArchiveOptions archiveOptions = ((Archive)loadStrategy.getContainer()).getOptions();
        if (!archiveOptions.isReadOnly(string)) {
            logger.logp(Level.FINER, className, string2, "createNestedLoadStrategy: read-only is not specified; attempting to create temp file");
            loadStrategy2 = this.createTempZipFileStrategyIfPossible(string, loadStrategy);
            if (loadStrategy2 == null) {
                logger.logp(Level.WARNING, className, string2, "Could not create temp file for base URI [ {0} ] and temporary directory [ {1} ]; creating nested strategy", new Object[]{string, ArchiveUtil.getTempDirectory()});
            } else {
                logger.logp(Level.FINER, className, string2, "Created temp file; using temp strategy");
            }
        } else {
            logger.logp(Level.FINER, className, string2, "Read-only is specified; creating nested strategy");
        }
        if (loadStrategy2 == null) {
            logger.logp(Level.FINER, className, string2, "Fall-back - creating NestedArchiveLoadStrategyImpl");
            loadStrategy2 = new NestedArchiveLoadStrategyImpl(loadStrategy);
        }
        logger.logp(Level.FINER, className, string2, "RETURN [ {0} ]", loadStrategy2);
        return loadStrategy2;
    }

    public RARFile createRARFileInitialized(String string) {
        RARFile rARFile = this.createRARFile();
        this.initializeNewRARFile(rARFile, string);
        return rARFile;
    }

    public LoadStrategy createTempZipFileStrategyIfPossible(String string, LoadStrategy loadStrategy) {
        String string2 = "createTempZipFileStrategyIfPossible";
        logger.logp(Level.FINER, className, string2, "ENTRY [ {0} ]", string);
        if (!ArchiveUtil.shouldUseTempDirectoryForRead()) {
            logger.logp(Level.SEVERE, className, string2, "RETURN [ null ] use of temporary directories is unexpectedly disallowed");
            return null;
        }
        java.io.File file = ArchiveUtil.getTempDirectory();
        logger.logp(Level.FINER, className, string2, "Using temporary directory [ {0} ] ", file);
        logger.logp(Level.FINER, className, string2, "parent load strategy [ {0} ] ", loadStrategy);
        try {
            Object object;
            Object object2;
            InputStream inputStream;
            java.io.File file2 = ArchiveUtil.createTempFile(string);
            DeleteOnExitUtility.markForDeletion(file2);
            if (loadStrategy instanceof ZipFileLoadStrategyImpl) {
                inputStream = loadStrategy.getInputStream(string);
            } else {
                ZipFile zipFile;
                ZipEntry zipEntry;
                object2 = loadStrategy.getBinariesPath();
                object = new java.io.File((String)object2);
                if (!((java.io.File)object).exists()) {
                    logger.logp(Level.FINER, className, string2, "parent zip file binaries path [ {0} ] does not exist", object2);
                }
                if ((zipEntry = (zipFile = new ZipFile((String)object2)).getEntry(string)) == null) {
                    logger.logp(Level.FINER, className, string2, "entry not found in parent [ {0} ]", object2);
                }
                inputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            }
            object2 = new FileOutputStream(file2);
            ArchiveUtil.copy(inputStream, (OutputStream)object2);
            object = new TempZipFileLoadStrategyImpl(file2);
            logger.logp(Level.FINER, className, string2, "RETURN [ {0} ]", object);
            return object;
        }
        catch (IOException iOException) {
            TempZipFileLoadStrategyImpl tempZipFileLoadStrategyImpl;
            java.io.File file3;
            logger.logp(Level.WARNING, className, string2, "Could not create temporary file using temporary location [ {0} ]", file);
            ArchiveUtil.inform(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.make_temp_file_WARN_, new Object[]{string}) + iOException.getLocalizedMessage());
            String string3 = this.getSystemTempDirName(string);
            if (string3 == null) {
                logger.logp(Level.SEVERE, className, string2, "Unable to retrieve system defined temporary location for uri [ {0} ]", string);
                logger.logp(Level.SEVERE, className, string2, "Could not create temporary file");
                logger.logp(Level.SEVERE, className, string2, "This failure usually results in very slow performance while performing application operations.");
                logger.logp(Level.FINER, className, string2, "RETURN [ null ]");
                return null;
            }
            logger.logp(Level.FINER, className, string2, "fallback to using system defined temporary location [ {0} ]", string3);
            try {
                file3 = ArchiveUtil.createTempFile(string, null);
            }
            catch (IOException iOException2) {
                logger.logp(Level.SEVERE, className, string2, "Could not create temporary file using system-defined temporary location [ {0} ]", string3);
                logger.logp(Level.FINER, className, string2, "This failure usually results in very slow performance while performing application operations.");
                logger.throwing(className, string2, iOException2);
                logger.logp(Level.FINER, className, string2, "RETURN [ null ]");
                return null;
            }
            logger.logp(Level.FINER, className, string2, "Created temp file [ {0} ]", file3.getName());
            DeleteOnExitUtility.markForDeletion(file3);
            logger.logp(Level.FINER, className, string2, "Marked for cleanup deletion.");
            try {
                InputStream inputStream = loadStrategy.getInputStream(string);
                FileOutputStream fileOutputStream = new FileOutputStream(file3);
                ArchiveUtil.copy(inputStream, fileOutputStream);
                tempZipFileLoadStrategyImpl = new TempZipFileLoadStrategyImpl(file3);
            }
            catch (IOException iOException3) {
                logger.logp(Level.SEVERE, className, string2, "Could not create temporary copy of [ {0} ]", string);
                logger.logp(Level.SEVERE, className, string2, "This failure usually results in very slow performance while performing application operations.");
                logger.throwing(className, string2, iOException3);
                logger.logp(Level.FINER, className, string2, "RETURN [ null ]");
                return null;
            }
            logger.logp(Level.FINER, className, string2, "RETURN [ {0} ]", tempZipFileLoadStrategyImpl);
            return tempZipFileLoadStrategyImpl;
        }
    }

    public String getSystemTempDirName(String string) {
        String string2 = "getSystemTempDirName";
        try {
            String string3 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("java.io.tmpdir");
                }
            });
            return string3;
        }
        catch (SecurityException securityException) {
            logger.logp(Level.FINER, className, string2, "RETURN null - system temp directory name could not be retrieved");
            return null;
        }
    }

    public WARFile createWARFileInitialized(String string) {
        WARFile wARFile = this.createWARFile();
        this.initializeNewWARFile(wARFile, string);
        return wARFile;
    }

    protected ArchiveOptions defaultOptions(LoadStrategy loadStrategy) {
        ArchiveOptions archiveOptions = new ArchiveOptions();
        archiveOptions.setLoadStrategy(loadStrategy);
        return archiveOptions;
    }

    public static CommonarchiveFactory getActiveFactory() {
        CommonarchivePackage commonarchivePackage = CommonarchiveFactoryImpl.getPackage();
        if (commonarchivePackage != null) {
            return commonarchivePackage.getCommonarchiveFactory();
        }
        return null;
    }

    public String[] getManifestClassPathValues(String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(string);
        String[] stringArray = archive.getManifest().getClassPathTokenized();
        archive.close();
        return stringArray;
    }

    public Map getOpenArchives() {
        return this.openArchives;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getOpenArchivesDependingOn(Archive archive) {
        Map map;
        Map map2 = map = this.getOpenArchives();
        synchronized (map2) {
            Object object;
            HashSet<Object> hashSet = new HashSet<Object>();
            Iterator iterator = this.getOpenArchives().keySet().iterator();
            while (iterator.hasNext()) {
                object = (Archive)iterator.next();
                if (object == archive || !object.isIndexed()) continue;
                EList eList = object.getFiles();
                for (int i = 0; i < eList.size(); ++i) {
                    File file = (File)eList.get(i);
                    if (file.getLoadingContainer() != archive) continue;
                    Object object2 = object;
                    for (Container container = object.getContainer(); container != null && container.isArchive(); container = container.getContainer()) {
                        object2 = (Archive)container;
                    }
                    hashSet.add(object2);
                }
            }
            object = archive.getArchiveFiles();
            for (int i = 0; i < object.size(); ++i) {
                hashSet.addAll(this.getOpenArchivesDependingOn((Archive)object.get(i)));
            }
            return hashSet;
        }
    }

    protected static void initPrereqs() {
        ArchiveInit.invokePrereqInits(true);
        ArchiveTypeDiscriminator archiveTypeDiscriminator = RootArchiveTypeDescriminatorImpl.singleton();
        archiveTypeDiscriminator.addChild(Ear12ImportStrategyImpl.getDiscriminator());
        archiveTypeDiscriminator.addChild(Ear30NoDDImportStrategyImpl.getDiscriminator());
        archiveTypeDiscriminator.addChild(War22ImportStrategyImpl.getDiscriminator());
        archiveTypeDiscriminator.addChild(RootEJBJarDescriminatorImpl.singleton());
        archiveTypeDiscriminator.addChild(RootAppClientJarDescriminatorImpl.singleton());
        archiveTypeDiscriminator.addChild(RarImportStrategyImpl.getDiscriminator());
    }

    public void initializeNewApplicationClientFile(ApplicationClientFile applicationClientFile, String string) {
        this.initializeNewModuleFile(applicationClientFile, string);
    }

    public void initializeNewArchive(Archive archive, String string) {
        archive.setURI(string);
        archive.setSize(0L);
        archive.setLastModified(System.currentTimeMillis());
        archive.setDirectoryEntry(false);
        archive.setLoadStrategy(this.createEmptyLoadStrategy());
    }

    public void initializeNewEARFile(EARFile eARFile, String string) {
        this.initializeNewModuleFile(eARFile, string);
    }

    public void initializeNewEJBJarFile(EJBJarFile eJBJarFile, String string) {
        this.initializeNewModuleFile(eJBJarFile, string);
    }

    public void initializeNewModuleFile(ModuleFile moduleFile, String string) {
        this.initializeNewArchive(moduleFile, string);
        moduleFile.makeDeploymentDescriptorResource();
    }

    public void initializeNewRARFile(RARFile rARFile, String string) {
        this.initializeNewModuleFile(rARFile, string);
    }

    public void initializeNewWARFile(WARFile wARFile, String string) {
        this.initializeNewModuleFile(wARFile, string);
    }

    public void initializeNewApplicationClientFile(ApplicationClientFile applicationClientFile, String string, ArchiveOptions archiveOptions) {
        this.initializeNewModuleFile(applicationClientFile, string, archiveOptions);
    }

    public void initializeNewArchive(Archive archive, String string, ArchiveOptions archiveOptions) {
        if (archiveOptions.getLoadStrategy() == null) {
            try {
                archiveOptions.setLoadStrategy(this.createEmptyLoadStrategy());
            }
            catch (Exception exception) {
                logger.severe(exception.getMessage());
            }
        }
        archive.setURI(string);
        archive.setSize(0L);
        archive.setLastModified(System.currentTimeMillis());
        archive.setDirectoryEntry(false);
        archive.setLoadStrategy(archiveOptions.getLoadStrategy());
        archive.setOptions(archiveOptions);
    }

    public void initializeNewEARFile(EARFile eARFile, String string, ArchiveOptions archiveOptions) {
        this.initializeNewModuleFile(eARFile, string, archiveOptions);
    }

    public void initializeNewEJBJarFile(EJBJarFile eJBJarFile, String string, ArchiveOptions archiveOptions) {
        this.initializeNewModuleFile(eJBJarFile, string, archiveOptions);
    }

    public void initializeNewModuleFile(ModuleFile moduleFile, String string, ArchiveOptions archiveOptions) {
        this.initializeNewArchive(moduleFile, string, archiveOptions);
        moduleFile.makeDeploymentDescriptorResource();
    }

    public void initializeNewRARFile(RARFile rARFile, String string, ArchiveOptions archiveOptions) {
        this.initializeNewModuleFile(rARFile, string, archiveOptions);
    }

    public void initializeNewWARFile(WARFile wARFile, String string, ArchiveOptions archiveOptions) {
        this.initializeNewModuleFile(wARFile, string, archiveOptions);
    }

    public ApplicationClientFile openApplicationClientFile(ArchiveOptions archiveOptions, String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(archiveOptions, string);
        ArchiveTypeDiscriminator archiveTypeDiscriminator = RootAppClientJarDescriminatorImpl.singleton();
        return (ApplicationClientFile)this.openSpecificArchive(archive, archiveTypeDiscriminator);
    }

    public ApplicationClientFile openApplicationClientFile(LoadStrategy loadStrategy, String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(loadStrategy, string);
        ArchiveTypeDiscriminator archiveTypeDiscriminator = RootAppClientJarDescriminatorImpl.singleton();
        return (ApplicationClientFile)this.openSpecificArchive(archive, archiveTypeDiscriminator);
    }

    public ApplicationClientFile openApplicationClientFile(String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(string);
        ArchiveTypeDiscriminator archiveTypeDiscriminator = RootAppClientJarDescriminatorImpl.singleton();
        return (ApplicationClientFile)this.openSpecificArchive(archive, archiveTypeDiscriminator);
    }

    public Archive openArchive(ArchiveOptions archiveOptions, String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(archiveOptions, string);
        return this.openSpecificArchive(archive, RootArchiveTypeDescriminatorImpl.singleton());
    }

    public Archive openArchive(LoadStrategy loadStrategy, String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(loadStrategy, string);
        return this.openSpecificArchive(archive, RootArchiveTypeDescriminatorImpl.singleton());
    }

    public Archive openArchive(String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(string);
        return this.openSpecificArchive(archive, RootArchiveTypeDescriminatorImpl.singleton());
    }

    public Archive openArchive(String string, String string2) throws OpenFailureException {
        Archive archive = this.primOpenArchive(string);
        archive.setExtraClasspath(string2);
        return this.openSpecificArchive(archive, RootArchiveTypeDescriminatorImpl.singleton());
    }

    public EARFile openEARFile(ArchiveOptions archiveOptions, String string) throws OpenFailureException {
        String string2 = "openEARFile";
        logger.logp(Level.FINER, className, string2, "ENTRY [ {0} }", string);
        Archive archive = this.primOpenArchive(archiveOptions, string);
        ArchiveTypeDiscriminator archiveTypeDiscriminator = RootEARFileDescriminatorImpl.singleton();
        EARFile eARFile = (EARFile)this.openSpecificArchive(archive, archiveTypeDiscriminator);
        logger.logp(Level.FINER, className, string2, "RETURN [ {0} ]", eARFile);
        return eARFile;
    }

    public EARFile openEARFile(LoadStrategy loadStrategy, String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(loadStrategy, string);
        ArchiveTypeDiscriminator archiveTypeDiscriminator = RootEARFileDescriminatorImpl.singleton();
        return (EARFile)this.openSpecificArchive(archive, archiveTypeDiscriminator);
    }

    public EARFile openEARFile(String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(string);
        ArchiveTypeDiscriminator archiveTypeDiscriminator = RootEARFileDescriminatorImpl.singleton();
        return (EARFile)this.openSpecificArchive(archive, archiveTypeDiscriminator);
    }

    public EJBJarFile openEJB11JarFile(ArchiveOptions archiveOptions, String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(archiveOptions, string);
        ArchiveTypeDiscriminator archiveTypeDiscriminator = EjbJar11ImportStrategyImpl.getDiscriminator();
        return (EJBJarFile)this.openSpecificArchive(archive, archiveTypeDiscriminator);
    }

    public EJBJarFile openEJB11JarFile(LoadStrategy loadStrategy, String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(loadStrategy, string);
        ArchiveTypeDiscriminator archiveTypeDiscriminator = EjbJar11ImportStrategyImpl.getDiscriminator();
        return (EJBJarFile)this.openSpecificArchive(archive, archiveTypeDiscriminator);
    }

    public EJBJarFile openEJB11JarFile(String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(string);
        ArchiveTypeDiscriminator archiveTypeDiscriminator = EjbJar11ImportStrategyImpl.getDiscriminator();
        return (EJBJarFile)this.openSpecificArchive(archive, archiveTypeDiscriminator);
    }

    public EJBJarFile openEJBJarFile(ArchiveOptions archiveOptions, String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(archiveOptions, string);
        RootEJBJarDescriminatorImpl rootEJBJarDescriminatorImpl = (RootEJBJarDescriminatorImpl)RootEJBJarDescriminatorImpl.singleton();
        return (EJBJarFile)this.openSpecificArchive(archive, rootEJBJarDescriminatorImpl);
    }

    public EJBJarFile openEJBJarFile(LoadStrategy loadStrategy, String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(loadStrategy, string);
        RootEJBJarDescriminatorImpl rootEJBJarDescriminatorImpl = (RootEJBJarDescriminatorImpl)RootEJBJarDescriminatorImpl.singleton();
        return (EJBJarFile)this.openSpecificArchive(archive, rootEJBJarDescriminatorImpl);
    }

    public EJBJarFile openEJBJarFile(LoadStrategy loadStrategy, String string, String string2) throws OpenFailureException {
        Archive archive = this.primOpenArchive(loadStrategy, string);
        archive.setExtraClasspath(string2);
        RootEJBJarDescriminatorImpl rootEJBJarDescriminatorImpl = (RootEJBJarDescriminatorImpl)RootEJBJarDescriminatorImpl.singleton();
        return (EJBJarFile)this.openSpecificArchive(archive, rootEJBJarDescriminatorImpl);
    }

    public EJBJarFile openEJBJarFile(String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(string);
        RootEJBJarDescriminatorImpl rootEJBJarDescriminatorImpl = (RootEJBJarDescriminatorImpl)RootEJBJarDescriminatorImpl.singleton();
        return (EJBJarFile)this.openSpecificArchive(archive, rootEJBJarDescriminatorImpl);
    }

    public EJBJarFile openEJBJarFile(String string, String string2) throws OpenFailureException {
        Archive archive = this.primOpenArchive(string);
        archive.setExtraClasspath(string2);
        RootEJBJarDescriminatorImpl rootEJBJarDescriminatorImpl = (RootEJBJarDescriminatorImpl)RootEJBJarDescriminatorImpl.singleton();
        return (EJBJarFile)this.openSpecificArchive(archive, rootEJBJarDescriminatorImpl);
    }

    public Archive openNestedArchive(LooseArchive looseArchive, Archive archive) throws OpenFailureException {
        String string = "openNestedArchive - loose";
        String string2 = looseArchive.getUri();
        logger.entering(className, string, string2);
        LoadStrategy loadStrategy = null;
        ArchiveOptions archiveOptions = null;
        try {
            if (looseArchive.getBinariesPath() == null) {
                logger.logp(Level.SEVERE, className, string, "No Binaries Path for Loose Archive [ {0} ]", string2);
                this.logLooseArchiveCharacteristics(Level.FINER, className, string, looseArchive, archive);
                logger.exiting(className, string, "Throwing OpenFailureException");
                throw new OpenFailureException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.open_nested_EXC_, new Object[]{string2, archive.getURI()}), null);
            }
            loadStrategy = this.createLoadStrategy(looseArchive.getBinariesPath());
            loadStrategy.setLooseArchive(looseArchive);
            archiveOptions = archive.getOptions().cloneWith(loadStrategy, looseArchive.getUri());
            Archive archive2 = this.primOpenArchive(archiveOptions, string2);
            logger.logp(Level.FINER, className, string, "RETURN primOpenArchive returned [ {0} ]", archive2);
            return archive2;
        }
        catch (IOException iOException) {
            logger.severe(iOException.getMessage());
            this.logLooseArchiveCharacteristics(Level.FINER, className, string, looseArchive, archive);
            logger.exiting(className, string, "Throwing OpenFailureException");
            throw new OpenFailureException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.open_nested_EXC_, new Object[]{string2, archive.getURI()}), iOException);
        }
    }

    public Archive openNestedArchive(String string, Archive archive) throws OpenFailureException {
        String string2 = "openNestedArchive";
        logger.logp(Level.FINER, className, string2, "ENTRY URI [ {0} ]", string);
        if (archive != null) {
            logger.logp(Level.FINER, className, string2, "Parent archive[ {0} ]", archive.getURI());
        } else {
            logger.logp(Level.FINER, className, string2, "Parent archive is null");
        }
        LoadStrategy loadStrategy = null;
        ArchiveOptions archiveOptions = null;
        try {
            loadStrategy = this.createChildLoadStrategy(string, archive.getLoadStrategy());
            archiveOptions = archive.getOptions().cloneWith(loadStrategy, string);
            if (archiveOptions.shouldDiscriminateNestedArchives()) {
                Archive archive2 = this.openArchive(archiveOptions, string);
                logger.logp(Level.FINER, className, string2, "RETURN openArchive returned [ {0} ]", archive2);
                return archive2;
            }
            Archive archive3 = this.primOpenArchive(archiveOptions, string);
            logger.logp(Level.FINER, className, string2, "RETURN primOpenArchive returned [ {0} ]", archive3);
            return archive3;
        }
        catch (IOException iOException) {
            logger.severe(iOException.getMessage());
            this.logArchiveCharacteristics(Level.FINER, className, string2, archive);
            logger.exiting(className, string2, "Throwing OpenFailureException");
            throw new OpenFailureException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.open_nested_EXC_, new Object[]{string, archive.getURI()}), iOException);
        }
    }

    public RARFile openRARFile(ArchiveOptions archiveOptions, String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(archiveOptions, string);
        ArchiveTypeDiscriminator archiveTypeDiscriminator = RarImportStrategyImpl.getDiscriminator();
        return (RARFile)this.openSpecificArchive(archive, archiveTypeDiscriminator);
    }

    public RARFile openRARFile(LoadStrategy loadStrategy, String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(loadStrategy, string);
        ArchiveTypeDiscriminator archiveTypeDiscriminator = RarImportStrategyImpl.getDiscriminator();
        return (RARFile)this.openSpecificArchive(archive, archiveTypeDiscriminator);
    }

    public RARFile openRARFile(String string) throws OpenFailureException {
        Archive archive = this.primOpenArchive(string);
        ArchiveTypeDiscriminator archiveTypeDiscriminator = RarImportStrategyImpl.getDiscriminator();
        return (RARFile)this.openSpecificArchive(archive, archiveTypeDiscriminator);
    }

    public ReadOnlyDirectory openReadOnlyDirectory(String string) throws IOException {
        java.io.File file = new java.io.File(string);
        if (!file.exists()) {
            throw new FileNotFoundException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.could_not_find_dir_EXC_, new Object[]{string}));
        }
        if (!file.isDirectory()) {
            throw new IOException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.not_a_dir_EXC_, new Object[]{string}));
        }
        ReadOnlyDirectoryLoadStrategyImpl readOnlyDirectoryLoadStrategyImpl = new ReadOnlyDirectoryLoadStrategyImpl(string);
        ReadOnlyDirectory readOnlyDirectory = this.createReadOnlyDirectory();
        readOnlyDirectory.setURI(string);
        readOnlyDirectory.setLoadStrategy(readOnlyDirectoryLoadStrategyImpl);
        readOnlyDirectory.setLastModified(file.lastModified());
        return readOnlyDirectory;
    }

    protected Archive openSpecificArchive(Archive archive, ArchiveTypeDiscriminator archiveTypeDiscriminator) throws OpenFailureException {
        String string = "openSpecificArchive";
        String string2 = archive.getURI();
        logger.logp(Level.FINER, className, string, "ENTRY uri [ {0} ]", string2);
        if (!archiveTypeDiscriminator.canImport(archive)) {
            archive.close();
            this.logArchiveCharacteristics(Level.FINER, className, string, archive);
            logger.exiting(className, string, "Throwing OpenFailureException");
            throw new OpenFailureException(archiveTypeDiscriminator.getUnableToOpenMessage());
        }
        Archive archive2 = archiveTypeDiscriminator.openArchive(archive);
        archive2.initializeAfterOpen();
        this.logArchiveCharacteristics(Level.CONFIG, className, string, archive2);
        logger.exiting(className, string, archive2);
        return archive2;
    }

    protected Archive openSpecificArchive(Archive archive, RootEJBJarDescriminatorImpl rootEJBJarDescriminatorImpl) throws OpenFailureException {
        String string = "openSpecificArchive - ejbjar";
        String string2 = archive.getURI();
        logger.entering(className, string, new Object[]{string2, rootEJBJarDescriminatorImpl});
        Archive archive2 = this.openSpecificArchive(archive, (ArchiveTypeDiscriminator)rootEJBJarDescriminatorImpl);
        if (archive2 == archive) {
            archive.close();
            this.logArchiveCharacteristics(Level.FINER, className, string, archive);
            logger.exiting(className, string, "Throwing OpenFailureException");
            throw new OpenFailureException(rootEJBJarDescriminatorImpl.getUnableToOpenMessage());
        }
        logger.exiting(className, string, archive2);
        return archive2;
    }

    public WARFile openWARFile(ArchiveOptions archiveOptions, String string) throws OpenFailureException {
        String string2 = "openWARFile - options";
        logger.logp(Level.FINER, className, string2, "ENTRY URI [ {0} ]", string);
        Archive archive = this.primOpenArchive(archiveOptions, string);
        ArchiveTypeDiscriminator archiveTypeDiscriminator = War22ImportStrategyImpl.getDiscriminator();
        WARFile wARFile = (WARFile)this.openSpecificArchive(archive, archiveTypeDiscriminator);
        logger.logp(Level.FINER, className, string2, "RETURN [ {0} ]", wARFile);
        return wARFile;
    }

    public WARFile openWARFile(LoadStrategy loadStrategy, String string) throws OpenFailureException {
        String string2 = "openWARFile - LoadStrategy";
        logger.logp(Level.FINER, className, string2, "ENTRY URI [ {0} ]", string);
        Archive archive = this.primOpenArchive(loadStrategy, string);
        ArchiveTypeDiscriminator archiveTypeDiscriminator = War22ImportStrategyImpl.getDiscriminator();
        WARFile wARFile = (WARFile)this.openSpecificArchive(archive, archiveTypeDiscriminator);
        logger.logp(Level.FINER, className, string2, "RETURN [ {0} ]", wARFile);
        return wARFile;
    }

    public WARFile openWARFile(String string) throws OpenFailureException {
        String string2 = "openWARFile - uri";
        logger.logp(Level.FINER, className, string2, "ENTRY URI [ {0} ]", string);
        Archive archive = this.primOpenArchive(string);
        ArchiveTypeDiscriminator archiveTypeDiscriminator = War22ImportStrategyImpl.getDiscriminator();
        WARFile wARFile = (WARFile)this.openSpecificArchive(archive, archiveTypeDiscriminator);
        logger.logp(Level.FINER, className, string2, "RETURN [ {0} ]", wARFile);
        return wARFile;
    }

    public Archive primOpenArchive(ArchiveOptions archiveOptions, String string) throws OpenFailureException {
        String string2 = "primOpenArchive";
        logger.entering(className, string2, string);
        if (archiveOptions.getLoadStrategy() == null) {
            try {
                logger.logp(Level.FINER, className, string2, "Create a LoadStrategy");
                archiveOptions.setLoadStrategy(this.createLoadStrategy(string));
            }
            catch (IOException iOException) {
                logger.exiting(className, string2, "Throwing OpenFailureException");
                throw new OpenFailureException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.could_not_open_EXC_, new Object[]{string}), iOException);
            }
        }
        Archive archive = this.createArchive();
        archive.setURI(string);
        archive.setOriginalURI(string);
        archive.setLoadStrategy(archiveOptions.getLoadStrategy());
        archive.setOptions(archiveOptions);
        ArchiveTypeDiscriminatorRegistry.getInstance().contributeTypes(archive);
        logger.exiting(className, string2, archive);
        return archive;
    }

    public Archive primOpenArchive(LoadStrategy loadStrategy, String string) throws OpenFailureException {
        return this.primOpenArchive(this.defaultOptions(loadStrategy), string);
    }

    public Archive primOpenArchive(String string) throws OpenFailureException {
        return this.primOpenArchive(new ArchiveOptions(), string);
    }

    protected void setOpenArchives(Map map) {
        this.openArchives = map;
    }

    public WARFile createWARFileGen() {
        WARFileImpl wARFileImpl = new WARFileImpl();
        return wARFileImpl;
    }

    public EJBJarFile createEJBJarFileGen() {
        EJBJarFileImpl eJBJarFileImpl = new EJBJarFileImpl();
        return eJBJarFileImpl;
    }

    public ApplicationClientFile createApplicationClientFileGen() {
        ApplicationClientFileImpl applicationClientFileImpl = new ApplicationClientFileImpl();
        return applicationClientFileImpl;
    }

    public EARFile createEARFileGen() {
        EARFileImpl eARFileImpl = new EARFileImpl();
        return eARFileImpl;
    }

    public RARFile createRARFileGen() {
        RARFileImpl rARFileImpl = new RARFileImpl();
        return rARFileImpl;
    }

    public File createFile() {
        FileImpl fileImpl = new FileImpl();
        return fileImpl;
    }

    public ReadOnlyDirectory createReadOnlyDirectory() {
        ReadOnlyDirectoryImpl readOnlyDirectoryImpl = new ReadOnlyDirectoryImpl();
        return readOnlyDirectoryImpl;
    }

    public CommonarchivePackage getCommonarchivePackage() {
        return (CommonarchivePackage)this.getEPackage();
    }

    public static CommonarchivePackage getPackage() {
        return CommonarchivePackage.eINSTANCE;
    }

    public EJBModuleRef createEJBModuleRefGen() {
        EJBModuleRefImpl eJBModuleRefImpl = new EJBModuleRefImpl();
        return eJBModuleRefImpl;
    }

    public WebModuleRef createWebModuleRefGen() {
        WebModuleRefImpl webModuleRefImpl = new WebModuleRefImpl();
        return webModuleRefImpl;
    }

    public ClientModuleRef createClientModuleRefGen() {
        ClientModuleRefImpl clientModuleRefImpl = new ClientModuleRefImpl();
        return clientModuleRefImpl;
    }

    public ConnectorModuleRef createConnectorModuleRefGen() {
        ConnectorModuleRefImpl connectorModuleRefImpl = new ConnectorModuleRefImpl();
        return connectorModuleRefImpl;
    }

    public ClientModuleRef createClientModuleRef(ApplicationClientFile applicationClientFile) {
        ClientModuleRef clientModuleRef = this.createClientModuleRef();
        clientModuleRef.setModuleFile(applicationClientFile);
        return clientModuleRef;
    }

    public ConnectorModuleRef createConnectorModuleRef(RARFile rARFile) {
        ConnectorModuleRef connectorModuleRef = this.createConnectorModuleRef();
        connectorModuleRef.setModuleFile(rARFile);
        return connectorModuleRef;
    }

    public EJBModuleRef createEJBModuleRef(EJBJarFile eJBJarFile) {
        EJBModuleRef eJBModuleRef = this.createEJBModuleRef();
        eJBModuleRef.setModuleFile(eJBJarFile);
        return eJBModuleRef;
    }

    public WebModuleRef createWebModuleRef(WARFile wARFile) {
        WebModuleRef webModuleRef = this.createWebModuleRef();
        webModuleRef.setModuleFile(wARFile);
        return webModuleRef;
    }

    public Archive createArchive() {
        ArchiveImpl archiveImpl = new ArchiveImpl();
        return archiveImpl;
    }

    public ApplicationClientFile createApplicationClientFile() {
        return CommonArchiveFactoryRegistry.INSTANCE.getCommonArchiveFactory().createApplicationClientFile();
    }

    public ClientModuleRef createClientModuleRef() {
        return CommonArchiveFactoryRegistry.INSTANCE.getCommonArchiveFactory().createClientModuleRef();
    }

    public ConnectorModuleRef createConnectorModuleRef() {
        return CommonArchiveFactoryRegistry.INSTANCE.getCommonArchiveFactory().createConnectorModuleRef();
    }

    public EARFile createEARFile() {
        return CommonArchiveFactoryRegistry.INSTANCE.getCommonArchiveFactory().createEARFile();
    }

    public EJBJarFile createEJBJarFile() {
        return CommonArchiveFactoryRegistry.INSTANCE.getCommonArchiveFactory().createEJBJarFile();
    }

    public EJBModuleRef createEJBModuleRef() {
        return CommonArchiveFactoryRegistry.INSTANCE.getCommonArchiveFactory().createEJBModuleRef();
    }

    public RARFile createRARFile() {
        return CommonArchiveFactoryRegistry.INSTANCE.getCommonArchiveFactory().createRARFile();
    }

    public WARFile createWARFile() {
        return CommonArchiveFactoryRegistry.INSTANCE.getCommonArchiveFactory().createWARFile();
    }

    public WebModuleRef createWebModuleRef() {
        return CommonArchiveFactoryRegistry.INSTANCE.getCommonArchiveFactory().createWebModuleRef();
    }

    public CommonarchiveFactory getDelegate() {
        return this.delegate;
    }

    private void logLooseArchiveCharacteristics(Level level, String string, String string2, LooseArchive looseArchive, Archive archive) {
        if (!logger.isLoggable(level)) {
            return;
        }
        StringBuffer stringBuffer = null;
        if (looseArchive != null) {
            stringBuffer = new StringBuffer("Loose Archive [ ").append(looseArchive.getUri()).append(" ] characteristics:\n");
            stringBuffer.append("\n\nLoose Archive [ ").append(looseArchive).append(" ]");
            stringBuffer.append("\n    Loose Archive URI    [ ").append(looseArchive.getUri()).append(" ]");
            String string3 = looseArchive.getBinariesPath();
            stringBuffer.append("\n        Binaries Path    [ ").append(this.confirmedPath(string3)).append(" ]");
            string3 = looseArchive.getResourcesPath();
            stringBuffer.append("\n        Resources Path   [ ").append(this.confirmedPath(string3)).append(" ]");
            LooseApplication looseApplication = looseArchive.getLooseApp();
            stringBuffer.append("\n        Loose App        [ ").append(looseApplication).append(" ]");
            if (looseApplication != null) {
                stringBuffer.append("\n            App URI      [ ").append(looseApplication.getUri()).append(" ]");
                string3 = looseApplication.getBinariesPath();
                stringBuffer.append("\n            Binaries Path[ ").append(this.confirmedPath(string3)).append(" ]");
                string3 = looseApplication.getResourcesPath();
                stringBuffer.append("\n            ResourcesPath[ ").append(this.confirmedPath(string3)).append(" ]");
            }
        } else {
            stringBuffer = new StringBuffer("Loose Archive is null");
        }
        logger.logp(level, string, string2, stringBuffer.toString());
        this.logArchiveCharacteristics(level, string, string2, archive);
    }

    private void logArchiveCharacteristics(Level level, String string, String string2, Archive archive) {
        if (!logger.isLoggable(level)) {
            return;
        }
        StringBuffer stringBuffer = null;
        if (archive != null) {
            Object object;
            Object object2;
            stringBuffer = new StringBuffer("Archive [ ").append(archive.getURI()).append(" ] characteristics:\n");
            stringBuffer.append("\n\nArchive                               [ ").append(archive.getClass().getName()).append("@").append(Integer.toHexString(this.hashCode())).append(" ]");
            stringBuffer.append("\n    Archive URI                       [ ").append(archive.getURI()).append(" ]");
            try {
                object2 = archive.getAbsolutePath();
                stringBuffer.append("\n        Absolute Path                 [ ").append(this.confirmedPath((String)object2)).append(" ]");
            }
            catch (FileNotFoundException fileNotFoundException) {
                stringBuffer.append("\n        Absolute Path                 [ unknown ]");
            }
            try {
                object2 = archive.getBinariesPath();
                stringBuffer.append("\n        Binaries Path                 [ ").append(this.confirmedPath((String)object2)).append(" ]");
            }
            catch (FileNotFoundException fileNotFoundException) {
                stringBuffer.append("\n        Binaries Path                 [ unknown ]");
            }
            try {
                object2 = archive.getResourcesPath();
                stringBuffer.append("\n        Resources Path                [ ").append(this.confirmedPath((String)object2)).append(" ]");
            }
            catch (FileNotFoundException fileNotFoundException) {
                stringBuffer.append("\n        Resources Path                [ unknown ]");
            }
            object2 = archive.getOptions();
            stringBuffer.append("\n        Archive Options               [ ").append(object2).append(" ]");
            if (object2 != null) {
                object = ((ArchiveOptions)object2).getParentEarBinariesPath();
                stringBuffer.append("\n            EAR ParentEarBinariesPath [ ").append(this.confirmedPath((String)object)).append(" ]");
                if (((ArchiveOptions)object2).isSetAltBinariesPath()) {
                    object = ((ArchiveOptions)object2).getAltBinariesPath();
                    stringBuffer.append("\n            EAR AltBinariesPath       [ ").append(this.confirmedPath((String)object)).append(" ]");
                } else {
                    stringBuffer.append("\n            EAR AltBinariesPath       [ <unset> ]");
                }
                stringBuffer.append("\n            Use Java Reflection       [ ").append(((ArchiveOptions)object2).useJavaReflection()).append(" ]");
            }
            object = archive.getManifest();
            stringBuffer.append("\n        Manifest                      [ ").append(object).append(" ]");
            if (object != null) {
                stringBuffer.append("\n            Manifest classpath        [ ").append(object.getClassPath()).append(" ]");
            }
            LoadStrategy loadStrategy = archive.getLoadStrategy();
            stringBuffer.append("\n        Load Strategy                 [ ").append(loadStrategy).append(" ]");
        } else {
            stringBuffer = new StringBuffer("Archive is null");
        }
        stringBuffer.append("\n    ArchiveImpl                       [ ").append("@(#) 1.3.1.8 FEPSPQ/ws/code/jst.j2ee.core.archive/src/org/eclipse/jst/j2ee/commonarchivecore/internal/impl/CommonarchiveFactoryImpl.java, WAS.prereq.ies, WAS61.FEPSPQ, cf230901.13 7/31/08 07:19:34 [2/12/09 13:46:39]").append(" ]\n");
        logger.logp(level, string, string2, stringBuffer.toString());
        ArchiveUtil.dumpStackTrace(string, string2);
    }

    private String confirmedPath(String string) {
        java.io.File file;
        if (string != null && !(file = new java.io.File(string)).exists()) {
            java.io.File file2 = new java.io.File(file.getParent());
            if (file2.exists() && file2.isFile()) {
                return "FILE DOES NOT EXIST (but parent file does) : " + string;
            }
            return "FILE DOES NOT EXIST : " + string;
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        CommonarchiveFactoryImpl.initPrereqs();
    }
}

