/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.impl;

import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jem.internal.java.adapters.jdk.JavaJDKAdapterFactory;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ArchiveTypeDiscriminatorRegistry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ReadOnlyDirectory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ManifestException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ReopenException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ResourceLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifestImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.FileIterator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.RuntimeClasspathEntry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.RuntimeClasspathEntryImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.SaveFilter;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ContainerImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.DirectorySaveStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ZipFileLoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ZipStreamSaveStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveFileDynamicClassLoader;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ClasspathUtil;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseArchive;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;
import org.eclipse.wst.common.internal.emf.utilities.ExtendedEcoreUtil;

public class ArchiveImpl
extends ContainerImpl
implements Archive {
    protected static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    protected static Logger loggerLCT = Logger.getLogger("com.ibm.config.eclipse.wtp.lct");
    private static String className = (class$org$eclipse$jst$j2ee$commonarchivecore$internal$impl$ArchiveImpl == null ? (class$org$eclipse$jst$j2ee$commonarchivecore$internal$impl$ArchiveImpl = ArchiveImpl.class$("org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ArchiveImpl")) : class$org$eclipse$jst$j2ee$commonarchivecore$internal$impl$ArchiveImpl).getName();
    protected EList types = null;
    protected ArchiveManifest manifest;
    protected SaveStrategy saveStrategy;
    protected SaveFilter saveFilter;
    protected String xmlEncoding = "UTF-8";
    protected ClassLoader archiveClassLoader;
    protected String extraClasspath;
    protected ArchiveOptions options;
    private String displayMsg;
    static /* synthetic */ Class class$org$eclipse$jst$j2ee$commonarchivecore$internal$impl$ArchiveImpl;
    static /* synthetic */ Class class$java$lang$String;

    public ArchiveImpl() {
        this.getCommonArchiveFactory().archiveOpened(this);
    }

    protected EClass eStaticClass() {
        return CommonarchivePackage.Literals.ARCHIVE;
    }

    public EList getTypes() {
        if (this.types == null) {
            this.types = new EDataTypeUniqueEList(class$java$lang$String == null ? (class$java$lang$String = ArchiveImpl.class$("java.lang.String")) : class$java$lang$String, this, 8);
        }
        return this.types;
    }

    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 8: {
                return this.getTypes();
            }
        }
        return super.eGet(n, bl, bl2);
    }

    public void eSet(int n, Object object) {
        switch (n) {
            case 8: {
                this.getTypes().clear();
                this.getTypes().addAll((Collection)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    public void eUnset(int n) {
        switch (n) {
            case 8: {
                this.getTypes().clear();
                return;
            }
        }
        super.eUnset(n);
    }

    public boolean eIsSet(int n) {
        switch (n) {
            case 8: {
                return this.types != null && !this.types.isEmpty();
            }
        }
        return super.eIsSet(n);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" (types: ");
        stringBuffer.append(this.types);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public Archive addCopy(Archive archive) throws DuplicateObjectException {
        this.checkAddValid(archive);
        Archive archive2 = this.getCommonArchiveFactory().copy(archive);
        this.getFiles().add(archive2);
        return archive2;
    }

    public File addCopy(File file) throws DuplicateObjectException {
        if (file.isReadOnlyDirectory()) {
            this.addCopy((ReadOnlyDirectory)file);
            return null;
        }
        this.checkAddValid(file);
        File file2 = this.copy(file);
        this.getFiles().add(file2);
        return file2;
    }

    public List addCopy(ReadOnlyDirectory readOnlyDirectory) throws DuplicateObjectException {
        return this.addCopyFiles(readOnlyDirectory.getFilesRecursive());
    }

    public List addCopyFiles(List list) throws DuplicateObjectException {
        this.getFiles();
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int i = 0; i < list.size(); ++i) {
            File file = (File)list.get(i);
            this.checkAddValid(file);
            arrayList.add(this.copy(file));
        }
        this.getFiles().addAll(arrayList);
        return arrayList;
    }

    public void addOrReplaceMofResource(Resource resource) {
        this.getLoadStrategy().addOrReplaceMofResource(resource);
    }

    public boolean canClose() {
        return !this.getCommonArchiveFactory().getOpenArchivesDependingOn(this).isEmpty();
    }

    protected void checkAddValid(File file) throws DuplicateObjectException {
        this.checkAddValid(file.getURI());
    }

    protected void checkAddValid(String string) throws DuplicateObjectException {
        try {
            File file = this.getFile(string);
            if (file != null) {
                throw new DuplicateObjectException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.duplicate_file_EXC_, new Object[]{this.getURI(), string}), file);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void setLoadStrategy(LoadStrategy loadStrategy) {
        super.setLoadStrategy(loadStrategy);
        if (this.loadStrategy != null && this.isModuleFile()) {
            this.getJavaAdapterFactory();
        }
    }

    protected void cleanupAfterTempSave(String string, java.io.File file, java.io.File file2) throws SaveFailureException {
        String string2 = "cleanupAfterTempSave";
        logger.logp(Level.FINER, className, string2, "ENTRY URI = [ {0} ]", string);
        this.checkWriteable(file);
        boolean bl = false;
        String string3 = file.getAbsolutePath();
        logger.logp(Level.FINER, className, string2, "Original file to be deleted [ {0} ]", string3);
        boolean bl2 = file.isDirectory();
        logger.logp(Level.FINER, className, string2, "Original file a directory [ {0} ]", Boolean.toString(bl2));
        if (!this.canRename(file)) {
            logger.logp(Level.FINER, className, string2, "RETURN Throwing SaveFailureException because original file cannot be renamed");
            if (logger.isLoggable(Level.FINEST)) {
                new Throwable("Debug data for " + string2).printStackTrace(System.out);
            }
            throw new SaveFailureException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.unable_replace_EXC_, new Object[]{string3}));
        }
        for (int i = 0; i < 10; ++i) {
            if (ArchiveUtil.delete(file)) {
                logger.logp(Level.FINER, className, string2, "Successfully deleted original file [ {0} ]", string3);
                if (i > 0) {
                    logger.logp(Level.FINER, className, string2, "Number of times slept [ {0} ]", Integer.toString(i));
                }
                bl = true;
                break;
            }
            try {
                Thread.sleep(250L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        String string4 = file2.getAbsolutePath();
        logger.logp(Level.FINER, className, string2, "File to be renamed [ {0} ]", string4);
        if (bl) {
            if (this.renameToWithRetry(file2, file)) {
                logger.logp(Level.FINER, className, string2, "Successfully renamed file to original name [ {0} ]", string3);
                return;
            }
            logger.logp(Level.FINER, className, string2, "Could not rename file to original name [ {0} ]", string3);
        } else {
            logger.logp(Level.FINER, className, string2, "Could not delete original file [ {0} ]", string3);
        }
        logger.logp(Level.FINER, className, string2, "RETURN Throwing SaveFailureException");
        if (loggerLCT.isLoggable(Level.FINER)) {
            loggerLCT.logp(Level.WARNING, className, string2, ZipFileLoadStrategyImpl.lct.printHash(string3));
        }
        throw new SaveFailureException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.unable_replace_EXC_, new Object[]{file.getAbsolutePath()}));
    }

    public void close() {
        String string = "close";
        logger.logp(Level.FINER, className, string, "ENTRY URI = [ {0} ]", this.getURI());
        this.getLoadStrategy().close();
        this.releaseClassLoader();
        this.getCommonArchiveFactory().archiveClosed(this);
        logger.logp(Level.FINER, className, string, "Archive closed.  Close nested archive files if archive is indexed.");
        if (this.isIndexed()) {
            List list = this.getArchiveFiles();
            for (int i = 0; i < list.size(); ++i) {
                Archive archive = (Archive)list.get(i);
                logger.logp(Level.FINER, className, string, "Close archive file [ {0} ]", archive.getURI());
                archive.close();
            }
        }
        logger.logp(Level.FINER, className, string, "RETURN");
    }

    protected File copy(File file) {
        String string = "copy";
        logger.logp(Level.FINER, className, string, "ENTRY file = [ {0} ]", file);
        File file2 = null;
        file2 = file.isArchive() ? this.getCommonArchiveFactory().copy((Archive)file) : (File)EtoolsCopyUtility.createCopy((EObject)file);
        logger.logp(Level.FINER, className, string, "RETURN copy [ {0} ]", file2);
        return file2;
    }

    protected LoadStrategy createLoadStrategyForReopen(Archive archive) throws IOException {
        String string = "createLoadStrategyForReopen";
        logger.logp(Level.FINER, className, string, "ENTRY parent = [ {0} ]", archive);
        LoadStrategy loadStrategy = null;
        LooseArchive looseArchive = null;
        if (!this.getOptions().isSetAltBinariesPath()) {
            looseArchive = this.getLoadStrategy().getLooseArchive();
        }
        if (looseArchive != null) {
            logger.logp(Level.FINER, className, string, "No loose archive for load strategy.  Creating it.");
            loadStrategy = this.getCommonArchiveFactory().createLoadStrategy(looseArchive.getBinariesPath());
            loadStrategy.setLooseArchive(looseArchive);
        } else {
            loadStrategy = archive == null ? this.getCommonArchiveFactory().createLoadStrategy(this.getURI()) : this.getCommonArchiveFactory().createChildLoadStrategy(this.getURI(), archive.getLoadStrategy());
        }
        logger.logp(Level.FINER, className, string, "RETURN [ {0} ]", loadStrategy);
        return loadStrategy;
    }

    protected RuntimeClasspathEntry createRuntimeClasspathEntry(String string) {
        RuntimeClasspathEntryImpl runtimeClasspathEntryImpl = new RuntimeClasspathEntryImpl();
        runtimeClasspathEntryImpl.setAbsolutePath(string);
        return runtimeClasspathEntryImpl;
    }

    protected List createRuntimeClasspathEntries(String[] stringArray, String string) {
        Object object;
        Object object2;
        String string2 = "createRuntimeClasspathEntries";
        logger.logp(Level.FINER, className, string2, "ENTRY parentPath = [ {0} ]", string);
        ArrayList<Object> arrayList = new ArrayList<Object>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            Object object3;
            object2 = stringArray[i];
            logger.logp(Level.FINER, className, string2, "looking at entry [ {0} ]", object2);
            object = this.resolveClasspathEntryInEAR((String)object2);
            logger.logp(Level.FINER, className, string2, "dependent JAR [ {0} ]", object);
            if (object != null) {
                try {
                    logger.logp(Level.FINER, className, string2, "Creating runtime classpath entry for entry [ {0} ]", object2);
                    object3 = this.createRuntimeClasspathEntry(object.getBinariesPath(), (String)object2);
                    object3.setReferencedArchive((Archive)object);
                    arrayList.add(object3);
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    logger.logp(Level.FINER, className, string2, "Ignoring FileNotFoundException for entry [ {0} ]", object2);
                }
            }
            object3 = new java.io.File((String)object2);
            String string3 = null;
            if (((java.io.File)object3).isAbsolute()) {
                string3 = ((java.io.File)object3).getAbsolutePath();
            } else {
                string3 = ArchiveUtil.getOSUri(string, (String)object2);
                string3 = ClasspathUtil.normalizePath(string3);
            }
            logger.logp(Level.FINER, className, string2, "Creating runtime classpath entry for entry [ {0} ]", object2);
            arrayList.add(this.createRuntimeClasspathEntry(string3, (String)object2));
        }
        if (logger.isLoggable(Level.FINER)) {
            String string4 = "RETURN " + arrayList.size() + " elements";
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                object = (RuntimeClasspathEntryImpl)object2.next();
                string4 = string4 + "\n  " + object;
            }
            logger.logp(Level.FINER, className, string2, string4);
        }
        return arrayList;
    }

    protected RuntimeClasspathEntry createRuntimeClasspathEntry(String string, String string2) {
        RuntimeClasspathEntry runtimeClasspathEntry = this.createRuntimeClasspathEntry(string);
        runtimeClasspathEntry.setManifestValue(string2);
        return runtimeClasspathEntry;
    }

    protected SaveStrategy createSaveStrategyForDirectory(java.io.File file, int n) {
        return new DirectorySaveStrategyImpl(file.getAbsolutePath(), n);
    }

    protected SaveStrategy createSaveStrategyForDirectory(String string, int n) {
        return new DirectorySaveStrategyImpl(string, n);
    }

    protected SaveStrategy createSaveStrategyForJar(java.io.File file) throws IOException {
        if (file.exists() && file.isDirectory()) {
            throw new IOException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.file_exist_as_dir_EXC_, new Object[]{file.getAbsolutePath()}));
        }
        java.io.File file2 = file.getParentFile();
        if (file2 != null) {
            file2.mkdirs();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        return new ZipStreamSaveStrategyImpl(fileOutputStream);
    }

    public void extract(int n) throws SaveFailureException, ReopenException {
        this.extractNoReopen(n);
        this.reopen();
    }

    public void extractNoReopen(int n) throws SaveFailureException {
        String string = this.getURI();
        java.io.File file = new java.io.File(string);
        boolean bl = this.getLoadStrategy().isUsing(file);
        try {
            java.io.File file2 = bl ? ArchiveUtil.createTempDirectory(string, file.getCanonicalFile().getParentFile()) : file;
            SaveStrategy saveStrategy = this.createSaveStrategyForDirectory(file2, n);
            this.save(saveStrategy);
            saveStrategy.close();
            this.close();
            if (bl) {
                this.cleanupAfterTempSave(string, file, file2);
            }
        }
        catch (IOException iOException) {
            throw new SaveFailureException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.error_saving_EXC_, new Object[]{this.uri}), iOException);
        }
    }

    public void extractTo(String string, int n) throws SaveFailureException {
        String string2 = "extractTo";
        logger.logp(Level.FINER, className, string2, "ENTRY URI [ {0} ]", string);
        java.io.File file = new java.io.File(string);
        if (this.getLoadStrategy().isUsing(file)) {
            throw new SaveFailureException(CommonArchiveResourceHandler.Extract_destination_is_the_EXC_);
        }
        try {
            SaveStrategy saveStrategy = this.createSaveStrategyForDirectory(file, n);
            this.save(saveStrategy);
            saveStrategy.close();
        }
        catch (IOException iOException) {
            logger.logp(Level.FINER, className, string2, "RETURN Throwing SaveFailureException");
            throw new SaveFailureException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.error_saving_EXC_, new Object[]{string}), iOException);
        }
        logger.logp(Level.FINER, className, string2, "RETURN");
    }

    public List filterFilesByPrefix(String string) {
        return this.filterFiles(string, null);
    }

    public List filterFiles(String string, String[] stringArray) {
        ArrayList<File> arrayList = new ArrayList<File>();
        EList eList = this.getFiles();
        for (int i = 0; i < eList.size(); ++i) {
            File file = (File)eList.get(i);
            if (file.isDirectoryEntry() || !file.getURI().startsWith(string) || stringArray != null && !this.hasSuffix(file.getURI(), stringArray)) continue;
            arrayList.add(file);
        }
        return arrayList;
    }

    private boolean hasSuffix(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.endsWith(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public List filterFilesWithoutPrefix(String[] stringArray) {
        ArrayList<File> arrayList = new ArrayList<File>();
        EList eList = this.getFiles();
        for (int i = 0; i < eList.size(); ++i) {
            File file = (File)eList.get(i);
            if (file.isDirectoryEntry()) continue;
            boolean bl = true;
            for (int j = 0; j < stringArray.length; ++j) {
                if (!file.getURI().startsWith(stringArray[j])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            arrayList.add(file);
        }
        return arrayList;
    }

    public ClassLoader getArchiveClassLoader() {
        String string = "getArchiveClassLoader";
        logger.logp(Level.FINER, className, string, "ENTRY");
        if (this.archiveClassLoader == null) {
            this.initializeClassLoader();
        }
        logger.logp(Level.FINER, className, string, "RETURN archiveClassLoader = [ {0} ]", this.archiveClassLoader);
        return this.archiveClassLoader;
    }

    public List getArchiveFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        EList eList = this.getFiles();
        for (int i = 0; i < eList.size(); ++i) {
            File file = (File)eList.get(i);
            if (!file.isArchive()) continue;
            arrayList.add(file);
        }
        return arrayList;
    }

    protected ClassLoader getClassPathClassLoader(ClassLoader classLoader) {
        String string;
        String string2 = "getClassPathClassLoader";
        logger.logp(Level.FINER, className, string2, "ENTRY parent classloader = [ {0} ]", classLoader);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getManifest() != null) {
            logger.logp(Level.FINER, className, string2, "manifest not null, adding its classpath");
            arrayList.addAll(Arrays.asList(this.getManifest().getClassPathTokenized()));
        }
        if ((string = this.getExtraClasspath()) != null) {
            logger.logp(Level.FINER, className, string2, "extra classpath not null, adding its classpath");
            arrayList.addAll(Arrays.asList(ArchiveUtil.getTokens(string, ";")));
        }
        URL[] uRLArray = ArchiveUtil.toLocalURLs(arrayList, this.getRootForRelativeDependentJars());
        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, classLoader);
        logger.logp(Level.FINER, className, string2, "RETURN classloader = [ {0} ]", uRLClassLoader);
        return uRLClassLoader;
    }

    public ResourceSet getResourceSet() {
        return this.getLoadStrategy().getResourceSet();
    }

    public ClassLoader getParentClassLoader() {
        return this.options != null ? this.options.getParentClassLoader() : null;
    }

    public ClassLoader setParentClassLoader(ClassLoader classLoader) {
        String string = "setParentClassLoader";
        logger.logp(Level.FINER, className, string, "Setting parent classloader on [ {0} ] : [ {1} ]", new Object[]{this.getURI(), classLoader});
        if (this.archiveClassLoader != null) {
            StringBuffer stringBuffer = new StringBuffer("setParentClassLoader attempted on archive [ ");
            stringBuffer.append(this.getURI());
            stringBuffer.append(" ]");
            stringBuffer.append(" after the archive classloader was constructed");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(stringBuffer.toString());
            logger.throwing(className, string, illegalArgumentException);
            throw illegalArgumentException;
        }
        ArchiveOptions archiveOptions = this.getOptions();
        ClassLoader classLoader2 = archiveOptions.getParentClassLoader();
        archiveOptions.setParentClassLoader(classLoader);
        this.setChildParentClassLoader(classLoader);
        logger.logp(Level.FINER, className, string, "Prior classloader [ {0} ]", classLoader2);
        return classLoader2;
    }

    protected void setChildParentClassLoader(ClassLoader classLoader) {
        Iterator iterator = this.getFiles().iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (!file.isArchive()) continue;
            ClassLoader classLoader2 = ((ArchiveImpl)file).setParentClassLoader(classLoader);
        }
    }

    protected ClassLoader getDefaultClassLoader() {
        String string = "getDefaultClassLoader";
        logger.logp(Level.FINER, className, string, "ENTRY for [ {0} ]", this.getURI());
        ClassLoader classLoader = this.getOptions().getParentClassLoader();
        if (classLoader != null) {
            logger.logp(Level.FINER, className, string, "RETURN with options classloader [ {0} ]", classLoader);
            return classLoader;
        }
        classLoader = this.getClass().getClassLoader();
        if (classLoader != null) {
            logger.logp(Level.FINER, className, string, "RETURN with class classloader [ {0} ]", classLoader);
            return classLoader;
        }
        classLoader = ClassLoader.getSystemClassLoader();
        logger.logp(Level.FINER, className, string, "RETURN with system classloader [ {0} ]", classLoader);
        return classLoader;
    }

    public Set getDependentOpenArchives() {
        return this.getCommonArchiveFactory().getOpenArchivesDependingOn(this);
    }

    protected List getEntriesAsAbsolutePaths(String[] stringArray, String string) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            java.io.File file;
            String string2 = stringArray[i];
            Archive archive = this.resolveClasspathEntryInEAR(string2);
            if (archive != null) {
                try {
                    arrayList.add(archive.getAbsolutePath());
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            if ((file = new java.io.File(string2)).isAbsolute()) {
                arrayList.add(file.getAbsolutePath());
                continue;
            }
            arrayList.add(ArchiveUtil.getOSUri(string, string2));
        }
        return arrayList;
    }

    public String getExtraClasspath() {
        return this.extraClasspath;
    }

    public FileIterator getFilesForSave() throws IOException {
        return this.getLoadStrategy().getFileIterator();
    }

    public InputStream getInputStream() throws FileNotFoundException, IOException {
        if (this.getLoadingContainer() != null || this.getLoadStrategy() == null || this.getLoadStrategy().isDirectory()) {
            return super.getInputStream();
        }
        if (this.isModuleFile() || !this.getOptions().isSaveLibrariesAsFiles()) {
            throw new IOException("Undefined state of nested archive");
        }
        EList eList = this.getFiles();
        String string = null;
        for (int i = 0; i < eList.size(); ++i) {
            File file = (File)eList.get(i);
            if (file.isArchive()) continue;
            string = file.getLoadingContainer().getAbsolutePath();
        }
        return new FileInputStream(string);
    }

    public InputStream getResourceInputStream(String string) throws IOException {
        return this.getLoadStrategy().getResourceInputStream(string);
    }

    protected JavaJDKAdapterFactory getJavaAdapterFactory() {
        String string = "getJavaAdapterFactory";
        logger.logp(Level.FINER, className, string, "ENTRY");
        JavaJDKAdapterFactory javaJDKAdapterFactory = null;
        LoadStrategy loadStrategy = this.getLoadStrategy();
        if (loadStrategy == null) {
            logger.logp(Level.FINER, className, string, "RETURN null.  LoadStrategy not found");
            return null;
        }
        logger.logp(Level.FINER, className, string, "LoadStrategy found [ {0} ]", loadStrategy);
        ResourceSet resourceSet = loadStrategy.getResourceSet();
        if (resourceSet == null) {
            logger.logp(Level.FINER, className, string, "RETURN null.  ResourceSet not found");
            return null;
        }
        logger.logp(Level.FINER, className, string, "ResourceSet found [ {0} ]", resourceSet);
        EList eList = resourceSet.getAdapterFactories();
        logger.logp(Level.FINER, className, string, "AdapterFactories found [ {0} ]", eList);
        javaJDKAdapterFactory = (JavaJDKAdapterFactory)EcoreUtil.getAdapterFactory(eList, "JavaReflection");
        logger.logp(Level.FINER, className, string, "RETURN [ {0} ]", javaJDKAdapterFactory);
        return javaJDKAdapterFactory;
    }

    public Collection getLoadedMofResources() {
        return this.getLoadStrategy().getLoadedMofResources();
    }

    /*
     * Unable to fully structure code
     */
    public ArchiveManifest getManifest() {
        block18: {
            if (this.manifest == null) {
                var1_1 = null;
                try {
                    var1_1 = this.getInputStream("META-INF/MANIFEST.MF");
                    this.makeManifest(var1_1);
                    var5_2 = null;
                    ** if (var1_1 == null) goto lbl-1000
                }
                catch (Throwable var4_14) {
                    var5_5 = null;
                    if (var1_1 != null) {
                        try {
                            var1_1.close();
                        }
                        catch (IOException var6_9) {
                            // empty catch block
                        }
                    }
                    throw var4_14;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var1_1.close();
                    }
                    catch (IOException var6_6) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block18;
                    catch (FileNotFoundException var2_10) {
                        this.makeManifest();
                        var5_3 = null;
                        if (var1_1 != null) {
                            try {
                                var1_1.close();
                            }
                            catch (IOException var6_7) {}
                        }
                        break block18;
                    }
                    catch (Resource.IOWrappedException var2_11) {
                        var3_13 = new WrappedException(var2_11.getWrappedException());
                        if (!ExtendedEcoreUtil.getFileNotFoundDetector().isFileNotFound(var3_13)) {
                            throw new ManifestException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.io_ex_manifest_EXC_, new Object[]{this.getURI()}), var2_11);
                        }
                        this.makeManifest();
                        var5_4 = null;
                        if (var1_1 != null) {
                            try {
                                var1_1.close();
                            }
                            catch (IOException var6_8) {}
                        }
                        break block18;
                    }
                    catch (IOException var2_12) {
                        throw new ManifestException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.io_ex_manifest_EXC_, new Object[]{this.getURI()}), var2_12);
                    }
                }
            }
        }
        if (this.manifest.getManifestVersion() == null || this.manifest.getManifestVersion().equals("")) {
            this.manifest.setManifestVersion("1.0");
        }
        return this.manifest;
    }

    public Resource getMofResource(String string) throws FileNotFoundException, ResourceLoadException {
        return this.getLoadStrategy().getMofResource(string);
    }

    protected Resource getMofResourceMakeIfNecessary(String string) {
        if (this.getLoadStrategy() == null) {
            return null;
        }
        Resource resource = null;
        try {
            resource = this.getMofResource(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                resource = this.makeMofResource(string);
            }
            catch (DuplicateObjectException duplicateObjectException) {
                // empty catch block
            }
        }
        return resource;
    }

    public ArchiveOptions getOptions() {
        if (this.options == null) {
            this.options = new ArchiveOptions();
        }
        return this.options;
    }

    public ProtectionDomain getProtectionDomain() {
        return this.options == null ? null : this.options.getProtectionDomain();
    }

    public ProtectionDomain setProtectionDomain(ProtectionDomain protectionDomain) {
        ArchiveOptions archiveOptions = this.getOptions();
        ProtectionDomain protectionDomain2 = archiveOptions.getProtectionDomain();
        archiveOptions.setProtectionDomain(protectionDomain);
        this.setChildProtectionDomains(protectionDomain);
        this.setClassLoaderProtectionDomain(protectionDomain);
        return protectionDomain2;
    }

    protected void setChildProtectionDomains(ProtectionDomain protectionDomain) {
        String string = "setChildProtectionDomains";
        logger.logp(Level.FINER, className, string, "ENTRY protectionDomain [ {0} ]", protectionDomain);
        Iterator iterator = this.getFiles().iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            logger.logp(Level.FINER, className, string, "archive file [ {0} ]", file.getURI());
            if (!file.isArchive()) continue;
            ProtectionDomain protectionDomain2 = ((ArchiveImpl)file).setProtectionDomain(protectionDomain);
            logger.logp(Level.FINER, className, string, "Set child protectionDomain [ {0} ]", protectionDomain2);
        }
        logger.logp(Level.FINER, className, string, "RETURN");
    }

    protected void setClassLoaderProtectionDomain(ProtectionDomain protectionDomain) {
        if (this.archiveClassLoader != null && this.archiveClassLoader instanceof ArchiveFileDynamicClassLoader) {
            ArchiveFileDynamicClassLoader archiveFileDynamicClassLoader = (ArchiveFileDynamicClassLoader)this.archiveClassLoader;
            archiveFileDynamicClassLoader.setProtectionDomain(protectionDomain);
        }
    }

    public String getRootForRelativeDependentJars() {
        String string = "getRootForRelativeDependentJars";
        logger.logp(Level.FINER, className, string, "ENTRY");
        String string2 = null;
        for (Container container = this; container != null && string2 == null; container = container.getLoadingContainer()) {
            logger.logp(Level.FINER, className, string, "Get absolute path of container [ {0} ]", container);
            try {
                string2 = container.getAbsolutePath();
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.logp(Level.FINER, className, string, "Ignoring FileNotFoundException while resolving absolute path");
            }
        }
        logger.logp(Level.FINER, className, string, "Path [ {0} ]", string2);
        if (string2 == null) {
            logger.logp(Level.FINER, className, string, "No path found, look in system property user.dir");
            string2 = System.getProperty("user.dir");
            if (string2 == null) {
                logger.logp(Level.FINER, className, string, "No path found, returning null");
                return "";
            }
            String string3 = new java.io.File(string2).getAbsolutePath();
            logger.logp(Level.FINER, className, string, "RETURN absolute path specified by system property [ {0} ]", string3);
            return string3;
        }
        String string4 = new java.io.File(string2).getParentFile().getAbsolutePath();
        logger.logp(Level.FINER, className, string, "RETURN absolute path of parent file [ {0} ]", string4);
        return string4;
    }

    public String[] getRuntimeClassPath() {
        String string = "getRuntimeClassPath";
        logger.logp(Level.FINER, className, string, "ENTRY");
        String string2 = this.internalGetBinariesPath();
        if (string2 == null) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        String string3 = this.getParentPath(string2);
        String[] stringArray = this.getManifest().getClassPathTokenized();
        arrayList.addAll(this.getEntriesAsAbsolutePaths(stringArray, string3));
        if (logger.isLoggable(Level.FINER)) {
            String string4 = "RETURN " + arrayList.size() + " elements";
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string5 = (String)iterator.next();
                string4 = string4 + "\n  " + string5;
            }
            logger.logp(Level.FINER, className, string, string4);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public SaveFilter getSaveFilter() {
        return this.saveFilter;
    }

    public SaveStrategy getSaveStrategy() {
        return this.saveStrategy;
    }

    public String getXmlEncoding() {
        return this.xmlEncoding;
    }

    public void initializeAfterOpen() {
    }

    public void initializeClassLoader() {
        String string = "initializeClassLoader";
        logger.logp(Level.FINER, className, string, "ENTRY");
        if (!this.shouldUseJavaReflection()) {
            logger.logp(Level.FINER, className, string, "RETURN - no reflection, so class loader not necessary");
            return;
        }
        ClassLoader classLoader = null;
        ClassLoader classLoader2 = this.getDefaultClassLoader();
        if (this.getContainer() == null || !this.getContainer().isEARFile()) {
            classLoader = this.getClassPathClassLoader(classLoader2);
        }
        ClassLoader classLoader3 = this.createDynamicClassLoader(classLoader2, classLoader);
        this.setArchiveClassLoader(classLoader3);
        JavaJDKAdapterFactory javaJDKAdapterFactory = this.getJavaAdapterFactory();
        if (javaJDKAdapterFactory != null) {
            javaJDKAdapterFactory.flushAll();
        } else {
            logger.logp(Level.FINER, className, string, "Java Adapter Factory was null");
        }
        logger.logp(Level.FINER, className, string, "RETURN");
    }

    public ClassLoader createDynamicClassLoader(ClassLoader classLoader, ClassLoader classLoader2) {
        return new ArchiveFileDynamicClassLoader(this, classLoader, classLoader2, this.getProtectionDomain());
    }

    public boolean isArchive() {
        return true;
    }

    public boolean isDuplicate(String string) {
        return this.containsFile(string) || this.isMofResourceLoaded(string) || "META-INF/MANIFEST.MF".equals(string);
    }

    public boolean isManifestSet() {
        return this.manifest != null;
    }

    public boolean isMofResourceLoaded(String string) {
        return this.getLoadStrategy().isMofResourceLoaded(string);
    }

    public boolean isNestedArchive(String string) {
        if (this.getLoadStrategy().isDirectory()) {
            try {
                String string2 = ArchiveUtil.getOSUri(this.getAbsolutePath(), string);
                java.io.File file = new java.io.File(string2);
                if (!file.exists() || file.isDirectory() && string.startsWith("ALT-INF")) {
                    return false;
                }
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return ArchiveTypeDiscriminatorRegistry.INSTANCE.isKnownArchiveType(string);
    }

    public boolean isOpen() {
        return this.getLoadStrategy() != null && this.getLoadStrategy().isOpen();
    }

    public ArchiveManifest makeManifest() {
        ArchiveManifestImpl archiveManifestImpl = new ArchiveManifestImpl();
        this.setManifest(archiveManifestImpl);
        return archiveManifestImpl;
    }

    public ArchiveManifest makeManifest(InputStream inputStream) throws IOException {
        ArchiveManifestImpl archiveManifestImpl = new ArchiveManifestImpl(inputStream);
        this.setManifest(archiveManifestImpl);
        return archiveManifestImpl;
    }

    public Resource makeMofResource(String string) throws DuplicateObjectException {
        return this.makeMofResource(string, null);
    }

    public Resource makeMofResource(String string, EList eList) throws DuplicateObjectException {
        if (this.isDuplicate(string)) {
            throw new DuplicateObjectException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.duplicate_entry_EXC_, new Object[]{string, this.getURI()}));
        }
        return this.getLoadStrategy().makeMofResource(string, eList);
    }

    public Archive openNestedArchive(String string) throws OpenFailureException {
        String string2 = "openNestedArchive - URI";
        logger.logp(Level.FINER, className, string2, "ENTRY - URI [ {0} ]", string);
        Archive archive = this.getCommonArchiveFactory().openNestedArchive(string, (Archive)this);
        logger.logp(Level.FINER, className, string2, "RETURN Factory opened archive [ {0} ]", archive);
        return archive;
    }

    public Archive openNestedArchive(LooseArchive looseArchive) throws OpenFailureException {
        String string = "openNestedArchive - loose";
        String string2 = looseArchive.getUri();
        logger.logp(Level.FINER, className, string, "ENTRY - loose archive URI [ {0} ]", string2);
        Archive archive = this.getCommonArchiveFactory().openNestedArchive(looseArchive, (Archive)this);
        logger.logp(Level.FINER, className, string, "RETURN Factory opened archive [ {0} ]", archive);
        return archive;
    }

    public void primSetExtraClasspath(String string) {
        this.extraClasspath = string;
    }

    public void releaseClassLoader() {
        if (this.archiveClassLoader != null) {
            this.setArchiveClassLoader(null);
            JavaJDKAdapterFactory javaJDKAdapterFactory = this.getJavaAdapterFactory();
            if (javaJDKAdapterFactory != null) {
                this.getJavaAdapterFactory().setContextClassLoader(null);
            }
        }
    }

    public void remove(File file) {
        this.getFiles().remove(file);
    }

    public void reopen() throws ReopenException {
        this.reopen(null);
    }

    public void reopen(Archive archive) throws ReopenException {
        LoadStrategy loadStrategy = null;
        try {
            loadStrategy = this.createLoadStrategyForReopen(archive);
        }
        catch (IOException iOException) {
            throw new ReopenException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.io_ex_reopen_EXC_, new Object[]{this.getURI()}), iOException);
        }
        LoadStrategy loadStrategy2 = this.getLoadStrategy();
        if (loadStrategy2 != null) {
            loadStrategy.setResourceSet(loadStrategy2.primGetResourceSet());
            loadStrategy2.setResourceSet(null);
        }
        this.setLoadStrategy(loadStrategy);
        this.initializeClassLoader();
        if (!this.isIndexed()) {
            return;
        }
        EList eList = this.getFiles();
        for (int i = 0; i < eList.size(); ++i) {
            File file = (File)eList.get(i);
            file.setOriginalURI(file.getURI());
            file.setLoadingContainer(this);
            if (!file.isArchive()) continue;
            ((Archive)file).reopen(this);
        }
        this.getCommonArchiveFactory().archiveOpened(this);
    }

    protected void replaceRoot(Resource resource, EObject eObject) {
        if (resource == null) {
            return;
        }
        EList eList = resource.getContents();
        EObject eObject2 = null;
        if (!eList.isEmpty()) {
            eObject2 = (EObject)eList.get(0);
            if (eObject2 == eObject) {
                return;
            }
            eList.remove(0);
        }
        if (eObject != null) {
            eList.add(0, eObject);
        }
    }

    protected Archive resolveClasspathEntryInEAR(String string) {
        Container container = this.getContainer();
        if (container == null || !container.isEARFile()) {
            return null;
        }
        String string2 = ArchiveUtil.deriveEARRelativeURI(string, this);
        if (string2 == null) {
            return null;
        }
        File file = null;
        try {
            file = container.getFile(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        return file.isArchive() ? (Archive)file : null;
    }

    public void save() throws SaveFailureException, ReopenException {
        this.saveAs(this.getURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(SaveStrategy saveStrategy) throws SaveFailureException {
        SaveFilter saveFilter;
        String string;
        block6: {
            string = "save";
            logger.logp(Level.FINER, className, string, "ENTRY SaveStrategy = [ {0} ]", saveStrategy);
            this.setSaveStrategy(saveStrategy);
            saveFilter = saveStrategy.getFilter();
            boolean bl = this.eDeliver();
            boolean bl2 = this.getOptions().isReadOnly();
            if (bl2) {
                logger.logp(Level.FINER, className, string, "isReadOnly [ {0} ]", Boolean.toString(bl2));
                this.eSetDeliver(false);
            }
            saveStrategy.setFilter(this.getSaveFilter());
            try {
                saveStrategy.save();
                try {
                    saveStrategy.finish();
                }
                catch (IOException iOException) {
                    logger.logp(Level.FINER, className, string, "RETURN Throwing SaveFailureException [ {0} ]", this.getURI());
                    throw new SaveFailureException(this.getURI(), iOException);
                }
                Object var8_7 = null;
                if (!bl2 || this.getLoadStrategy().isDirectory()) break block6;
                logger.logp(Level.FINER, className, string, "Clear file index");
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (bl2 && !this.getLoadStrategy().isDirectory()) {
                    logger.logp(Level.FINER, className, string, "Clear file index");
                    this.files.clear();
                    this.eSetDeliver(bl);
                    this.eAdapters().remove(this.getFileIndexAdapter());
                    this.fileIndexAdapter = null;
                    this.fileIndex = null;
                }
                this.setSaveStrategy(null);
                saveStrategy.setFilter(saveFilter);
                throw throwable;
            }
            this.files.clear();
            this.eSetDeliver(bl);
            this.eAdapters().remove(this.getFileIndexAdapter());
            this.fileIndexAdapter = null;
            this.fileIndex = null;
            {
            }
        }
        this.setSaveStrategy(null);
        saveStrategy.setFilter(saveFilter);
        logger.logp(Level.FINER, className, string, "RETURN");
    }

    public void saveAs(String string) throws SaveFailureException, ReopenException {
        this.saveAsNoReopen(string);
        this.reopen();
    }

    protected boolean canRename(java.io.File file) {
        String string = "canRename";
        logger.logp(Level.FINER, className, string, "ENTRY [ {0} ]", file);
        boolean bl = false;
        java.io.File file2 = null;
        java.io.File file3 = null;
        try {
            file2 = file.getCanonicalFile();
            file3 = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            logger.logp(Level.FINEST, className, string, iOException.getMessage());
            logger.logp(Level.FINER, className, string, "Ignoring IOException - Could not get canonicalFile for [ {0} ]", file);
            return false;
        }
        String string2 = null;
        String string3 = "save.tmp";
        String string4 = file.getParent();
        if (string4 != null) {
            try {
                string3 = new java.io.File(string4, string3).getCanonicalPath();
            }
            catch (IOException iOException) {
                logger.logp(Level.FINEST, className, string, iOException.getMessage());
                logger.logp(Level.FINER, className, string, "Ignoring IOException - Could not get canonical path for parent [ {0} ]", string4);
                return false;
            }
        }
        java.io.File file4 = null;
        int n = 0;
        do {
            string2 = string3 + n;
            file4 = new java.io.File(string2);
            ++n;
        } while (file4.exists());
        if (this.renameToWithRetry(file2, file4) && this.renameToWithRetry(file4, file3)) {
            bl = true;
        }
        logger.logp(Level.FINER, className, string, "RETURN[ {0} ]", Boolean.toString(bl));
        return bl;
    }

    protected void checkWriteable(java.io.File file) throws SaveFailureException {
        List list = ArchiveUtil.getWriteProtectedFiles(file, null);
        if (list.isEmpty()) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Cannot write to file: ");
        stringBuffer.append(file.getAbsolutePath());
        stringBuffer.append('\n');
        stringBuffer.append("One or more files is write protected or locked:");
        stringBuffer.append('\n');
        for (int i = 0; i < list.size(); ++i) {
            java.io.File file2 = (java.io.File)list.get(i);
            stringBuffer.append(file2.getAbsolutePath());
            stringBuffer.append('\n');
        }
        throw new SaveFailureException(stringBuffer.toString());
    }

    public void saveAsNoReopen(String string) throws SaveFailureException {
        java.io.File file = new java.io.File(string);
        this.checkWriteable(file);
        boolean bl = file.exists();
        SaveStrategy saveStrategy = null;
        try {
            try {
                java.io.File file2 = bl ? ArchiveUtil.createTempFile(string, file.getCanonicalFile().getParentFile()) : file;
                saveStrategy = this.createSaveStrategyForJar(file2);
                this.save(saveStrategy);
                saveStrategy.close();
                this.close();
                if (bl) {
                    this.cleanupAfterTempSave(string, file, file2);
                }
            }
            catch (IOException iOException) {
                throw new SaveFailureException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.error_saving_EXC_, new Object[]{string}), iOException);
            }
        }
        catch (SaveFailureException saveFailureException) {
            try {
                if (saveStrategy != null) {
                    saveStrategy.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!bl) {
                file.delete();
            }
            throw saveFailureException;
        }
        this.setURI(string);
    }

    public void saveNoReopen() throws SaveFailureException {
        this.saveAsNoReopen(this.getURI());
    }

    public void setArchiveClassLoader(ClassLoader classLoader) {
        this.archiveClassLoader = classLoader;
    }

    public void setExtraClasspath(String string) {
        this.primSetExtraClasspath(string);
        if (this.archiveClassLoader != null) {
            this.initializeClassLoader();
        }
    }

    public void setManifest(ArchiveManifest archiveManifest) {
        this.manifest = archiveManifest;
    }

    public void setManifest(Manifest manifest) {
        this.setManifest(new ArchiveManifestImpl(manifest));
    }

    public void setManifestClassPathAndRefresh(String string) {
        ArchiveManifest archiveManifest = this.getManifest();
        if (this.manifest == null) {
            this.makeManifest();
        }
        archiveManifest.setClassPath(string);
        if (this.archiveClassLoader != null) {
            this.initializeClassLoader();
        }
    }

    public void setOptions(ArchiveOptions archiveOptions) {
        this.options = archiveOptions;
    }

    public void setSaveFilter(SaveFilter saveFilter) {
        this.saveFilter = saveFilter;
    }

    public void setSaveStrategy(SaveStrategy saveStrategy) {
        this.saveStrategy = saveStrategy;
        if (saveStrategy != null) {
            saveStrategy.setArchive(this);
        }
    }

    public void setXmlEncoding(String string) {
        this.xmlEncoding = string;
    }

    public boolean shouldUseJavaReflection() {
        return this.getOptions().useJavaReflection() && this.getLoadStrategy().isClassLoaderNeeded();
    }

    protected void throwResourceLoadException(String string, Exception exception) throws ResourceLoadException {
        throw new ResourceLoadException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.load_resource_EXC_, new Object[]{string, this.getURI()}), exception);
    }

    public String getResourcesPath() throws FileNotFoundException {
        return this.getLoadStrategy().getResourcesPath();
    }

    public String getBinariesPath() throws FileNotFoundException {
        String string;
        String string2 = "getBinariesPath";
        logger.logp(Level.FINER, className, string2, "ENTRY [ {0} ]", this.uri);
        String string3 = this.getLoadStrategy().getBinariesPath();
        ArchiveOptions archiveOptions = this.getOptions();
        if (archiveOptions.isSetAltBinariesPath() && (string = archiveOptions.getAltBinariesPath()) != null) {
            logger.logp(Level.FINER, className, string2, "Replacing binariesPath [ {0} ] with altBinariesPath in archiveOptions", string3);
            string3 = string;
        }
        logger.logp(Level.FINER, className, string2, "RETURN [ {0} ]", string3);
        return string3;
    }

    protected RuntimeClasspathEntry[] emptyClasspath() {
        return new RuntimeClasspathEntry[0];
    }

    protected String internalGetBinariesPath() {
        try {
            return this.getBinariesPath();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public RuntimeClasspathEntry[] getLocalRuntimeClassPath() {
        String string = "getLocalRuntimeClassPath";
        logger.logp(Level.FINER, className, string, "ENTRY");
        String string2 = this.internalGetBinariesPath();
        logger.logp(Level.FINER, className, string, "internalGetBinariesPath = [ {0} ]", string2);
        if (string2 == null) {
            logger.logp(Level.FINER, className, string, "RETURN empty classpath");
            return this.emptyClasspath();
        }
        RuntimeClasspathEntry[] runtimeClasspathEntryArray = new RuntimeClasspathEntry[]{this.createRuntimeClasspathEntry(string2)};
        logger.logp(Level.FINER, className, string, "RETURN [ {0} ] elements", Integer.toString(runtimeClasspathEntryArray.length));
        return runtimeClasspathEntryArray;
    }

    protected String getParentPath(String string) {
        String string2 = "getParentPath";
        logger.logp(Level.FINER, className, string2, "ENTRY absolutePath = [ {0} ]", string);
        Container container = this.getContainer();
        if (this.getLoadStrategy().getLooseArchive() != null && container != null && container.isEARFile()) {
            try {
                logger.logp(Level.FINER, className, string2, "Non-assigned loose archive with EAR parent");
                String string3 = this.getEARFile().getBinariesPath();
                logger.logp(Level.FINER, className, string2, "EAR file binaries path [ {0} ]", string3);
                java.io.File file = new java.io.File(string3, this.getURI());
                String string4 = file.getParentFile().getAbsolutePath();
                logger.logp(Level.FINER, className, string2, "RETURN Virtual parent path [ {0} ]", string4);
                return string4;
            }
            catch (Throwable throwable) {
                logger.logp(Level.FINER, className, string2, "Ignoring Exception while calculating parent path");
            }
        }
        java.io.File file = new java.io.File(string).getParentFile();
        logger.logp(Level.FINER, className, string2, "Using absolute path of parent file named [ {0} ]", file.getName());
        String string5 = file.getAbsolutePath();
        logger.logp(Level.FINER, className, string2, "RETURN absolute parent path [ {0} ]", string5);
        return string5;
    }

    protected RuntimeClasspathEntry[] getDependencyClassPathAtThisLevel() {
        String string = "getDependencyClassPathAtThisLevel";
        logger.logp(Level.FINER, className, string, "ENTRY");
        String string2 = this.internalGetBinariesPath();
        if (string2 == null) {
            logger.logp(Level.FINER, className, string, "RETURN empty classpath because binaries path not found");
            return this.emptyClasspath();
        }
        String[] stringArray = this.getManifest().getClassPathTokenized();
        if (stringArray.length == 0) {
            logger.logp(Level.FINER, className, string, "RETURN empty classpath because manifest entries not found");
            return this.emptyClasspath();
        }
        String string3 = this.getParentPath(string2);
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.createRuntimeClasspathEntries(stringArray, string3));
        if (logger.isLoggable(Level.FINER)) {
            String string4 = "RETURN classpath with " + arrayList.size() + " elements";
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                RuntimeClasspathEntryImpl runtimeClasspathEntryImpl = (RuntimeClasspathEntryImpl)iterator.next();
                string4 = string4 + "\n  " + runtimeClasspathEntryImpl;
            }
            logger.logp(Level.FINER, className, string, string4);
        }
        return arrayList.toArray(new RuntimeClasspathEntry[arrayList.size()]);
    }

    public RuntimeClasspathEntry[] getFullRuntimeClassPath() {
        String string = "getFullRuntimeClassPath";
        logger.logp(Level.FINER, className, string, "ENTRY");
        RuntimeClasspathEntry[] runtimeClasspathEntryArray = this.concat(this.getLocalRuntimeClassPath(), this.getDependencyClassPath());
        logger.logp(Level.FINER, className, string, "RETURN [ {0} ] elements", Integer.toString(runtimeClasspathEntryArray.length));
        if (logger.isLoggable(Level.FINEST)) {
            String string2 = "Classpath :";
            for (int i = 0; i < runtimeClasspathEntryArray.length; ++i) {
                RuntimeClasspathEntry runtimeClasspathEntry = runtimeClasspathEntryArray[i];
                string2 = string2 + "\n  " + runtimeClasspathEntry;
            }
            logger.logp(Level.FINER, className, string, string2);
        }
        return runtimeClasspathEntryArray;
    }

    protected RuntimeClasspathEntry[] concat(RuntimeClasspathEntry[] runtimeClasspathEntryArray, RuntimeClasspathEntry[] runtimeClasspathEntryArray2) {
        ArrayList<RuntimeClasspathEntry> arrayList = new ArrayList<RuntimeClasspathEntry>();
        arrayList.addAll(Arrays.asList(runtimeClasspathEntryArray));
        arrayList.addAll(Arrays.asList(runtimeClasspathEntryArray2));
        return arrayList.toArray(new RuntimeClasspathEntry[arrayList.size()]);
    }

    public RuntimeClasspathEntry[] getDependencyClassPath() {
        String string = "getDependencyClassPath";
        logger.logp(Level.FINER, className, string, "ENTRY");
        ArrayList arrayList = new ArrayList();
        HashSet<ArchiveImpl> hashSet = new HashSet<ArchiveImpl>();
        HashSet hashSet2 = new HashSet();
        hashSet.add(this);
        this.getDependencyClassPath(hashSet, arrayList, hashSet2, this);
        RuntimeClasspathEntry[] runtimeClasspathEntryArray = arrayList.toArray(new RuntimeClasspathEntry[arrayList.size()]);
        RuntimeClasspathEntry[] runtimeClasspathEntryArray2 = this.getLibraryDirectoryClassPath(null);
        RuntimeClasspathEntry[] runtimeClasspathEntryArray3 = this.concat(runtimeClasspathEntryArray2, runtimeClasspathEntryArray);
        logger.logp(Level.FINER, className, string, "RETURN [ {0} ] elements", Integer.toString(runtimeClasspathEntryArray3.length));
        if (logger.isLoggable(Level.FINEST)) {
            String string2 = "Classpath :";
            for (int i = 0; i < runtimeClasspathEntryArray3.length; ++i) {
                RuntimeClasspathEntry runtimeClasspathEntry = runtimeClasspathEntryArray3[i];
                string2 = string2 + "\n  " + runtimeClasspathEntry;
            }
            logger.logp(Level.FINER, className, string, string2);
        }
        return runtimeClasspathEntryArray3;
    }

    public RuntimeClasspathEntry[] getDependencyClassPath(Application application) {
        ArrayList arrayList = new ArrayList();
        HashSet<ArchiveImpl> hashSet = new HashSet<ArchiveImpl>();
        HashSet hashSet2 = new HashSet();
        hashSet.add(this);
        this.getDependencyClassPath(hashSet, arrayList, hashSet2, this);
        RuntimeClasspathEntry[] runtimeClasspathEntryArray = arrayList.toArray(new RuntimeClasspathEntry[arrayList.size()]);
        RuntimeClasspathEntry[] runtimeClasspathEntryArray2 = this.getLibraryDirectoryClassPath(application);
        return this.concat(runtimeClasspathEntryArray2, runtimeClasspathEntryArray);
    }

    protected RuntimeClasspathEntry[] getLibraryDirectoryClassPath(Application application) {
        ArrayList arrayList = new ArrayList();
        EARFile eARFile = this.getEARFile();
        try {
            String string = eARFile.getBinariesPath();
            CommonarchiveFactory commonarchiveFactory = (CommonarchiveFactory)CommonarchivePackage.eINSTANCE.getEFactoryInstance();
            ArchiveOptions archiveOptions = new ArchiveOptions();
            archiveOptions.setIsReadOnly(true);
            archiveOptions.setUseJavaReflection(false);
            archiveOptions.setDiscriminateNestedArchives(false);
            EARFile eARFile2 = commonarchiveFactory.openEARFile(archiveOptions, string);
            if (eARFile2 != null) {
                String string2;
                Application application2 = application != null ? application : eARFile2.getDeploymentDescriptor();
                if (application2 == null) {
                    string2 = "lib";
                } else if (application2.getJ2EEVersionID() >= 50) {
                    if (application2.isSetLibraryDirectory()) {
                        string2 = application2.getLibraryDirectory();
                        if (string2.equals("")) {
                            string2 = null;
                        }
                    } else {
                        string2 = "lib";
                    }
                } else {
                    string2 = null;
                }
                if (string2 != null) {
                    String[] stringArray;
                    Object object;
                    EList eList = eARFile2.getFiles();
                    LinkedList<String[]> linkedList = new LinkedList<String[]>();
                    String string3 = string2 + "/";
                    Iterator iterator = eList.iterator();
                    while (iterator.hasNext()) {
                        object = (File)iterator.next();
                        if (object.isDirectoryEntry() || !(stringArray = object.getURI()).startsWith(string3) || !stringArray.endsWith(".jar")) continue;
                        linkedList.add(stringArray);
                    }
                    int n = linkedList.size();
                    if (n > 0) {
                        object = this.getRootForRelativeDependentJars();
                        stringArray = new String[n];
                        int n2 = 0;
                        Iterator iterator2 = linkedList.iterator();
                        while (iterator2.hasNext()) {
                            stringArray[n2++] = (String)iterator2.next();
                        }
                        arrayList.addAll(this.createRuntimeClasspathEntries(stringArray, (String)object));
                    }
                }
            }
        }
        catch (Throwable throwable) {
            arrayList = new ArrayList();
        }
        return arrayList.toArray(new RuntimeClasspathEntry[arrayList.size()]);
    }

    protected void getDependencyClassPath(Set set, List list, Set set2, Archive archive) {
        String string = "getDependencyClassPath";
        logger.logp(Level.FINER, className, string, "ENTRY current archive [ {0} ]", archive.getURI());
        RuntimeClasspathEntry[] runtimeClasspathEntryArray = ((ArchiveImpl)archive).getDependencyClassPathAtThisLevel();
        logger.logp(Level.FINER, className, string, "current dependency classpath has [ {0} ] elements", Integer.toString(runtimeClasspathEntryArray.length));
        for (int i = 0; i < runtimeClasspathEntryArray.length; ++i) {
            RuntimeClasspathEntry runtimeClasspathEntry = runtimeClasspathEntryArray[i];
            logger.logp(Level.FINER, className, string, "classpath entry [ {0} ]", runtimeClasspathEntry);
            if (!set2.contains(runtimeClasspathEntry)) {
                logger.logp(Level.FINER, className, string, "not processed yet, add to lists");
                list.add(runtimeClasspathEntry);
                set2.add(runtimeClasspathEntry);
            }
            Archive archive2 = runtimeClasspathEntry.getReferencedArchive();
            logger.logp(Level.FINER, className, string, "referenced archive [ {0} ]", archive2);
            if (archive2 == null) {
                logger.logp(Level.FINER, className, string, "archive not found, process manifest");
                ClasspathUtil.processManifest(runtimeClasspathEntry.getAbsolutePath(), list, set2);
                continue;
            }
            if (set.contains(archive2)) continue;
            logger.logp(Level.FINER, className, string, "not visited yet, get its path");
            set.add(archive2);
            this.getDependencyClassPath(set, list, set2, archive2);
        }
        logger.logp(Level.FINER, className, string, "RETURN from archive [ {0} ]", archive.getURI());
    }

    protected EARFile getEARFile() {
        Container container = this.getContainer();
        if (container == null || !(container instanceof EARFile)) {
            return null;
        }
        return (EARFile)container;
    }

    protected Archive getResolvedArchive(String string, EARFile eARFile) {
        String string2 = ArchiveUtil.deriveEARRelativeURI(string, this);
        if (string2 == null) {
            return null;
        }
        try {
            return (Archive)eARFile.getFile(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public boolean hasClasspathVisibilityTo(Archive archive) {
        if (archive == null) {
            return false;
        }
        EARFile eARFile = this.getEARFile();
        if (eARFile == null) {
            return false;
        }
        HashSet hashSet = new HashSet();
        return this.hasClasspathVisibilityTo(archive, hashSet, eARFile);
    }

    public boolean hasClasspathVisibilityTo(Archive archive, Set set, EARFile eARFile) {
        if (this == archive) {
            return true;
        }
        if (set.contains(this)) {
            return false;
        }
        set.add(this);
        String[] stringArray = this.getManifest().getClassPathTokenized();
        for (int i = 0; i < stringArray.length; ++i) {
            Archive archive2 = this.getResolvedArchive(stringArray[i], eARFile);
            if (archive2 == null || !archive2.hasClasspathVisibilityTo(archive, set, eARFile)) continue;
            return true;
        }
        return false;
    }

    public boolean isType(String string) {
        return this.types != null && this.getTypes().contains(string);
    }

    private boolean renameToWithRetry(java.io.File file, java.io.File file2) {
        String string = "renameToWithRetry";
        logger.logp(Level.FINER, className, string, "ENTRY rename [ {0} ]", file);
        for (int i = 1; i < 21; ++i) {
            if (file.renameTo(file2)) {
                logger.logp(Level.FINER, className, string, "RETURN true");
                return true;
            }
            System.gc();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (i != 1 && i % 10 != 0) continue;
            logger.logp(Level.FINER, className, string, "Garbage collection forced.  Slept {0} times.", Integer.toString(i));
        }
        logger.logp(Level.FINER, className, string, "RETURN false");
        if (logger.isLoggable(Level.FINEST)) {
            this.displayFileData(file);
        }
        return false;
    }

    public void displayFileData(java.io.File file) {
        String string = "displayFileData";
        this.displayMsg = "\n\nDisplaying data for file [ " + file + " ]";
        boolean bl = file.isDirectory();
        boolean bl2 = file.exists();
        this.displayMsg = this.displayMsg + "\n   File path [ " + file.getPath() + " ]";
        this.displayMsg = this.displayMsg + "\n   File absolute path [ " + file.getAbsolutePath() + " ]";
        try {
            this.displayMsg = this.displayMsg + "\n   File canonical file [ " + file.getCanonicalFile() + " ]";
        }
        catch (IOException iOException) {
            this.displayMsg = this.displayMsg + "\n   File canonical file [ unknown ]";
        }
        this.displayMsg = this.displayMsg + "\n   File parent file [ " + file.getParentFile() + " ]";
        if (!bl2) {
            this.displayMsg = this.displayMsg + "\n   ERROR: File does not exist";
        } else {
            this.displayMsg = this.displayMsg + "\n   File exists";
            if (bl) {
                this.displayMsg = this.displayMsg + "\n   File is a directory";
                int n = this.scanFilesInDirectory(file);
                this.displayMsg = this.displayMsg + "\n   Scanned a total of [ " + n + " ] files";
            } else {
                this.displayMsg = this.displayMsg + "\n   File is NOT a directory";
                this.checkFile(file);
            }
        }
        LoadStrategy loadStrategy = this.getLoadStrategy();
        this.displayMsg = this.displayMsg + "\n   Load Strategy [ " + loadStrategy + " ]";
        if (loadStrategy instanceof ZipFileLoadStrategyImpl) {
            ZipFileLoadStrategyImpl zipFileLoadStrategyImpl = (ZipFileLoadStrategyImpl)loadStrategy;
            java.io.File file2 = zipFileLoadStrategyImpl.getFile();
            this.displayMsg = this.displayMsg + "\n     File [ " + file2 + " ]";
            if (file2 != null) {
                this.displayMsg = this.displayMsg + "\n     File absolute path [ " + file2.getAbsolutePath() + " ]";
                this.displayMsg = this.displayMsg + "\n     File exists [ " + file2.exists() + " ]";
            }
        }
        logger.logp(Level.FINER, className, string, this.displayMsg);
    }

    private int scanFilesInDirectory(java.io.File file) {
        this.displayMsg = this.displayMsg + "\nScanning directory [ " + file + " ]";
        boolean bl = file.canRead();
        boolean bl2 = file.canWrite();
        if (!bl || !bl2) {
            this.displayMsg = this.displayMsg + "\n\nERROR: directory name= + " + file + "R/W: " + bl + "/" + bl2;
        }
        int n = 1;
        java.io.File[] fileArray = file.listFiles(new NonDirectoryFileFilter());
        for (int i = 0; i < fileArray.length; ++i) {
            this.checkFile(fileArray[i]);
            ++n;
        }
        java.io.File[] fileArray2 = file.listFiles(new DirectoryFileFilter());
        for (int i = 0; i < fileArray2.length; ++i) {
            n += this.scanFilesInDirectory(fileArray2[i]);
        }
        return n;
    }

    private void checkFile(java.io.File file) {
        boolean bl = file.canRead();
        boolean bl2 = file.canWrite();
        String string = "";
        try {
            string = file.getCanonicalPath();
            this.displayMsg = this.displayMsg + "\nFile's canonical path = [ " + string + " ]";
        }
        catch (IOException iOException) {
            this.displayMsg = this.displayMsg + "\n\nERROR: couldn't get canonical path of file " + file;
        }
        if (!bl || !bl2) {
            this.displayMsg = this.displayMsg + "\n\nERROR: file name= + " + string + "R/W: " + bl + "/" + bl2;
            return;
        }
        String string2 = string + ".tmp";
        java.io.File file2 = new java.io.File(string2);
        boolean bl3 = file.renameTo(file2);
        if (!bl3) {
            this.displayMsg = this.displayMsg + "\n\nERROR: Could not rename original file " + string;
        } else {
            this.displayMsg = this.displayMsg + "\nSuccessfully renamed  original file " + string;
            bl3 = file2.renameTo(file);
            this.displayMsg = this.displayMsg + "\nSuccessfully renamed temporary file " + string2;
            if (!bl3) {
                this.displayMsg = this.displayMsg + "\n\nERROR: Could not rename temporary file " + string2;
            }
        }
    }

    public void closeArchiveZipFile() {
        String string = "closeArchiveZipFile";
        LoadStrategy loadStrategy = this.getLoadStrategy();
        if (loadStrategy instanceof ZipFileLoadStrategyImpl) {
            ZipFileLoadStrategyImpl zipFileLoadStrategyImpl = (ZipFileLoadStrategyImpl)loadStrategy;
            try {
                zipFileLoadStrategyImpl.closeZipFile();
            }
            catch (IOException iOException) {
                logger.logp(Level.WARNING, className, string, "IOException from zipfile close [ {0} ]", iOException);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class NonDirectoryFileFilter
    implements FileFilter {
        NonDirectoryFileFilter() {
        }

        public boolean accept(java.io.File file) {
            return !file.isDirectory();
        }
    }

    class DirectoryFileFilter
    implements FileFilter {
        DirectoryFileFilter() {
        }

        public boolean accept(java.io.File file) {
            return file.isDirectory();
        }
    }
}

