/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.common.internal.util.Defaultable;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveRuntimeException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifestImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ArchiveCopySessionUtility;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.webapplication.FilterMapping;
import org.eclipse.wst.common.internal.emf.utilities.CopyGroup;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;

public class ArchiveCopyUtility
extends EtoolsCopyUtility {
    public ArchiveCopyUtility() {
        this.setCopyAdapters(true);
    }

    protected void addDeferredSingleReferenceCopy(EReference eReference, EObject eObject, String string, EObject eObject2) {
        if (((Defaultable)((Object)eObject)).isDefault()) {
            return;
        }
        super.addDeferredSingleReferenceCopy(eReference, eObject, string, eObject2);
    }

    public ArchiveManifest copy(ArchiveManifest archiveManifest) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            archiveManifest.write(byteArrayOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return new ArchiveManifestImpl(byteArrayInputStream);
        }
        catch (IOException iOException) {
            throw new ArchiveRuntimeException(CommonArchiveResourceHandler.IOException_occurred_while_EXC_, iOException);
        }
    }

    public Archive copy(Archive archive) {
        CopyGroup copyGroup = new CopyGroup();
        copyGroup.setPreserveIds(true);
        this.prepareResourcesForCopy(archive, copyGroup);
        copyGroup.add((EObject)archive);
        this.copy(copyGroup);
        Archive archive2 = (Archive)this.getCopy(archive);
        this.finishCopy(archive, archive2, copyGroup);
        return archive2;
    }

    public ModuleFile copy(ModuleFile moduleFile) {
        Object object;
        moduleFile.getStandardDeploymentDescriptor();
        if (moduleFile.isWARFile()) {
            object = ((WARFile)moduleFile).getDeploymentDescriptor().getFilterMappings();
            for (int i = 0; i < object.size(); ++i) {
                ((FilterMapping)object.get(i)).getServlet();
            }
        }
        object = (ModuleFile)this.copy((Archive)moduleFile);
        return object;
    }

    public void copy(CopyGroup copyGroup) {
        if (copyGroup != null) {
            ArchiveCopySessionUtility archiveCopySessionUtility = new ArchiveCopySessionUtility(this);
            archiveCopySessionUtility.setPreserveIds(copyGroup.getPreserveIds());
            archiveCopySessionUtility.copy(copyGroup);
            archiveCopySessionUtility.flush();
        }
    }

    public EObject copy(EObject eObject, String string) {
        ArchiveCopySessionUtility archiveCopySessionUtility = new ArchiveCopySessionUtility(this);
        EObject eObject2 = archiveCopySessionUtility.copy(eObject, string);
        archiveCopySessionUtility.flush();
        return eObject2;
    }

    public Resource copy(Resource resource, String string) {
        ArchiveCopySessionUtility archiveCopySessionUtility = new ArchiveCopySessionUtility(this);
        Resource resource2 = archiveCopySessionUtility.copy(resource, string);
        archiveCopySessionUtility.flush();
        return resource2;
    }

    protected void copyImportStrategyIfNecessary(ModuleFile moduleFile, ModuleFile moduleFile2) {
        if (!moduleFile.isDeploymentDescriptorSet()) {
            moduleFile2.setImportStrategy(moduleFile.getImportStrategy().createImportStrategy(moduleFile, moduleFile2));
        }
    }

    public EObject copyObject(EObject eObject, String string) {
        ArchiveCopySessionUtility archiveCopySessionUtility = new ArchiveCopySessionUtility(this);
        EObject eObject2 = archiveCopySessionUtility.copyObject(eObject, string);
        archiveCopySessionUtility.flush();
        return eObject2;
    }

    public static void createCopy(CopyGroup copyGroup) {
        ArchiveCopyUtility archiveCopyUtility = new ArchiveCopyUtility();
        archiveCopyUtility.copy(copyGroup);
    }

    protected void finishCopy(Archive archive, Archive archive2, CopyGroup copyGroup) {
        Object object;
        archive2.setLoadStrategy(this.getCommonarchiveFactory().createEmptyLoadStrategy());
        archive2.setExtraClasspath(archive.getExtraClasspath());
        archive2.setXmlEncoding(archive.getXmlEncoding());
        if (archive.isManifestSet()) {
            archive2.setManifest(this.copy(archive.getManifest()));
        } else {
            try {
                object = archive.getFile("META-INF/MANIFEST.MF");
                if (object != null) {
                    File file = (File)this.getCopy((EObject)object);
                    file.setLoadingContainer(object.getLoadingContainer());
                    archive2.addCopy(file);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (DuplicateObjectException duplicateObjectException) {
                // empty catch block
            }
        }
        this.retrieveResourcesFromCopy(archive2, copyGroup);
        if (archive.isModuleFile()) {
            this.copyImportStrategyIfNecessary((ModuleFile)archive, (ModuleFile)archive2);
        }
        object = archive.getFiles();
        for (int i = 0; i < object.size(); ++i) {
            File file = (File)object.get(i);
            File file2 = (File)this.getCopy(file);
            file2.setLoadingContainer(file.getLoadingContainer());
            if (!file.isArchive()) continue;
            this.finishNestedCopy((Archive)file, (Archive)file2);
        }
        archive2.rebuildFileIndex();
    }

    protected void finishNestedCopy(Archive archive, Archive archive2) {
        CopyGroup copyGroup = new CopyGroup();
        this.prepareResourcesForCopy(archive, copyGroup);
        this.copy(copyGroup);
        this.finishCopy(archive, archive2, copyGroup);
    }

    private CommonarchiveFactory getCommonarchiveFactory() {
        return CommonarchivePackage.eINSTANCE.getCommonarchiveFactory();
    }

    protected void prepareResourcesForCopy(Archive archive, CopyGroup copyGroup) {
        Iterator iterator = archive.getLoadedMofResources().iterator();
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            if (ArchiveUtil.isJavaResource(resource)) continue;
            copyGroup.add(resource);
        }
    }

    protected void retrieveResourcesFromCopy(Archive archive, CopyGroup copyGroup) {
        List list = copyGroup.getCopiedResources();
        for (int i = 0; i < list.size(); ++i) {
            Resource resource = (Resource)list.get(i);
            archive.addOrReplaceMofResource(resource);
        }
    }
}

