/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.helpers;

import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveRuntimeException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.FileIteratorImpl;

public class NestedArchiveIterator
extends FileIteratorImpl {
    protected ZipInputStream zipInputStream;

    public NestedArchiveIterator(List list, ZipInputStream zipInputStream) {
        super(list);
        this.zipInputStream = zipInputStream;
    }

    public InputStream getInputStream(File file) throws IOException, FileNotFoundException {
        Archive archive;
        if (file.isArchive() && (archive = (Archive)file).getLoadStrategy().getLooseArchive() != null) {
            return file.getInputStream();
        }
        boolean bl = false;
        String string = file.getURI();
        while (!bl) {
            ZipEntry zipEntry;
            try {
                zipEntry = this.zipInputStream.getNextEntry();
            }
            catch (IOException iOException) {
                throw new ArchiveRuntimeException(CommonArchiveResourceHandler.Error_iterating_the_archiv_EXC_, iOException);
            }
            bl = !zipEntry.isDirectory() && string.equals(zipEntry.getName());
        }
        return new WrapperInputStream(this.zipInputStream);
    }

    public File next() throws NoSuchElementException {
        File file = super.next();
        return file;
    }

    public void close() throws IOException {
        this.zipInputStream.close();
    }

    static class WrapperInputStream
    extends FilterInputStream {
        public WrapperInputStream(InputStream inputStream) {
            super(inputStream);
        }

        public void close() throws IOException {
        }
    }
}

