/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.helpers;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ModuleLocatorClassAdapter;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.DirectoryArchiveLoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseApplication;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseConfigRegister;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class ModuleLocator {
    protected static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    private static final String className = (class$org$eclipse$jst$j2ee$commonarchivecore$internal$helpers$ModuleLocator == null ? (class$org$eclipse$jst$j2ee$commonarchivecore$internal$helpers$ModuleLocator = ModuleLocator.class$("org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ModuleLocator")) : class$org$eclipse$jst$j2ee$commonarchivecore$internal$helpers$ModuleLocator).getName();
    static /* synthetic */ Class class$org$eclipse$jst$j2ee$commonarchivecore$internal$helpers$ModuleLocator;

    public boolean isEJBModule(Archive archive) {
        String string = "isEJBModule";
        String string2 = archive.getURI();
        logger.entering(className, string, string2);
        if (this.jarArchiveContainsAnnotations(archive)) {
            logger.exiting(className, string, "true");
            return true;
        }
        boolean bl = archive.getLoadStrategy() instanceof DirectoryArchiveLoadStrategyImpl;
        if (bl) {
            boolean bl2 = this.binariesPathContainsAnnotations(archive);
            if (bl2) {
                logger.exiting(className, string, "true");
            } else {
                logger.exiting(className, string, "false");
            }
            return bl2;
        }
        logger.exiting(className, string, "false");
        return false;
    }

    private boolean jarArchiveContainsAnnotations(Archive archive) {
        Object object;
        Object object2;
        String string = "jarArchiveContainsAnnotations";
        String string2 = archive.getURI();
        logger.entering(className, string, string2);
        EList eList = archive.getFiles();
        logger.logp(Level.FINER, className, string, "Examining {0} files", Integer.toString(eList.size()));
        if (logger.isLoggable(Level.FINEST)) {
            object2 = "Archive files to scan:\n";
            object = eList.iterator();
            while (object.hasNext()) {
                object2 = (String)object2 + object.next() + "\n    ";
            }
            logger.logp(Level.FINEST, className, string, (String)object2);
        }
        object2 = eList.iterator();
        while (object2.hasNext()) {
            InputStream inputStream;
            object = (File)object2.next();
            String string3 = object.getURI();
            boolean bl = false;
            if (!string3.endsWith(".class")) continue;
            logger.logp(Level.FINER, className, string, "Scanning class file [ {0} ]", string3);
            try {
                inputStream = object.getInputStream();
                logger.logp(Level.FINER, className, string, "Created input stream for class [ {0} ]", string3);
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.logp(Level.FINEST, className, string, fileNotFoundException.getMessage());
                logger.logp(Level.FINER, className, string, "Ignoring FileNotFoundException - Could not get file inputstream for class [ {0} ]", string3);
                continue;
            }
            catch (IOException iOException) {
                logger.logp(Level.FINEST, className, string, iOException.getMessage());
                logger.logp(Level.FINER, className, string, "Ignoring IOException - Could not get file inputstream for class [ {0} ]", string3);
                continue;
            }
            bl = this.inputStreamContainsAnnotations(inputStream);
            try {
                inputStream.close();
                logger.logp(Level.FINER, className, string, "Closed input stream for class [ {0} ]", string3);
            }
            catch (IOException iOException) {
                logger.logp(Level.FINEST, className, string, iOException.getMessage());
                logger.logp(Level.FINER, className, string, "Ignoring IOException - Could not close file inputstream for class [ {0} ]", string3);
            }
            if (!bl) continue;
            logger.logp(Level.FINER, className, string, "RETURN true - found annotation in [ {0} ]", string3);
            return true;
        }
        logger.exiting(className, string, "false - No annotations found");
        return false;
    }

    private boolean binariesPathContainsAnnotations(Archive archive) {
        JarFile jarFile;
        String string = "binariesPathContainsAnnotations";
        String string2 = archive.getURI();
        logger.entering(className, string, string2);
        if (logger.isLoggable(Level.FINEST)) {
            this.describeArchive(archive);
        }
        String string3 = null;
        Archive archive2 = (Archive)archive.getContainer();
        ArchiveOptions archiveOptions = archive.getOptions();
        string3 = archiveOptions.getAltBinariesPath();
        if (string3 != null) {
            logger.logp(Level.FINER, className, string, "Got alternate binaries path [ {0} ]", string3);
        } else if (archive2 != null) {
            logger.logp(Level.FINER, className, string, "Parent archive is [ {0} ]", archive2.getURI());
            try {
                string3 = archive2.getBinariesPath();
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.logp(Level.FINEST, className, string, fileNotFoundException.getMessage());
                logger.logp(Level.FINER, className, string, "RETURN false - Ignoring IOException - Could not find parent archive binaries path");
                return false;
            }
            logger.logp(Level.FINER, className, string, "No parent container. Got archive binaries path [ {0} ]", string3);
        } else {
            string3 = archiveOptions.getParentEarBinariesPath();
            if (string3 == null) {
                logger.logp(Level.FINER, className, string, "RETURN false - Could not find parent archive binaries path in archive options");
                return false;
            }
            logger.logp(Level.FINER, className, string, "Got parent archive binaries path [ {0} ]", string3);
        }
        string3 = string3 + System.getProperty("file.separator") + string2;
        logger.logp(Level.FINER, className, string, "Archive is a directory, look for classes in binary path [ {0} ]", string3);
        try {
            jarFile = new JarFile(string3);
        }
        catch (IOException iOException) {
            logger.logp(Level.FINEST, className, string, iOException.getMessage());
            logger.logp(Level.FINER, className, string, "RETURN false - Ignoring IOException - Could not open jar file [ {0} ]", string3);
            return false;
        }
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            InputStream inputStream;
            ZipEntry zipEntry = enumeration.nextElement();
            String string4 = zipEntry.getName();
            if (!string4.endsWith(".class")) continue;
            logger.logp(Level.FINER, className, string, "Examine class file [ {0} ]", string4);
            boolean bl = false;
            try {
                inputStream = jarFile.getInputStream(zipEntry);
                logger.logp(Level.FINER, className, string, "Created input stream for class [ {0} ]", string4);
            }
            catch (IOException iOException) {
                logger.logp(Level.FINEST, className, string, iOException.getMessage());
                logger.logp(Level.FINER, className, string, "Ignoring IOException - Could  not get file inputstream for class [ {0} ]", string4);
                continue;
            }
            bl = this.inputStreamContainsAnnotations(inputStream);
            try {
                inputStream.close();
                logger.logp(Level.FINER, className, string, "Closed input stream for class [ {0} ]", string4);
            }
            catch (IOException iOException) {
                logger.logp(Level.FINEST, className, string, iOException.getMessage());
                logger.logp(Level.FINER, className, string, "Ignoring IOException - Could not close file inputstream for class [ {0} ]", string4);
            }
            if (!bl) continue;
            logger.logp(Level.FINER, className, string, "RETURN true - found annotation in class [ {0} ]", string4);
            return true;
        }
        logger.exiting(className, string, "false - no annotations found");
        return false;
    }

    private boolean inputStreamContainsAnnotations(InputStream inputStream) {
        ClassReader classReader;
        String string = "inputStreamContainsAnnotations";
        logger.entering(className, string);
        try {
            classReader = new ClassReader(inputStream);
        }
        catch (IOException iOException) {
            logger.logp(Level.FINEST, className, string, iOException.getMessage());
            logger.logp(Level.FINER, className, string, "RETURN false - Ignoring IOException - Could not create ClassReader");
            return false;
        }
        ClassWriter classWriter = new ClassWriter(true);
        ModuleLocatorClassAdapter moduleLocatorClassAdapter = new ModuleLocatorClassAdapter((ClassVisitor)classWriter);
        classReader.accept((ClassVisitor)moduleLocatorClassAdapter, false);
        if (moduleLocatorClassAdapter.isEJBModule()) {
            logger.exiting(className, string, "true - annotations found");
            return true;
        }
        logger.exiting(className, string, "false - no annotations found");
        return false;
    }

    protected void describeArchive(Archive archive) {
        String string;
        String string2;
        String string3;
        String string4 = "\n    \nDescribing archive [ " + archive.getURI() + " ]\n";
        ArchiveOptions archiveOptions = archive.getOptions();
        String string5 = archiveOptions.getAltBinariesPath();
        string4 = string4 + "\n    Archive options altBinariesPath [ " + string5 + " ]";
        String string6 = archiveOptions.getParentEarBinariesPath();
        string4 = string4 + "\n    Archive options parent EAR binariesPath [ " + string6 + " ]";
        try {
            string3 = archive.getBinariesPath();
        }
        catch (IOException iOException) {
            string3 = "*** UNAVAILABLE ***";
        }
        string4 = string4 + "\n    Archive Binaries Path [ " + string3 + " ]";
        try {
            string2 = archive.getBinariesPath();
        }
        catch (IOException iOException) {
            string2 = "*** UNAVAILABLE ***";
        }
        string4 = string4 + "\n    Archive Resources Path [ " + string2 + " ]";
        try {
            string = archive.getAbsolutePath();
        }
        catch (IOException iOException) {
            string = "*** UNAVAILABLE ***";
        }
        string4 = string4 + "\n    Archive Absolute Path [ " + string + " ]";
        Container container = archive.getContainer();
        if (container == null) {
            string4 = string4 + "\n    Container [ *** NULL *** ]";
        } else {
            string4 = string4 + "\n    Container [ " + container.getURI() + " ]";
            if (!(container instanceof Archive)) {
                string4 = string4 + "\n    Container is not an archive";
            } else {
                String string7;
                String string8;
                String string9;
                Archive archive2 = (Archive)container;
                LooseConfigRegister looseConfigRegister = LooseConfigRegister.singleton();
                LooseApplication looseApplication = looseConfigRegister.findLooseApplication(archive2.getURI());
                if (looseApplication != null) {
                    string4 = string4 + "\n    Container is a loose application";
                    string4 = string4 + "\n    Container loose Binaries Path [ " + looseApplication.getBinariesPath() + " ]";
                    string4 = string4 + "\n    Container loose Resources Path [ " + looseApplication.getResourcesPath() + " ]";
                } else {
                    string4 = string4 + "\n    Container is NOT a loose application";
                }
                try {
                    string9 = archive2.getBinariesPath();
                }
                catch (IOException iOException) {
                    string9 = "*** UNAVAILABLE ***";
                }
                string4 = string4 + "\n    Container Binaries Path [ " + string9 + " ]";
                try {
                    string8 = archive2.getResourcesPath();
                }
                catch (IOException iOException) {
                    string8 = "*** UNAVAILABLE ***";
                }
                string4 = string4 + "\n    Container Resources Path [ " + string8 + " ]";
                try {
                    string7 = archive2.getAbsolutePath();
                }
                catch (IOException iOException) {
                    string7 = "*** UNAVAILABLE ***";
                }
                string4 = string4 + "\n    Container Absolute Path [ " + string7 + " ]";
            }
        }
        logger.finest(string4 + "\n");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

