/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.helpers;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.SaveFilter;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.SaveFilterImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;

public class FileExtensionsFilterImpl
extends SaveFilterImpl
implements SaveFilter {
    protected Set excludedExtensions;
    protected boolean isCaseSensitive = false;
    protected Set excludedExtensionsAsUppercase;

    public FileExtensionsFilterImpl(String[] stringArray, boolean bl) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(stringArray[i]);
        }
        this.setExcludedExtensions(hashSet);
        this.setIsCaseSensitive(bl);
        this.initialize();
    }

    public FileExtensionsFilterImpl(String string, boolean bl) {
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add(string);
        this.setExcludedExtensions(hashSet);
        this.setIsCaseSensitive(bl);
        this.initialize();
    }

    public FileExtensionsFilterImpl(Set set, boolean bl) {
        this.setExcludedExtensions(set);
        this.setIsCaseSensitive(bl);
        this.initialize();
    }

    public Set getExcludedExtensions() {
        return this.excludedExtensions;
    }

    protected Set getExcludedExtensionsAsUppercase() {
        return this.excludedExtensionsAsUppercase;
    }

    protected void initialize() {
        if (this.isCaseSensitive()) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.getExcludedExtensions().iterator();
        while (iterator.hasNext()) {
            hashSet.add(((String)iterator.next()).toUpperCase());
        }
        this.setExcludedExtensionsAsUppercase(hashSet);
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    protected void setExcludedExtensions(Set set) {
        this.excludedExtensions = set;
    }

    protected void setExcludedExtensionsAsUppercase(Set set) {
        this.excludedExtensionsAsUppercase = set;
    }

    protected void setIsCaseSensitive(boolean bl) {
        this.isCaseSensitive = bl;
    }

    public boolean shouldSave(String string, Archive archive) {
        Set set;
        String string2 = ArchiveUtil.getFileNameExtension(string);
        if (string2.equals("")) {
            return true;
        }
        if (this.isCaseSensitive()) {
            set = this.getExcludedExtensions();
        } else {
            set = this.getExcludedExtensionsAsUppercase();
            string2 = string2.toUpperCase();
        }
        return !set.contains(string2);
    }
}

