/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.helpers;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;

public class ArchiveURIConverterImpl
extends URIConverterImpl {
    public static final String CONFIG_WTP_LOGGER = "com.ibm.config.eclipse.wtp";
    public static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    public static final String CLASS_NAME = (class$org$eclipse$jst$j2ee$commonarchivecore$internal$helpers$ArchiveURIConverterImpl == null ? (class$org$eclipse$jst$j2ee$commonarchivecore$internal$helpers$ArchiveURIConverterImpl = ArchiveURIConverterImpl.class$("org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveURIConverterImpl")) : class$org$eclipse$jst$j2ee$commonarchivecore$internal$helpers$ArchiveURIConverterImpl).getName();
    protected static final String fileProtocol = "file";
    protected static final String platformProtocol = "platform";
    private String inFilepath;
    private String outFilepath;
    protected Archive archive;
    protected String resourcesPath;
    static /* synthetic */ Class class$org$eclipse$jst$j2ee$commonarchivecore$internal$helpers$ArchiveURIConverterImpl;

    public ArchiveURIConverterImpl(Archive archive, String string) {
        LoadStrategy loadStrategy;
        String string2 = "ArchiveURIConverterImpl";
        logger.logp(Level.FINER, CLASS_NAME, string2, "ENTRY - archive [ {0} ]", archive);
        this.setArchive(archive);
        this.resourcesPath = string;
        logger.logp(Level.FINER, CLASS_NAME, string2, "resources path [ {0} ]", string);
        this.setInputFilepath(string);
        String string3 = string;
        if (string3 == null && (loadStrategy = archive.getLoadStrategy()) != null && loadStrategy.isDirectory()) {
            logger.logp(Level.FINER, CLASS_NAME, string2, "directory load strategy");
            try {
                string3 = loadStrategy.getAbsolutePath();
                logger.logp(Level.FINER, CLASS_NAME, string2, "outpath [ {0} ]", string3);
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.logp(Level.FINER, CLASS_NAME, string2, "Ignoring FileNotFoundException while getting absolute path");
            }
        }
        this.setOutputFilepath(string3);
        logger.logp(Level.FINER, CLASS_NAME, string2, "RETURN");
    }

    public Archive getArchive() {
        return this.archive;
    }

    protected String getSearchText(URI uRI) {
        String string;
        String string2 = "getSearchText";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, string2, "ENTER");
            logger.logp(Level.FINER, CLASS_NAME, string2, "URI String [ {0} ], ", uRI.toString());
            logger.logp(Level.FINER, CLASS_NAME, string2, "URI File String [ {0} ], ", uRI.toFileString());
        }
        if ((string = uRI.toFileString()) == null) {
            string = uRI.toString();
            logger.logp(Level.WARNING, CLASS_NAME, string2, "Entry URI file string is null; using basic string [ {0} ]", string);
        } else if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, string2, "RETURN [ {0} ]", string);
        }
        return string;
    }

    public InputStream createInputStream(URI uRI) throws IOException {
        String string = "createInputStream";
        logger.logp(Level.FINER, CLASS_NAME, string, "ENTRY - URI [ {0} ]", uRI);
        InputStream inputStream = null;
        if (this.resourcesPath != null) {
            logger.logp(Level.FINER, CLASS_NAME, string, "resourcesPath not null. make input stream");
            inputStream = this.makeInputStream(uRI);
        }
        if (inputStream != null) {
            logger.logp(Level.FINER, CLASS_NAME, string, "RETURN - input stream [ {0} ]", inputStream);
            return inputStream;
        }
        InputStream inputStream2 = this.getArchive().getInputStream(this.getSearchText(uRI));
        logger.logp(Level.FINER, CLASS_NAME, string, "RETURN - archive input stream [ {0} ]", inputStream2);
        return inputStream2;
    }

    public void setArchive(Archive archive) {
        this.archive = archive;
    }

    public String getResourcesPath() {
        return this.resourcesPath;
    }

    public void setResourcesPath(String string) {
        this.resourcesPath = string;
        this.setInputFilepath(string);
        this.setOutputFilepath(string);
    }

    public URI normalize(URI uRI) {
        return this.getInternalURIMap().getURI(uRI);
    }

    public String getInputFilepath() {
        return this.inFilepath;
    }

    public void setInputFilepath(String string) {
        this.inFilepath = string;
    }

    public String getOutputFilepath() {
        return this.outFilepath;
    }

    public void setOutputFilepath(String string) {
        this.outFilepath = string;
    }

    public InputStream makeInputStream(URI uRI) throws IOException {
        String string = "makeInputStream";
        logger.logp(Level.FINER, CLASS_NAME, string, "ENTRY - URI [ {0} ]", uRI);
        URI uRI2 = uRI;
        if ((fileProtocol.equals(uRI2.scheme()) || uRI2.scheme() == null) && this.inFilepath != null) {
            return this.searchFilePath(uRI2.toString());
        }
        URL uRL = this.createURL(uRI2.toString());
        URLConnection uRLConnection = uRL.openConnection();
        InputStream inputStream = uRLConnection.getInputStream();
        logger.logp(Level.FINER, CLASS_NAME, string, "RETURN input stream [ {0} ]", inputStream);
        return inputStream;
    }

    protected InputStream searchFilePath(String string) throws IOException {
        String string2 = "searchFilePath";
        logger.logp(Level.FINER, CLASS_NAME, string2, "ENTRY - filename [ {0} ]", string);
        File file = new File(string);
        if (file.isAbsolute()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            logger.logp(Level.FINER, CLASS_NAME, string2, "RETURN input stream for absolute file [ {0} ]", fileInputStream);
            return fileInputStream;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.inFilepath, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(string3);
            }
            catch (Exception exception) {
                logger.logp(Level.FINER, CLASS_NAME, string2, "Ignore Exception while creating zipfile [ {0} ]", string3);
            }
            InputStream inputStream = null;
            if (zipFile != null) {
                inputStream = this.searchZipFile(zipFile, string);
                if (inputStream == null) {
                    try {
                        zipFile.close();
                    }
                    catch (Exception exception) {
                        logger.logp(Level.FINER, CLASS_NAME, string2, "Ignore Exception while closing zipfile [ {0} ]", zipFile);
                    }
                }
            } else {
                inputStream = this.searchDirectory(string3, string);
            }
            if (inputStream == null) continue;
            logger.logp(Level.FINER, CLASS_NAME, string2, "RETURN input stream for absolute file [ {0} ]", inputStream);
            return inputStream;
        }
        logger.logp(Level.FINER, CLASS_NAME, string2, "RETURN null");
        return null;
    }

    protected InputStream searchDirectory(String string, String string2) throws IOException {
        String string3;
        File file;
        String string4 = "searchDirectory";
        logger.logp(Level.FINER, CLASS_NAME, string4, "ENTRY - directory [ {0} ]", string);
        if (string.equals(".")) {
            string = System.getProperty("user.dir");
            logger.logp(Level.FINER, CLASS_NAME, string4, "Use directory specified by system property [ {0} ]", string);
        }
        if (!(file = new File(string3 = string + System.getProperty("file.separator") + string2.replace('/', File.separatorChar))).exists()) {
            logger.logp(Level.FINER, CLASS_NAME, string4, "RETURN null.  File doesn't exist.");
            return null;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        logger.logp(Level.FINER, CLASS_NAME, string4, "RETURN FileInputStream [ {0} ]", fileInputStream);
        return fileInputStream;
    }

    protected InputStream searchZipFile(ZipFile zipFile, String string) throws IOException {
        String string2 = "searchZipFile";
        logger.logp(Level.FINER, CLASS_NAME, string2, "ENTRY - zip [ {0} ]", zipFile);
        logger.logp(Level.FINER, CLASS_NAME, string2, "Search for entry [ {0} ]", string);
        ZipEntry zipEntry = zipFile.getEntry(string);
        if (zipEntry == null) {
            logger.logp(Level.FINER, CLASS_NAME, string2, "RETURN null. Entry not found.");
            return null;
        }
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        logger.logp(Level.FINER, CLASS_NAME, string2, "RETURN InputStream [ {0} ]", inputStream);
        return inputStream;
    }

    public URL createURL(String string) throws MalformedURLException {
        String string2 = "createURL";
        logger.logp(Level.FINER, CLASS_NAME, string2, "ENTRY - uri [ {0} ]", string);
        MalformedURLException malformedURLException = null;
        if (string == null) {
            logger.logp(Level.FINER, CLASS_NAME, string2, "RETURN null.  URI is null.");
            return null;
        }
        URL uRL = null;
        try {
            logger.logp(Level.FINER, CLASS_NAME, string2, "Create URL from uri [ {0} ]", string);
            uRL = new URL(string);
        }
        catch (Exception exception) {
            malformedURLException = (MalformedURLException)exception;
        }
        if (uRL != null) {
            logger.logp(Level.FINER, CLASS_NAME, string2, "RETURN URL [ {0} ]", uRL);
            return uRL;
        }
        int n = string.indexOf(":");
        if (n == -1 || n == 1) {
            string = "file:" + string;
        } else if (n > 0) {
            string = "file:" + string.substring(n + 1);
        }
        try {
            logger.logp(Level.FINER, CLASS_NAME, string2, "Create URL from uri [ {0} ]", string);
            uRL = new URL(string);
        }
        catch (Exception exception) {
            logger.logp(Level.FINER, CLASS_NAME, string2, "Ignore Exception received while creating URL");
        }
        if (uRL != null) {
            logger.logp(Level.FINER, CLASS_NAME, string2, "RETURN URL [ {0} ]", uRL);
            return uRL;
        }
        logger.logp(Level.FINER, CLASS_NAME, string2, "RETURN Throw MalformedURLException");
        throw malformedURLException;
    }

    public OutputStream createOutputStream(URI uRI) throws IOException {
        Object object;
        String string = "createOutputStream";
        logger.logp(Level.FINER, CLASS_NAME, string, "ENTRY - uri [ {0} ]", uRI);
        URI uRI2 = uRI;
        if (platformProtocol.equals(uRI2.scheme())) {
            object = this.resolvePlatform(new URL(uRI2.toString()));
            logger.logp(Level.FINER, CLASS_NAME, string, "resolved URL [ {0} ]", object);
            if (object != null) {
                uRI2 = URI.createFileURI(((URL)object).getFile());
                logger.logp(Level.FINER, CLASS_NAME, string, "converted URI [ {0} ]", uRI2);
            }
        }
        if (fileProtocol.equals(uRI2.scheme()) || uRI2.scheme() == null) {
            object = this.openFileOutputStream(uRI2);
            logger.logp(Level.FINER, CLASS_NAME, string, "RETURN OutputStream [ {0} ]", object);
            return object;
        }
        object = this.createURL(uRI2.toString());
        URLConnection uRLConnection = ((URL)object).openConnection();
        uRLConnection.setDoOutput(true);
        OutputStream outputStream = uRLConnection.getOutputStream();
        logger.logp(Level.FINER, CLASS_NAME, string, "RETURN OutputStream [ {0} ]", outputStream);
        return outputStream;
    }

    protected URL resolvePlatform(URL uRL) throws IOException {
        return null;
    }

    protected OutputStream openFileOutputStream(URI uRI) throws IOException {
        String string;
        String string2 = "openFileOutputStream";
        logger.logp(Level.FINER, CLASS_NAME, string2, "ENTRY - uri [ {0} ]", uRI);
        File file = new File(uRI.toFileString());
        if (!file.isAbsolute() && this.outFilepath != null) {
            string = this.outFilepath + File.separator + uRI.toFileString();
            logger.logp(Level.FINER, CLASS_NAME, string2, "File is not absolute. Try filename [ {0} ]", string);
            file = new File(string);
        }
        string = file.getParent();
        logger.logp(Level.FINER, CLASS_NAME, string2, "Parent [ {0} ]", string);
        if (string != null) {
            logger.logp(Level.FINER, CLASS_NAME, string2, "Create parent directory structure.");
            new File(string).mkdirs();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        logger.logp(Level.FINER, CLASS_NAME, string2, "RETURN OutputStream [ {0} ]", fileOutputStream);
        return fileOutputStream;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

