/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.helpers;

import com.ibm.icu.util.StringTokenizer;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;

public class ArchiveManifestImpl
extends Manifest
implements ArchiveManifest {
    public ArchiveManifestImpl() {
    }

    public ArchiveManifestImpl(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public ArchiveManifestImpl(Manifest manifest) {
        super(manifest);
    }

    public void addEntry(String string) {
        Attributes attributes = new Attributes();
        this.addEntry(string, attributes);
    }

    public void addEntry(String string, Attributes attributes) {
        this.getEntries().put(string, attributes);
    }

    public void addEntryAttribute(String string, String string2, String string3) {
        Attributes attributes = this.getAttributes(string);
        if (attributes == null) {
            this.addEntry(string);
        }
        attributes = this.getAttributes(string);
        attributes.putValue(string2, string3);
    }

    public void addVersionIfNecessary() {
        if (this.getManifestVersion() == null || this.getManifestVersion().equals("")) {
            this.setManifestVersion("1.0");
        }
    }

    public void appendClassPath(String string) {
        String string2 = this.getClassPath();
        if (string2 != null) {
            this.setClassPath(string2 + " " + string);
        } else {
            this.setClassPath(string);
        }
    }

    public String getClassPath() {
        return ArchiveUtil.getValueIgnoreKeyCase(Attributes.Name.CLASS_PATH.toString(), this.getMainAttributes());
    }

    public String[] getClassPathTokenized() {
        String string = this.getClassPath();
        if (string == null) {
            return new String[0];
        }
        return ArchiveUtil.getTokens(string);
    }

    public String getEntryAttribute(String string, String string2) {
        Attributes attributes = this.getAttributes(string);
        if (attributes == null) {
            return null;
        }
        return attributes.getValue(string2);
    }

    public String getMainClass() {
        return ArchiveUtil.getValueIgnoreKeyCase(Attributes.Name.MAIN_CLASS.toString(), this.getMainAttributes());
    }

    public String getManifestVersion() {
        return this.getMainAttributes().getValue(Attributes.Name.MANIFEST_VERSION);
    }

    public void mergeClassPath(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        List<String> list = Arrays.asList(this.getClassPathTokenized());
        String string = this.getClassPath();
        if (string != null) {
            stringBuffer.append(string);
        }
        boolean bl = string == null || "".equals(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (list.contains(stringArray[i])) continue;
            if (!bl) {
                stringBuffer.append(" ");
            } else {
                bl = false;
            }
            stringBuffer.append(stringArray[i]);
        }
        this.setClassPath(stringBuffer.toString());
    }

    public void removeEntry(String string) {
        this.getEntries().remove(string);
    }

    public void removeEntryAttribute(String string, Object object) {
        Attributes attributes = this.getAttributes(string);
        if (attributes != null) {
            attributes.remove(object);
        }
    }

    public void setClassPath(String string) {
        Attributes attributes = this.getMainAttributes();
        if (string == null) {
            attributes.remove(Attributes.Name.CLASS_PATH);
        } else {
            attributes.putValue(Attributes.Name.CLASS_PATH.toString(), string);
        }
    }

    public void setMainClass(String string) {
        Attributes attributes = this.getMainAttributes();
        if (string == null) {
            attributes.remove(Attributes.Name.MAIN_CLASS);
        } else {
            attributes.putValue(Attributes.Name.MAIN_CLASS.toString(), string);
        }
    }

    public void setManifestVersion(String string) {
        Attributes attributes = this.getMainAttributes();
        attributes.putValue(Attributes.Name.MANIFEST_VERSION.toString(), string);
    }

    public void writeSplittingClasspath(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        this.writeMainSplittingClasspath(this.getMainAttributes(), dataOutputStream);
        Iterator<Map.Entry<String, Attributes>> iterator = this.getEntries().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Attributes> entry = iterator.next();
            StringBuffer stringBuffer = new StringBuffer("Name: ");
            stringBuffer.append(entry.getKey());
            stringBuffer.append("\r\n");
            ArchiveManifestImpl.localMake72Safe(stringBuffer);
            dataOutputStream.writeBytes(stringBuffer.toString());
            this.write(entry.getValue(), dataOutputStream);
        }
        dataOutputStream.flush();
    }

    protected void write(Attributes attributes, DataOutputStream dataOutputStream) throws IOException {
        Iterator<Map.Entry<Object, Object>> iterator = attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            StringBuffer stringBuffer = new StringBuffer(((Attributes.Name)entry.getKey()).toString());
            stringBuffer.append(": ");
            stringBuffer.append(this.toUtf8((String)entry.getValue()));
            stringBuffer.append("\r\n");
            ArchiveManifestImpl.localMake72Safe(stringBuffer);
            dataOutputStream.writeBytes(stringBuffer.toString());
        }
        dataOutputStream.writeBytes("\r\n");
    }

    protected void writeMainSplittingClasspath(Attributes attributes, DataOutputStream dataOutputStream) throws IOException {
        String string = Attributes.Name.MANIFEST_VERSION.toString();
        String string2 = this.toUtf8(attributes.getValue(string));
        if (string2 == null) {
            string = Attributes.Name.SIGNATURE_VERSION.toString();
            string2 = this.toUtf8(attributes.getValue(string));
        }
        if (string2 != null) {
            dataOutputStream.writeBytes(string + ": " + string2 + "\r\n");
        }
        Iterator<Map.Entry<Object, Object>> iterator = attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String string3 = ((Attributes.Name)entry.getKey()).toString();
            if (string2 == null || string3.equalsIgnoreCase(string)) continue;
            if (string3.equalsIgnoreCase(Attributes.Name.CLASS_PATH.toString())) {
                this.writeSplit(dataOutputStream, string3, this.toUtf8((String)entry.getValue()));
                continue;
            }
            StringBuffer stringBuffer = new StringBuffer(string3);
            stringBuffer.append(": ");
            stringBuffer.append(this.toUtf8((String)entry.getValue()));
            stringBuffer.append("\r\n");
            ArchiveManifestImpl.localMake72Safe(stringBuffer);
            dataOutputStream.writeBytes(stringBuffer.toString());
        }
        dataOutputStream.writeBytes("\r\n");
    }

    protected void writeSplit(DataOutputStream dataOutputStream, String string, String string2) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            StringBuffer stringBuffer = null;
            if (n == 0) {
                stringBuffer = new StringBuffer(string);
                stringBuffer.append(": ");
            } else {
                stringBuffer = new StringBuffer();
                stringBuffer.append(' ');
            }
            stringBuffer.append(stringTokenizer.nextToken());
            if (stringTokenizer.countTokens() > 0) {
                stringBuffer.append(" \r\n");
            } else {
                stringBuffer.append("\r\n");
            }
            ArchiveManifestImpl.localMake72Safe(stringBuffer);
            dataOutputStream.writeBytes(stringBuffer.toString());
            ++n;
        }
    }

    protected static void localMake72Safe(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        if (n > 72) {
            int n2 = 70;
            while (n2 - 1 < n) {
                stringBuffer.insert(n2, "\r\n ");
                n2 += 72;
                n += 3;
            }
        }
    }

    public String getImplementationVersion() {
        return this.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
    }

    public void setImplemenationVersion(String string) {
        Attributes attributes = this.getMainAttributes();
        attributes.putValue(Attributes.Name.IMPLEMENTATION_VERSION.toString(), string);
    }

    private String toUtf8(String string) throws IOException {
        if (string == null) {
            return null;
        }
        byte[] byArray = string.getBytes("UTF-8");
        return new String(byArray, 0, 0, byArray.length);
    }
}

