/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.XmlValidationResult;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveRuntimeException;
import org.eclipse.jst.j2ee.internal.xml.CollectingErrorHandler;
import org.eclipse.jst.j2ee.internal.xml.XmlDocumentReader;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class ValidateXmlCommand
extends AbstractCommand {
    protected List results;
    protected ModuleFile archive;
    public boolean validateNested = true;

    protected ValidateXmlCommand() {
    }

    public ValidateXmlCommand(ModuleFile moduleFile) {
        this.archive = moduleFile;
    }

    protected ValidateXmlCommand(String string) {
        super(string);
    }

    protected ValidateXmlCommand(String string, String string2) {
        super(string, string2);
    }

    public void execute() {
        this.results = new ArrayList();
        this.validatateXml();
        if (this.isValidateNested()) {
            List list = this.archive.getArchiveFiles();
            for (int i = 0; i < list.size(); ++i) {
                Archive archive = (Archive)list.get(i);
                if (!archive.isModuleFile()) continue;
                ModuleFile moduleFile = (ModuleFile)archive;
                ValidateXmlCommand validateXmlCommand = new ValidateXmlCommand(moduleFile);
                validateXmlCommand.execute();
                this.results.addAll(validateXmlCommand.getResult());
            }
        }
    }

    public Collection getResult() {
        return this.results;
    }

    public boolean isValidateNested() {
        return this.validateNested;
    }

    protected boolean prepare() {
        return true;
    }

    public void redo() {
    }

    public void setValidateNested(boolean bl) {
        this.validateNested = bl;
    }

    protected void validatateXml() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Resource resource = this.archive.getStandardDeploymentDescriptor().eResource();
        XmlValidationResult xmlValidationResult = new XmlValidationResult();
        xmlValidationResult.setArchive(this.archive);
        try {
            resource.save(byteArrayOutputStream, new HashMap());
        }
        catch (Exception exception) {
            throw new ArchiveRuntimeException(exception);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        InputSource inputSource = new InputSource(byteArrayInputStream);
        CollectingErrorHandler collectingErrorHandler = new CollectingErrorHandler();
        XmlDocumentReader xmlDocumentReader = new XmlDocumentReader(inputSource, null, (ErrorHandler)collectingErrorHandler);
        try {
            xmlDocumentReader.parseDocument();
        }
        catch (RuntimeException runtimeException) {
            if (collectingErrorHandler.getCaughtExceptions() != null) {
                xmlValidationResult.setArchive(this.archive);
                xmlValidationResult.setCaughtExceptions(collectingErrorHandler.getCaughtExceptions());
                this.results.add(xmlValidationResult);
            }
            throw runtimeException;
        }
        xmlValidationResult.setArchive(this.archive);
        xmlValidationResult.setCaughtExceptions(collectingErrorHandler.getCaughtExceptions());
        this.results.add(xmlValidationResult);
    }
}

