/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipFile;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveFactoryRegistry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;

public class RepairArchiveCommand
extends AbstractCommand {
    protected Archive archive;
    protected static Map directoryNames;

    public RepairArchiveCommand(Archive archive) {
        super("Repair Archive", CommonArchiveResourceHandler.Repairs_all_entries_in_the);
        this.archive = archive;
        RepairArchiveCommand.getDirectoryNames();
    }

    public void execute() {
        EList eList = this.archive.getFiles();
        block0: for (int i = 0; i < eList.size(); ++i) {
            File file = (File)eList.get(i);
            if (file.isArchive()) {
                new RepairArchiveCommand((Archive)file).execute();
                continue;
            }
            String string = file.getURI().toUpperCase();
            Iterator iterator = directoryNames.entrySet().iterator();
            while (iterator.hasNext()) {
                String string2 = file.getURI();
                Map.Entry entry = iterator.next();
                String string3 = (String)entry.getKey();
                String string4 = (String)entry.getValue();
                if (!string.startsWith(string3) || string2.startsWith(string4)) continue;
                String string5 = string2.substring(string3.length());
                file.setURI(string4.concat(string5));
                continue block0;
            }
        }
    }

    protected static Map getDirectoryNames() {
        if (directoryNames == null) {
            directoryNames = new HashMap(6);
            directoryNames.put("META-INF".toUpperCase(), "META-INF");
            directoryNames.put("WEB-INF".toUpperCase(), "WEB-INF");
            directoryNames.put("WEB-INF/lib/".toUpperCase(), "WEB-INF/lib/");
            directoryNames.put("WEB-INF/classes/".toUpperCase(), "WEB-INF/classes/");
        }
        return directoryNames;
    }

    public Collection getResult() {
        return Arrays.asList(this.archive);
    }

    public static void main(String[] stringArray) {
        if (!RepairArchiveCommand.validateArgs(stringArray)) {
            return;
        }
        try {
            Archive archive = CommonArchiveFactoryRegistry.INSTANCE.getCommonArchiveFactory().primOpenArchive(stringArray[0]);
            new RepairArchiveCommand(archive).execute();
            archive.saveAs(stringArray[1]);
        }
        catch (Exception exception) {
            System.out.println(CommonArchiveResourceHandler.Repair_command_failed___ex_EXC_);
            exception.printStackTrace();
        }
    }

    protected boolean prepare() {
        return true;
    }

    public void redo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected static boolean validateArgs(String[] var0) {
        block14: {
            if (var0.length != 2) {
                Logger.getLogger().logError(CommonArchiveResourceHandler.RepairArchiveCommand_usage);
                return false;
            }
            var1_1 = new java.io.File(var0[0]);
            var2_2 = false;
            var3_3 = null;
            try {
                var3_3 = new ZipFile(var1_1);
                var2_2 = true;
                var6_4 = null;
                ** if (var3_3 == null) goto lbl-1000
            }
            catch (Throwable var5_11) {
                var6_6 = null;
                if (var3_3 != null) {
                    try {
                        var3_3.close();
                    }
                    catch (IOException var7_9) {
                        // empty catch block
                    }
                }
                throw var5_11;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var3_3.close();
                }
                catch (IOException var7_7) {}
            }
lbl-1000:
            // 2 sources

            {
                break block14;
                catch (IOException var4_10) {
                    var2_2 = false;
                    var6_5 = null;
                    if (var3_3 != null) {
                        try {
                            var3_3.close();
                        }
                        catch (IOException var7_8) {}
                    }
                }
            }
        }
        if (!var2_2 && !var1_1.isDirectory()) {
            System.out.println(CommonArchiveResourceHandler.RepairArchiveCommand_usage1_ERROR_);
            return false;
        }
        if (new java.io.File(var0[1]).canWrite()) {
            System.out.println(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.repair_usage_ERROR_, new Object[]{var0[1]}));
            return false;
        }
        return true;
    }
}

